/*
 * Copyright (c) 2010,2015 The Linux Foundation. All rights reserved.
 *
 * Previously licensed under the ISC license by Qualcomm Atheros, Inc.
 *
 *
 * Permission to use, copy, modify, and/or distribute this software for
 * any purpose with or without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL
 * WARRANTIES WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE
 * AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
 * PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

/*
 * This file was originally distributed by Qualcomm Atheros, Inc.
 * under proprietary terms before Copyright ownership was assigned
 * to the Linux Foundation.
 */


#include <adf_os_mem.h>
#ifdef MEMORY_DEBUG
#include <vos_memory.h>
#endif

#ifdef MEMORY_DEBUG
void *
adf_os_mem_alloc_debug(adf_os_device_t osdev,
				adf_os_size_t size,
				const char *fileName,
				a_uint32_t lineNum)
{
	void *p = vos_mem_malloc_debug(size, fileName, lineNum);
	if (p) {
		memset(p, 0, size);
	}
	return p;
}

void
adf_os_mem_free_debug(void *buf)
{
	vos_mem_free(buf);
}

#endif

void *
adf_os_mem_alloc_outline(adf_os_device_t osdev, size_t size)
{
    return __adf_os_mem_alloc(osdev, size);
}

void
adf_os_mem_free_outline(void *buf)
{
    __adf_os_mem_free(buf);
}

void
adf_os_mem_zero_outline(void *buf, adf_os_size_t size)
{
    __adf_os_mem_zero(buf, size);
}
