/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.view;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.main.view.AppTreeNode;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AppSearchPane
extends JPanel
implements ActionListener,
KeyListener {
    private AppTable m_table = null;
    private AppTableModel m_model = null;
    private String[][] m_corner = new String[][]{new String[0]};
    private String[][] m_colTitle = new String[][]{{AppLang.getText("Go"), AppLang.getText("Result")}};
    private String[][] m_rowTitle = new String[][]{new String[0]};
    private ArrayList m_component = new ArrayList();
    private AppTextBox m_compText = null;
    private JButton m_compBtn = null;
    private JPanel m_panSub = new JPanel(new BorderLayout());
    private Hashtable m_mmcList = new Hashtable();
    private Hashtable m_menuList = new Hashtable();
    private JRadioButton m_rbMenu = new JRadioButton(AppLang.getText("by Menu"));
    private JRadioButton m_rbMMC = new JRadioButton(AppLang.getText("by MMC"), true);
    private JButton m_btSearch = new JButton(AppLang.getText("Search"));
    private JButton m_btQSearch = new JButton(AppLang.getText("Search All"));
    private JTextField m_txtSearch = new JTextField();
    private ArrayList m_result = new ArrayList();
    private ArrayList m_useMmcList = new ArrayList();
    private String m_search = "";
    private JCheckBox m_field = new JCheckBox(AppLang.getText("Include Field Item"), true);

    public AppSearchPane() {
        this.setLayout(new BorderLayout());
    }

    public void setMMCList() {
        for (String key : AppProperty.m_allMmcList.keySet()) {
            String val = ((AppTreeNode)AppProperty.m_allMmcList.get(key)).getMmcList();
            if (Integer.parseInt(key, 16) >= 37129 || !AppGlobal.g_useMenu.containsKey(key)) continue;
            this.m_menuList.put(key, ((AppTreeNode)AppProperty.m_allMmcList.get(key)).getTabTitle());
            if (val.equals("")) continue;
            this.m_mmcList.put(key, val);
        }
        this.m_useMmcList = this.getUseMmcList();
        this.createComponents();
    }

    private void createComponents() {
        JPanel panOption = new JPanel(new BorderLayout());
        ButtonGroup btGroup = new ButtonGroup();
        btGroup.add(this.m_rbMenu);
        btGroup.add(this.m_rbMMC);
        panOption.add((Component)this.m_rbMenu, "West");
        panOption.add((Component)this.m_rbMMC, "Center");
        this.m_rbMenu.setActionCommand("by Menu");
        this.m_rbMenu.addActionListener(this);
        this.m_rbMMC.setActionCommand("by MMC");
        this.m_rbMMC.addActionListener(this);
        this.m_field.setEnabled(false);
        panOption.add((Component)this.m_field, "South");
        this.m_rbMenu.setFont(new Font("SansSerif", 0, 12));
        this.m_rbMMC.setFont(new Font("SansSerif", 0, 12));
        this.m_btQSearch.setPreferredSize(new Dimension(90, 23));
        this.m_btQSearch.setFont(new Font("SansSerif", 0, 12));
        this.m_btQSearch.setMargin(new Insets(0, 0, 0, 0));
        this.m_btQSearch.setActionCommand("Search All");
        this.m_btQSearch.addActionListener(this);
        JPanel panSearchAll = new JPanel(new BorderLayout());
        panSearchAll.add((Component)this.m_btQSearch, "North");
        panOption.add((Component)panSearchAll, "East");
        panOption.setPreferredSize(new Dimension(300, 60));
        JPanel panSearch = new JPanel(new BorderLayout());
        this.m_txtSearch.setPreferredSize(new Dimension(200, 23));
        this.m_txtSearch.addKeyListener(this);
        this.m_btSearch.setPreferredSize(new Dimension(90, 23));
        this.m_btSearch.setFont(new Font("SansSerif", 0, 12));
        this.m_btSearch.setMargin(new Insets(0, 0, 0, 0));
        this.m_btSearch.setActionCommand("Search");
        this.m_btSearch.addActionListener(this);
        panSearch.add((Component)this.m_txtSearch, "Center");
        panSearch.add((Component)this.m_btSearch, "East");
        panSearch.setPreferredSize(new Dimension(300, 23));
        this.m_panSub.add((Component)panSearch, "North");
        this.add((Component)panOption, "North");
        this.add((Component)this.m_panSub, "Center");
    }

    private void searchByMenu() {
        ArrayList<String> result = null;
        for (String key : this.m_menuList.keySet()) {
            String sField;
            int j2;
            int i2;
            String val = (String)this.m_menuList.get(key);
            val = AppLang.getText(val);
            if (!this.isExistUseMmc(key).booleanValue()) continue;
            if (val.toUpperCase().indexOf(this.m_search.toUpperCase()) >= 0) {
                result = new ArrayList<String>();
                result.add(0, key);
                result.add(1, val);
                this.m_result.add(this.m_result.size(), result);
                continue;
            }
            if (!this.m_field.isSelected()) continue;
            AppPageInfo m_pageInfo = new AppPageInfo(key);
            AppPage m_page = new AppPage();
            m_page.setPageInfo(m_pageInfo);
            String[][] colTitle = m_pageInfo.getColTitle();
            String[][] rowTitle = m_pageInfo.getRowTitle();
            if (colTitle != null && colTitle.length > 0) {
                i2 = 0;
                while (i2 < colTitle.length) {
                    j2 = 0;
                    while (j2 < colTitle[i2].length) {
                        if (this.isIncludeTlsSrtp(colTitle[i2][j2]) && AppLang.getText(colTitle[i2][j2]).toUpperCase().indexOf(this.m_search.toUpperCase()) >= 0) {
                            sField = val.substring(0, val.lastIndexOf("."));
                            sField = String.valueOf(sField) + " >> " + AppLang.getText(colTitle[i2][j2]);
                            result = new ArrayList();
                            result.add(0, key);
                            result.add(1, sField);
                            if (!this.m_result.contains(result)) {
                                this.m_result.add(this.m_result.size(), result);
                            }
                        }
                        ++j2;
                    }
                    ++i2;
                }
            }
            if (rowTitle == null || rowTitle.length <= 0) continue;
            i2 = 0;
            while (i2 < rowTitle.length) {
                j2 = 0;
                while (j2 < rowTitle[i2].length) {
                    if (this.isIncludeTlsSrtp(rowTitle[i2][j2]) && AppLang.getText(rowTitle[i2][j2]).toUpperCase().indexOf(this.m_search.toUpperCase()) >= 0) {
                        sField = val.substring(0, val.lastIndexOf("."));
                        sField = String.valueOf(sField) + " >> " + AppLang.getText(rowTitle[i2][j2]);
                        result = new ArrayList();
                        result.add(0, key);
                        result.add(1, sField);
                        if (!this.m_result.contains(result)) {
                            this.m_result.add(this.m_result.size(), result);
                        }
                    }
                    ++j2;
                }
                ++i2;
            }
        }
        this.setComponents();
    }

    private boolean isIncludeTlsSrtp(String str) {
        if (AppRunInfo.getCountry() != 21) {
            return true;
        }
        if (AppLang.getText(str).toUpperCase().indexOf("TLS") >= 0) {
            return false;
        }
        return AppLang.getText(str).toUpperCase().indexOf("SRTP") < 0;
    }

    private void searchByMMC() {
        ArrayList<String> result = null;
        AppTreeNode tnInfo = null;
        for (String key : this.m_mmcList.keySet()) {
            String val = (String)this.m_mmcList.get(key);
            if (val.indexOf(this.m_search) < 0 || !this.isExistUseMmc(key).booleanValue()) continue;
            result = new ArrayList<String>();
            tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get(key);
            result.add(0, key);
            result.add(1, String.valueOf(tnInfo.getIndex()) + " - MMC " + val);
            this.m_result.add(this.m_result.size(), result);
        }
        this.setComponents();
    }

    private void searchQuick() {
        this.m_result = (ArrayList)this.m_useMmcList.clone();
        this.setComponents();
    }

    private Boolean isExistUseMmc(String key) {
        int i2 = 0;
        while (i2 < this.m_useMmcList.size()) {
            if (((ArrayList)this.m_useMmcList.get(i2)).get(0).equals(key)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private ArrayList getUseMmcList() {
        ArrayList m_return = new ArrayList();
        ArrayList<String> result = null;
        int i2 = 0;
        while (i2 < AppProperty.m_useMmcList.size()) {
            String key = (String)AppProperty.m_useMmcList.get(i2);
            String val = (String)this.m_menuList.get(key);
            if (!(val = AppLang.getText(val)).equals("")) {
                result = new ArrayList<String>();
                result.add(0, key);
                result.add(1, val);
                m_return.add(m_return.size(), result);
            }
            ++i2;
        }
        return m_return;
    }

    private ArrayList sortArrayList(ArrayList al) {
        ArrayList temp = new ArrayList();
        ArrayList temp2 = new ArrayList();
        int i2 = 0;
        while (i2 < al.size()) {
            int j2 = 0;
            while (j2 < al.size()) {
                int k2 = this.keyToint((String)((ArrayList)al.get(i2)).get(0));
                int l2 = this.keyToint((String)((ArrayList)al.get(j2)).get(0));
                if (l2 > k2) {
                    temp = (ArrayList)al.get(j2);
                    temp2 = (ArrayList)al.get(i2);
                    al.remove(j2);
                    al.add(j2, temp2);
                    al.remove(i2);
                    al.add(i2, temp);
                }
                ++j2;
            }
            ++i2;
        }
        return al;
    }

    private int keyToint(String str) {
        int XOOXX;
        int OXXXX = Integer.parseInt(str.substring(0, 1)) * 10000;
        int XXXOO = Integer.parseInt(str.substring(2, 3)) * 10 + Integer.parseInt(str.substring(3, 4));
        switch (str.charAt(1)) {
            case 'A': {
                XOOXX = 1000;
                break;
            }
            case 'B': {
                XOOXX = 1100;
                break;
            }
            case 'C': {
                XOOXX = 1200;
                break;
            }
            case 'D': {
                XOOXX = 1300;
                break;
            }
            case 'E': {
                XOOXX = 1400;
                break;
            }
            case 'F': {
                XOOXX = 1500;
                break;
            }
            default: {
                XOOXX = Integer.parseInt(str.substring(1, 2)) * 100;
            }
        }
        return OXXXX + XOOXX + XXXOO;
    }

    private void setComponents() {
        if (this.m_table != null) {
            this.m_panSub.remove(this.m_table);
            this.m_model = null;
            this.m_table = null;
        }
        ArrayList result = new ArrayList();
        ArrayList<Object> compData = null;
        this.m_component.clear();
        this.m_rowTitle = new String[this.m_result.size()][1];
        int i2 = 0;
        while (i2 < this.m_rowTitle.length) {
            result = (ArrayList)this.m_result.get(i2);
            compData = new ArrayList<Object>();
            this.m_compBtn = new JButton("...");
            this.m_compBtn.setFont(new Font("SansSerif", 0, 11));
            this.m_compBtn.setMargin(new Insets(0, 0, 0, 0));
            this.m_compBtn.setActionCommand((String)result.get(0));
            this.m_compBtn.addActionListener(this);
            compData.add(0, this.m_compBtn);
            this.m_compText = new AppTextBox(0, 0);
            this.m_compText.setText((String)result.get(1));
            compData.add(1, this.m_compText);
            this.m_component.add(i2, compData);
            ++i2;
        }
        this.createTable();
    }

    private void createTable() {
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                ArrayList compData = (ArrayList)AppSearchPane.this.m_component.get(row);
                if (col == 0) {
                    return (JButton)compData.get(col);
                }
                return (AppTextBox)compData.get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return col != 1;
            }
        };
        this.m_model.setColWidth(new int[]{40, 250});
        this.m_model.setRowHeaderHidden();
        this.m_table = new AppTable(this.m_model, 2);
        this.m_panSub.add((Component)this.m_table, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String command = e2.getActionCommand();
        this.m_search = this.m_txtSearch.getText().trim();
        if (command.equals("Search")) {
            if (!this.m_search.equals("")) {
                this.m_result.clear();
                if (this.m_rbMenu.isSelected()) {
                    this.searchByMenu();
                } else {
                    this.searchByMMC();
                }
            }
        } else if (command.equals("by Menu")) {
            this.m_field.setEnabled(true);
        } else if (command.equals("by MMC")) {
            this.m_field.setEnabled(false);
        } else if (command.equals("Search All")) {
            this.m_result.clear();
            this.searchQuick();
        } else {
            AppTreeNode tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get(command);
            AppGlobal.g_frmMain.m_pagePane.openNewPage(tnInfo.getTreeNode());
        }
    }

    @Override
    public void keyPressed(KeyEvent e2) {
    }

    @Override
    public void keyReleased(KeyEvent e2) {
        if (e2.getKeyCode() == 10) {
            this.m_btSearch.doClick();
        }
    }

    @Override
    public void keyTyped(KeyEvent e2) {
    }
}

