/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.conference;

import com.sec.osdm.common.AppDateTimer;
import com.sec.osdm.common.AppFileBrowser;
import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppRunConference;
import com.sec.osdm.main.utils.AppDialog;
import com.sec.osdm.pages.AppCalendar;
import com.sec.osdm.pages.AppConference;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.conference.PA104SearchParty;
import com.sec.osdm.pages.conference.PA106EmailForm;
import com.sec.osdm.pages.utils.AppNumPlan;
import com.sec.osdm.pages.utils.components.AppComboBox;
import com.sec.osdm.pages.utils.components.AppPattern;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;

public class PA108CreateConference
extends AppConference
implements MouseListener,
ItemListener,
KeyListener {
    private final int SIZE_WIDTH = 490;
    private final int SIZE_HEIGHT = 578;
    private JTextField m_txtCard = new JTextField();
    private JTextField m_txtDate = new JTextField();
    public JTextField m_txtEndDate = new JTextField();
    private JTextField m_txtSubject = new JTextField();
    private JTextField m_txtId = new JTextField();
    private JTextField m_txtChannel = new JTextField();
    private JTextField m_txtPage = new JTextField();
    private JTextField m_txtOwner = new JTextField();
    private JScrollPane m_txtPartyScroll = new JScrollPane();
    private JTextArea m_txtParty = new JTextArea();
    private JPasswordField m_txtPassword = new JPasswordField();
    private JButton[] m_buttons = new JButton[8];
    private JRadioButton m_rbNoCheck = new JRadioButton(AppLang.getText("Not Required"));
    private JRadioButton m_rbCheck = new JRadioButton(AppLang.getText("Required"));
    public JRadioButton[] m_rbRepeat = new JRadioButton[4];
    private JCheckBox m_chkEmail = new JCheckBox(AppLang.getText("Send Invitation Email"), false);
    private JCheckBox m_chkEarly = new JCheckBox(AppLang.getText("Early Entrance"));
    private JCheckBox m_chkRecording = new JCheckBox(AppLang.getText("Recording"));
    private JCheckBox m_chkPaging = new JCheckBox(AppLang.getText("Paging"));
    private JLabel m_lbChannel = new JLabel("", 2);
    private JLabel m_lbFile = new JLabel("");
    private JLabel m_lbUseId = new JLabel("");
    private JLabel m_period = new JLabel("~");
    private AppComboBox m_cboStart = new AppComboBox();
    private AppComboBox m_cboEnd = new AppComboBox();
    private Hashtable m_partyInfo = new Hashtable();
    private String m_promptFile = "";
    private short[] m_partyList = new short[24];
    private int[] m_useChannel = new int[6];
    private boolean m_bIsCheckID = false;
    public int m_repeat = 0;
    private int m_maxChannel = 0;
    private AppDialog m_ownerDlg = null;

    public PA108CreateConference(AppConference parent) {
        this.m_parent = parent;
        System.arraycopy(this.m_parent.m_cardPos, 0, this.m_cardPos, 0, 2);
        this.m_layout = new AppLayout(this.m_panMain, 490, 578);
        this.createComponents();
        this.openDialog(AppLang.getText("Conference Reservation Form"), 490, 578);
    }

    private void createComponents() {
        ButtonGroup bgPasscode = new ButtonGroup();
        ButtonGroup bgRepeat = new ButtonGroup();
        String[] btnTitles = new String[]{"Check", "", "...", "Upload", "Submit", "Cancel", "Select...", "Select"};
        String[] rbTitles = new String[]{"Once", "Daily", "Weekly", "Monthly"};
        byte[] temp = null;
        int[] cols = this.m_parent.m_table.getTable().getSelectedColumns();
        int[] rows = this.m_parent.m_table.getTable().getSelectedRows();
        temp = (byte[])this.m_parent.m_reqList.get(cols[0]);
        System.arraycopy(temp, 0, this.m_startTime, 0, 8);
        System.arraycopy(temp, 0, this.m_endTime, 0, 8);
        this.m_startMin = rows[0];
        this.m_endMin = rows[rows.length - 1] + 1;
        this.setDateMinute();
        System.arraycopy(this.m_endTime, 0, this.m_endDate, 0, 8);
        int i2 = 0;
        while (i2 < this.m_buttons.length) {
            this.m_buttons[i2] = new JButton(AppLang.getText(btnTitles[i2]));
            this.m_buttons[i2].setActionCommand(btnTitles[i2]);
            this.m_buttons[i2].setMargin(new Insets(0, 0, 0, 0));
            this.m_buttons[i2].addActionListener(this);
            ++i2;
        }
        this.m_buttons[1].setActionCommand("Calendar");
        this.m_buttons[1].setBorderPainted(false);
        this.m_txtCard.setEditable(false);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Card")), 10, 10, 150, 22);
        this.m_txtCard.setText("C" + (this.m_cardPos[0] + 1) + "-S" + (this.m_cardPos[1] + 1));
        this.m_layout.addComponent(this.m_txtCard, 150, 10, 310, 22);
        this.m_txtDate.setEditable(false);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Date")), 10, 37, 150, 22);
        this.m_txtDate.setText(PA108CreateConference.getCurrentDate(this.m_startTime));
        this.m_layout.addComponent(this.m_txtDate, 150, 37, 100, 22);
        this.m_layout.addComponent(this.m_period, 260, 37, 40, 22);
        this.m_txtEndDate.setEditable(false);
        this.m_txtEndDate.setText(PA108CreateConference.getCurrentDate(this.m_endDate));
        this.m_layout.addComponent(this.m_txtEndDate, 300, 37, 100, 22);
        this.m_buttons[1].setVisible(false);
        this.m_buttons[1].setIcon(AppImages.Img_Calendar);
        this.m_layout.addComponent(this.m_buttons[1], 410, 37, 22, 22);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Subject")), 10, 64, 150, 22);
        this.m_layout.addComponent(this.m_txtSubject, 150, 64, 310, 22);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Conference ID")), 10, 91, 150, 22);
        this.m_txtId.setDocument(new AppPattern(3, "^[0-9]*$"));
        this.m_txtId.setToolTipText(AppLang.getText("Enter Numbers Only."));
        this.m_layout.addComponent(this.m_txtId, 150, 91, 100, 22);
        this.m_txtId.addKeyListener(this);
        this.m_layout.addComponent(this.m_buttons[0], 265, 91, 100, 22);
        this.m_layout.addComponent(this.m_lbUseId, 375, 91, 110, 22);
        i2 = 0;
        while (i2 < 96) {
            this.m_cboStart.addItem(AppRunConference.getDispTime(i2), i2);
            this.m_cboEnd.addItem(AppRunConference.getDispTime(i2), i2);
            ++i2;
        }
        this.m_cboEnd.removeItem(0);
        this.m_cboEnd.addItem(AppRunConference.getDispTime(96), 96);
        this.m_cboStart.setSelectedIndex(this.m_startMin);
        this.m_cboStart.addListener(this);
        this.m_cboEnd.setSelectedIndex(this.m_endMin);
        this.m_cboEnd.addListener(this);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Duration")), 10, 118, 150, 22);
        this.m_layout.addComponent(this.m_cboStart.getComponent(), 150, 118, 100, 22);
        this.m_layout.addComponent(new JLabel("~", 0), 250, 118, 40, 22);
        this.m_layout.addComponent(this.m_cboEnd.getComponent(), 290, 118, 100, 22);
        this.m_layout.addComponent(new JLabel(AppDateTimer.getTimeZone(), 4), 385, 118, 80, 22);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Repeat")), 10, 145, 150, 22);
        i2 = 0;
        while (i2 < this.m_rbRepeat.length) {
            this.m_rbRepeat[i2] = new JRadioButton(AppLang.getText(rbTitles[i2]));
            this.m_rbRepeat[i2].setActionCommand("" + i2);
            this.m_rbRepeat[i2].addItemListener(this);
            bgRepeat.add(this.m_rbRepeat[i2]);
            this.m_layout.addComponent(this.m_rbRepeat[i2], 145 + i2 * 110, 145, 110, 22);
            ++i2;
        }
        this.m_rbRepeat[0].setSelected(true);
        this.m_rbRepeat[3].setVisible(false);
        this.m_layout.addComponent(new JLabel(AppLang.getText("# of Attendees")), 10, 172, 150, 22);
        this.m_txtChannel.setDocument(new AppPattern(2, "^[0-9]*$"));
        this.m_txtChannel.setToolTipText(AppLang.getText("Enter Numbers Only."));
        this.m_layout.addComponent(this.m_txtChannel, 150, 172, 100, 22);
        this.m_layout.addComponent(new JLabel(String.valueOf(AppLang.getText("Available Channel")) + " : ", 4), 290, 172, 120, 22);
        this.m_layout.addComponent(this.m_lbChannel, 420, 172, 30, 22);
        this.m_txtOwner.setDocument(new AppPattern(4, AppPattern.PATTERN2));
        this.m_txtOwner.setEditable(false);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Owner Station")), 10, 200, 150, 22);
        this.m_layout.addComponent(this.m_txtOwner, 150, 200, 100, 22);
        this.m_layout.addComponent(this.m_buttons[7], 255, 200, 80, 22);
        this.m_txtPartyScroll.getViewport().add(this.m_txtParty);
        this.m_txtParty.setLineWrap(true);
        this.m_txtParty.setEditable(false);
        this.m_txtParty.addMouseListener(this);
        this.m_txtParty.setBorder(new LineBorder(Color.darkGray));
        this.m_layout.addComponent(new JLabel(AppLang.getText("Attendee List")), 10, 228, 150, 22);
        this.m_layout.addComponent(this.m_buttons[6], 150, 228, 100, 22);
        this.m_layout.addComponent(this.m_txtPartyScroll, 150, 256, 310, 82);
        Arrays.fill(this.m_partyList, 0, this.m_partyList.length, (short)-1);
        this.m_chkEmail.addItemListener(this);
        this.m_layout.addComponent(this.m_chkEmail, 150, 343, 300, 22);
        bgPasscode.add(this.m_rbNoCheck);
        bgPasscode.add(this.m_rbCheck);
        this.m_rbCheck.addActionListener(this);
        this.m_rbCheck.setActionCommand("PassCheck");
        this.m_rbCheck.setSelected(false);
        this.m_rbNoCheck.addActionListener(this);
        this.m_rbNoCheck.setActionCommand("PassCheck");
        this.m_rbNoCheck.setSelected(true);
        this.m_layout.addComponent(new JLabel(AppLang.getText("Password")), 10, 371, 150, 22);
        this.m_layout.addComponent(this.m_rbNoCheck, 150, 371, 100, 22);
        this.m_layout.addComponent(this.m_rbCheck, 260, 371, 100, 22);
        this.m_txtPassword.setDocument(new AppPattern(4, "^[0-9]*$"));
        this.m_txtPassword.setToolTipText(AppLang.getText("Enter Numbers Only."));
        this.m_layout.addComponent(this.m_txtPassword, 150, 371, 100, 22);
        this.m_txtPassword.addKeyListener(this);
        this.m_txtPassword.setEditable(this.m_useChannel[2] == 1);
        this.m_rbCheck.setVisible(false);
        this.m_rbNoCheck.setVisible(false);
        JPanel optionPan = new JPanel(new BorderLayout());
        optionPan.setBorder(BorderFactory.createTitledBorder(AppLang.getText("Options")));
        AppLayout optionLayout = new AppLayout(optionPan, 490, 578);
        this.m_chkEarly.addItemListener(this);
        optionLayout.addComponent(this.m_chkEarly, 10, 20, 130, 22);
        this.m_chkRecording.addItemListener(this);
        optionLayout.addComponent(this.m_chkRecording, 145, 20, 120, 22);
        this.m_chkPaging.addItemListener(this);
        optionLayout.addComponent(this.m_chkPaging, 280, 20, 120, 22);
        this.m_txtPage.setDocument(new AppPattern(1, "^[0-8*]*$"));
        this.m_txtPage.setToolTipText(AppLang.getText("Input the Page Group (0~8)"));
        this.m_txtPage.setEditable(false);
        this.m_txtPage.addKeyListener(this);
        optionLayout.addComponent(this.m_txtPage, 400, 20, 50, 22);
        this.m_lbFile.setBorder(new LineBorder(Color.darkGray));
        optionLayout.addComponent(new JLabel(AppLang.getText("Greeting Prompt")), 10, 45, 180, 22);
        optionLayout.addComponent(this.m_lbFile, 10, 70, 310, 22);
        optionLayout.addComponent(this.m_buttons[2], 325, 70, 22, 22);
        optionLayout.addComponent(this.m_buttons[3], 350, 70, 100, 22);
        this.m_layout.addComponent(optionPan, 10, 413, 460, 100);
        this.m_layout.addComponent(this.m_buttons[4], 260, 518, 100, 22);
        this.m_layout.addComponent(this.m_buttons[5], 370, 518, 100, 22);
    }

    private void getUsableChannel() {
        ArrayList recvData = new ArrayList();
        this.m_reqData = new byte[28];
        this.m_pageInfo = new AppPageInfo("A102");
        this.m_pageInfo.setDownMsgType((byte)-39);
        this.m_pageInfo.setUpMsgType((byte)-11);
        System.arraycopy(this.m_startTime, 0, this.m_reqData, 0, 8);
        System.arraycopy(this.m_endTime, 0, this.m_reqData, 8, 8);
        System.arraycopy(this.m_cardPos, 0, this.m_reqData, 16, 2);
        this.m_reqData[18] = (byte)this.m_repeat;
        this.m_reqData[19] = -1;
        System.arraycopy(this.m_endDate, 0, this.m_reqData, 20, 8);
        if (this.readDataFromSystem()) {
            recvData = (ArrayList)this.m_recvData.get(0);
            int i2 = 0;
            while (i2 < this.m_useChannel.length) {
                this.m_useChannel[i2] = (byte)Integer.parseInt((String)recvData.get(i2));
                ++i2;
            }
        }
        this.m_rbCheck.setEnabled(this.m_useChannel[2] == 1);
        this.m_rbNoCheck.setEnabled(this.m_useChannel[2] == 1);
        if (this.m_useChannel[2] != 1 && this.m_rbCheck.isSelected()) {
            this.m_rbCheck.setSelected(false);
            this.m_rbNoCheck.setSelected(true);
            this.m_txtPassword.setEditable(false);
        }
        this.m_buttons[2].setEnabled(this.m_useChannel[3] == 1);
        this.m_buttons[3].setEnabled(this.m_useChannel[3] == 1);
        this.m_chkEarly.setEnabled(this.m_useChannel[4] == 1);
        if (this.m_useChannel[4] != 1 && this.m_chkEarly.isSelected()) {
            this.m_chkEarly.setSelected(false);
        }
        this.m_chkEmail.setEnabled(this.m_useChannel[5] == 1);
        if (this.m_useChannel[5] != 1 && this.m_chkEmail.isSelected()) {
            this.m_chkEmail.setSelected(false);
        }
        this.setMaxChannel();
    }

    private boolean checkConferenceID(Boolean bShowDialog) {
        ArrayList recvData = new ArrayList();
        this.m_reqData = new byte[30];
        this.m_pageInfo = new AppPageInfo("A103");
        this.m_pageInfo.setDownMsgType((byte)-39);
        this.m_pageInfo.setUpMsgType((byte)-11);
        System.arraycopy(this.m_startTime, 0, this.m_reqData, 0, 8);
        System.arraycopy(this.m_endTime, 0, this.m_reqData, 8, 8);
        System.arraycopy(this.m_cardPos, 0, this.m_reqData, 16, 2);
        AppFunctions.str2byte(this.m_reqData, 18, 3, this.m_txtId.getText().trim());
        this.m_reqData[21] = (byte)this.m_repeat;
        System.arraycopy(this.m_endDate, 0, this.m_reqData, 22, 8);
        if (!this.readDataFromSystem()) {
            return false;
        }
        if (this.m_recvData.size() > 0) {
            recvData = (ArrayList)this.m_recvData.get(0);
            if (!this.m_txtId.getText().equals((String)recvData.get(0)) && bShowDialog.booleanValue() && JOptionPane.showConfirmDialog(null, String.valueOf(AppLang.getText("Conference ID is Not Available.")) + AppLang.getText("System Recommends") + "( [" + (String)recvData.get(0) + "] " + AppLang.getText(" as Conference ID.") + "\n" + AppLang.getText("Would you accept new Conference ID?"), AppLang.getText("Conference ID"), 0) == 1) {
                this.m_lbUseId.setForeground(Color.RED);
                this.m_lbUseId.setText(AppLang.getText("Unaccepted ID"));
                this.m_txtId.setText("");
                this.m_txtId.requestFocus();
                return false;
            }
            this.m_lbUseId.setForeground(Color.BLUE);
            this.m_lbUseId.setText(AppLang.getText("ID Accepted"));
            this.m_txtId.setText((String)recvData.get(0));
        }
        return true;
    }

    private boolean checkCreateData() {
        long curTime;
        if (this.m_txtSubject.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(null, AppLang.getText("Enter Email Subject."));
            this.m_txtSubject.requestFocus();
            return false;
        }
        if (!this.m_bIsCheckID) {
            JOptionPane.showMessageDialog(null, AppLang.getText("You must verify Conference ID availability by clicking on the Check button."));
            return false;
        }
        long startTime = AppRunConference.getCurrentTime(this.m_startTime);
        if (startTime < (curTime = AppDateTimer.getTimeInMillis())) {
            JOptionPane.showMessageDialog(null, AppLang.getText("Reservation time must be later than current system time."));
            return false;
        }
        if (this.m_txtChannel.getText().trim().equals("")) {
            JOptionPane.showMessageDialog(null, AppLang.getText("Enter number of Attendees."));
            this.m_txtChannel.requestFocus();
            return false;
        }
        if (Integer.parseInt(this.m_txtChannel.getText().trim()) > this.m_maxChannel) {
            JOptionPane.showMessageDialog(null, AppLang.getText("Number of Channels has exceeded maximum available."));
            this.m_txtChannel.setText("");
            this.m_txtChannel.requestFocus();
            return false;
        }
        if (Integer.parseInt(this.m_txtChannel.getText().trim()) < this.m_partyInfo.size()) {
            JOptionPane.showMessageDialog(null, AppLang.getText("You have exceeded the allowed Number of Attendees. Please select fewer Attendees."));
            this.m_txtChannel.setText("");
            this.m_txtChannel.requestFocus();
            return false;
        }
        if (this.m_txtPassword.getPassword().length != 0 && this.m_txtPassword.getPassword().length != 4) {
            JOptionPane.showMessageDialog(null, AppLang.getText("Enter the Password or clear for Not Required. Password length cannot exceed 4 digits."));
            this.m_txtPassword.requestFocus();
            this.m_txtPassword.selectAll();
            return false;
        }
        if (this.m_txtOwner.getText().equals("")) {
            JOptionPane.showMessageDialog(null, AppLang.getText("Select the Owner"));
            this.m_txtOwner.requestFocus();
            return false;
        }
        if (this.m_chkPaging.isSelected() && !this.m_txtPage.getText().trim().equals("*")) {
            int iTest;
            try {
                iTest = Integer.parseInt(this.m_txtPage.getText());
            }
            catch (NumberFormatException e2) {
                JOptionPane.showMessageDialog(null, AppLang.getText("Enter Page Group Number (0 ~ 8)."));
                this.m_txtPage.requestFocus();
                this.m_txtPage.selectAll();
                return false;
            }
            if (iTest < 0 || iTest > 9) {
                JOptionPane.showMessageDialog(null, AppLang.getText("Enter Page Group Number (0 ~ 8)."));
                this.m_txtPage.requestFocus();
                this.m_txtPage.selectAll();
                return false;
            }
        }
        if (this.m_lbFile.toString().trim().equals("") && !this.m_bFtpResult) {
            JOptionPane.showMessageDialog(null, AppLang.getText("Upload Greeting."));
            return false;
        }
        this.createConference();
        return true;
    }

    private void createConference() {
        ArrayList<String> saveData = new ArrayList<String>();
        int i2 = 0;
        while (i2 < 8) {
            saveData.add(i2, AppFunctions.unsignedValue(this.m_startTime[i2]));
            ++i2;
        }
        i2 = 0;
        while (i2 < 8) {
            saveData.add(i2 + 8, AppFunctions.unsignedValue(this.m_endTime[i2]));
            ++i2;
        }
        saveData.add(16, AppFunctions.unsignedValue(this.m_cardPos[0]));
        saveData.add(17, AppFunctions.unsignedValue(this.m_cardPos[1]));
        saveData.add(18, this.m_txtOwner.getText());
        saveData.add(19, this.m_txtId.getText().trim());
        saveData.add(20, "" + this.m_repeat);
        i2 = 0;
        while (i2 < 8) {
            saveData.add(i2 + 21, AppFunctions.unsignedValue(this.m_endDate[i2]));
            ++i2;
        }
        saveData.add(29, String.valueOf(this.m_txtPassword.getPassword()).trim());
        saveData.add(30, this.m_txtChannel.getText().trim());
        saveData.add(31, this.m_chkRecording.isSelected() ? "1" : "0");
        saveData.add(32, this.m_chkPaging.isSelected() ? "1" : "0");
        if (this.m_txtPage.getText().trim().equals("")) {
            saveData.add(33, "255");
        } else {
            saveData.add(33, this.m_txtPage.getText().trim());
        }
        saveData.add(34, this.m_chkEarly.isSelected() ? "1" : "0");
        saveData.add(35, "255");
        i2 = 0;
        while (i2 < 24) {
            saveData.add(i2 + 36, AppFunctions.unsignedValue(this.m_partyList[i2]));
            ++i2;
        }
        saveData.add(60, this.m_promptFile);
        saveData.add(61, this.m_txtSubject.getText().trim());
        this.m_pageInfo = new AppPageInfo("A108");
        this.m_pageInfo.setDownMsgType((byte)-39);
        this.m_pageInfo.setUpMsgType((byte)-11);
        this.m_saveData = new ArrayList();
        this.m_saveData.add(0, saveData);
    }

    private void setMaxChannel() {
        this.m_maxChannel = (this.m_chkEarly.isSelected() ? this.m_useChannel[1] : this.m_useChannel[0]) - ((this.m_chkRecording.isSelected() ? 1 : 0) + (this.m_chkPaging.isSelected() ? 1 : 0));
        this.m_lbChannel.setText("" + this.m_maxChannel);
    }

    @Override
    public void runActionEvent(String command) {
        this.m_cnfId = this.m_txtId.getText().trim();
        this.m_cnfTitle = this.m_txtSubject.getText().trim();
        this.m_cnfOwner = this.m_txtOwner.getText().trim();
        if (command.equals("Check")) {
            if (this.m_txtId.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(null, AppLang.getText("Enter Conference ID Number."));
                this.m_txtId.requestFocus();
                this.m_txtId.selectAll();
                return;
            }
            if (this.m_txtId.getText().length() != 3) {
                JOptionPane.showMessageDialog(null, AppLang.getText("Length of Conference ID cannot exceed 3 characters."));
                this.m_txtId.requestFocus();
                this.m_txtId.selectAll();
                return;
            }
            this.m_bIsCheckID = this.checkConferenceID(true);
        } else if (command.equals("Calendar")) {
            new AppCalendar(this);
            this.getUsableChannel();
            if (!this.m_txtId.getText().trim().equals("")) {
                this.m_bIsCheckID = this.checkConferenceID(true);
            }
        } else if (command.equals("...")) {
            AppFileBrowser browser = new AppFileBrowser();
            browser.setFileFilter(AppLang.getText("CNF24 Prompt File"), "snd", "wav");
            if (browser.openBrowser()) {
                this.m_lbFile.setText(browser.getFilePath());
            }
        } else if (command.equals("Upload")) {
            if (!this.m_bIsCheckID) {
                JOptionPane.showMessageDialog(null, AppLang.getText("You must verify Conference ID availability by clicking on the Check button."));
            } else if (!this.m_lbFile.getText().trim().equals("")) {
                this.m_promptFile = String.format("grt_20%02d%02d%02d_%3s.snd", this.m_startTime[5], this.m_startTime[4], this.m_startTime[3], this.m_cnfId);
                this.sendFTPFile(this.m_lbFile.getText().trim(), String.valueOf(AppGlobal.g_greetingDir) + this.m_promptFile);
            }
        } else if (command.equals("Submit")) {
            if (this.checkCreateData() && this.saveDataToSystem()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                if (!this.m_txtParty.getText().isEmpty() && this.m_chkEmail.isSelected()) {
                    this.setVisible(false);
                    this.m_cnfTitle = this.m_txtSubject.getText().trim();
                    this.m_cnfId = this.m_txtId.getText().trim();
                    this.m_cnfOwner = this.m_txtOwner.getText().trim();
                    this.m_cnfRepeat = this.m_repeat;
                    new PA106EmailForm(this, this.m_partyInfo, this.m_chkEmail);
                }
                this.closeDialog();
            }
        } else if (command.equals("Cancel")) {
            if (this.m_bFtpResult) {
                this.deleteFTPFile(String.valueOf(AppGlobal.g_greetingDir) + this.m_promptFile);
            }
            this.closeDialog();
        } else if (command.equals("Select...")) {
            if (this.m_txtChannel.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(null, AppLang.getText("Enter number of Attendees."));
                return;
            }
            if (Integer.parseInt(this.m_txtChannel.getText().trim()) > this.m_maxChannel) {
                JOptionPane.showMessageDialog(null, AppLang.getText("Number of Channels has exceeded maximum available."));
                return;
            }
            this.setVisible(false);
            new PA104SearchParty(this, this.m_txtParty, this.m_partyInfo, this.m_partyList, Integer.parseInt(this.m_txtChannel.getText().trim()));
        } else if (command.equals("PassCheck")) {
            if (this.m_rbCheck.isSelected()) {
                this.m_txtPassword.setEditable(true);
            } else {
                this.m_txtPassword.setEditable(false);
            }
        } else if (command.equals("Select")) {
            this.createOwnerTable(AppNumPlan.getOwnerList());
        }
    }

    private AppTable createOwnerTable(String ownerList) {
        this.m_ownerDlg = new AppDialog();
        AppLayout layout = new AppLayout(this.m_ownerDlg.m_contentPane, 300, 200);
        final String[] list = ownerList.split(";");
        Object[][] rowTitle = new String[list.length][1];
        Object[][] colTitle = new String[][]{{"Owner List"}};
        final AppTableModel ownerModel = new AppTableModel(rowTitle, colTitle, ""){

            @Override
            public Object getValueAt(int row, int col) {
                return list[row];
            }
        };
        ownerModel.setRowHeaderHidden();
        ownerModel.setColWidth(new int[]{282});
        final AppTable ownerTable = new AppTable(ownerModel);
        ownerTable.getTable().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() >= 2) {
                    ownerTable.getTable().getSelectedRow();
                    String sValue = (String)ownerModel.getValueAt(ownerTable.getTable().getSelectedRow(), ownerTable.getTable().getSelectedColumn());
                    PA108CreateConference.this.m_txtOwner.setText(sValue);
                    PA108CreateConference.this.m_ownerDlg.closeDialog();
                }
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
            }

            @Override
            public void mousePressed(MouseEvent e2) {
            }

            @Override
            public void mouseExited(MouseEvent e2) {
            }

            @Override
            public void mouseEntered(MouseEvent e2) {
            }
        });
        JButton button = new JButton(AppLang.getText("Close"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PA108CreateConference.this.m_ownerDlg.closeDialog();
            }
        });
        layout.addComponent(ownerTable, 5, 5, 285, 325);
        layout.addComponent(button, 90, 340, 120, 22);
        this.m_ownerDlg.openDialog("Station Owner", 300, 400);
        return ownerTable;
    }

    public static String getCurrentDate(byte[] day) {
        Calendar now = Calendar.getInstance();
        int i2 = 0;
        while (i2 < 8) {
            if (day[i2] != -1) {
                AppRunConference.vArrayList2Calendar(now, day);
                return AppRunConference.szDate2LangLocale(now.getTime(), 1);
            }
            ++i2;
        }
        return "";
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        me.getSource();
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        Object obj = ie.getSource();
        if (obj instanceof JRadioButton) {
            if (ie.getStateChange() == 1) {
                JRadioButton rbRepeat = (JRadioButton)ie.getSource();
                this.m_repeat = Integer.parseInt(rbRepeat.getActionCommand());
                this.m_buttons[1].setVisible(true);
                this.m_period.setVisible(true);
                this.m_txtEndDate.setVisible(true);
                if (this.m_repeat == 0) {
                    this.m_buttons[1].setVisible(false);
                    this.m_period.setVisible(false);
                    this.m_txtEndDate.setVisible(false);
                }
                this.getUsableChannel();
                if (!this.m_txtId.getText().trim().equals("")) {
                    this.m_bIsCheckID = this.checkConferenceID(true);
                }
            }
        } else if (ie.getSource() == this.m_chkEarly) {
            this.setMaxChannel();
        } else if (ie.getSource() == this.m_chkRecording) {
            this.setMaxChannel();
        } else if (ie.getSource() == this.m_chkPaging) {
            this.setMaxChannel();
            this.m_txtPage.setEditable(this.m_chkPaging.isSelected());
        } else if (ie.getSource() != this.m_chkEmail && ie.getStateChange() == 1) {
            if (ie.getSource() == this.m_cboStart.getComponent()) {
                long curTime;
                if (this.m_cboStart.getSelectedIndex() >= this.m_endMin) {
                    JOptionPane.showMessageDialog(null, AppLang.getText("Conference Start Time is later than End Time."));
                    this.m_cboStart.setSelectedIndex(this.m_startMin);
                    return;
                }
                this.m_startMin = this.m_cboStart.getSelectedIndex();
                this.m_startTime[1] = (byte)(this.m_startMin % 4 * 15);
                this.m_startTime[2] = (byte)(this.m_startMin / 4);
                long startTime = AppRunConference.getCurrentTime(this.m_startTime);
                if (startTime < (curTime = AppDateTimer.getTimeInMillis())) {
                    JOptionPane.showMessageDialog(null, AppLang.getText("Reservation time must be later than current system time."));
                    return;
                }
            } else {
                if (this.m_startMin >= this.m_cboEnd.getSelectedIndex()) {
                    JOptionPane.showMessageDialog(null, AppLang.getText("End time must be later than start time."));
                    this.m_cboEnd.setSelectedIndex(this.m_endMin);
                    return;
                }
                this.m_endMin = this.m_cboEnd.getSelectedIndex();
                this.m_endTime[1] = (byte)(this.m_endMin % 4 * 15);
                this.m_endTime[2] = (byte)(this.m_endMin / 4);
            }
            this.getUsableChannel();
            if (!this.m_txtId.getText().trim().equals("")) {
                this.m_bIsCheckID = this.checkConferenceID(true);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        if (ke.getSource() == this.m_txtId) {
            if (ke.getKeyCode() == 10) {
                this.m_buttons[0].requestFocus();
            } else {
                this.m_bIsCheckID = false;
                this.m_lbUseId.setText("");
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent ke) {
        if (ke.getSource() == this.m_txtId && this.m_txtId.getText().length() > 3) {
            ke.consume();
        } else if (ke.getSource() == this.m_txtPassword && this.m_txtPassword.getPassword().length > 4) {
            ke.consume();
        } else if (ke.getSource() == this.m_txtPage && this.m_txtPage.getText().length() > 1) {
            ke.consume();
        }
    }
}

