/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import com.sec.osdm.pages.utils.table.ISpanModel;
import com.sec.osdm.pages.utils.table.ITableModel;
import com.sec.osdm.pages.utils.table.SpanInfo;
import com.sec.osdm.pages.utils.table.SpanTableLabelRenderer;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class SpanTableColumnModel
extends DefaultTableColumnModel
implements ISpanModel {
    private static final int DEFAULT_COL_WIDTH = 150;
    private ITableModel m_ITableModel = null;
    private TableCellRenderer m_renderer = new SpanTableLabelRenderer();

    public SpanTableColumnModel(ITableModel tableExModel) {
        this.m_ITableModel = tableExModel;
        this.setTableColumns();
    }

    private void setTableColumns() {
        this.tableColumns = new Vector();
        int i2 = 0;
        while (i2 < this.m_ITableModel.getColHdrColCount()) {
            TableColumn column = this.m_ITableModel.getColHdrWidth(i2) != -1 ? new TableColumn(i2, this.m_ITableModel.getColHdrWidth(i2)) : new TableColumn(i2, 150);
            column.setHeaderRenderer(this.m_renderer);
            this.addColumn(column);
            ++i2;
        }
    }

    @Override
    public SpanInfo getSpanInfo() {
        return this.m_ITableModel.getColHeaderSpanInfo();
    }

    @Override
    public void setSpanInfo(SpanInfo newSpanInfo) {
        this.m_ITableModel.setColHeaderSpanInfo(newSpanInfo);
    }

    public Dimension getSize() {
        return this.m_ITableModel.getColHeaderSpanInfo().getSize();
    }

    public TableCellRenderer getHeaderRenderer(int row, int col) {
        return this.m_renderer;
    }

    public Object getHeaderValue(int row, int col) {
        return this.m_ITableModel.getColHdrName(row, col);
    }

    public Dimension getCellSize(JTable table, int row, int col) {
        Object comp = null;
        TableColumn tableColumn = null;
        int[] span = this.m_ITableModel.getColHeaderSpanInfo().getSpan(row, col);
        Dimension cellSize = new Dimension();
        tableColumn = this.getColumn(col);
        cellSize.height = 18;
        cellSize.width = tableColumn.getWidth();
        int i2 = 1;
        while (i2 < span[0]) {
            cellSize.height += 18;
            ++i2;
        }
        int j2 = 1;
        while (j2 < span[1]) {
            tableColumn = this.getColumn(col + j2);
            cellSize.width += tableColumn.getWidth();
            ++j2;
        }
        return cellSize;
    }

    public int getRowCount() {
        return this.m_ITableModel.getColHdrRowCount();
    }

    public int getColCount() {
        return this.m_ITableModel.getColHdrColCount();
    }
}

