/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.update;

import com.sec.osdm.common.AppLang;
import com.sec.osdm.update.AppProgress;
import com.sun.net.ftp.FtpClient;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;

public class SunFtpWrapper
extends FtpClient {
    @Override
    public String pwd() throws IOException {
        this.issueCommand("PWD");
        if (this.isValidResponse()) {
            String response = this.getResponseString().substring(4).trim();
            if (response.startsWith("\"")) {
                response = response.substring(1);
            }
            if (response.endsWith("\"")) {
                response = response.substring(0, response.length() - 1);
            }
            return response;
        }
        return "";
    }

    public boolean cdup() throws IOException {
        this.issueCommand("CDUP");
        return this.isValidResponse();
    }

    public boolean mkdir(String newDir) throws IOException {
        this.issueCommand("MKDIR " + newDir);
        return this.isValidResponse();
    }

    public boolean deleteFile(String fileName) throws IOException {
        this.issueCommand("DELE " + fileName);
        return this.isValidResponse();
    }

    public Vector listRaw() throws IOException {
        String fileName;
        Vector<String> ftpList = new Vector<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.list()));
        while ((fileName = reader.readLine()) != null) {
            ftpList.add(fileName);
        }
        return ftpList;
    }

    public int getResponseCode() throws NumberFormatException {
        return Integer.parseInt(this.getResponseString().substring(0, 3));
    }

    public boolean isValidResponse() {
        try {
            int respCode = this.getResponseCode();
            return respCode >= 200 && respCode < 300;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public int issueRawCommand(String command) throws IOException {
        return this.issueCommand(command);
    }

    public boolean downloadFile(String serverFile, String localFile) throws IOException {
        int i2 = 0;
        byte[] bytesIn = new byte[1024];
        BufferedInputStream in = new BufferedInputStream(this.get(serverFile));
        FileOutputStream out = new FileOutputStream(localFile);
        while ((i2 = in.read(bytesIn)) >= 0) {
            out.write(bytesIn, 0, i2);
        }
        out.close();
        return true;
    }

    public boolean uploadFile(String localFile, String serverFile, AppProgress m_progress) throws IOException {
        int i2 = 0;
        long lSend = 0L;
        long lFileSize = 0L;
        byte[] bytesIn = new byte[1024];
        FileInputStream in = new FileInputStream(localFile);
        BufferedOutputStream out = new BufferedOutputStream(this.put(serverFile));
        File oFile = new File(localFile);
        if (oFile.exists()) {
            lFileSize = oFile.length();
        }
        while ((i2 = in.read(bytesIn)) >= 0) {
            out.write(bytesIn, 0, i2);
            m_progress.setLable(String.valueOf(AppLang.getText("Transfer to IVM :")) + " " + (lSend += (long)i2) + " / " + lFileSize + AppLang.getText(" (bytes)"));
            m_progress.setProgValue1(100, (int)((double)lSend / (double)lFileSize * 100.0));
        }
        in.close();
        out.close();
        return true;
    }
}

