/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Assert;
import common.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import jxl.biff.drawing.ClientAnchor;
import jxl.biff.drawing.ClientData;
import jxl.biff.drawing.DrawingGroup;
import jxl.biff.drawing.EscherContainer;
import jxl.biff.drawing.EscherRecordData;
import jxl.biff.drawing.EscherRecordType;
import jxl.biff.drawing.EscherStream;
import jxl.biff.drawing.MsoDrawingRecord;
import jxl.biff.drawing.ObjRecord;
import jxl.biff.drawing.Opt;
import jxl.biff.drawing.Sp;
import jxl.biff.drawing.SpContainer;

public class Drawing
implements EscherStream {
    private static Logger logger = Logger.getLogger(class$jxl$biff$drawing$Drawing == null ? (class$jxl$biff$drawing$Drawing = Drawing.class$("jxl.biff.drawing.Drawing")) : class$jxl$biff$drawing$Drawing);
    private byte[] drawingData;
    private SpContainer readSpContainer;
    private MsoDrawingRecord msoDrawingRecord;
    private ObjRecord objRecord;
    private boolean initialized = false;
    private File imageFile;
    private byte[] imageData;
    private int objectId;
    private int blipId;
    private double x;
    private double y;
    private double width;
    private double height;
    private int referenceCount;
    private EscherContainer escherData;
    private Origin origin;
    private DrawingGroup drawingGroup;
    public static final Origin READ = new Origin();
    public static final Origin WRITE = new Origin();
    public static final Origin READ_WRITE = new Origin();
    static /* synthetic */ Class class$jxl$biff$drawing$Drawing;

    public Drawing(MsoDrawingRecord mso, ObjRecord obj, DrawingGroup dg2) {
        this.drawingGroup = dg2;
        this.msoDrawingRecord = mso;
        this.objRecord = obj;
        this.initialized = false;
        this.origin = READ;
        this.drawingData = this.msoDrawingRecord.getData();
        Assert.verify(mso != null && obj != null);
        this.initialize();
        if (this.blipId != 0) {
            this.drawingGroup.addDrawing(this);
        } else if (this.objRecord.getType() != ObjRecord.MSOFFICEDRAWING) {
            logger.warn("linked drawings are not supported");
        }
    }

    protected Drawing(Drawing d2) {
        Assert.verify(d2.origin == READ);
        this.msoDrawingRecord = d2.msoDrawingRecord;
        this.objRecord = d2.objRecord;
        this.initialized = false;
        this.origin = READ;
        this.drawingData = d2.drawingData;
        this.drawingGroup = d2.drawingGroup;
    }

    public Drawing(double x2, double y2, double width, double height, File image) {
        this.imageFile = image;
        this.initialized = true;
        this.origin = WRITE;
        this.x = x2;
        this.y = y2;
        this.width = width;
        this.height = height;
        this.referenceCount = 1;
    }

    public Drawing(double x2, double y2, double width, double height, byte[] image) {
        this.imageData = image;
        this.initialized = true;
        this.origin = WRITE;
        this.x = x2;
        this.y = y2;
        this.width = width;
        this.height = height;
        this.referenceCount = 1;
    }

    private void initialize() {
        EscherRecordData er = new EscherRecordData(this, 0);
        Assert.verify(er.isContainer());
        this.escherData = new EscherContainer(er);
        this.readSpContainer = null;
        if (this.escherData.getType() == EscherRecordType.DG_CONTAINER) {
            EscherRecordData erd = new EscherRecordData(this, 80);
            Assert.verify(erd.getType() == EscherRecordType.SP_CONTAINER);
            this.readSpContainer = new SpContainer(erd);
        } else {
            Assert.verify(this.escherData.getType() == EscherRecordType.SP_CONTAINER);
            this.readSpContainer = new SpContainer(er);
        }
        Sp sp = (Sp)this.readSpContainer.getChildren()[0];
        this.objectId = sp.getShapeId() - 1024;
        Opt opt = (Opt)this.readSpContainer.getChildren()[1];
        if (opt.getProperty(260) != null) {
            this.blipId = opt.getProperty((int)260).value;
        }
        if (opt.getProperty(261) != null) {
            this.imageFile = new File(opt.getProperty((int)261).stringValue);
        } else if (this.objRecord.getType() != ObjRecord.MSOFFICEDRAWING) {
            logger.warn("no filename property for drawing");
            this.imageFile = new File(Integer.toString(this.blipId));
        }
        ClientAnchor clientAnchor = (ClientAnchor)this.readSpContainer.getChildren()[2];
        this.x = clientAnchor.getX1();
        this.y = clientAnchor.getY1();
        this.width = clientAnchor.getX2() - this.x;
        this.height = clientAnchor.getY2() - this.y;
        this.initialized = true;
    }

    protected File getImageFile() {
        return this.imageFile;
    }

    protected String getImageFilePath() {
        if (this.imageFile == null) {
            return this.blipId != 0 ? Integer.toString(this.blipId) : "__new__image__";
        }
        return this.imageFile.getPath();
    }

    final void setObjectId(int objid, int bip) {
        this.objectId = objid;
        this.blipId = bip;
        if (this.origin == READ) {
            this.origin = READ_WRITE;
        }
    }

    final int getObjectId() {
        return this.objectId;
    }

    final int getBlipId() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.blipId;
    }

    public byte[] getData() {
        return this.drawingData;
    }

    MsoDrawingRecord getMsoDrawingRecord() {
        return this.msoDrawingRecord;
    }

    ObjRecord getObjRecord() {
        return this.objRecord;
    }

    public SpContainer getSpContainer() {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.origin == READ) {
            return this.getReadSpContainer();
        }
        SpContainer spContainer = new SpContainer();
        Sp sp = new Sp(Sp.PICTURE_FRAME, 1024 + this.objectId, 2560);
        spContainer.add(sp);
        Opt opt = new Opt();
        opt.addProperty(260, true, false, this.blipId);
        String filePath = this.imageFile != null ? this.imageFile.getPath() : "";
        opt.addProperty(261, true, true, filePath.length() * 2, filePath);
        opt.addProperty(447, false, false, 65536);
        opt.addProperty(959, false, false, 524288);
        spContainer.add(opt);
        ClientAnchor clientAnchor = new ClientAnchor(this.x, this.y, this.x + this.width, this.y + this.height);
        spContainer.add(clientAnchor);
        ClientData clientData = new ClientData();
        spContainer.add(clientData);
        return spContainer;
    }

    void setDrawingGroup(DrawingGroup dg2) {
        this.drawingGroup = dg2;
    }

    DrawingGroup getDrawingGroup() {
        return this.drawingGroup;
    }

    Origin getOrigin() {
        return this.origin;
    }

    int getReferenceCount() {
        return this.referenceCount;
    }

    void setReferenceCount(int r2) {
        this.referenceCount = r2;
    }

    public double getX() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.x;
    }

    public void setX(double x2) {
        if (this.origin == READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = READ_WRITE;
        }
        this.x = x2;
    }

    public double getY() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.y;
    }

    public void setY(double y2) {
        if (this.origin == READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = READ_WRITE;
        }
        this.y = y2;
    }

    public double getWidth() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.width;
    }

    public void setWidth(double w2) {
        if (this.origin == READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = READ_WRITE;
        }
        this.width = w2;
    }

    public double getHeight() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.height;
    }

    public void setHeight(double h2) {
        if (this.origin == READ) {
            if (!this.initialized) {
                this.initialize();
            }
            this.origin = READ_WRITE;
        }
        this.height = h2;
    }

    private SpContainer getReadSpContainer() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.readSpContainer;
    }

    public byte[] getImageData() {
        Assert.verify(this.origin == READ || this.origin == READ_WRITE);
        if (!this.initialized) {
            this.initialize();
        }
        return this.drawingGroup.getImageData(this.blipId);
    }

    byte[] getImageBytes() throws IOException {
        if (this.origin == READ || this.origin == READ_WRITE) {
            return this.getImageData();
        }
        Assert.verify(this.origin == WRITE);
        if (this.imageFile == null) {
            Assert.verify(this.imageData != null);
            return this.imageData;
        }
        byte[] data = new byte[(int)this.imageFile.length()];
        FileInputStream fis = new FileInputStream(this.imageFile);
        fis.read(data, 0, data.length);
        fis.close();
        return data;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class Origin {
        Origin() {
        }
    }
}

