/*
 * Decompiled with CFR 0.152.
 */
package jxl.demo;

import common.Logger;
import java.io.File;
import java.io.OutputStream;
import jxl.Cell;
import jxl.Range;
import jxl.Workbook;
import jxl.demo.BiffDump;
import jxl.demo.CSV;
import jxl.demo.Formulas;
import jxl.demo.PropertySetsReader;
import jxl.demo.ReadWrite;
import jxl.demo.Write;
import jxl.demo.WriteAccess;
import jxl.demo.XML;

public class Demo {
    private static final int CSVFormat = 13;
    private static final int XMLFormat = 14;
    private static Logger logger = Logger.getLogger(class$jxl$demo$Demo == null ? (class$jxl$demo$Demo = Demo.class$("jxl.demo.Demo")) : class$jxl$demo$Demo);
    static /* synthetic */ Class class$jxl$demo$Demo;

    private static void displayHelp() {
        System.err.println("Command format:  Demo [-unicode] [-csv] [-hide] excelfile");
        System.err.println("                 Demo -xml [-format]  excelfile");
        System.err.println("                 Demo -write excelfile");
        System.err.println("                 Demo -formulas excelfile");
        System.err.println("                 Demo -readwrite|-rw excelfile output");
        System.err.println("                 Demo -biffdump | -bd | -wa | -ps excelfile");
        System.err.println("                 Demo -version");
        System.err.println("                 Demo -logtest");
        System.err.println("                 Demo -h|-help");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            Demo.displayHelp();
            System.exit(1);
        }
        if (args[0].equals("-help") || args[0].equals("-h")) {
            Demo.displayHelp();
            System.exit(1);
        }
        if (args[0].equals("-version")) {
            System.out.println("v" + Workbook.getVersion());
            System.exit(0);
        }
        if (args[0].equals("-logtest")) {
            logger.debug("A sample \"debug\" message");
            logger.info("A sample \"info\" message");
            logger.warn("A sample \"warning\" message");
            logger.error("A sample \"error\" message");
            logger.fatal("A sample \"fatal\" message");
            System.exit(0);
        }
        boolean write = false;
        boolean readwrite = false;
        boolean formulas = false;
        boolean biffdump = false;
        boolean jxlversion = false;
        boolean propertysets = false;
        String file = args[0];
        String outputFile = null;
        if (args[0].equals("-write")) {
            write = true;
            file = args[1];
        } else if (args[0].equals("-formulas")) {
            formulas = true;
            file = args[1];
        } else if (args[0].equals("-biffdump") || args[0].equals("-bd")) {
            biffdump = true;
            file = args[1];
        } else if (args[0].equals("-wa")) {
            jxlversion = true;
            file = args[1];
        } else if (args[0].equals("-ps")) {
            propertysets = true;
            file = args[1];
        } else if (args[0].equals("-readwrite") || args[0].equals("-rw")) {
            readwrite = true;
            file = args[1];
            outputFile = args[2];
        } else {
            file = args[args.length - 1];
        }
        String encoding = "UTF8";
        int format = 13;
        boolean formatInfo = false;
        boolean hideCells = false;
        if (!(write || readwrite || formulas || biffdump || jxlversion || propertysets)) {
            for (int i2 = 0; i2 < args.length - 1; ++i2) {
                if (args[i2].equals("-unicode")) {
                    encoding = "UnicodeBig";
                    continue;
                }
                if (args[i2].equals("-xml")) {
                    format = 14;
                    continue;
                }
                if (args[i2].equals("-csv")) {
                    format = 13;
                    continue;
                }
                if (args[i2].equals("-format")) {
                    formatInfo = true;
                    continue;
                }
                if (args[i2].equals("-hide")) {
                    hideCells = true;
                    continue;
                }
                System.err.println("Command format:  CSV [-unicode] [-xml|-csv] excelfile");
                System.exit(1);
            }
        }
        try {
            if (write) {
                Write w2 = new Write(file);
                w2.write();
            } else if (readwrite) {
                ReadWrite rw = new ReadWrite(file, outputFile);
                rw.readWrite();
            } else if (formulas) {
                Workbook w3 = Workbook.getWorkbook(new File(file));
                Formulas f2 = new Formulas(w3, System.out, encoding);
                w3.close();
            } else if (biffdump) {
                BiffDump bd2 = new BiffDump(new File(file), (OutputStream)System.out);
            } else if (jxlversion) {
                WriteAccess bd3 = new WriteAccess(new File(file));
            } else if (propertysets) {
                PropertySetsReader psr = new PropertySetsReader(new File(file), System.out);
            } else {
                Workbook w4 = Workbook.getWorkbook(new File(file));
                if (format == 13) {
                    CSV csv = new CSV(w4, System.out, encoding, hideCells);
                } else if (format == 14) {
                    XML xml = new XML(w4, System.out, encoding, formatInfo);
                }
                w4.close();
            }
        }
        catch (Throwable t2) {
            System.out.println(t2.toString());
            t2.printStackTrace();
        }
    }

    private static void findTest(Workbook w2) {
        int i2;
        Range[] range;
        logger.info("Find test");
        Cell c2 = w2.findCellByName("named1");
        if (c2 != null) {
            logger.info("named1 contents:  " + c2.getContents());
        }
        if ((c2 = w2.findCellByName("named2")) != null) {
            logger.info("named2 contents:  " + c2.getContents());
        }
        if ((c2 = w2.findCellByName("namedrange")) != null) {
            logger.info("named2 contents:  " + c2.getContents());
        }
        if ((range = w2.findByName("namedrange")) != null) {
            c2 = range[0].getTopLeft();
            logger.info("namedrange top left contents:  " + c2.getContents());
            c2 = range[0].getBottomRight();
            logger.info("namedrange bottom right contents:  " + c2.getContents());
        }
        if ((range = w2.findByName("nonadjacentrange")) != null) {
            for (i2 = 0; i2 < range.length; ++i2) {
                c2 = range[i2].getTopLeft();
                logger.info("nonadjacent top left contents:  " + c2.getContents());
                c2 = range[i2].getBottomRight();
                logger.info("nonadjacent bottom right contents:  " + c2.getContents());
            }
        }
        if ((range = w2.findByName("horizontalnonadjacentrange")) != null) {
            for (i2 = 0; i2 < range.length; ++i2) {
                c2 = range[i2].getTopLeft();
                logger.info("horizontalnonadjacent top left contents:  " + c2.getContents());
                c2 = range[i2].getBottomRight();
                logger.info("horizontalnonadjacent bottom right contents:  " + c2.getContents());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

