/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.ColumnBuilder;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.ImportFilter;
import com.healthmarketscience.jackcess.SimpleImportFilter;
import com.healthmarketscience.jackcess.Table;
import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportUtil {
    private static final Log LOG = LogFactory.getLog(ImportUtil.class);
    private static final int COPY_TABLE_BATCH_SIZE = 200;
    static final String LINE_SEPARATOR = System.getProperty("line.separator");

    private ImportUtil() {
    }

    public static String importResultSet(ResultSet source, Database db2, String name) throws SQLException, IOException {
        return ImportUtil.importResultSet(source, db2, name, SimpleImportFilter.INSTANCE);
    }

    public static String importResultSet(ResultSet source, Database db2, String name, ImportFilter filter) throws SQLException, IOException {
        return ImportUtil.importResultSet(source, db2, name, filter, false);
    }

    public static String importResultSet(ResultSet source, Database db2, String name, ImportFilter filter, boolean useExistingTable) throws SQLException, IOException {
        ResultSetMetaData md = source.getMetaData();
        name = Database.escapeIdentifier(name);
        Table table = null;
        if (!useExistingTable || (table = db2.getTable(name)) == null) {
            LinkedList<Column> columns = new LinkedList<Column>();
            for (int i2 = 1; i2 <= md.getColumnCount(); ++i2) {
                Column column = new Column();
                column.setName(Database.escapeIdentifier(md.getColumnName(i2)));
                int lengthInUnits = md.getColumnDisplaySize(i2);
                column.setSQLType(md.getColumnType(i2), lengthInUnits);
                DataType type = column.getType();
                if (type.isTrueVariableLength() && !type.isLongValue()) {
                    column.setLengthInUnits((short)lengthInUnits);
                }
                if (type.getHasScalePrecision()) {
                    int scale = md.getScale(i2);
                    int precision = md.getPrecision(i2);
                    if (type.isValidScale(scale)) {
                        column.setScale((byte)scale);
                    }
                    if (type.isValidPrecision(precision)) {
                        column.setPrecision((byte)precision);
                    }
                }
                columns.add(column);
            }
            table = ImportUtil.createUniqueTable(db2, name, columns, md, filter);
        }
        ArrayList<Object[]> rows = new ArrayList<Object[]>(200);
        int numColumns = md.getColumnCount();
        while (source.next()) {
            Object[] row = new Object[numColumns];
            for (int i3 = 0; i3 < row.length; ++i3) {
                row[i3] = source.getObject(i3 + 1);
            }
            rows.add(filter.filterRow(row));
            if (rows.size() != 200) continue;
            table.addRows(rows);
            rows.clear();
        }
        if (rows.size() > 0) {
            table.addRows(rows);
        }
        return table.getName();
    }

    public static String importFile(File f2, Database db2, String name, String delim) throws IOException {
        return ImportUtil.importFile(f2, db2, name, delim, SimpleImportFilter.INSTANCE);
    }

    public static String importFile(File f2, Database db2, String name, String delim, ImportFilter filter) throws IOException {
        return ImportUtil.importFile(f2, db2, name, delim, '\"', filter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String importFile(File f2, Database db2, String name, String delim, char quote, ImportFilter filter, boolean useExistingTable) throws IOException {
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(f2));
            String string = ImportUtil.importReader(in, db2, name, delim, quote, filter, useExistingTable);
            return string;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    LOG.warn("Could not close file " + f2.getAbsolutePath(), ex);
                }
            }
        }
    }

    public static String importReader(BufferedReader in, Database db2, String name, String delim) throws IOException {
        return ImportUtil.importReader(in, db2, name, delim, SimpleImportFilter.INSTANCE);
    }

    public static String importReader(BufferedReader in, Database db2, String name, String delim, ImportFilter filter) throws IOException {
        return ImportUtil.importReader(in, db2, name, delim, filter, false);
    }

    public static String importReader(BufferedReader in, Database db2, String name, String delim, ImportFilter filter, boolean useExistingTable) throws IOException {
        return ImportUtil.importReader(in, db2, name, delim, '\"', filter, useExistingTable);
    }

    public static String importReader(BufferedReader in, Database db2, String name, String delim, char quote, ImportFilter filter, boolean useExistingTable) throws IOException {
        String line = in.readLine();
        if (line == null || line.trim().length() == 0) {
            return null;
        }
        Pattern delimPat = Pattern.compile(delim);
        try {
            name = Database.escapeIdentifier(name);
            Table table = null;
            if (!useExistingTable || (table = db2.getTable(name)) == null) {
                LinkedList<Column> columns = new LinkedList<Column>();
                String[] columnNames = ImportUtil.splitLine(line, delimPat, quote, in, 0);
                for (int i2 = 0; i2 < columnNames.length; ++i2) {
                    columns.add(new ColumnBuilder(columnNames[i2], DataType.TEXT).escapeName().setLength((short)DataType.TEXT.getMaxSize()).toColumn());
                }
                table = ImportUtil.createUniqueTable(db2, name, columns, null, filter);
            }
            ArrayList<Object[]> rows = new ArrayList<Object[]>(200);
            int numColumns = table.getColumnCount();
            while ((line = in.readLine()) != null) {
                Object[] data = ImportUtil.splitLine(line, delimPat, quote, in, numColumns);
                rows.add(filter.filterRow(data));
                if (rows.size() != 200) continue;
                table.addRows(rows);
                rows.clear();
            }
            if (rows.size() > 0) {
                table.addRows(rows);
            }
            return table.getName();
        }
        catch (SQLException e2) {
            throw (IOException)new IOException(e2.getMessage()).initCause(e2);
        }
    }

    private static String[] splitLine(String line, Pattern delim, char quote, BufferedReader in, int numColumns) throws IOException {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        Matcher m2 = delim.matcher(line);
        int idx = 0;
        while (idx < line.length()) {
            if (line.charAt(idx) == quote) {
                int endIdx;
                block6: {
                    sb.setLength(0);
                    ++idx;
                    while (true) {
                        if ((endIdx = line.indexOf(quote, idx)) >= 0) {
                            sb.append(line, idx, endIdx);
                            if (++endIdx < line.length() && line.charAt(endIdx) == quote) {
                                sb.append(quote);
                                idx = endIdx + 1;
                                continue;
                            }
                            break block6;
                        }
                        sb.append(line, idx, line.length());
                        sb.append(LINE_SEPARATOR);
                        idx = 0;
                        line = in.readLine();
                        if (line == null) break;
                    }
                    throw new EOFException("Missing end of quoted value " + sb);
                }
                idx = endIdx;
                tokens.add(sb.toString());
                idx = m2.find(idx) ? m2.end() : line.length();
                continue;
            }
            if (m2.find(idx)) {
                tokens.add(line.substring(idx, m2.start()));
                idx = m2.end();
                continue;
            }
            tokens.add(line.substring(idx));
            idx = line.length();
        }
        return tokens.toArray(new String[Math.max(tokens.size(), numColumns)]);
    }

    private static Table createUniqueTable(Database db2, String name, List<Column> columns, ResultSetMetaData md, ImportFilter filter) throws IOException, SQLException {
        String baseName = name;
        int counter = 2;
        while (db2.getTable(name) != null) {
            name = baseName + counter++;
        }
        db2.createTable(name, filter.filterColumns(columns, md));
        return db2.getTable(name);
    }
}

