/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.ByteUtil;
import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.JetFormat;
import com.healthmarketscience.jackcess.PageChannel;
import com.healthmarketscience.jackcess.PropertyMap;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMaps
implements Iterable<PropertyMap> {
    public static final String DEFAULT_NAME = "";
    private static final short PROPERTY_NAME_LIST = 128;
    private static final short DEFAULT_PROPERTY_VALUE_LIST = 0;
    private static final short COLUMN_PROPERTY_VALUE_LIST = 1;
    private final Map<String, PropertyMap> _maps = new LinkedHashMap<String, PropertyMap>();
    private final int _objectId;

    public PropertyMaps(int objectId) {
        this._objectId = objectId;
    }

    public int getObjectId() {
        return this._objectId;
    }

    public int getSize() {
        return this._maps.size();
    }

    public boolean isEmpty() {
        return this._maps.isEmpty();
    }

    public PropertyMap getDefault() {
        return this.get(DEFAULT_NAME, (short)0);
    }

    public PropertyMap get(String name) {
        return this.get(name, (short)1);
    }

    private PropertyMap get(String name, short type) {
        String lookupName = Database.toLookupName(name);
        PropertyMap map = this._maps.get(lookupName);
        if (map == null) {
            map = new PropertyMap(name, type);
            this._maps.put(lookupName, map);
        }
        return map;
    }

    public void put(PropertyMap map) {
        this._maps.put(Database.toLookupName(map.getName()), map);
    }

    @Override
    public Iterator<PropertyMap> iterator() {
        return this._maps.values().iterator();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<PropertyMap> iter = this.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Handler {
        private final Database _database;
        private final Map<DataType, PropColumn> _columns = new HashMap<DataType, PropColumn>();

        Handler(Database database) {
            this._database = database;
        }

        public PropertyMaps read(byte[] propBytes, int objectId) throws IOException {
            PropertyMaps maps = new PropertyMaps(objectId);
            if (propBytes == null || propBytes.length == 0) {
                return maps;
            }
            ByteBuffer bb2 = ByteBuffer.wrap(propBytes).order(PageChannel.DEFAULT_BYTE_ORDER);
            boolean knownType = false;
            for (byte[] tmpType : JetFormat.PROPERTY_MAP_TYPES) {
                if (!ByteUtil.matchesRange(bb2, bb2.position(), tmpType)) continue;
                ByteUtil.forward(bb2, tmpType.length);
                knownType = true;
                break;
            }
            if (!knownType) {
                throw new IOException("Uknown property map type " + ByteUtil.toHexString(bb2, 4));
            }
            List<String> propNames = null;
            while (bb2.hasRemaining()) {
                int len = bb2.getInt();
                short type = bb2.getShort();
                int endPos = bb2.position() + len - 6;
                ByteBuffer bbBlock = PageChannel.narrowBuffer(bb2, bb2.position(), endPos);
                if (type == 128) {
                    propNames = this.readPropertyNames(bbBlock);
                } else if (type == 0 || type == 1) {
                    maps.put(this.readPropertyValues(bbBlock, propNames, type));
                } else {
                    throw new IOException("Unknown property block type " + type);
                }
                bb2.position(endPos);
            }
            return maps;
        }

        private List<String> readPropertyNames(ByteBuffer bbBlock) {
            ArrayList<String> names = new ArrayList<String>();
            while (bbBlock.hasRemaining()) {
                names.add(this.readPropName(bbBlock));
            }
            return names;
        }

        private PropertyMap readPropertyValues(ByteBuffer bbBlock, List<String> propNames, short blockType) throws IOException {
            String mapName = PropertyMaps.DEFAULT_NAME;
            if (bbBlock.hasRemaining()) {
                int nameBlockLen = bbBlock.getInt();
                int endPos = bbBlock.position() + nameBlockLen - 4;
                if (nameBlockLen > 6) {
                    mapName = this.readPropName(bbBlock);
                }
                bbBlock.position(endPos);
            }
            PropertyMap map = new PropertyMap(mapName, blockType);
            while (bbBlock.hasRemaining()) {
                short valLen = bbBlock.getShort();
                int endPos = bbBlock.position() + valLen - 2;
                byte flag = bbBlock.get();
                DataType dataType = DataType.fromByte(bbBlock.get());
                short nameIdx = bbBlock.getShort();
                short dataSize = bbBlock.getShort();
                String propName = propNames.get(nameIdx);
                PropColumn col = this.getColumn(dataType, propName, dataSize);
                byte[] data = new byte[dataSize];
                bbBlock.get(data);
                Object value = col.read(data);
                map.put(propName, dataType, flag, value);
                bbBlock.position(endPos);
            }
            return map;
        }

        private String readPropName(ByteBuffer buffer) {
            short nameLength = buffer.getShort();
            byte[] nameBytes = new byte[nameLength];
            buffer.get(nameBytes);
            return Column.decodeUncompressedText(nameBytes, this._database.getCharset());
        }

        private PropColumn getColumn(DataType dataType, String propName, int dataSize) {
            PropColumn col;
            if (this.isPseudoGuidColumn(dataType, propName, dataSize)) {
                dataType = DataType.GUID;
            }
            if ((col = this._columns.get((Object)dataType)) == null) {
                DataType colType = dataType;
                if (dataType == DataType.MEMO) {
                    colType = DataType.TEXT;
                } else if (dataType == DataType.OLE) {
                    colType = DataType.BINARY;
                }
                col = colType == DataType.BOOLEAN ? new BooleanPropColumn() : new PropColumn();
                col.setType(colType);
                if (col.isVariableLength()) {
                    col.setLength((short)colType.getMaxSize());
                }
            }
            return col;
        }

        private boolean isPseudoGuidColumn(DataType dataType, String propName, int dataSize) {
            return dataType == DataType.BINARY && dataSize == DataType.GUID.getFixedSize() && "GUID".equalsIgnoreCase(propName);
        }

        private final class BooleanPropColumn
        extends PropColumn {
            private BooleanPropColumn() {
            }

            public Object read(byte[] data) throws IOException {
                return data[0] != 0 ? Boolean.TRUE : Boolean.FALSE;
            }

            public ByteBuffer write(Object obj, int remainingRowLength) throws IOException {
                ByteBuffer buffer = this.getPageChannel().createBuffer(1);
                buffer.put(((Number)BooleanPropColumn.booleanToInteger(obj)).byteValue());
                buffer.flip();
                return buffer;
            }
        }

        private class PropColumn
        extends Column {
            private PropColumn() {
            }

            public Database getDatabase() {
                return Handler.this._database;
            }
        }
    }
}

