/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import org.apache.commons.lang.builder.CompareToBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RowId
implements Comparable<RowId> {
    public static final int FIRST_PAGE_NUMBER = -1;
    public static final int LAST_PAGE_NUMBER = -2;
    public static final int INVALID_ROW_NUMBER = -1;
    public static final RowId FIRST_ROW_ID = new RowId(-1, -1);
    public static final RowId LAST_ROW_ID = new RowId(-2, -1);
    private final int _pageNumber;
    private final int _rowNumber;
    private final Type _type;

    public RowId(int pageNumber, int rowNumber) {
        this._pageNumber = pageNumber;
        this._rowNumber = rowNumber;
        this._type = this._pageNumber == -1 ? Type.ALWAYS_FIRST : (this._pageNumber == -2 ? Type.ALWAYS_LAST : Type.NORMAL);
    }

    public int getPageNumber() {
        return this._pageNumber;
    }

    public int getRowNumber() {
        return this._rowNumber;
    }

    public boolean isValid() {
        return this.getRowNumber() >= 0 && this.getPageNumber() >= 0;
    }

    public Type getType() {
        return this._type;
    }

    @Override
    public int compareTo(RowId other) {
        return new CompareToBuilder().append((Object)this.getType(), (Object)other.getType()).append(this.getPageNumber(), other.getPageNumber()).append(this.getRowNumber(), other.getRowNumber()).toComparison();
    }

    public int hashCode() {
        return this.getPageNumber() ^ this.getRowNumber();
    }

    public boolean equals(Object o2) {
        return this == o2 || o2 != null && this.getClass() == o2.getClass() && this.getPageNumber() == ((RowId)o2).getPageNumber() && this.getRowNumber() == ((RowId)o2).getRowNumber();
    }

    public String toString() {
        return this.getPageNumber() + ":" + this.getRowNumber();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ALWAYS_FIRST,
        NORMAL,
        ALWAYS_LAST;

    }
}

