/*
 * Decompiled with CFR 0.152.
 */
package com.oroinc.net.ftp;

import com.oroinc.net.ftp.FTPFile;
import com.oroinc.net.ftp.FTPFileListParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Vector;

public final class DefaultFTPFileListParser
implements FTPFileListParser {
    private int __charArrayToInt(char[] cArray, int n2, int n3) {
        int n4 = 0;
        int n5 = 1;
        while (n3-- > n2) {
            n4 += n5 * (cArray[n3] - 48);
            n5 *= 10;
        }
        return n4;
    }

    private long __charArrayToLong(char[] cArray, int n2, int n3) {
        long l2 = 0L;
        long l3 = 1L;
        while (n3-- > n2) {
            l2 += l3 * (long)(cArray[n3] - 48);
            l3 *= 10L;
        }
        return l2;
    }

    private int __skipWhitespace(char[] cArray, int n2) {
        while (n2 < cArray.length && Character.isWhitespace(cArray[n2])) {
            ++n2;
        }
        return n2;
    }

    private int __skipDigits(char[] cArray, int n2) {
        while (n2 < cArray.length && Character.isDigit(cArray[n2])) {
            ++n2;
        }
        return n2;
    }

    private int __skipNonWhitespace(char[] cArray, int n2) {
        while (n2 < cArray.length && !Character.isWhitespace(cArray[n2])) {
            ++n2;
        }
        return n2;
    }

    private int __skipNonWhitespaceToLower(char[] cArray, int n2) {
        while (n2 < cArray.length && !Character.isWhitespace(cArray[n2])) {
            cArray[n2] = Character.toLowerCase(cArray[n2]);
            ++n2;
        }
        return n2;
    }

    public FTPFile parseFTPEntry(String string) {
        FTPFile fTPFile;
        try {
            int n2;
            int n3;
            char[] cArray = string.toCharArray();
            fTPFile = new FTPFile();
            fTPFile.setRawListing(string);
            boolean bl2 = cArray[0] == 'b' || cArray[0] == 'c';
            switch (cArray[0]) {
                case 'd': {
                    n3 = 1;
                    break;
                }
                case 'l': {
                    n3 = 2;
                    break;
                }
                default: {
                    n3 = 0;
                }
            }
            fTPFile.setType(n3);
            int n4 = 0;
            int n5 = 1;
            while (n4 < 3) {
                fTPFile.setPermission(n4, 0, cArray[n5++] != '-');
                fTPFile.setPermission(n4, 1, cArray[n5++] != '-');
                fTPFile.setPermission(n4, 2, cArray[n5++] != '-');
                ++n4;
            }
            n5 = this.__skipWhitespace(cArray, n5);
            int n6 = this.__skipDigits(cArray, n5);
            fTPFile.setHardLinkCount(this.__charArrayToInt(cArray, n5, n6));
            n5 = this.__skipWhitespace(cArray, n6);
            n6 = this.__skipNonWhitespace(cArray, n5);
            fTPFile.setUser(new String(cArray, n5, n6 - n5));
            n5 = this.__skipWhitespace(cArray, n6);
            n6 = this.__skipNonWhitespace(cArray, n5);
            fTPFile.setGroup(new String(cArray, n5, n6 - n5));
            if (bl2) {
                n5 = this.__skipWhitespace(cArray, n6);
                n6 = this.__skipNonWhitespace(cArray, n5);
                n5 = this.__skipWhitespace(cArray, n6);
                n6 = this.__skipNonWhitespace(cArray, n5);
            } else {
                n5 = this.__skipWhitespace(cArray, n6);
                n6 = this.__skipDigits(cArray, n5);
                fTPFile.setSize(this.__charArrayToLong(cArray, n5, n6));
            }
            n5 = this.__skipWhitespace(cArray, n6);
            n6 = this.__skipNonWhitespaceToLower(cArray, n5);
            switch (cArray[n5]) {
                case 'a': {
                    if (cArray[n6 - 1] == 'r') {
                        n2 = 3;
                        break;
                    }
                    n2 = 7;
                    break;
                }
                case 'd': {
                    n2 = 11;
                    break;
                }
                case 'f': {
                    n2 = 1;
                    break;
                }
                case 'j': {
                    if (cArray[n6 - 1] == 'l') {
                        n2 = 6;
                        break;
                    }
                    if (cArray[n5 + 1] == 'a') {
                        n2 = 0;
                        break;
                    }
                    n2 = 5;
                    break;
                }
                case 'm': {
                    if (cArray[n6 - 1] == 'y') {
                        n2 = 4;
                        break;
                    }
                    n2 = 2;
                    break;
                }
                case 'n': {
                    n2 = 10;
                    break;
                }
                case 'o': {
                    n2 = 9;
                    break;
                }
                case 's': {
                    n2 = 8;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            n5 = this.__skipWhitespace(cArray, n6);
            n6 = this.__skipDigits(cArray, n5);
            n4 = this.__charArrayToInt(cArray, n5, n6);
            n5 = this.__skipWhitespace(cArray, n6);
            n6 = this.__skipDigits(cArray, n5);
            Calendar calendar = Calendar.getInstance();
            try {
                int n7;
                int n8;
                int n9;
                if (cArray[n6] == ':') {
                    n9 = calendar.get(1);
                    n8 = calendar.get(2);
                    if (n8 < n2) {
                        --n9;
                    }
                    n8 = this.__charArrayToInt(cArray, n5, n6);
                    n5 = n6 + 1;
                    n6 = this.__skipDigits(cArray, n5);
                    n7 = this.__charArrayToInt(cArray, n5, n6);
                } else {
                    n7 = -1;
                    n8 = -1;
                    n9 = this.__charArrayToInt(cArray, n5, n6);
                }
                calendar.clear();
                calendar.set(1, n9);
                calendar.set(2, n2);
                calendar.set(5, n4);
                if (n8 != -1) {
                    calendar.set(10, n8);
                    calendar.set(12, n7);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            fTPFile.setTimestamp(calendar);
            n5 = n6 + 1;
            n6 = this.__skipNonWhitespace(cArray, n5);
            if (n6 >= cArray.length) {
                fTPFile.setName(new String(cArray, n5, n6 - n5));
                return fTPFile;
            }
            String string2 = new String(cArray, n5, cArray.length - n5);
            if (n3 == 2) {
                n6 = string2.indexOf(" -> ");
                if (n6 == -1) {
                    fTPFile.setName(string2);
                    return fTPFile;
                }
                fTPFile.setName(string2.substring(0, n6));
                fTPFile.setLink(string2.substring(n6 + 4));
                return fTPFile;
            }
            fTPFile.setName(string2);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            return null;
        }
        return fTPFile;
    }

    public FTPFile[] parseFileList(InputStream inputStream) throws IOException {
        Vector<FTPFile> vector;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        if (string == null) {
            vector = null;
        } else {
            FTPFile fTPFile;
            vector = new Vector<FTPFile>();
            if (string.toLowerCase().startsWith("total")) {
                string = bufferedReader.readLine();
            } else {
                fTPFile = this.parseFTPEntry(string);
                if (fTPFile != null) {
                    vector.addElement(fTPFile);
                }
                string = bufferedReader.readLine();
            }
            while (string != null) {
                if (string.length() == 0 || (fTPFile = this.parseFTPEntry(string)) == null) {
                    vector = null;
                    break;
                }
                vector.addElement(fTPFile);
                string = bufferedReader.readLine();
            }
        }
        if (string != null) {
            while ((string = bufferedReader.readLine()) != null) {
            }
        }
        bufferedReader.close();
        if (vector != null) {
            Object[] objectArray = new FTPFile[vector.size()];
            if (objectArray.length > 0) {
                vector.copyInto(objectArray);
            }
            return objectArray;
        }
        return null;
    }
}

