/*
 * Decompiled with CFR 0.152.
 */
package com.oroinc.net.tftp;

import com.oroinc.io.FromNetASCIIOutputStream;
import com.oroinc.io.ToNetASCIIInputStream;
import com.oroinc.net.tftp.TFTP;
import com.oroinc.net.tftp.TFTPAckPacket;
import com.oroinc.net.tftp.TFTPDataPacket;
import com.oroinc.net.tftp.TFTPErrorPacket;
import com.oroinc.net.tftp.TFTPPacket;
import com.oroinc.net.tftp.TFTPPacketException;
import com.oroinc.net.tftp.TFTPReadRequestPacket;
import com.oroinc.net.tftp.TFTPWriteRequestPacket;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class TFTPClient
extends TFTP {
    public static final int DEFAULT_MAX_TIMEOUTS = 5;
    private int __maxTimeouts = 5;

    public void setMaxTimeouts(int n2) {
        this.__maxTimeouts = this.__maxTimeouts < 1 ? 1 : n2;
    }

    public int getMaxTimeouts() {
        return this.__maxTimeouts;
    }

    public int receiveFile(String string, int n2, OutputStream outputStream, InetAddress inetAddress, int n3) throws IOException {
        TFTPPacket tFTPPacket = null;
        TFTPAckPacket tFTPAckPacket = new TFTPAckPacket(inetAddress, n3, 0);
        this.beginBufferedOps();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 1;
        if (n2 == 0) {
            outputStream = new FromNetASCIIOutputStream(outputStream);
        }
        TFTPPacket tFTPPacket2 = new TFTPReadRequestPacket(inetAddress, n3, string, n2);
        block10: do {
            block16: {
                TFTPErrorPacket tFTPErrorPacket;
                this.bufferedSend(tFTPPacket2);
                block11: while (true) {
                    int n9 = 0;
                    while (n9 < this.__maxTimeouts) {
                        try {
                            tFTPPacket = this.bufferedReceive();
                            break;
                        }
                        catch (SocketException socketException) {
                            if (++n9 < this.__maxTimeouts) continue;
                            this.endBufferedOps();
                            throw new IOException("Connection timed out.");
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            if (++n9 < this.__maxTimeouts) continue;
                            this.endBufferedOps();
                            throw new IOException("Connection timed out.");
                        }
                        catch (TFTPPacketException tFTPPacketException) {
                            this.endBufferedOps();
                            throw new IOException("Bad packet: " + tFTPPacketException.getMessage());
                        }
                    }
                    if (n6 == 0) {
                        n5 = tFTPPacket.getPort();
                        tFTPAckPacket.setPort(n5);
                    }
                    if (!inetAddress.equals(tFTPPacket.getAddress()) || tFTPPacket.getPort() != n5) break;
                    switch (tFTPPacket.getType()) {
                        case 5: {
                            tFTPErrorPacket = (TFTPErrorPacket)tFTPPacket;
                            this.endBufferedOps();
                            throw new IOException("Error code " + tFTPErrorPacket.getError() + " received: " + tFTPErrorPacket.getMessage());
                        }
                        case 3: {
                            TFTPDataPacket tFTPDataPacket = (TFTPDataPacket)tFTPPacket;
                            n7 = tFTPDataPacket.getDataLength();
                            n6 = tFTPDataPacket.getBlockNumber();
                            if (n6 == n8) {
                                try {
                                    outputStream.write(tFTPDataPacket.getData(), tFTPDataPacket.getDataOffset(), n7);
                                }
                                catch (IOException iOException) {
                                    tFTPErrorPacket = new TFTPErrorPacket(inetAddress, n5, 3, "File write failed.");
                                    this.bufferedSend(tFTPErrorPacket);
                                    this.endBufferedOps();
                                    throw iOException;
                                }
                                ++n8;
                                break block16;
                            }
                            this.discardPackets();
                            if (n6 != n8 - 1) continue block11;
                            continue block10;
                        }
                        default: {
                            this.endBufferedOps();
                            throw new IOException("Received unexpected packet type.");
                        }
                    }
                    break;
                }
                tFTPErrorPacket = new TFTPErrorPacket(tFTPPacket.getAddress(), tFTPPacket.getPort(), 5, "Unexpected host or port.");
                this.bufferedSend(tFTPErrorPacket);
                continue;
            }
            tFTPAckPacket.setBlockNumber(n6);
            tFTPPacket2 = tFTPAckPacket;
            n4 += n7;
        } while (n7 == 512);
        this.bufferedSend(tFTPPacket2);
        this.endBufferedOps();
        return n4;
    }

    public int receiveFile(String string, int n2, OutputStream outputStream, String string2, int n3) throws UnknownHostException, IOException {
        return this.receiveFile(string, n2, outputStream, InetAddress.getByName(string2), n3);
    }

    public int receiveFile(String string, int n2, OutputStream outputStream, InetAddress inetAddress) throws IOException {
        return this.receiveFile(string, n2, outputStream, inetAddress, 69);
    }

    public int receiveFile(String string, int n2, OutputStream outputStream, String string2) throws UnknownHostException, IOException {
        return this.receiveFile(string, n2, outputStream, InetAddress.getByName(string2), 69);
    }

    public void sendFile(String string, int n2, InputStream inputStream, InetAddress inetAddress, int n3) throws IOException {
        TFTPPacket tFTPPacket = null;
        TFTPDataPacket tFTPDataPacket = new TFTPDataPacket(inetAddress, n3, 0, this._sendBuffer, 4, 0);
        this.beginBufferedOps();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        if (n2 == 0) {
            inputStream = new ToNetASCIIInputStream(inputStream);
        }
        TFTPPacket tFTPPacket2 = new TFTPWriteRequestPacket(inetAddress, n3, string, n2);
        block8: do {
            block15: {
                TFTPErrorPacket tFTPErrorPacket;
                this.bufferedSend(tFTPPacket2);
                block9: while (true) {
                    int n9 = 0;
                    while (n9 < this.__maxTimeouts) {
                        try {
                            tFTPPacket = this.bufferedReceive();
                            break;
                        }
                        catch (SocketException socketException) {
                            if (++n9 < this.__maxTimeouts) continue;
                            this.endBufferedOps();
                            throw new IOException("Connection timed out.");
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            if (++n9 < this.__maxTimeouts) continue;
                            this.endBufferedOps();
                            throw new IOException("Connection timed out.");
                        }
                        catch (TFTPPacketException tFTPPacketException) {
                            this.endBufferedOps();
                            throw new IOException("Bad packet: " + tFTPPacketException.getMessage());
                        }
                    }
                    if (n6 == 0) {
                        n5 = tFTPPacket.getPort();
                        tFTPDataPacket.setPort(n5);
                    }
                    if (!inetAddress.equals(tFTPPacket.getAddress()) || tFTPPacket.getPort() != n5) break;
                    switch (tFTPPacket.getType()) {
                        case 5: {
                            tFTPErrorPacket = (TFTPErrorPacket)tFTPPacket;
                            this.endBufferedOps();
                            throw new IOException("Error code " + tFTPErrorPacket.getError() + " received: " + tFTPErrorPacket.getMessage());
                        }
                        case 4: {
                            TFTPAckPacket tFTPAckPacket = (TFTPAckPacket)tFTPPacket;
                            n6 = tFTPAckPacket.getBlockNumber();
                            if (n6 == n8) {
                                ++n8;
                                break block15;
                            }
                            this.discardPackets();
                            if (n6 != n8 - 1) continue block9;
                            continue block8;
                        }
                        default: {
                            this.endBufferedOps();
                            throw new IOException("Received unexpected packet type.");
                        }
                    }
                    break;
                }
                tFTPErrorPacket = new TFTPErrorPacket(tFTPPacket.getAddress(), tFTPPacket.getPort(), 5, "Unexpected host or port.");
                this.bufferedSend(tFTPErrorPacket);
                continue;
            }
            n7 = 512;
            int n10 = 4;
            while (n7 > 0 && (n4 = inputStream.read(this._sendBuffer, n10, n7)) > 0) {
                n10 += n4;
                n7 -= n4;
            }
            tFTPDataPacket.setBlockNumber(n8);
            tFTPDataPacket.setData(this._sendBuffer, 4, n10 - 4);
            tFTPPacket2 = tFTPDataPacket;
        } while (n7 == 0);
        this.bufferedSend(tFTPPacket2);
        this.endBufferedOps();
    }

    public void sendFile(String string, int n2, InputStream inputStream, String string2, int n3) throws UnknownHostException, IOException {
        this.sendFile(string, n2, inputStream, InetAddress.getByName(string2), n3);
    }

    public void sendFile(String string, int n2, InputStream inputStream, InetAddress inetAddress) throws IOException {
        this.sendFile(string, n2, inputStream, inetAddress, 69);
    }

    public void sendFile(String string, int n2, InputStream inputStream, String string2) throws UnknownHostException, IOException {
        this.sendFile(string, n2, inputStream, InetAddress.getByName(string2), 69);
    }
}

