/*
 * Decompiled with CFR 0.152.
 */
package com.oroinc.net.tftp;

import com.oroinc.net.tftp.TFTPPacket;
import com.oroinc.net.tftp.TFTPPacketException;
import java.net.DatagramPacket;
import java.net.InetAddress;

public final class TFTPDataPacket
extends TFTPPacket {
    public static final int MAX_DATA_LENGTH = 512;
    public static final int MIN_DATA_LENGTH = 0;
    int _blockNumber;
    int _length;
    int _offset;
    byte[] _data;

    public TFTPDataPacket(InetAddress inetAddress, int n2, int n3, byte[] byArray, int n4, int n5) {
        super(3, inetAddress, n2);
        this._blockNumber = n3;
        this._data = byArray;
        this._offset = n4;
        this._length = n5 > 512 ? 512 : n5;
    }

    public TFTPDataPacket(InetAddress inetAddress, int n2, int n3, byte[] byArray) {
        this(inetAddress, n2, n3, byArray, 0, byArray.length);
    }

    TFTPDataPacket(DatagramPacket datagramPacket) throws TFTPPacketException {
        super(3, datagramPacket.getAddress(), datagramPacket.getPort());
        this._data = datagramPacket.getData();
        this._offset = 4;
        if (this.getType() != this._data[1]) {
            throw new TFTPPacketException("TFTP operator code does not match type.");
        }
        this._blockNumber = (this._data[2] & 0xFF) << 8 | this._data[3] & 0xFF;
        this._length = datagramPacket.getLength() - 4;
        if (this._length > 512) {
            this._length = 512;
        }
    }

    DatagramPacket _newDatagram(DatagramPacket datagramPacket, byte[] byArray) {
        byArray[0] = 0;
        byArray[1] = (byte)this._type;
        byArray[2] = (byte)((this._blockNumber & 0xFFFF) >> 8);
        byArray[3] = (byte)(this._blockNumber & 0xFF);
        if (byArray != this._data) {
            System.arraycopy(this._data, this._offset, byArray, 4, this._length);
        }
        datagramPacket.setAddress(this._address);
        datagramPacket.setPort(this._port);
        datagramPacket.setData(byArray);
        datagramPacket.setLength(this._length + 4);
        return datagramPacket;
    }

    public DatagramPacket newDatagram() {
        byte[] byArray = new byte[this._length + 4];
        byArray[0] = 0;
        byArray[1] = (byte)this._type;
        byArray[2] = (byte)((this._blockNumber & 0xFFFF) >> 8);
        byArray[3] = (byte)(this._blockNumber & 0xFF);
        System.arraycopy(this._data, this._offset, byArray, 4, this._length);
        return new DatagramPacket(byArray, this._length + 4, this._address, this._port);
    }

    public int getBlockNumber() {
        return this._blockNumber;
    }

    public void setBlockNumber(int n2) {
        this._blockNumber = n2;
    }

    public void setData(byte[] byArray, int n2, int n3) {
        this._data = byArray;
        this._offset = n2;
        this._length = n3;
        this._length = n3 > 512 ? 512 : n3;
    }

    public int getDataLength() {
        return this._length;
    }

    public int getDataOffset() {
        return this._offset;
    }

    public byte[] getData() {
        return this._data;
    }
}

