/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.common;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;

public class AppRunConference {
    private static byte[] m_linkData = null;
    private static ArrayList m_cardInfo = new ArrayList();

    public static void setLinkData(byte[] link) {
        m_linkData = link;
        AppRunConference.setCardInfo();
    }

    public static byte[] getLinkData() {
        return m_linkData;
    }

    public static void setCardInfo() {
        Hashtable<String, Object> cardInfo = null;
        m_cardInfo.clear();
        int i2 = 0;
        int j2 = 4;
        while (i2 < 4) {
            if (m_linkData[j2 + 44] == 1) {
                cardInfo = new Hashtable<String, Object>();
                cardInfo.put("CABINET", m_linkData[j2]);
                cardInfo.put("SLOT", m_linkData[j2 + 1]);
                cardInfo.put("LICENSE", m_linkData[j2 + 2]);
                cardInfo.put("MEETME", m_linkData[j2 + 3]);
                cardInfo.put("VERSION", AppFunctions.byte2str(m_linkData, j2 + 4, 16));
                cardInfo.put("EPLD_VERSION", "V" + String.format("%02x", m_linkData[j2 + 20]));
                cardInfo.put("PCB_VERSION", "V" + String.format("%02x", m_linkData[j2 + 21]));
                cardInfo.put("ADDRESS", AppFunctions.byte2ip(m_linkData, j2 + 22, 16));
                cardInfo.put("MAC_ADDR", AppFunctions.byte2mac(m_linkData, j2 + 38));
                cardInfo.put("STATUS", m_linkData[j2 + 44]);
                cardInfo.put("FTP_PORT", AppFunctions.unsignedValue(AppFunctions.byte2short(m_linkData, j2 + 46)));
                m_cardInfo.add(m_cardInfo.size(), cardInfo);
            }
            ++i2;
            j2 += 48;
        }
    }

    public static ArrayList getCardInfo() {
        return m_cardInfo;
    }

    public static Hashtable getCardInfo(int cab, int slot) {
        Hashtable cardInfo = null;
        int i2 = 0;
        while (i2 < m_cardInfo.size()) {
            cardInfo = (Hashtable)m_cardInfo.get(i2);
            if ((byte)cab == (Byte)cardInfo.get("CABINET") && (byte)slot == (Byte)cardInfo.get("SLOT")) break;
            ++i2;
        }
        return cardInfo;
    }

    public static String getCardVersion(int cab, int slot) {
        String version = "";
        Hashtable cardInfo = AppRunConference.getCardInfo(cab, slot);
        if (cardInfo != null) {
            version = (String)cardInfo.get("VERSION");
        }
        return version;
    }

    public static String getCardAddress(int cab, int slot) {
        String address = "";
        Hashtable cardInfo = AppRunConference.getCardInfo(cab, slot);
        if (cardInfo != null) {
            address = (String)cardInfo.get("ADDRESS");
        }
        return address;
    }

    public static int getCardFtpPort(int cab, int slot) {
        int ftp_port = 21;
        Hashtable cardInfo = AppRunConference.getCardInfo(cab, slot);
        if (cardInfo != null) {
            ftp_port = Integer.parseInt((String)cardInfo.get("FTP_PORT"));
        }
        if (ftp_port == 65535) {
            return 21;
        }
        return ftp_port;
    }

    public static String getMacAddress(int cab, int slot) {
        String mac = "";
        Hashtable cardInfo = AppRunConference.getCardInfo(cab, slot);
        if (cardInfo != null) {
            mac = (String)cardInfo.get("MAC_ADDR");
        }
        return mac;
    }

    public static int getLicenseChannel(int cab, int slot) {
        int count = 0;
        Hashtable cardInfo = AppRunConference.getCardInfo(cab, slot);
        if (cardInfo != null) {
            count = Integer.parseInt((String)cardInfo.get("LICENSE"));
        }
        return count;
    }

    public static int getMeetMeChannel(int cab, int slot) {
        int count = 0;
        Hashtable cardInfo = AppRunConference.getCardInfo(cab, slot);
        if (cardInfo != null) {
            count = Integer.parseInt((String)cardInfo.get("MEETME"));
        }
        return count;
    }

    public static String getEPLDVersion(int cab, int slot) {
        String version = "";
        Hashtable cardInfo = AppRunConference.getCardInfo(cab, slot);
        if (cardInfo != null) {
            version = (String)cardInfo.get("EPLD_VERSION");
        }
        return version;
    }

    public static String getPCBVersion(int cab, int slot) {
        String version = "";
        Hashtable cardInfo = AppRunConference.getCardInfo(cab, slot);
        if (cardInfo != null) {
            version = (String)cardInfo.get("PCB_VERSION");
        }
        return version;
    }

    public static byte[] getSystemTime() {
        byte[] time = new byte[8];
        System.arraycopy(m_linkData, 196, time, 0, 8);
        return time;
    }

    public static String getDispTime(int time) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat format = Integer.parseInt((String)AppProperty.m_properties.get("USER_LANG")) == 4 ? new SimpleDateFormat("HH:mm", Locale.US) : new SimpleDateFormat("a hh:mm", Locale.US);
        cal.set(11, time / 4);
        cal.set(12, time % 4 * 15);
        return format.format(cal.getTime());
    }

    public static long getCurrentTime(int week) {
        Calendar now = Calendar.getInstance();
        int curWeek = 0;
        AppRunConference.vArrayList2Calendar(now, AppRunConference.getSystemTime());
        curWeek = now.get(3);
        AppRunConference.setCheckDate(now);
        now.set(3, curWeek + week);
        now.set(7, now.getFirstDayOfWeek());
        return now.getTimeInMillis();
    }

    public static long getCurrentTime(byte[] date) {
        Calendar now = Calendar.getInstance();
        AppRunConference.vArrayList2Calendar(now, date);
        return now.getTimeInMillis();
    }

    public static void vArrayList2Calendar(Calendar cal, byte[] time) {
        cal.set(1, time[5] + 2000);
        cal.set(2, time[4] - 1);
        cal.set(5, time[3]);
        cal.set(11, time[2]);
        cal.set(12, time[1]);
        cal.set(13, time[0]);
    }

    public static void vCalendar2ArrayList(byte[] time, Calendar cal) {
        time[5] = (byte)(cal.get(1) - 2000);
        time[4] = (byte)(cal.get(2) + 1);
        time[3] = (byte)cal.get(5);
        time[2] = (byte)cal.get(11);
        time[1] = (byte)cal.get(12);
        time[0] = (byte)cal.get(13);
    }

    public static String getCurrentDate(byte[] day) {
        Calendar now = Calendar.getInstance();
        int i2 = 0;
        while (i2 < 8) {
            if (day[i2] != -1) {
                AppRunConference.vArrayList2Calendar(now, day);
                return AppRunConference.szDate2LangLocale(now.getTime(), 0);
            }
            ++i2;
        }
        return "";
    }

    public static ArrayList getCurrentWeek(int week) {
        ArrayList<byte[]> weeks = new ArrayList<byte[]>();
        byte[] date = null;
        Calendar now = Calendar.getInstance();
        int day = 0;
        int curWeek = 0;
        int origYear = 0;
        int newYear = 0;
        AppRunConference.vArrayList2Calendar(now, AppRunConference.getSystemTime());
        curWeek = now.get(3);
        AppRunConference.setCheckDate(now);
        now.set(3, curWeek + week);
        now.set(7, now.getFirstDayOfWeek());
        day = now.get(6);
        origYear = now.get(1);
        int i2 = 0;
        while (i2 < 7) {
            date = new byte[8];
            now.set(6, day + i2);
            date[0] = (byte)now.get(13);
            date[1] = (byte)now.get(12);
            date[2] = (byte)now.get(10);
            date[3] = (byte)now.get(5);
            date[4] = (byte)(now.get(2) + 1);
            date[5] = (byte)(now.get(1) - 2000);
            date[6] = (byte)(now.get(7) - 1);
            date[7] = -1;
            weeks.add(i2, date);
            newYear = now.get(1);
            if (newYear != origYear) {
                now.set(1, origYear);
            }
            ++i2;
        }
        return weeks;
    }

    public static void setCheckDate(Calendar now) {
        Calendar chkNow = Calendar.getInstance();
        AppRunConference.vArrayList2Calendar(chkNow, AppRunConference.getSystemTime());
        int maxday = now.getActualMaximum(5);
        chkNow.set(5, maxday);
        if (chkNow.get(2) + 1 == 12 && chkNow.get(7) != 7 && chkNow.get(4) == now.get(4)) {
            now.set(1, now.get(1) + 1);
        }
    }

    public static byte[] addDate(byte[] date, int value) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, date[5] + 2000);
        cal.set(2, date[4] - 1);
        cal.set(5, date[3]);
        cal.set(11, date[2]);
        cal.set(12, date[1]);
        cal.set(13, date[0]);
        cal.add(5, value);
        byte[] result = new byte[]{(byte)cal.get(13), (byte)cal.get(12), (byte)cal.get(10), (byte)cal.get(5), (byte)(cal.get(2) + 1), (byte)(cal.get(1) - 2000), (byte)(cal.get(7) - 1), -1};
        return result;
    }

    public static int getDifferentDate(byte[] start, byte[] end) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMdd");
        int term = 0;
        Calendar calStart = Calendar.getInstance();
        calStart.set(1, start[5] + 2000);
        calStart.set(2, start[4] - 1);
        calStart.set(5, start[3]);
        Calendar calEnd = Calendar.getInstance();
        calEnd.set(1, end[5] + 2000);
        calEnd.set(2, end[4] - 1);
        calEnd.set(5, end[3]);
        try {
            Date startDate = formatter.parse(formatter.format(calStart.getTime()));
            Date endDate = formatter.parse(formatter.format(calEnd.getTime()));
            term = (int)((endDate.getTime() - startDate.getTime()) / 86400000L);
        }
        catch (ParseException e2) {
            term = -1;
        }
        return term;
    }

    public static String szDate2LangLocale(Date dt2, int iType) {
        SimpleDateFormat b2;
        SimpleDateFormat a2;
        int iLang = 0;
        try {
            iLang = Integer.parseInt((String)AppProperty.m_properties.get("USER_LANG"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String szResult = "";
        Boolean bUse24Hour = true;
        switch (iType) {
            case 0: {
                a2 = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 3);
                break;
            }
            case 1: {
                a2 = (SimpleDateFormat)SimpleDateFormat.getDateInstance(2);
                break;
            }
            case 2: {
                a2 = (SimpleDateFormat)SimpleDateFormat.getTimeInstance(3);
                break;
            }
            case 3: {
                a2 = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 2);
                break;
            }
            default: {
                a2 = (SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 3);
            }
        }
        String szFormat = a2.toPattern();
        if (bUse24Hour.booleanValue() && iType != 3) {
            szFormat = szFormat.replace(" a", "");
            szFormat = szFormat.replace("h", "HH");
        }
        if (iType == 9) {
            szFormat = "MMM W'" + AppLang.getText("th") + "'";
        } else if (iType == 10) {
            szFormat = "dd'('EEE')'";
        }
        switch (iLang) {
            case 0: {
                b2 = new SimpleDateFormat(szFormat, Locale.ENGLISH);
                break;
            }
            case 1: {
                b2 = new SimpleDateFormat(szFormat, Locale.KOREAN);
                break;
            }
            case 2: {
                b2 = new SimpleDateFormat(szFormat);
                break;
            }
            case 3: {
                b2 = new SimpleDateFormat(szFormat, Locale.GERMANY);
                break;
            }
            case 4: {
                b2 = new SimpleDateFormat(szFormat, Locale.ITALIAN);
                break;
            }
            case 5: {
                b2 = new SimpleDateFormat(szFormat, Locale.CHINA);
                break;
            }
            case 6: {
                b2 = new SimpleDateFormat(szFormat);
                break;
            }
            default: {
                b2 = new SimpleDateFormat(szFormat, Locale.US);
            }
        }
        szResult = b2.format(dt2);
        return szResult;
    }
}

