/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils;

import com.sec.osdm.common.AppFileBrowser;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.main.utils.AppDetailData;
import com.sec.osdm.main.utils.AppDialog;
import com.sec.osdm.main.view.AppTreeNode;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class AppCompare
extends AppDialog {
    private final int SIZE_WIDTH = 800;
    private final int SIZE_HEIGHT = 600;
    private AppTextBox m_compText = null;
    private JButton m_compBtn = null;
    private Hashtable m_fileData1 = null;
    private Hashtable m_fileData2 = null;
    private JLabel m_dbFile1 = new JLabel();
    private JLabel m_dbFile2 = new JLabel();
    private boolean[] m_result = null;
    private AppTreeNode m_tnInfo = null;
    private Hashtable m_mmcList = null;
    private byte[] m_data1 = null;
    private byte[] m_data2 = null;

    public AppCompare() {
        this.m_layout = new AppLayout(this.m_contentPane, 800, 600);
        this.createComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppCompare.this.openDialog("DB Comparison", 800, 600);
            }
        });
    }

    private void createComponents() {
        String[] titles = new String[]{"...", "...", AppLang.getText("Start"), AppLang.getText("Close")};
        String[] command = new String[]{"File1", "File2", "Start", "Close"};
        JButton[] buttons = new JButton[4];
        JLabel file1 = new JLabel(String.valueOf(AppLang.getText("File")) + "1", 4);
        JLabel file2 = new JLabel(String.valueOf(AppLang.getText("File")) + "2", 4);
        this.m_corner = new String[][]{{""}};
        this.m_colTitle = new String[][]{{"File 1", "File 2", "Result"}};
        this.m_rowTitle = new String[][]{new String[0]};
        int i2 = 0;
        while (i2 < 4) {
            buttons[i2] = new JButton(titles[i2]);
            buttons[i2].setActionCommand(command[i2]);
            buttons[i2].addActionListener(this);
            ++i2;
        }
        this.m_dbFile1.setBorder(new LineBorder(Color.darkGray));
        this.m_dbFile2.setBorder(new LineBorder(Color.darkGray));
        ArrayList<AppTextBox> compData = new ArrayList<AppTextBox>();
        int i3 = 0;
        while (i3 < 3) {
            this.m_compText = new AppTextBox(0, 0);
            compData.add(i3, this.m_compText);
            ++i3;
        }
        this.m_components.add(0, compData);
        this.m_result = new boolean[1];
        this.m_result[0] = true;
        this.createTable();
        this.m_layout.addComponent(file1, 5, 5, 60, 20);
        this.m_layout.addComponent(this.m_dbFile1, 70, 5, 600, 20);
        this.m_layout.addComponent(buttons[0], 675, 5, 30, 20);
        this.m_layout.addComponent(buttons[2], 715, 5, 70, 20);
        this.m_layout.addComponent(file2, 5, 30, 60, 20);
        this.m_layout.addComponent(this.m_dbFile2, 70, 30, 600, 20);
        this.m_layout.addComponent(buttons[1], 675, 30, 30, 20);
        this.m_layout.addComponent(buttons[3], 715, 30, 70, 20);
    }

    private void createTable() {
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                ArrayList compData = (ArrayList)AppCompare.this.m_components.get(row);
                if (col == 2 && !AppCompare.this.m_result[row]) {
                    return (JButton)compData.get(col);
                }
                return (AppTextBox)compData.get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return !AppCompare.this.m_result[row];
            }
        };
        this.m_model.setColWidth(new int[]{345, 345, 70});
        this.m_model.setRowHeaderHidden();
        this.m_table = new AppTable(this.m_model, 2);
        this.m_layout.addComponent(this.m_table, 5, 55, 785, 510);
    }

    private void startCompare() {
        byte[] val;
        if (this.m_table != null) {
            this.m_contentPane.remove(this.m_table);
            this.m_model = null;
            this.m_table = null;
        }
        this.m_mmcList = new Hashtable();
        for (String key : this.m_fileData1.keySet()) {
            val = (byte[])this.m_fileData1.get(key);
            this.m_mmcList.put(key, val);
        }
        for (String key : this.m_fileData2.keySet()) {
            if (this.m_fileData1.containsKey(key)) continue;
            val = (byte[])this.m_fileData2.get(key);
            this.m_mmcList.put(key, val);
        }
        this.m_rowTitle = new String[this.m_mmcList.size() - 2][1];
        this.m_result = new boolean[this.m_rowTitle.length];
        this.m_components.clear();
        ArrayList<Object> compData = null;
        Vector vtTemp = new Vector(this.m_mmcList.keySet());
        Collections.sort(vtTemp);
        for (String key : vtTemp) {
            if (key.equals("0000") || key.equals("0001")) continue;
            this.m_tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get(key);
            this.m_data1 = null;
            this.m_data2 = null;
            compData = new ArrayList<Object>();
            this.m_compText = new AppTextBox(0, 0);
            if (this.m_fileData1.containsKey(key)) {
                this.m_compText.setText(this.m_tnInfo.getTabTitle());
                this.m_data1 = (byte[])this.m_fileData1.get(key);
            }
            compData.add(0, this.m_compText);
            this.m_compText = new AppTextBox(0, 0);
            if (this.m_fileData2.containsKey(key)) {
                this.m_compText.setText(this.m_tnInfo.getTabTitle());
                this.m_data2 = (byte[])this.m_fileData2.get(key);
            }
            compData.add(1, this.m_compText);
            this.m_result[this.m_components.size()] = true;
            this.m_compText = new AppTextBox(0, 0);
            if (this.m_data1 != null && this.m_data2 != null) {
                if (Arrays.equals(this.m_data1, this.m_data2)) {
                    this.m_compText.setText(AppLang.getText("Same"));
                    compData.add(2, this.m_compText);
                } else {
                    this.m_compBtn = new JButton(AppLang.getText("Detail"));
                    this.m_compBtn.setActionCommand(String.valueOf(key) + ":" + this.m_tnInfo.getTabTitle());
                    this.m_compBtn.addActionListener(this);
                    this.m_result[this.m_components.size()] = false;
                    compData.add(2, this.m_compBtn);
                }
            } else {
                compData.add(2, this.m_compText);
            }
            this.m_components.add(this.m_components.size(), compData);
        }
        this.createTable();
    }

    @Override
    public void runActionEvent(String command) {
        if (command.equals("Start")) {
            if (this.m_dbFile1.getText().trim().equals("") || this.m_dbFile2.getText().trim().equals("")) {
                return;
            }
            this.startCompare();
        } else if (command.equals("File1") || command.equals("File2")) {
            AppFileBrowser browser = new AppFileBrowser();
            browser.setFileFilter(String.valueOf(AppLang.getText("Database File")) + "(*.odm)", "odm");
            if (browser.openBrowser() && browser.checkDatabaseFile()) {
                Hashtable fileData = browser.getDatabaseFile();
                if (command.equals("File1")) {
                    this.m_fileData1 = fileData;
                    this.m_dbFile1.setText(browser.getFilePath());
                } else {
                    this.m_fileData2 = fileData;
                    this.m_dbFile2.setText(browser.getFilePath());
                }
            }
        } else if (command.equals("Close")) {
            this.closeDialog();
        } else {
            String[] info = command.split(":");
            byte[] data1 = (byte[])this.m_fileData1.get(info[0]);
            byte[] data2 = (byte[])this.m_fileData2.get(info[0]);
            new AppDetailData(info[1], data1, data2);
        }
    }
}

