/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.io.AppIOConst;
import com.sec.osdm.main.utils.AppDialog;
import com.sec.osdm.main.view.AppTreeNode;
import com.sec.osdm.pages.utils.AppNumPlan;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.SwingUtilities;

public class AppErrorInfo
extends AppDialog {
    private final int SIZE_WIDTH = 600;
    private final int SIZE_HEIGHT = 400;
    private ArrayList m_menuList = new ArrayList();
    private ArrayList m_compData = null;
    private AppTextBox m_compText = null;

    public AppErrorInfo() {
        this.m_layout = new AppLayout(this.m_contentPane, 600, 400);
        this.createComponents();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AppErrorInfo.this.openDialog("Warning Information", 600, 400);
            }
        });
    }

    private void createComponents() {
        JButton btnClose = new JButton(AppLang.getText("Close"));
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AppErrorInfo.this.closeDialog();
            }
        });
        this.setComponents();
        this.m_corner = new String[][]{{"Menu"}};
        this.m_colTitle = new String[][]{{"Type", "Index", "ID", "Description"}};
        this.m_rowTitle = new String[this.m_menuList.size()][1];
        int i2 = 0;
        while (i2 < this.m_menuList.size()) {
            this.m_rowTitle[i2][0] = (String)this.m_menuList.get(i2);
            ++i2;
        }
        this.createTable();
        this.m_layout.addComponent(btnClose, 510, 5, 80, 20);
        this.m_layout.addComponent(this.m_table, 5, 30, 585, 330);
    }

    private void setComponents() {
        AppTreeNode tnInfo = null;
        byte[] recvData = null;
        byte[] errData = null;
        int cnt = 0;
        this.m_components.clear();
        this.m_menuList.clear();
        Vector vtTemp = new Vector(AppGlobal.g_errorData.keySet());
        Collections.sort(vtTemp);
        for (String msgId : vtTemp) {
            recvData = (byte[])AppGlobal.g_errorData.get(msgId);
            int msgLen = AppFunctions.byte2int(recvData, 8);
            short rcdSize = AppFunctions.byte2short(recvData, 6);
            tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get(msgId);
            errData = new byte[msgLen];
            System.arraycopy(recvData, 18, errData, 0, msgLen);
            int i2 = 0;
            while (i2 < msgLen) {
                String sIndex;
                String sType;
                this.m_compData = new ArrayList();
                short iPort = AppFunctions.byte2short(errData, i2 + 2);
                switch (errData[i2 + 1]) {
                    case 1: {
                        sType = AppLang.getText("Cabinet-Slot");
                        sIndex = "C" + (errData[i2 + 2] + 1) + "-S" + (errData[i2 + 3] + 1);
                        break;
                    }
                    case 2: {
                        sType = AppLang.getText("Tel Number");
                        sIndex = String.valueOf(AppNumPlan.getTelNumber(iPort)) + "(P: " + iPort + ")";
                        break;
                    }
                    case 3: {
                        sType = AppLang.getText("Entry Number");
                        sIndex = "" + iPort;
                        break;
                    }
                    case 4: {
                        sType = AppLang.getText("Port Number");
                        sIndex = iPort + "(T: " + AppNumPlan.getTelNumber(iPort) + ")";
                        break;
                    }
                    case 5: {
                        sType = AppLang.getText("Group-Index");
                        sIndex = "G: " + iPort + "-I: " + (errData[i2 + 4] + 1);
                        break;
                    }
                    case 6: {
                        sType = AppLang.getText("MMC Number");
                        sIndex = AppFunctions.byte2str(errData, i2 + 2, 3);
                        break;
                    }
                    case 16: {
                        sType = AppLang.getText("Entry Number");
                        sIndex = "" + errData[2];
                        break;
                    }
                    default: {
                        sType = AppLang.getText("Etc");
                        sIndex = "";
                    }
                }
                this.m_compText = new AppTextBox(0, 0);
                this.m_compText.setText(sType);
                this.m_compData.add(0, this.m_compText);
                this.m_compText = new AppTextBox(0, 0);
                this.m_compText.setText(sIndex);
                this.m_compData.add(1, this.m_compText);
                this.m_compText = new AppTextBox(0, 0);
                this.m_compText.setText("0x" + String.format("%02x", errData[i2]).toUpperCase());
                this.m_compData.add(2, this.m_compText);
                this.m_compText = new AppTextBox(0, 0);
                this.m_compText.setText((String)AppIOConst.m_htError.get(errData[i2]));
                this.m_compData.add(3, this.m_compText);
                this.m_components.add(cnt, this.m_compData);
                this.m_menuList.add(cnt, tnInfo.getIndex());
                ++cnt;
                i2 += rcdSize;
            }
        }
    }

    private void createTable() {
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                ArrayList compData = (ArrayList)AppErrorInfo.this.m_components.get(row);
                return (AppTextBox)compData.get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_model.setRowWidth(new int[]{50});
        this.m_model.setColWidth(new int[]{100, 100, 50, 265});
        int cnt = 1;
        int i2 = 1;
        while (i2 < this.m_model.getRowHdrRowCount()) {
            if (((String)this.m_model.getRowHdrName(i2 - 1, 0)).equals((String)this.m_model.getRowHdrName(i2, 0))) {
                ++cnt;
            } else {
                this.m_model.setRowHeaderRowSpan(i2 - cnt, 0, cnt);
                cnt = 1;
            }
            ++i2;
        }
        if (cnt > 1) {
            this.m_model.setRowHeaderRowSpan(this.m_model.getRowHdrRowCount() - cnt, 0, cnt);
        }
        this.m_table = new AppTable(this.m_model, 2);
    }

    @Override
    public void closeDialog() {
        AppGlobal.g_errorData.clear();
        this.dispose();
    }
}

