/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.view;

import com.sec.osdm.common.AppImages;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.plaf.MenuItemUI;
import javax.swing.plaf.basic.BasicMenuItemUI;

public class JScrollPopupMenu
extends JPopupMenu {
    private int visibleRowCount;
    private List children;
    JMenuItem previousItem;
    JMenuItem nextItem;
    private static Icon upIcon = AppImages.Img_Up;
    private static Icon downIcon = AppImages.Img_Down;
    private Timer previousTimer = new Timer(100, new MenuScrollAction(-1));
    private Timer nextTimer = new Timer(100, new MenuScrollAction(1));
    private int firstItemIndex;
    private static final int DEFAULT_ROW_COUNT = 15;
    private static final int DELAY = 100;
    private static final String PROPERTY_TIMER = "ScrollableJPopupMenu.timer";

    public JScrollPopupMenu() {
        this(15);
    }

    public JScrollPopupMenu(int rowCount) {
        this.enableEvents(131072L);
        this.visibleRowCount = rowCount;
        this.children = new ArrayList(rowCount);
        MenuMouseAdapter adapter = new MenuMouseAdapter();
        this.previousItem = new ArrowMenuItem(upIcon);
        this.previousItem.putClientProperty(PROPERTY_TIMER, this.previousTimer);
        this.previousItem.addMouseListener(adapter);
        this.nextItem = new ArrowMenuItem(downIcon);
        this.nextItem.putClientProperty(PROPERTY_TIMER, this.nextTimer);
        this.nextItem.addMouseListener(adapter);
        this.refresh();
    }

    public void addComponent(Component c2) {
        this.children.add(c2);
    }

    public void removeAllComponent() {
        this.children.clear();
    }

    public int getCompSize() {
        return this.children.size();
    }

    public JMenuItem getComp(int idx) {
        return (JMenuItem)this.children.get(idx);
    }

    public void removeComp(int idx) {
        this.children.remove(idx);
    }

    public void setfirstItemIndex(int idx) {
        this.firstItemIndex = idx;
    }

    @Override
    public void addSeparator() {
        this.addComponent(new JPopupMenu.Separator());
    }

    @Override
    public void applyComponentOrientation(ComponentOrientation o2) {
        super.applyComponentOrientation(o2);
        for (Component c2 : this.children) {
            c2.applyComponentOrientation(o2);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        this.refresh();
        return super.getPreferredSize();
    }

    @Override
    protected void processMouseWheelEvent(MouseWheelEvent e2) {
        if (this.getComponent(0) == this.previousItem) {
            int amt = e2.getUnitsToScroll() > 0 ? 1 : -1;
            this.firstItemIndex += amt;
            this.refresh();
        }
        super.processMouseWheelEvent(e2);
    }

    private void refresh() {
        this.removeAll();
        int itemCount = this.children.size();
        if (itemCount > this.visibleRowCount) {
            int i2 = 0;
            while (i2 < itemCount) {
                this.add((Component)this.children.get(i2));
                ++i2;
            }
            int w2 = super.getPreferredSize().width;
            this.removeAll();
            this.firstItemIndex = Math.min(itemCount - this.visibleRowCount, this.firstItemIndex);
            this.firstItemIndex = Math.max(0, this.firstItemIndex);
            this.previousItem.setEnabled(this.firstItemIndex > 0);
            this.nextItem.setEnabled(this.firstItemIndex < itemCount - this.visibleRowCount);
            this.add(this.previousItem);
            int i3 = 0;
            while (i3 < this.visibleRowCount && this.firstItemIndex + i3 < itemCount) {
                this.add((Component)this.children.get(this.firstItemIndex + i3));
                ++i3;
            }
            this.add(this.nextItem);
            Dimension size = super.getPreferredSize();
            size.width = w2;
            this.setSize(size);
            this.revalidate();
            this.repaint();
        } else {
            int i4 = 0;
            while (i4 < itemCount) {
                this.add((Component)this.children.get(i4));
                ++i4;
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.refresh();
        }
        super.setVisible(visible);
    }

    private static class ArrowMenuItem
    extends JMenuItem {
        public ArrowMenuItem(Icon icon) {
            super(icon);
        }

        @Override
        public void setUI(MenuItemUI ui) {
            super.setUI(new BasicMenuItemUI(){

                @Override
                public void paintMenuItem(Graphics g2, JComponent c2, Icon checkIcon, Icon arrowIcon, Color bg2, Color fg, int defaultTextIconGap) {
                    JMenuItem mi = (JMenuItem)c2;
                    if (bg2 == null) {
                        bg2 = UIManager.getColor("nimbusSelectionBackground");
                    }
                    this.paintBackground(g2, mi, bg2);
                    Icon icon = mi.getModel().isEnabled() ? ArrowMenuItem.this.getIcon() : ArrowMenuItem.this.getDisabledIcon();
                    int x2 = (ArrowMenuItem.this.getWidth() - icon.getIconWidth()) / 2;
                    icon.paintIcon(c2, g2, x2, 0);
                }
            });
        }
    }

    private static class MenuMouseAdapter
    extends MouseAdapter {
        private MenuMouseAdapter() {
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
            JMenuItem item = (JMenuItem)e2.getSource();
            Timer timer = (Timer)item.getClientProperty(JScrollPopupMenu.PROPERTY_TIMER);
            timer.start();
        }

        @Override
        public void mouseExited(MouseEvent e2) {
            JMenuItem item = (JMenuItem)e2.getSource();
            Timer timer = (Timer)item.getClientProperty(JScrollPopupMenu.PROPERTY_TIMER);
            timer.stop();
        }
    }

    private class MenuScrollAction
    extends AbstractAction {
        private int increment;

        public MenuScrollAction(int increment) {
            this.increment = increment;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            JScrollPopupMenu jScrollPopupMenu = JScrollPopupMenu.this;
            jScrollPopupMenu.firstItemIndex = jScrollPopupMenu.firstItemIndex + this.increment;
            JScrollPopupMenu.this.refresh();
        }
    }
}

