/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.printpreview;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.utils.printpreview.AppPrintPage;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AppPrintPreview2
extends JDialog
implements ActionListener,
KeyListener {
    private static final int ALL_PAGE = 0;
    private static final int SELECT_PAGE = 1;
    private static final int CURRENT_PAGE = 2;
    private static final int MAX_WIDTH_SIZE = 1000;
    private static final int MAX_ROW_COUNT = 67;
    private AppPage mPage = null;
    private AppTableModel mModel = null;
    private JPanel mContentPane = new JPanel(new BorderLayout());
    private ArrayList mPrintPages = new ArrayList();
    private ArrayList mColWidth = new ArrayList();
    private ArrayList mRowHeight = new ArrayList();
    private JLabel mShowPage = new JLabel("", 0);
    private JTextField mStartPage = new JTextField(3);
    private JTextField mEndPage = new JTextField(3);
    private JButton[] mButtons = new JButton[6];
    private int mPrintPage = 0;
    private int mCurPage = 0;
    private int mColCount = 0;
    private int mRowCount = 0;
    private String mHeaderText = "";
    private AppTable[] printTable = null;

    public AppPrintPreview2(AppPage page) {
        this.mPage = page;
        this.mHeaderText = this.mPage.m_tnInfo.getTabTitle();
        this.initTableInfo(this.mPage.m_table);
        this.createComponents();
        this.createPrintPages();
        this.openDialog();
    }

    private void initTableInfo(AppTable table) {
        this.mModel = table.getModels();
        this.mColCount = this.mModel.getColHdrColCount();
        this.mRowCount = this.mModel.getRowHdrRowCount();
        this.mColWidth.clear();
        int i2 = 0;
        while (i2 < this.mColCount) {
            if (this.mModel.isColHidden(i2)) {
                this.mColWidth.add(i2, 0);
            } else {
                this.mColWidth.add(i2, this.mPage.m_model.getColHdrWidth(i2));
            }
            ++i2;
        }
        this.mRowHeight.clear();
        i2 = 0;
        while (i2 < this.mRowCount) {
            if (this.mModel.isRowHidden(i2)) {
                this.mRowHeight.add(i2, 0);
            } else {
                this.mRowHeight.add(i2, 22);
            }
            ++i2;
        }
    }

    private void createComponents() {
        JPanel panControl = new JPanel(new GridLayout(3, 1));
        JPanel[] panPanel = new JPanel[3];
        AppLayout[] layout = new AppLayout[3];
        String[] title = new String[]{"<<", "<", ">", ">>", AppLang.getText("Print"), AppLang.getText("Close")};
        String[] command = new String[]{"First", "Prev", "Next", "Last", "Print", "Close"};
        JRadioButton[] optPage = new JRadioButton[3];
        String[] optTitle = new String[]{AppLang.getText("All"), AppLang.getText("Select Page"), AppLang.getText("Current Page")};
        String[] optCommand = new String[]{"0", "1", "2"};
        ButtonGroup optGroup = new ButtonGroup();
        int i2 = 0;
        while (i2 < panPanel.length) {
            panPanel[i2] = new JPanel(new BorderLayout());
            layout[i2] = new AppLayout(panPanel[i2], 650, 20);
            panControl.add(panPanel[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < optPage.length) {
            optPage[i2] = new JRadioButton(optTitle[i2]);
            optPage[i2].setActionCommand(optCommand[i2]);
            optPage[i2].addActionListener(this);
            optGroup.add(optPage[i2]);
            optPage[i2].setMargin(new Insets(1, 20, 1, 1));
            ++i2;
        }
        optPage[0].setSelected(true);
        i2 = 0;
        while (i2 < this.mButtons.length) {
            this.mButtons[i2] = new JButton(title[i2]);
            this.mButtons[i2].setActionCommand(command[i2]);
            this.mButtons[i2].addActionListener(this);
            this.mButtons[i2].setMargin(new Insets(4, 4, 4, 4));
            this.mButtons[i2].setPreferredSize(new Dimension(40, 20));
            if (i2 > 3) {
                this.mButtons[i2].setPreferredSize(new Dimension(80, 20));
            }
            ++i2;
        }
        layout[0].addComponent(optPage[0], 20, 5, 80, 20);
        layout[1].addComponent(optPage[1], 20, 5, 120, 20);
        this.mStartPage.addKeyListener(this);
        this.mStartPage.setEnabled(false);
        layout[1].addComponent(this.mStartPage, 145, 5, 40, 20);
        layout[1].addComponent(new JLabel("~", 0), 190, 5, 30, 20);
        this.mEndPage.addKeyListener(this);
        this.mEndPage.setEnabled(false);
        layout[1].addComponent(this.mEndPage, 225, 5, 40, 20);
        layout[2].addComponent(optPage[2], 20, 5, 120, 20);
        layout[2].addComponent(this.mButtons[0], 145, 5, 40, 20);
        layout[2].addComponent(this.mButtons[1], 190, 5, 40, 20);
        layout[2].addComponent(this.mShowPage, 230, 5, 100, 20);
        layout[2].addComponent(this.mButtons[2], 330, 5, 40, 20);
        layout[2].addComponent(this.mButtons[3], 375, 5, 40, 20);
        layout[2].addComponent(this.mButtons[4], 460, 5, 80, 20);
        layout[2].addComponent(this.mButtons[5], 550, 5, 80, 20);
        panControl.setPreferredSize(new Dimension(this.getWidth(), 80));
        this.add((Component)panControl, "North");
        this.add((Component)this.mContentPane, "Center");
    }

    private void createPrintPages() {
        int j2;
        ArrayList<ArrayList> rowList = new ArrayList<ArrayList>();
        ArrayList<ArrayList> colList = new ArrayList<ArrayList>();
        ArrayList<Integer> widthInfo = new ArrayList<Integer>();
        ArrayList<Integer> heightInfo = new ArrayList<Integer>();
        int maxRowCount = 67 - this.mPage.m_model.getColHdrRowCount();
        int fixedWidth = 0;
        int totalWidth = 0;
        int totalRow = 0;
        int i2 = 0;
        while (i2 < this.mModel.getRowHdrColCount()) {
            fixedWidth += this.mModel.getRowHdrWidth(i2);
            ++i2;
        }
        totalWidth = fixedWidth;
        widthInfo.add(0);
        i2 = 0;
        while (i2 < this.mColWidth.size()) {
            if (!this.mModel.isColHidden(i2) && (totalWidth += ((Integer)this.mColWidth.get(i2)).intValue()) > 1000) {
                widthInfo.add(i2);
                totalWidth = fixedWidth + (Integer)this.mColWidth.get(i2);
            }
            if (i2 == this.mColWidth.size() - 1 && totalWidth > fixedWidth) {
                widthInfo.add(this.mColWidth.size());
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < widthInfo.size() - 1) {
            ArrayList colWidth = (ArrayList)this.mColWidth.clone();
            j2 = 0;
            while (j2 < colWidth.size()) {
                if (j2 < (Integer)widthInfo.get(i2) || j2 >= (Integer)widthInfo.get(i2 + 1)) {
                    colWidth.set(j2, 0);
                }
                ++j2;
            }
            colList.add(colWidth);
            ++i2;
        }
        heightInfo.add(0);
        i2 = 0;
        while (i2 < this.mRowHeight.size()) {
            if (!this.mModel.isRowHidden(i2) && ++totalRow > maxRowCount) {
                heightInfo.add(i2);
                totalRow = 0;
            }
            if (i2 == this.mRowHeight.size() - 1 && totalRow > 0) {
                heightInfo.add(this.mRowHeight.size());
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < heightInfo.size() - 1) {
            ArrayList rowHeight = (ArrayList)this.mRowHeight.clone();
            j2 = 0;
            while (j2 < rowHeight.size()) {
                if (j2 < (Integer)heightInfo.get(i2) || j2 >= (Integer)heightInfo.get(i2 + 1)) {
                    rowHeight.set(j2, 0);
                }
                ++j2;
            }
            rowList.add(rowHeight);
            ++i2;
        }
        this.mPrintPages.clear();
        i2 = 0;
        while (i2 < rowList.size()) {
            j2 = 0;
            while (j2 < colList.size()) {
                ArrayList page = new ArrayList();
                page.add(colList.get(j2));
                page.add(rowList.get(i2));
                this.mPrintPages.add(page);
                ++j2;
            }
            ++i2;
        }
        if (this.mPrintPages != null && this.mPrintPages.size() > 0) {
            AppTableModel[] model = new AppTableModel[this.mPrintPages.size()];
            int i3 = 0;
            while (i3 < model.length) {
                model[i3] = this.getDeepCopyModel(this.mModel);
                ++i3;
            }
            this.printTable = new AppTable[this.mPrintPages.size()];
            i3 = 0;
            while (i3 < this.printTable.length) {
                this.printTable[i3] = new AppTable(model[i3], 2);
                ++i3;
            }
            this.mStartPage.setText("1");
            this.mEndPage.setText("" + this.mPrintPages.size());
            this.showPrintPage(0);
        } else {
            this.mStartPage.setText("0");
            this.mEndPage.setText("0");
            this.mCurPage = -1;
            i2 = 0;
            while (i2 < 5) {
                this.mButtons[i2].setEnabled(false);
                ++i2;
            }
        }
    }

    public Hashtable readObjectFile(String filePath, Hashtable writeObj) {
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        ObjectInputStream in = null;
        File objData = new File(filePath);
        if (objData.exists()) {
            objData.delete();
        }
        try {
            fos = new FileOutputStream(objData);
            out = new ObjectOutputStream(fos);
            out.writeObject(writeObj);
            fos.flush();
            fos.close();
            out.flush();
            out.close();
            in = new ObjectInputStream(new FileInputStream(objData));
            Hashtable obj = (Hashtable)in.readObject();
            in.close();
            return obj;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public AppTableModel getDeepCopyModel(final AppTableModel tableModel) {
        AppTableModel deepCopyModel = null;
        Hashtable dataList = new Hashtable();
        ArrayList<Object> list = null;
        int row = 0;
        while (row < tableModel.getRowHdrRowCount()) {
            list = new ArrayList<Object>();
            int col = 0;
            while (col < tableModel.getColHdrColCount()) {
                Object obj = tableModel.getValueAt(row, col);
                list.add(obj);
                ++col;
            }
            dataList.put(row, list);
            ++row;
        }
        final Hashtable objList = this.readObjectFile(String.valueOf(AppProperty.m_runDirectory) + "printTemp1", dataList);
        Hashtable<Integer, String[][]> names = new Hashtable<Integer, String[][]>();
        names.put(0, tableModel.getRowHdrNames());
        names.put(1, tableModel.getColHdrNames());
        names.put(2, tableModel.getCornerHdrNames());
        Hashtable name = this.readObjectFile(String.valueOf(AppProperty.m_runDirectory) + "printTemp2", names);
        deepCopyModel = new AppTableModel((String[][])name.get(0), (String[][])name.get(1), (String[][])name.get(2)){

            @Override
            public Object getValueAt(int row, int col) {
                ArrayList rowData = (ArrayList)objList.get(row);
                return rowData.get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return tableModel.isCellEditable(row, col);
            }
        };
        this.setCellSpan(deepCopyModel);
        return deepCopyModel;
    }

    public void setCellSpan(AppTableModel model) {
        String[] cellSpan = this.mPage.m_pageInfo.getCellSpan();
        int i2 = 0;
        while (i2 < cellSpan.length) {
            try {
                String[] span = cellSpan[i2].split(",");
                int row = Integer.parseInt(span[1]);
                int col = Integer.parseInt(span[2]);
                int count = Integer.parseInt(span[3]);
                if (span[0].equals("0")) {
                    model.setRowHeaderRowSpan(row, col, count);
                } else if (span[0].equals("1")) {
                    model.setRowHeaderColSpan(row, col, count);
                } else if (span[0].equals("2")) {
                    model.setColHeaderRowSpan(row, col, count);
                } else if (span[0].equals("3")) {
                    model.setColHeaderColSpan(row, col, count);
                } else if (span[0].equals("4")) {
                    model.setCornerHeaderRowSpan(row, col, count);
                } else if (span[0].equals("5")) {
                    model.setCornerHeaderColSpan(row, col, count);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
    }

    private void showPrintPage(int page) {
        ArrayList pageInfo = (ArrayList)this.mPrintPages.get(page);
        ArrayList colWidth = (ArrayList)pageInfo.get(0);
        ArrayList rowHeight = (ArrayList)pageInfo.get(1);
        try {
            this.mContentPane.removeAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int i2 = 0;
        while (i2 < colWidth.size()) {
            if ((Integer)colWidth.get(i2) == 0) {
                this.printTable[page].setColHidden(i2);
            } else {
                this.printTable[page].setColWidth(i2, (Integer)colWidth.get(i2));
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < rowHeight.size()) {
            if ((Integer)rowHeight.get(i2) == 0) {
                this.printTable[page].setRowHidden(i2);
            } else {
                this.printTable[page].setRowHeight(i2, 22);
            }
            ++i2;
        }
        this.mContentPane.add((Component)this.printTable[page], "Center");
        this.mContentPane.repaint();
        this.mShowPage.setText(page + 1 + " / " + this.mPrintPages.size());
    }

    private void startPrint() {
        int start = 1;
        int end = 1;
        try {
            if (this.mPrintPage == 0) {
                end = this.mPrintPages.size();
            } else if (this.mPrintPage == 2) {
                end = start = this.mCurPage + 1;
            } else {
                if (this.mStartPage.getText().trim().equals("") || this.mEndPage.getText().trim().equals("")) {
                    return;
                }
                start = Integer.parseInt(this.mStartPage.getText().trim());
                if (start > (end = Integer.parseInt(this.mEndPage.getText().trim()))) {
                    int temp = start;
                    start = end;
                    end = temp;
                }
            }
            PrinterJob job = PrinterJob.getPrinterJob();
            job.setJobName("OfficeServ DM");
            int i2 = start - 1;
            while (i2 < end) {
                this.showPrintPage(i2);
                this.printTable[i2].editingStopped(null);
                this.printTable[i2].repaint();
                job.setPrintable(new AppPrintPage(this.printTable[i2], this.mHeaderText, i2 + 1 + "/" + this.mPrintPages.size()));
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                job.print();
                ++i2;
            }
        }
        catch (PrinterException e3) {
            e3.printStackTrace();
        }
    }

    private void openDialog() {
        this.setTitle(this.mPage.m_tnInfo.getTabTitle());
        this.setModal(true);
        this.setIconImage(AppImages.Img_Logo);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                AppPrintPreview2.this.closeDialog();
            }
        });
        this.setSize(690, 750);
        this.setResizable(false);
        this.setLocation(AppGlobal.getCenterPoint(this.getSize().width, this.getSize().height));
        this.setVisible(true);
    }

    private void closeDialog() {
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand().trim();
        if (command.equals("Print")) {
            this.startPrint();
        } else if (command.equals("Close")) {
            this.closeDialog();
        } else if (command.equals("First") || command.equals("Prev") || command.equals("Next") || command.equals("Last")) {
            if (command.equals("First")) {
                this.mCurPage = 0;
            } else if (command.equals("Prev")) {
                --this.mCurPage;
                this.mCurPage = this.mCurPage < 0 ? 0 : this.mCurPage;
            } else if (command.equals("Next")) {
                ++this.mCurPage;
                this.mCurPage = this.mCurPage > this.mPrintPages.size() - 1 ? this.mPrintPages.size() - 1 : this.mCurPage;
            } else if (command.equals("Last")) {
                this.mCurPage = this.mPrintPages.size() - 1;
            }
            this.showPrintPage(this.mCurPage);
        } else {
            this.mPrintPage = Integer.parseInt(command);
            this.mStartPage.setEnabled(false);
            this.mEndPage.setEnabled(false);
            if (this.mPrintPage == 1) {
                this.mStartPage.setEnabled(true);
                this.mEndPage.setEnabled(true);
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e2) {
    }

    @Override
    public void keyReleased(KeyEvent e2) {
        int value;
        JTextField txtPage = (JTextField)e2.getSource();
        String strValue = txtPage.getText().trim();
        int n2 = value = strValue.equals("") ? 1 : Integer.parseInt(strValue);
        if (value < 1 || value > this.mPrintPages.size()) {
            txtPage.setText(strValue.substring(0, strValue.length() - 1));
        }
    }

    @Override
    public void keyTyped(KeyEvent e2) {
        char c2 = e2.getKeyChar();
        if (!Character.isDigit(c2) && c2 != '\\' && c2 != '\u007f') {
            e2.consume();
        }
        if (e2.getSource() == this.mStartPage && this.mStartPage.getText().length() >= 3 || e2.getSource() == this.mEndPage && this.mEndPage.getText().length() >= 3) {
            e2.consume();
        }
    }
}

