/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.pages.utils.components.AppNewCombo;
import com.sec.osdm.pages.utils.components.AppNewText;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppEditorCellComponent;
import com.sec.osdm.pages.utils.table.AppHandlerClear;
import com.sec.osdm.pages.utils.table.AppHandlerCopy;
import com.sec.osdm.pages.utils.table.AppHandlerCut;
import com.sec.osdm.pages.utils.table.AppHandlerFind;
import com.sec.osdm.pages.utils.table.AppHandlerPaste;
import com.sec.osdm.pages.utils.table.AppHandlerRefresh;
import com.sec.osdm.pages.utils.table.AppHandlerRepeat;
import com.sec.osdm.pages.utils.table.AppHandlerSave;
import com.sec.osdm.pages.utils.table.AppHiddenTable;
import com.sec.osdm.pages.utils.table.AppKeyHandler;
import com.sec.osdm.pages.utils.table.AppRendererCellComponent;
import com.sec.osdm.pages.utils.table.ICellComponent;
import com.sec.osdm.pages.utils.table.SpanTableLabelRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.SizeSequence;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AppDataTable
extends AppHiddenTable {
    private SpanTableLabelRenderer m_rendererOfNull = new SpanTableLabelRenderer(this.getTableHeader().getForeground(), this.getTableHeader().getBackground(), 0, null, BorderFactory.createEmptyBorder());
    private SpanTableLabelRenderer m_rendererOfReadOnly = new SpanTableLabelRenderer(this.getTableHeader().getForeground(), AppGlobal.g_ReadOnlyColor, 0, null, BorderFactory.createEmptyBorder());
    private JComponentCellRenderer m_rendererOfComponent = new JComponentCellRenderer();
    private JComponentCellEditor m_editorOfComponent = new JComponentCellEditor();
    Vector<AppKeyHandler> m_vtHandler;

    public AppDataTable(TableModel tm, boolean isPage) {
        super(tm);
        this.prepareShow();
        this.appleyKeyHandler(isPage);
        this.setCellSelectionEnabled(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setSurrendersFocusOnKeystroke(true);
    }

    protected void appleyKeyHandler(boolean isPage) {
        this.m_vtHandler = new Vector(0);
        this.m_vtHandler.add(new AppHandlerClear(this));
        this.m_vtHandler.add(new AppHandlerCopy(this));
        this.m_vtHandler.add(new AppHandlerPaste(this));
        this.m_vtHandler.add(new AppHandlerFind(this));
        this.m_vtHandler.add(new AppHandlerRepeat(this));
        this.m_vtHandler.add(new AppHandlerCut(this));
        if (isPage) {
            this.m_vtHandler.add(new AppHandlerSave(this));
            this.m_vtHandler.add(new AppHandlerRefresh(this));
        }
    }

    protected void prepareShow() {
        this.setDefaultEditor(Object.class, new AppEditorCellComponent());
        this.setDefaultRenderer(Object.class, new AppRendererCellComponent());
        this.setCellSelectionEnabled(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.setSurrendersFocusOnKeystroke(true);
    }

    @Override
    public void setRowHeight(int row, int rowHeight) {
        try {
            Class<JTable> jTableClass = JTable.class;
            Method getRowModelMethod = jTableClass.getDeclaredMethod("getRowModel", null);
            getRowModelMethod.setAccessible(true);
            SizeSequence rowModel = (SizeSequence)getRowModelMethod.invoke((Object)this, null);
            if (rowHeight < 0) {
                throw new IllegalArgumentException("New row height less than 0");
            }
            rowModel.setSize(row, rowHeight);
            this.resizeAndRepaint();
        }
        catch (Exception ex) {
            super.setRowHeight(row, rowHeight);
        }
    }

    @Override
    public void editingStopped(ChangeEvent e2) {
        TableCellEditor editor = this.getCellEditor();
        if (editor != null) {
            Object value = editor.getCellEditorValue();
            if (value instanceof ICellComponent) {
                ((ICellComponent)value).finishEditing();
            }
            this.setValueAt(value, this.editingRow, this.editingColumn);
            this.removeEditor();
        }
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        TableCellRenderer renderer = tableColumn.getCellRenderer();
        if (renderer == null) {
            Class<?> c2 = this.getColumnClass(column);
            if (c2.equals(Object.class)) {
                Object o2 = this.getValueAt(row, column);
                if (o2 != null) {
                    if (o2 instanceof JComponent) {
                        return this.m_rendererOfComponent;
                    }
                    if (!this.getModel().isCellEditable(row, column) || o2 instanceof String) {
                        return this.m_rendererOfReadOnly;
                    }
                    c2 = this.getValueAt(row, column).getClass();
                    if (o2 instanceof AppTextBox) {
                        renderer = this.getDefaultRenderer(c2);
                        ((DefaultTableCellRenderer)renderer).setBackground(((AppTextBox)o2).getBackground());
                        ((DefaultTableCellRenderer)renderer).setHorizontalAlignment(((AppTextBox)o2).getHorizontalAlignment());
                        return renderer;
                    }
                    if (o2 instanceof AppNewText) {
                        renderer = this.getDefaultRenderer(c2);
                        ((DefaultTableCellRenderer)renderer).setBackground(((AppNewText)o2).getBackground());
                        ((DefaultTableCellRenderer)renderer).setHorizontalAlignment(((AppNewText)o2).getHorizontalAlignment());
                        return renderer;
                    }
                    if (o2 instanceof AppNewCombo) {
                        renderer = this.getDefaultRenderer(c2);
                        ((DefaultTableCellRenderer)renderer).setBackground(((AppNewCombo)o2).getBackground());
                        return renderer;
                    }
                } else {
                    return this.m_rendererOfNull;
                }
            }
            renderer = this.getDefaultRenderer(c2);
        }
        return renderer;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        TableColumn tableColumn = this.getColumnModel().getColumn(column);
        TableCellEditor editor = tableColumn.getCellEditor();
        if (editor == null) {
            Class<?> c2 = this.getColumnClass(column);
            if (c2.equals(Object.class)) {
                Object o2 = this.getValueAt(row, column);
                if (o2 instanceof JComponent) {
                    return this.m_editorOfComponent;
                }
                if (o2 != null) {
                    c2 = this.getValueAt(row, column).getClass();
                }
            }
            editor = this.getDefaultEditor(c2);
        }
        return editor;
    }

    protected class JComponentCellEditor
    implements TableCellEditor {
        protected EventListenerList listenerList = new EventListenerList();
        protected transient ChangeEvent changeEvent = null;
        protected JComponent editorComponent = null;

        protected JComponentCellEditor() {
        }

        public Component getComponent() {
            return this.editorComponent;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editorComponent;
        }

        @Override
        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        @Override
        public boolean shouldSelectCell(EventObject anEvent) {
            if (this.editorComponent != null && anEvent instanceof MouseEvent && ((MouseEvent)anEvent).getID() == 501) {
                Component dispatchComponent = SwingUtilities.getDeepestComponentAt(this.editorComponent, 3, 3);
                MouseEvent mouseEvent = (MouseEvent)anEvent;
            }
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        @Override
        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        @Override
        public void addCellEditorListener(CellEditorListener l2) {
            this.listenerList.add(CellEditorListener.class, l2);
        }

        @Override
        public void removeCellEditorListener(CellEditorListener l2) {
            this.listenerList.remove(CellEditorListener.class, l2);
        }

        public void fireEditingStopped() {
            Object[] listeners = this.listenerList.getListenerList();
            int i2 = listeners.length - 2;
            while (i2 >= 0) {
                if (listeners[i2] == CellEditorListener.class) {
                    if (this.changeEvent == null) {
                        this.changeEvent = new ChangeEvent(this);
                    }
                    ((CellEditorListener)listeners[i2 + 1]).editingStopped(this.changeEvent);
                }
                i2 -= 2;
            }
        }

        public void fireEditingCanceled() {
            Object[] listeners = this.listenerList.getListenerList();
            int i2 = listeners.length - 2;
            while (i2 >= 0) {
                if (listeners[i2] == CellEditorListener.class) {
                    if (this.changeEvent == null) {
                        this.changeEvent = new ChangeEvent(this);
                    }
                    ((CellEditorListener)listeners[i2 + 1]).editingCanceled(this.changeEvent);
                }
                i2 -= 2;
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.editorComponent = (JComponent)value;
            return this.editorComponent;
        }
    }

    protected class JComponentCellRenderer
    implements TableCellRenderer {
        protected JComponentCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent comp = (JComponent)value;
            if (isSelected) {
                comp.setBackground(table.getSelectionBackground());
                comp.setForeground(table.getSelectionForeground());
            } else {
                if (!table.isCellEditable(row, column)) {
                    comp.setBackground(Color.WHITE);
                } else {
                    comp.setBackground(table.getBackground());
                }
                comp.setForeground(table.getForeground());
            }
            return comp;
        }
    }
}

