/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import com.sec.osdm.common.AppLang;
import com.sec.osdm.pages.utils.table.AppDataTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import com.sec.osdm.pages.utils.table.ColHeaderTableModel;
import com.sec.osdm.pages.utils.table.ConferenceTableLabelRenderer;
import com.sec.osdm.pages.utils.table.CornerHeaderTableModel;
import com.sec.osdm.pages.utils.table.ITableModel;
import com.sec.osdm.pages.utils.table.RowHeaderTableModel;
import com.sec.osdm.pages.utils.table.SpanInfo;
import com.sec.osdm.pages.utils.table.SpanTable;
import com.sec.osdm.pages.utils.table.SpanTableColumnModel;
import com.sec.osdm.pages.utils.table.SpanTableHeader;
import com.sec.osdm.pages.utils.table.SpanTableLabelRenderer;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class AppTable
extends JScrollPane {
    private int m_eTableType = 0;
    private static int TT_ROW_HEADER_SPAN_TABLE = 1;
    private static int TT_COL_HEADER_SPAN_TABLE = 2;
    private static int TT_EMPTY_TABLE_TYPE = 8;
    public JTable m_rowHeaderTable = null;
    public AppDataTable m_table = null;
    public JTable m_CornerHeaderTable = null;
    public AppDataTable m_CornerTable = null;
    private JLabel m_corner = null;
    private JViewport m_viewport = null;
    private ITableModel m_ITableModel = null;
    private boolean m_bConfImgTable = false;
    public static final int OPTION_CONFIMGTABLE = 0;
    public static final int OPTION_PAGETABLE = 1;
    public static final int OPTION_PAGENOTTABLE = 2;
    private boolean m_isPage = true;

    public AppTable(ITableModel tableModel) {
        this.m_ITableModel = tableModel;
        this.initTable();
    }

    public AppTable(ITableModel tableModel, int option) {
        this.m_ITableModel = tableModel;
        switch (option) {
            case 0: {
                this.m_bConfImgTable = true;
                break;
            }
            case 2: {
                this.m_isPage = false;
                break;
            }
        }
        this.initTable();
    }

    public AppTableModel getModels() {
        return (AppTableModel)this.m_ITableModel;
    }

    private void createTable(ITableModel ItableModel) {
        RowHeaderTableModel rowHeaderTableModel = new RowHeaderTableModel(ItableModel);
        ColHeaderTableModel tableModel = new ColHeaderTableModel(ItableModel);
        SpanTableColumnModel columnModel = null;
        this.m_table = ItableModel.getDataSpanInfo() != null ? new SpanTable((TableModel)tableModel, this.m_isPage) : new AppDataTable((TableModel)tableModel, this.m_isPage);
        this.m_table.setRowHeight(22);
        if (this.m_ITableModel.getIsA104SearchTable()) {
            this.m_eTableType |= TT_COL_HEADER_SPAN_TABLE;
        } else if (ItableModel.getColHeaderSpanInfo() != null) {
            this.m_eTableType |= TT_COL_HEADER_SPAN_TABLE;
            columnModel = new SpanTableColumnModel(ItableModel);
            this.m_table.setColumnModel(columnModel);
            if (this.m_ITableModel.get4601UCDGroup()) {
                this.m_table.setTableHeader(new SpanTableHeader((SpanTableColumnModel)this.m_table.getColumnModel(), this.m_ITableModel.get4601UCDGroup()));
            } else {
                this.m_table.setTableHeader(new SpanTableHeader((SpanTableColumnModel)this.m_table.getColumnModel()));
            }
        } else {
            this.m_table.getTableHeader().setDefaultRenderer(new SpanTableLabelRenderer());
        }
        if (this.m_bConfImgTable) {
            this.m_rowHeaderTable = new SpanTable((TableModel)rowHeaderTableModel, this.m_isPage);
            this.m_rowHeaderTable.setDefaultRenderer(String.class, new ConferenceTableLabelRenderer(this.m_table, 2));
        } else if (ItableModel.getRowHeaderSpanInfo() != null) {
            this.m_rowHeaderTable = new SpanTable((TableModel)rowHeaderTableModel, this.m_isPage);
            this.m_rowHeaderTable.setDefaultRenderer(String.class, new SpanTableLabelRenderer(this.m_table, 2));
        } else {
            this.m_eTableType |= TT_ROW_HEADER_SPAN_TABLE;
            this.m_rowHeaderTable = new AppDataTable((TableModel)rowHeaderTableModel, this.m_isPage);
            this.m_rowHeaderTable.setDefaultRenderer(String.class, new SpanTableLabelRenderer(this.m_table, 2));
            this.m_rowHeaderTable.setRowMargin(0);
            this.m_rowHeaderTable.getColumnModel().setColumnMargin(0);
        }
        this.m_rowHeaderTable.setRowHeight(22);
        this.setCorner();
        if (this.m_ITableModel.IsRowHeaderHidden()) {
            this.m_rowHeaderTable.setPreferredSize(new Dimension(0, 0));
        }
        if (this.m_ITableModel.IsColHeaderHidden()) {
            this.m_table.getTableHeader().setPreferredSize(new Dimension(0, 0));
        }
        this.aplyColumnWidths();
        this.aplyHidden();
        this.m_table.setAutoResizeMode(0);
        this.setViewportView(this.m_table);
        if (this.m_viewport == null) {
            this.m_viewport = new JViewport();
        }
        this.m_viewport.setView(this.m_rowHeaderTable);
        this.m_viewport.setPreferredSize(this.m_rowHeaderTable.getPreferredSize());
        this.setRowHeaderView(this.m_viewport);
    }

    private void initTable() {
        this.m_eTableType = 0;
        this.m_ITableModel.onCreate(this);
        if (this.m_ITableModel.getRowHdrRowCount() == 0 && this.m_ITableModel.getColHdrColCount() == 0) {
            this.createEmptyLabel();
            return;
        }
        if (this.m_ITableModel.getRowHdrRowCount() == 0 || this.m_ITableModel.getColHdrColCount() == 0) {
            this.createEmptyTableModel();
            return;
        }
        this.createTable(this.m_ITableModel);
        this.setHandles();
    }

    private void setHandles() {
        this.m_table.setCellSelectionEnabled(true);
        this.m_table.getTableHeader().addMouseListener(new MouseAdapterColumnHeader(this.m_table));
        this.m_rowHeaderTable.addMouseListener(new MouseAdapterRowHeader(this.m_table, this.m_rowHeaderTable));
    }

    private void createEmptyLabel() {
        this.m_eTableType = TT_EMPTY_TABLE_TYPE;
        this.setRowHeaderView(null);
        this.setCorner("UPPER_LEFT_CORNER", null);
        JLabel lblEmptyLabel = new JLabel("( " + AppLang.getText("No Data") + " )");
        this.setViewportView(lblEmptyLabel);
    }

    private void createEmptyTableModel() {
        this.m_eTableType = TT_EMPTY_TABLE_TYPE;
        AppTableModel objITableModel = null;
        String[] arrCornerNames = new String[this.m_ITableModel.getCornerCount()];
        int i2 = 0;
        while (i2 < this.m_ITableModel.getCornerCount()) {
            arrCornerNames[i2] = this.m_ITableModel.getCornerName(i2);
            ++i2;
        }
        if (this.m_ITableModel.getRowHdrRowCount() == 0) {
            Object[][] tmpRowHeaderName = new String[1][this.m_ITableModel.getCornerCount()];
            int i3 = 0;
            while (i3 < this.m_ITableModel.getCornerCount()) {
                tmpRowHeaderName[0][i3] = " - ";
                ++i3;
            }
            objITableModel = new AppTableModel(tmpRowHeaderName, this.m_ITableModel.getColHdrNames(), arrCornerNames[0]){

                @Override
                public Object getValueAt(int row, int col) {
                    return "( " + AppLang.getText("No Data") + " )";
                }

                @Override
                public boolean isCellEditable(int row, int col) {
                    return false;
                }

                @Override
                public SpanInfo getDataSpanInfo() {
                    SpanInfo spanInfo = null;
                    if (this.getColHdrColCount() > 1) {
                        spanInfo = new SpanInfo(1, this.getColHdrColCount());
                        spanInfo.setColSpan(0, 0, this.getColHdrColCount());
                    }
                    return spanInfo;
                }

                @Override
                public SpanInfo getColHeaderSpanInfo() {
                    return AppTable.this.m_ITableModel.getColHeaderSpanInfo();
                }
            };
        } else {
            objITableModel = new AppTableModel(this.m_ITableModel.getRowHdrNames(), new String[][]{{" - "}}, arrCornerNames[0]){

                @Override
                public Object getValueAt(int row, int col) {
                    return "( " + AppLang.getText("No Data") + " )";
                }

                @Override
                public boolean isCellEditable(int row, int col) {
                    return false;
                }

                @Override
                public SpanInfo getDataSpanInfo() {
                    SpanInfo spanInfo = null;
                    if (this.getRowHdrRowCount() > 1) {
                        spanInfo = new SpanInfo(this.getRowHdrRowCount(), 1);
                        spanInfo.setRowSpan(0, 0, this.getRowHdrRowCount());
                    }
                    return spanInfo;
                }

                @Override
                public SpanInfo getRowHeaderSpanInfo() {
                    return AppTable.this.m_ITableModel.getRowHeaderSpanInfo();
                }
            };
        }
        this.createTable(objITableModel);
    }

    private void aplyColumnWidths() {
        int iWidth = -1;
        int i2 = 0;
        while (i2 < this.m_rowHeaderTable.getColumnCount()) {
            iWidth = this.m_ITableModel.getRowHdrWidth(i2);
            if (iWidth >= 0) {
                this.m_rowHeaderTable.getColumnModel().getColumn(i2).setPreferredWidth(iWidth);
            }
            ++i2;
        }
        iWidth = -1;
        i2 = 0;
        while (i2 < this.m_table.getColumnCount()) {
            iWidth = this.m_ITableModel.getColHdrWidth(i2);
            if (iWidth >= 0) {
                this.m_table.getColumnModel().getColumn(i2).setPreferredWidth(iWidth);
            }
            ++i2;
        }
        if (this.m_ITableModel.getCornerHeaderSpanInfo() != null) {
            iWidth = -1;
            i2 = 0;
            while (i2 < this.m_CornerHeaderTable.getColumnCount()) {
                iWidth = this.m_ITableModel.getRowHdrWidth(i2);
                if (iWidth >= 0) {
                    this.m_CornerHeaderTable.getColumnModel().getColumn(i2).setPreferredWidth(iWidth);
                }
                ++i2;
            }
        }
    }

    private void aplyHidden() {
        int i2 = 0;
        while (i2 < this.m_ITableModel.getRowHdrRowCount()) {
            if (this.m_ITableModel.isRowHidden(i2)) {
                this.setRowHidden(i2);
            }
            ++i2;
        }
        int j2 = 0;
        while (j2 < this.m_ITableModel.getColHdrColCount()) {
            if (this.m_ITableModel.isColHidden(j2)) {
                this.setColHidden(j2);
            }
            ++j2;
        }
    }

    private void setCorner() {
        if (this.m_ITableModel.getCornerHeaderSpanInfo() != null) {
            ColHeaderTableModel tableModel = new ColHeaderTableModel(this.m_ITableModel);
            this.m_CornerTable = new SpanTable((TableModel)tableModel, this.m_isPage);
            CornerHeaderTableModel cornerHeaderTableModel = new CornerHeaderTableModel(this.m_ITableModel);
            this.m_CornerHeaderTable = new SpanTable((TableModel)cornerHeaderTableModel, this.m_isPage);
            this.m_CornerHeaderTable.setDefaultRenderer(String.class, new SpanTableLabelRenderer(this.m_CornerTable, 0));
            this.m_CornerHeaderTable.setRowHeight(18);
            if (this.m_ITableModel.get4601UCDGroup()) {
                this.m_CornerHeaderTable.setRowHeight(22);
            }
            this.m_CornerHeaderTable.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            super.setCorner("UPPER_LEFT_CORNER", this.m_CornerHeaderTable);
            return;
        }
        if (this.m_corner != null) {
            this.m_corner.setText(this.m_ITableModel.getCornerName(0));
        } else {
            this.m_corner = new JLabel(this.m_ITableModel.getCornerName(0));
            this.m_corner.setOpaque(true);
            this.m_corner.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.m_corner.setHorizontalAlignment(0);
            this.m_corner.setForeground(this.m_table.getTableHeader().getForeground());
            this.m_corner.setBackground(this.m_table.getTableHeader().getBackground());
            this.m_corner.setFont(this.m_table.getTableHeader().getFont());
        }
        super.setCorner("UPPER_LEFT_CORNER", this.m_corner);
    }

    public void setRowHeight(int row, int height) {
        this.m_table.setRowHeight(row, height);
        this.m_rowHeaderTable.setRowHeight(row, height);
    }

    public void setRowHidden(int row) {
        this.m_rowHeaderTable.setRowHeight(row, 0);
        this.m_table.setRowHeight(row, 0);
    }

    public void setRowDisplay(int row, int height) {
        this.m_table.setRowHeight(row, height);
    }

    public void setColWidth(int col, int width) {
        TableColumn column = this.m_table.getColumnModel().getColumn(col);
        column.setMaxWidth(width);
        column.setPreferredWidth(width);
        column.setResizable(true);
    }

    public void setColHidden(int col) {
        TableColumn column = this.m_table.getTableHeader().getColumnModel().getColumn(col);
        column.setMaxWidth(0);
        column.setMinWidth(0);
        column.setPreferredWidth(0);
        column.setResizable(false);
    }

    private int getTableType() {
        int newTableType = 0;
        if (this.m_ITableModel.getColHeaderSpanInfo() != null) {
            newTableType = TT_COL_HEADER_SPAN_TABLE;
        }
        if (this.m_ITableModel.getRowHeaderSpanInfo() != null) {
            newTableType = TT_ROW_HEADER_SPAN_TABLE;
        }
        return newTableType;
    }

    public JTable getTable() {
        return this.m_table;
    }

    public JTable getRowHeaderTable() {
        return this.m_rowHeaderTable;
    }

    public void editingStopped(ChangeEvent e2) {
        if (this.m_table != null) {
            this.m_table.editingStopped(e2);
        }
    }

    public void tableChanged(TableModelEvent e2) {
        if ((this.m_eTableType & 8) != 0) {
            this.initTable();
            return;
        }
        if (this.m_eTableType != this.getTableType()) {
            this.initTable();
            return;
        }
        if (this.m_table != null) {
            this.m_table.tableChanged(e2);
        }
        if (this.m_rowHeaderTable != null) {
            this.m_rowHeaderTable.tableChanged(e2);
        }
        this.aplyColumnWidths();
        this.aplyHidden();
    }

    public void changeSelection(int row, int col, boolean toggle, boolean extend) {
        this.m_table.setColumnSelectionAllowed(false);
        this.m_table.setColumnSelectionAllowed(false);
        this.m_table.changeSelection(row, col, toggle, extend);
        this.m_table.requestFocusInWindow();
    }

    public class MouseAdapterColumnHeader
    implements MouseListener {
        protected JTable m_table = null;

        public MouseAdapterColumnHeader(JTable table) {
            this.m_table = table;
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            this.m_table.editingStopped(new ChangeEvent(this.m_table));
            TableColumnModel colModel = this.m_table.getColumnModel();
            int columnModelIndex = colModel.getColumnIndexAtX(e2.getX());
            if (e2.isShiftDown()) {
                this.m_table.changeSelection(0, columnModelIndex, false, true);
            } else {
                this.m_table.changeSelection(0, columnModelIndex, false, false);
            }
            this.m_table.setRowSelectionInterval(0, this.m_table.getRowCount() - 1);
            this.m_table.requestFocusInWindow();
        }

        @Override
        public void mouseEntered(MouseEvent e2) {
        }

        @Override
        public void mouseExited(MouseEvent e2) {
        }

        @Override
        public void mousePressed(MouseEvent e2) {
        }

        @Override
        public void mouseReleased(MouseEvent e2) {
        }
    }

    public class MouseAdapterRowHeader
    extends MouseAdapter {
        JTable m_rowHeaderTable = null;
        JTable m_table = null;

        public MouseAdapterRowHeader(JTable table, JTable rowHeaderTable) {
            this.m_rowHeaderTable = rowHeaderTable;
            this.m_table = table;
        }

        @Override
        public void mouseClicked(MouseEvent e2) {
            Point p2 = e2.getPoint();
            int row = this.m_rowHeaderTable.rowAtPoint(p2);
            this.m_table.editingStopped(new ChangeEvent(this.m_table));
            if (e2.isShiftDown()) {
                this.m_table.changeSelection(row, this.m_table.getColumnCount() - 1, false, true);
            } else {
                this.m_table.changeSelection(row, 0, false, false);
            }
            this.m_table.setColumnSelectionInterval(0, this.m_table.getColumnCount() - 1);
            this.m_table.requestFocusInWindow();
        }
    }
}

