/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;

public class SpanTableCellRenderer
extends JLabel
implements TableCellRenderer,
Serializable {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private Color unselectedForeground;
    private Color unselectedBackground;
    private boolean m_isEditable;

    public SpanTableCellRenderer() {
        this(true, null, null);
    }

    public SpanTableCellRenderer(boolean isEditable, Color fgColor, Color bgColor) {
        this.unselectedForeground = fgColor;
        this.unselectedBackground = bgColor;
        this.m_isEditable = isEditable;
        this.setOpaque(true);
        this.setBorder(SpanTableCellRenderer.getNoFocusBorder());
    }

    private static Border getNoFocusBorder() {
        if (System.getSecurityManager() != null) {
            return SAFE_NO_FOCUS_BORDER;
        }
        return noFocusBorder;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color fg = null;
        Color bg2 = null;
        JTable.DropLocation dropLocation = table.getDropLocation();
        if (dropLocation != null && !dropLocation.isInsertRow() && !dropLocation.isInsertColumn() && dropLocation.getRow() == row && dropLocation.getColumn() == column) {
            fg = UIManager.getColor("Table.dropCellForeground");
            bg2 = UIManager.getColor("Table.dropCellBackground");
            isSelected = true;
        }
        if (value == null) {
            if (!isSelected) {
                super.setForeground(table.getTableHeader().getForeground());
                super.setBackground(table.getTableHeader().getBackground());
            } else {
                super.setForeground(fg == null ? table.getSelectionForeground() : fg);
                super.setBackground(bg2 == null ? table.getSelectionBackground() : bg2);
            }
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
        if (isSelected) {
            super.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            super.setForeground(this.unselectedForeground != null ? this.unselectedForeground : table.getForeground());
            super.setBackground(this.unselectedBackground != null ? this.unselectedBackground : table.getBackground());
        }
        this.setFont(table.getFont());
        if (this.m_isEditable && hasFocus) {
            Border border = null;
            if (isSelected) {
                border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.setBorder(border);
            if (!isSelected && table.isCellEditable(row, column)) {
                Color col = UIManager.getColor("Table.focusCellForeground");
                if (col != null) {
                    super.setForeground(col);
                }
                if ((col = UIManager.getColor("Table.focusCellBackground")) != null) {
                    super.setBackground(col);
                }
            }
        } else {
            this.setBorder(UIManager.getBorder("Table.cellBorder"));
        }
        this.setValue(value);
        return this;
    }

    protected void setValue(Object value) {
        this.setText(value == null ? "" : value.toString());
    }
}

