/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import com.sec.osdm.pages.utils.table.ISpanModel;
import com.sec.osdm.pages.utils.table.SpanInfo;
import com.sec.osdm.pages.utils.table.SpanTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableCellRenderer;

public class SpanTableUI
extends BasicTableUI {
    @Override
    public void paint(Graphics g2, JComponent c2) {
        Rectangle oldClipBounds = g2.getClipBounds();
        Rectangle clipBounds = new Rectangle(oldClipBounds);
        int tableWidth = this.table.getColumnModel().getTotalColumnWidth();
        clipBounds.width = Math.min(clipBounds.width, tableWidth);
        g2.setClip(clipBounds);
        int firstIndex = this.table.rowAtPoint(new Point(0, clipBounds.y));
        int lastIndex = this.table.getRowCount() - 1;
        Rectangle rowRect = new Rectangle(0, 0, tableWidth, 0);
        int i2 = 0;
        while (i2 < firstIndex) {
            rowRect.y += this.table.getRowHeight(i2);
            ++i2;
        }
        int index = firstIndex;
        while (index <= lastIndex) {
            int height;
            rowRect.height = height = this.table.getRowHeight(index);
            if (rowRect.intersects(clipBounds)) {
                this.paintRow(g2, index);
            }
            rowRect.y += height;
            ++index;
        }
        g2.setClip(oldClipBounds);
    }

    private void paintRow(Graphics g2, int row) {
        Rectangle rect = g2.getClipBounds();
        boolean drawn = false;
        ISpanModel tableModel = (ISpanModel)((Object)this.table.getModel());
        SpanInfo spanInfo = tableModel.getSpanInfo();
        int numColumns = this.table.getColumnCount();
        int column = 0;
        while (column < numColumns) {
            int cellColumn;
            int cellRow;
            Rectangle cellRect = this.table.getCellRect(row, column, true);
            if (spanInfo.isVisible(row, column)) {
                cellRow = row;
                cellColumn = column;
            } else {
                cellRow = row + spanInfo.getSpan(row, column)[0];
                cellColumn = column + spanInfo.getSpan(row, column)[1];
            }
            if (cellRect.intersects(rect)) {
                drawn = true;
                this.paintCell(g2, cellRect, cellRow, cellColumn);
            } else if (drawn) break;
            ++column;
        }
    }

    private void paintCell(Graphics g2, Rectangle cellRect, int row, int column) {
        Color c2 = g2.getColor();
        TableCellRenderer renderer = this.table.getCellRenderer(row, column);
        if (renderer instanceof SpanTableCellRenderer) {
            g2.setColor(this.table.getGridColor());
            g2.drawRect(cellRect.x - 1, cellRect.y - 1, cellRect.width, cellRect.height);
            g2.setColor(c2);
            cellRect.setBounds(cellRect.x, cellRect.y, cellRect.width - 1, cellRect.height - 1);
        } else {
            g2.setColor(this.table.getTableHeader().getForeground());
            g2.drawRect(cellRect.x - 1, cellRect.y - 1, cellRect.width, cellRect.height);
            g2.setColor(c2);
            cellRect.setBounds(cellRect.x, cellRect.y, cellRect.width, cellRect.height);
        }
        if (this.table.isEditing() && this.table.getEditingRow() == row && this.table.getEditingColumn() == column) {
            Component component = this.table.getEditorComponent();
            component.setBounds(cellRect);
            component.validate();
        } else {
            Component component = this.table.prepareRenderer(renderer, row, column);
            if (component.getParent() == null) {
                this.rendererPane.add(component);
            }
            this.rendererPane.paintComponent(g2, component, this.table, cellRect.x, cellRect.y, cellRect.width, cellRect.height, true);
        }
    }
}

