/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm;

import com.sun.comm.NotificationThread;
import com.sun.comm.Win32SerialInputStream;
import com.sun.comm.Win32SerialOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;
import javax.comm.SerialPort;
import javax.comm.SerialPortEvent;
import javax.comm.SerialPortEventListener;
import javax.comm.UnsupportedCommOperationException;

class Win32SerialPort
extends SerialPort {
    int nativeHandle;
    private InputStream ins;
    private OutputStream outs;
    private int rcvThreshold = -1;
    int rcvTimeout = -1;
    private boolean framing = false;
    private int framingByte;
    boolean framingByteReceived;
    private int baudrate;
    private int parity;
    private int dataBits;
    private int stopBits;
    private int flowcontrol;
    private static int[] speeds = new int[]{75, 110, 134, 150, 300, 600, 1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200};
    private boolean dtr = true;
    private boolean rts = true;
    NotificationThread notificationThread;
    SerialPortEventListener eventListener;
    private int notifyMask;
    static final int NOTIFY_DATA_AVAIL = 1;
    static final int NOTIFY_OUTPUT_EMPTY = 2;
    static final int NOTIFY_RI = 4;
    static final int NOTIFY_CTS = 8;
    static final int NOTIFY_DSR = 16;
    static final int NOTIFY_CD = 32;
    static final int NOTIFY_OE = 64;
    static final int NOTIFY_PE = 128;
    static final int NOTIFY_FE = 256;
    static final int NOTIFY_BI = 512;
    private boolean stateRI;
    private boolean stateCTS;
    private boolean stateDSR;
    private boolean stateCD;
    private boolean stateOE;
    private boolean statePE;
    private boolean stateFE;
    private boolean stateBI;
    Object readSignal;
    private byte[] wa;
    private static final int READ_POLL = 200;
    boolean closed = false;

    Win32SerialPort(String string) throws IOException {
        this.name = string;
        if (!this.nativeConstructor(string)) {
            String string2 = "Unable to create port " + string;
            throw new IOException(string2);
        }
        this.outs = new Win32SerialOutputStream(this);
        this.ins = new Win32SerialInputStream(this);
        this.readSignal = new Object();
        this.wa = new byte[1];
        try {
            this.setFlowControlMode(0);
            this.setSerialPortParams(9600, 8, 1, 0);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {}
        this.notificationThread = new NotificationThread("Win32SerialPort Notification thread", this);
        this.notificationThread.start();
    }

    private native boolean nativeConstructor(String var1);

    public InputStream getInputStream() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.ins;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.outs;
    }

    public void enableReceiveThreshold(int n2) throws UnsupportedCommOperationException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        if (n2 < 0) {
            throw new UnsupportedCommOperationException("This threshold value is not supported");
        }
        this.rcvThreshold = n2;
    }

    public void disableReceiveThreshold() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.rcvThreshold = -1;
    }

    public boolean isReceiveThresholdEnabled() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.rcvThreshold != -1;
    }

    public int getReceiveThreshold() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.rcvThreshold;
    }

    public void enableReceiveTimeout(int n2) throws UnsupportedCommOperationException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        if (n2 < 0) {
            throw new UnsupportedCommOperationException("This timeout value is not supported");
        }
        this.rcvTimeout = n2;
    }

    public void disableReceiveTimeout() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.rcvTimeout = -1;
    }

    public int getReceiveTimeout() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.rcvTimeout;
    }

    public boolean isReceiveTimeoutEnabled() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.rcvTimeout != -1;
    }

    public void disableReceiveFraming() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.framing = false;
        this.nativeDisableFraming();
    }

    public void enableReceiveFraming(int n2) throws UnsupportedCommOperationException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.framing = true;
        this.framingByte = n2 & 0xFF;
        this.nativeEnableFraming(n2);
    }

    public int getReceiveFramingByte() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.framingByte;
    }

    public boolean isReceiveFramingEnabled() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.framing;
    }

    native void nativeEnableFraming(int var1);

    native void nativeDisableFraming();

    public void setInputBufferSize(int n2) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.nsetInputBufferSize(n2);
    }

    private native void nsetInputBufferSize(int var1);

    public int getInputBufferSize() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.ngetInputBufferSize();
    }

    private native int ngetInputBufferSize();

    public void setOutputBufferSize(int n2) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.nsetOutputBufferSize(n2);
    }

    private native void nsetOutputBufferSize(int var1);

    public int getOutputBufferSize() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.ngetOutputBufferSize();
    }

    private native int ngetOutputBufferSize();

    public int getBaudRate() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.baudrate;
    }

    public int getDataBits() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.dataBits;
    }

    public int getStopBits() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.stopBits;
    }

    public int getParity() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.parity;
    }

    public void setFlowControlMode(int n2) throws UnsupportedCommOperationException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        if ((n2 & 3) != 0 && (n2 & 0xC) != 0) {
            throw new UnsupportedCommOperationException("Cannot mix hardware and software flow control");
        }
        this.flowcontrol = n2;
        this.nativeSetFlowcontrolMode(n2);
        if ((n2 & 1) == 0) {
            this.rts = true;
            this.dtr = true;
        }
    }

    native void nativeSetFlowcontrolMode(int var1);

    public int getFlowControlMode() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.flowcontrol;
    }

    public void setSerialPortParams(int n2, int n3, int n4, int n5) throws UnsupportedCommOperationException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        int n6 = 0;
        while (n6 < speeds.length) {
            if (n2 == speeds[n6]) break;
            if (n2 < speeds[n6]) {
                throw new UnsupportedCommOperationException("Unsupported baud rate");
            }
            ++n6;
        }
        if (n3 != 5 && n3 != 6 && n3 != 7 && n3 != 8) {
            throw new UnsupportedCommOperationException("Unsupported num of databits");
        }
        if (n4 != 1 && n4 != 2 && n4 != 3) {
            throw new UnsupportedCommOperationException("Unsupported num of stopbits");
        }
        if (n5 != 2 && n5 != 1 && n5 != 0) {
            throw new UnsupportedCommOperationException("Unsupported parity value");
        }
        this.baudrate = n2;
        this.parity = n5;
        this.dataBits = n3;
        this.stopBits = n4;
        this.setCommDeviceParams(n2, n5, n3, n4);
        this.saveCommDeviceState();
        try {
            this.setFlowControlMode(this.flowcontrol);
            return;
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            return;
        }
    }

    public native void setCommDeviceParams(int var1, int var2, int var3, int var4);

    public void sendBreak(int n2) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        Win32SerialPort win32SerialPort = this;
        synchronized (win32SerialPort) {
            this.setCommBreak();
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {}
            this.clearCommBreak();
            return;
        }
    }

    private native void setCommBreak();

    private native void clearCommBreak();

    public void setDTR(boolean bl2) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        if ((this.flowcontrol & 1) == 1) {
            return;
        }
        this.nativeSetDTR(bl2);
        this.dtr = bl2;
    }

    private native void nativeSetDTR(boolean var1);

    public boolean isDTR() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.dtr;
    }

    public void setRTS(boolean bl2) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        if ((this.flowcontrol & 1) == 1) {
            throw new IllegalStateException("Cannot modify RTS when Hardware flowcontrol is on.");
        }
        this.nativeSetRTS(bl2);
        this.rts = bl2;
    }

    private native void nativeSetRTS(boolean var1);

    public boolean isRTS() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.rts;
    }

    public boolean isCTS() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.nativeIsCTS();
    }

    private native boolean nativeIsCTS();

    public boolean isDSR() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.nativeIsDSR();
    }

    private native boolean nativeIsDSR();

    public boolean isRI() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.nativeIsRI();
    }

    private native boolean nativeIsRI();

    public boolean isCD() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        return this.nativeIsCD();
    }

    private native boolean nativeIsCD();

    public synchronized void addEventListener(SerialPortEventListener serialPortEventListener) throws TooManyListenersException {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        if (this.eventListener != null) {
            throw new TooManyListenersException();
        }
        this.eventListener = serialPortEventListener;
        if (this.eventListener != null && this.notificationThread == null) {
            this.notificationThread = new NotificationThread("Win32SerialPort Notification thread", this);
            this.notificationThread.start();
        }
    }

    public synchronized void removeEventListener() {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.eventListener = null;
    }

    public synchronized void notifyOnDataAvailable(boolean bl2) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.notifyMask = bl2 ? (this.notifyMask |= 1) : (this.notifyMask &= 0xFFFFFFFE);
        this.nnotifyOnDataAvailable(bl2);
    }

    private native void nnotifyOnDataAvailable(boolean var1);

    public synchronized void notifyOnOutputEmpty(boolean bl2) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.notifyMask = bl2 ? (this.notifyMask |= 2) : (this.notifyMask &= 0xFFFFFFFD);
        this.nnotifyOnOutputEmpty(bl2);
    }

    private native void nnotifyOnOutputEmpty(boolean var1);

    public synchronized void notifyOnCTS(boolean bl2) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.notifyMask = bl2 ? (this.notifyMask |= 8) : (this.notifyMask &= 0xFFFFFFF7);
        this.nnotifyOnCTS(bl2);
    }

    private native void nnotifyOnCTS(boolean var1);

    public synchronized void notifyOnDSR(boolean bl2) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.notifyMask = bl2 ? (this.notifyMask |= 0x10) : (this.notifyMask &= 0xFFFFFFEF);
        this.nnotifyOnDSR(bl2);
    }

    private native void nnotifyOnDSR(boolean var1);

    public synchronized void notifyOnCarrierDetect(boolean bl2) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.notifyMask = bl2 ? (this.notifyMask |= 0x20) : (this.notifyMask &= 0xFFFFFFDF);
        this.nnotifyOnCarrierDetect(bl2);
    }

    private native void nnotifyOnCarrierDetect(boolean var1);

    public synchronized void notifyOnRingIndicator(boolean bl2) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.notifyMask = bl2 ? (this.notifyMask |= 4) : (this.notifyMask &= 0xFFFFFFFB);
        this.nnotifyOnRingIndicator(bl2);
    }

    private native void nnotifyOnRingIndicator(boolean var1);

    public synchronized void notifyOnOverrunError(boolean bl2) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.notifyMask = bl2 ? (this.notifyMask |= 0x40) : (this.notifyMask &= 0xFFFFFFBF);
        this.nnotifyOnOverrunError(bl2);
    }

    private native void nnotifyOnOverrunError(boolean var1);

    public synchronized void notifyOnParityError(boolean bl2) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.notifyMask = bl2 ? (this.notifyMask |= 0x80) : (this.notifyMask &= 0xFFFFFF7F);
        this.nnotifyOnParityError(bl2);
    }

    private native void nnotifyOnParityError(boolean var1);

    public synchronized void notifyOnFramingError(boolean bl2) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.notifyMask = bl2 ? (this.notifyMask |= 0x100) : (this.notifyMask &= 0xFFFFFEFF);
        this.nnotifyOnFramingError(bl2);
    }

    private native void nnotifyOnFramingError(boolean var1);

    public synchronized void notifyOnBreakInterrupt(boolean bl2) {
        if (this.closed) {
            throw new IllegalStateException("Port Closed");
        }
        this.notifyMask = bl2 ? (this.notifyMask |= 0x200) : (this.notifyMask &= 0xFFFFFDFF);
        this.nnotifyOnBreakInterrupt(bl2);
    }

    private native void nnotifyOnBreakInterrupt(boolean var1);

    native int waitForEvent();

    private void saveCommDeviceState() {
        this.stateRI = this.isRI();
        this.stateCTS = this.isCTS();
        this.stateDSR = this.isDSR();
        this.stateCD = this.isCD();
    }

    void sendCTSevent() {
        boolean bl2;
        if ((this.notifyMask & 8) == 8 && (bl2 = this.isCTS()) != this.stateCTS) {
            SerialPortEvent serialPortEvent = new SerialPortEvent(this, 3, this.stateCTS, bl2);
            this.eventListener.serialEvent(serialPortEvent);
            this.stateCTS = bl2;
        }
    }

    void sendDSRevent() {
        boolean bl2;
        if ((this.notifyMask & 0x10) == 16 && (bl2 = this.isDSR()) != this.stateDSR) {
            SerialPortEvent serialPortEvent = new SerialPortEvent(this, 4, this.stateDSR, bl2);
            this.eventListener.serialEvent(serialPortEvent);
            this.stateDSR = bl2;
        }
    }

    void sendCDevent() {
        boolean bl2;
        if ((this.notifyMask & 0x20) == 32 && (bl2 = this.isCD()) != this.stateCD) {
            SerialPortEvent serialPortEvent = new SerialPortEvent(this, 6, this.stateCD, bl2);
            this.eventListener.serialEvent(serialPortEvent);
            this.stateCD = bl2;
        }
    }

    void sendRIevent() {
        boolean bl2;
        if ((this.notifyMask & 4) == 4 && (bl2 = this.isRI()) != this.stateRI) {
            SerialPortEvent serialPortEvent = new SerialPortEvent(this, 5, this.stateRI, bl2);
            this.eventListener.serialEvent(serialPortEvent);
            this.stateRI = bl2;
        }
    }

    void sendBIevent() {
        if ((this.notifyMask & 0x200) == 512) {
            SerialPortEvent serialPortEvent = new SerialPortEvent(this, 10, false, true);
            this.eventListener.serialEvent(serialPortEvent);
        }
    }

    void sendOEevent() {
        if ((this.notifyMask & 0x40) == 64) {
            SerialPortEvent serialPortEvent = new SerialPortEvent(this, 7, false, true);
            this.eventListener.serialEvent(serialPortEvent);
        }
    }

    void sendPEevent() {
        if ((this.notifyMask & 0x80) == 128) {
            SerialPortEvent serialPortEvent = new SerialPortEvent(this, 8, false, true);
            this.eventListener.serialEvent(serialPortEvent);
        }
    }

    void sendFEevent() {
        if ((this.notifyMask & 0x100) == 256) {
            SerialPortEvent serialPortEvent = new SerialPortEvent(this, 9, false, true);
            this.eventListener.serialEvent(serialPortEvent);
        }
    }

    void sendOutputEmptyEvent() {
        if ((this.notifyMask & 2) == 2) {
            SerialPortEvent serialPortEvent = new SerialPortEvent(this, 2, false, true);
            this.eventListener.serialEvent(serialPortEvent);
        }
    }

    void sendDataAvailEvent() {
        if ((this.notifyMask & 1) == 1) {
            SerialPortEvent serialPortEvent = new SerialPortEvent(this, 1, false, true);
            this.eventListener.serialEvent(serialPortEvent);
        }
    }

    protected void finalize() throws Throwable {
        this.nativeFinalize();
    }

    private native void nativeFinalize();

    void write(int n2) throws IOException {
        this.wa[0] = (byte)n2;
        this.write(this.wa, 0, 1);
    }

    void write(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        for (int i2 = 0; i2 < n3; i2 += n4) {
            n4 = this.nwrite(byArray, n2 + i2, n3 - i2 > 512 ? 512 : n3 - i2);
            if (n4 > 0) {
                continue;
            }
            throw new IOException("write error");
        }
    }

    private native int nwrite(byte[] var1, int var2, int var3);

    private native int nread(byte[] var1, int var2, int var3) throws IOException;

    native int available() throws IOException;

    int read() throws IOException {
        byte[] byArray = new byte[1];
        switch (this.read(byArray, 0, 1)) {
            case 1: {
                return byArray[0] & 0xFF;
            }
        }
        return -1;
    }

    int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 200;
        int n5 = 0;
        if (this.rcvTimeout == 0) {
            n5 = 0;
        } else if (this.rcvTimeout == -1) {
            n5 = 0;
        } else {
            n4 = this.rcvTimeout < 200 ? this.rcvTimeout : 200;
            n5 = this.rcvTimeout / n4;
        }
        int n6 = 0;
        int n7 = 0;
        while (n6 < n3) {
            int n8;
            int n9 = this.available();
            if (n9 > 0) {
                n8 = this.nread(byArray, n2 + n6, n3 - n6);
                if (n8 >= 0) {
                    n6 += n8;
                } else {
                    return n6;
                }
            }
            if (this.rcvTimeout == 0) {
                return n6;
            }
            if (n6 == n3) {
                return n6;
            }
            if (this.framing && this.framingByteReceived) {
                this.framingByteReceived = false;
                return n6;
            }
            if (this.rcvTimeout == -1) {
                if (this.rcvThreshold == -1 ? n6 > 0 : n6 >= Math.min(this.rcvThreshold, n3)) {
                    return n6;
                }
            } else {
                if (n7 >= n5) {
                    return n6;
                }
                if (this.rcvThreshold == -1 ? n6 > 0 : n6 >= Math.min(this.rcvThreshold, n3)) {
                    return n6;
                }
            }
            Object object = this.readSignal;
            synchronized (object) {
                ++n7;
                try {
                    this.readSignal.wait(n4);
                }
                catch (InterruptedException interruptedException) {
                    n8 = -1;
                    Object var11_11 = null;
                    return n8;
                }
            }
        }
        return n6;
    }

    public void close() {
        this.eventListener = null;
        this.nativeFinalize();
        this.nativeHandle = 0;
        this.closed = true;
        super.close();
    }
}

