/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.ByteArrayDecompressor;
import com.sun.java.help.search.ConceptData;
import com.sun.java.help.search.ConceptGroupGenerator;
import com.sun.java.help.search.GeneratorHeap;
import com.sun.java.help.search.IntegerArray;
import com.sun.java.help.search.NextDocGenerator;
import com.sun.java.help.search.NextDocGeneratorHeap;
import com.sun.java.help.search.Query;
import com.sun.java.help.search.RoleFiller;
import com.sun.java.help.search.SearchEnvironment;
import javax.help.search.SearchQuery;

class Search {
    private static final int InitNConcepts = 128;
    private SearchEnvironment _env;
    private int _max;
    private int _nConcepts;
    private int _nQueries;
    private ConceptGroupGenerator _firstGenerator = new ConceptGroupGenerator();
    private int[] _concepts = new int[16];
    private int _free2;
    private int _size2;
    private int _startingIndex = 0;
    private int _limit = 0;
    private Query[] _query;
    private ConceptData[] _conceptData;
    private GeneratorHeap _genHeap = new GeneratorHeap();
    private int _document;
    private byte[] _data = null;
    private int _base = 0;
    private NextDocGeneratorHeap _nextDocGenHeap = new NextDocGeneratorHeap();
    private IntegerArray _kTable = new IntegerArray();
    private IntegerArray _offsets = new IntegerArray();
    private IntegerArray _maxConcepts = new IntegerArray();
    private IntegerArray _docConcepts = new IntegerArray();
    private IntegerArray _queryMasks = new IntegerArray();
    private int _maxHitsToShow = 100;

    public Search(SearchEnvironment searchEnvironment, int n2) {
        this._env = searchEnvironment;
        this._nQueries = 1;
        this._query = new Query[this._nQueries];
        this._size2 = 128;
        this._free2 = 0;
        this._conceptData = new ConceptData[this._size2];
        this._query[0] = new Query(searchEnvironment, n2, null);
    }

    public void addTerm(int n2, int n3, double d2, int n4) {
        if (this._env.occursInText(n3)) {
            if (this._free2 == this._size2) {
                ConceptData[] conceptDataArray = new ConceptData[this._size2 *= 2];
                System.arraycopy(this._conceptData, 0, conceptDataArray, 0, this._free2);
                this._conceptData = conceptDataArray;
            }
            this._conceptData[this._free2++] = new ConceptData(n3, n2, d2, n4, this._query[n4].getNColumns());
        }
    }

    public void startSearch(SearchQuery searchQuery) {
        int n2;
        this.quicksort(0, this._free2 - 1);
        int n3 = 0;
        while (n3 < this._free2 - 1) {
            n2 = n3 + 1;
            while (n2 < this._free2) {
                if (this._conceptData[n3].crqEquals(this._conceptData[n2])) {
                    this._conceptData[n2] = null;
                } else {
                    n3 = n2;
                }
                ++n2;
            }
            n3 = n2;
        }
        n3 = 0;
        while (n3 < this._free2 - 1) {
            n2 = n3 + 1;
            while (n2 < this._free2) {
                if (this._conceptData[n2] != null) {
                    if (this._conceptData[n3].cEquals(this._conceptData[n2])) {
                        this._conceptData[n3].addLast(this._conceptData[n2]);
                        this._conceptData[n2] = null;
                    } else {
                        n3 = n2;
                    }
                }
                ++n2;
            }
            n3 = n2;
        }
        n3 = 0;
        while (n3 < this._free2 - 1) {
            if (this._conceptData[n3] == null) {
                n2 = n3 + 1;
                while (n2 < this._free2) {
                    if (this._conceptData[n2] != null) {
                        this._conceptData[n3] = this._conceptData[n2];
                        this._conceptData[n2] = null;
                        break;
                    }
                    ++n2;
                }
            }
            ++n3;
        }
        this._nextDocGenHeap.reset();
        n3 = 0;
        while (n3 < this._free2 && this._conceptData[n3] != null) {
            NextDocGenerator nextDocGenerator = new NextDocGenerator(this._conceptData[n3], this._env);
            try {
                nextDocGenerator.first();
                if (nextDocGenerator.getDocument() != -1) {
                    this._conceptData[n3].setConceptLength(this._env.getConceptLength(this._conceptData[n3].getConcept()));
                    this._nextDocGenHeap.addGenerator(nextDocGenerator);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n3;
        }
        this._nextDocGenHeap.start();
        this.searchDocument();
        if (searchQuery == null) {
            this.printResults(this._maxHitsToShow);
        } else {
            this._query[0].makeEvent(this._maxHitsToShow, searchQuery);
        }
    }

    private void searchDocument() {
        RoleFiller[] roleFillerArray = new RoleFiller[this._nQueries];
        do {
            try {
                switch (this.nextDocument(roleFillerArray)) {
                    case 0: {
                        this._genHeap.start(roleFillerArray);
                        while (this._genHeap.next(roleFillerArray)) {
                        }
                        break;
                    }
                    case 1: {
                        if (!this._firstGenerator.next()) break;
                        this._firstGenerator.generateFillers(roleFillerArray);
                        while (this._firstGenerator.next()) {
                            this._firstGenerator.generateFillers(roleFillerArray);
                        }
                        break;
                    }
                    case 2: {
                        return;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace(System.err);
                continue;
            }
            int n2 = 0;
            while (n2 < this._nQueries) {
                RoleFiller roleFiller = roleFillerArray[n2];
                if (roleFiller != null && roleFiller != RoleFiller.STOP) {
                    roleFiller.scoreList(this._query[n2], this._document);
                }
                ++n2;
            }
            this._genHeap.reset();
        } while (this._nextDocGenHeap.isNonEmpty());
    }

    private int indexOf(int n2) throws Exception {
        int n3 = this._startingIndex;
        int n4 = this._nConcepts;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            if (this._concepts[n5] < n2) {
                n3 = n5 + 1;
                continue;
            }
            if (n2 < this._concepts[n5]) {
                n4 = n5 - 1;
                continue;
            }
            this._startingIndex = n5 + 1;
            return n5;
        }
        throw new Exception("indexOf " + n2 + " not found");
    }

    private void printResults(int n2) {
        int n3 = 0;
        while (n3 < this._nQueries) {
            System.out.println("query " + n3);
            if (this._query[n3] != null) {
                this._query[n3].printHits(n2);
            }
            ++n3;
        }
    }

    private ConceptGroupGenerator makeGenerator(int n2) throws Exception {
        int n3;
        int n4;
        if (n2 > 0) {
            n4 = this._base + this._offsets.at(n2 - 1);
            n3 = this._maxConcepts.at(n2 - 1);
        } else {
            n4 = this._base;
            n3 = 0;
        }
        ConceptGroupGenerator conceptGroupGenerator = new ConceptGroupGenerator(this._data, n4, this._kTable.at(2 * n2 + 1));
        this._nConcepts = conceptGroupGenerator.decodeConcepts(this._kTable.at(2 * n2), n3, this._concepts);
        this._max = n2 < this._limit ? (this._concepts[this._nConcepts] = this._maxConcepts.at(n2)) : this._concepts[this._nConcepts - 1];
        this._genHeap.addGenerator(conceptGroupGenerator);
        this._startingIndex = 0;
        return conceptGroupGenerator;
    }

    private boolean openDocumentIndex(int n2) throws Exception {
        this._data = this._env.getPositions(n2);
        this._base = 0;
        this._startingIndex = 0;
        int n3 = this._data[this._base] & 0xFF;
        switch (n3 >> 6) {
            case 0: {
                byte by2 = this._data[this._base + 1];
                this._firstGenerator.init(this._data, this._base += 2, by2);
                this._nConcepts = this._firstGenerator.decodeConcepts(n3 & 0x3F, 0, this._concepts);
                return false;
            }
            case 2: {
                this._kTable.clear();
                this._offsets.clear();
                this._maxConcepts.clear();
                ByteArrayDecompressor byteArrayDecompressor = new ByteArrayDecompressor(this._data, this._base + 1);
                byteArrayDecompressor.decode(n3 & 0x3F, this._kTable);
                byteArrayDecompressor.ascDecode(this._kTable.popLast(), this._offsets);
                byteArrayDecompressor.ascDecode(this._kTable.popLast(), this._maxConcepts);
                this._base += 1 + byteArrayDecompressor.bytesRead();
                this._limit = this._maxConcepts.cardinality();
                return true;
            }
            case 1: 
            case 3: {
                throw new Exception("extents not yet implemented\n");
            }
        }
        return false;
    }

    private int nextDocument(RoleFiller[] roleFillerArray) throws Exception {
        while (this._nextDocGenHeap.isNonEmpty()) {
            int n2 = 0;
            while (n2 < this._nQueries) {
                if (this._query[n2] != null) {
                    this._query[n2].resetForNextDocument();
                }
                ++n2;
            }
            int n3 = 0;
            this._document = this._nextDocGenHeap.getDocument();
            this._docConcepts.clear();
            this._queryMasks.clear();
            do {
                this._docConcepts.add(this._nextDocGenHeap.getConcept());
                this._queryMasks.add(this._nextDocGenHeap.getQueryMask());
                int n4 = n3++;
                ConceptData conceptData = this._nextDocGenHeap.getTerms();
                this._conceptData[n4] = conceptData;
                conceptData.runBy(this._query);
                this._nextDocGenHeap.step();
            } while (this._nextDocGenHeap.atDocument(this._document));
            int n5 = 0;
            int n6 = 0;
            while (n6 < this._nQueries) {
                if (this._query[n6] != null) {
                    if (this._query[n6].vote()) {
                        roleFillerArray[n6] = null;
                        n5 |= 1 << n6;
                    } else {
                        roleFillerArray[n6] = RoleFiller.STOP;
                    }
                }
                ++n6;
            }
            if (n5 == 0) continue;
            if (this.openDocumentIndex(this._document)) {
                int n7 = 0;
                while ((this._queryMasks.at(n7) & n5) == 0) {
                    ++n7;
                }
                int n8 = this._docConcepts.at(n7);
                int n9 = 0;
                while (n8 > this._maxConcepts.at(n9) && ++n9 < this._limit) {
                }
                ConceptGroupGenerator conceptGroupGenerator = this.makeGenerator(n9);
                conceptGroupGenerator.addTerms(this.indexOf(n8), this._conceptData[n7]);
                ++n7;
                while (n7 < n3) {
                    if ((this._queryMasks.at(n7) & n5) > 0) {
                        n8 = this._docConcepts.at(n7);
                        if (n8 > this._max) {
                            while (n8 > this._maxConcepts.at(n9) && ++n9 < this._limit) {
                            }
                            conceptGroupGenerator = this.makeGenerator(n9);
                        }
                        conceptGroupGenerator.addTerms(this.indexOf(n8), this._conceptData[n7]);
                    }
                    ++n7;
                }
                return 0;
            }
            int n10 = 0;
            while (n10 < n3) {
                if ((this._queryMasks.at(n10) & n5) != 0) {
                    this._firstGenerator.addTerms(this.indexOf(this._docConcepts.at(n10)), this._conceptData[n10]);
                }
                ++n10;
            }
            return 1;
        }
        return 2;
    }

    private int partition(int n2, int n3) {
        ConceptData conceptData = this._conceptData[n2];
        int n4 = n2 - 1;
        int n5 = n3 + 1;
        while (true) {
            if (conceptData.compareWith(this._conceptData[--n5])) {
                continue;
            }
            while (this._conceptData[++n4].compareWith(conceptData)) {
            }
            if (n4 >= n5) break;
            ConceptData conceptData2 = this._conceptData[n4];
            this._conceptData[n4] = this._conceptData[n5];
            this._conceptData[n5] = conceptData2;
        }
        return n5;
    }

    private void quicksort(int n2, int n3) {
        if (n2 < n3) {
            int n4 = this.partition(n2, n3);
            this.quicksort(n2, n4);
            this.quicksort(n4 + 1, n3);
        }
    }
}

