/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import java.text.DateFormat;
import java.util.Date;
import jxl.CellType;
import jxl.DateCell;
import jxl.biff.DoubleHelper;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.read.biff.BaseSharedFormulaRecord;
import jxl.read.biff.DateRecord;
import jxl.read.biff.SharedNumberFormulaRecord;
import jxl.read.biff.SheetImpl;

public class SharedDateFormulaRecord
extends BaseSharedFormulaRecord
implements DateCell,
FormulaData {
    private DateRecord dateRecord;
    private double value;

    public SharedDateFormulaRecord(SharedNumberFormulaRecord nfr, FormattingRecords fr, boolean nf, SheetImpl si, int pos) {
        super(nfr.getRecord(), fr, nfr.getExternalSheet(), nfr.getNameTable(), si, pos);
        this.dateRecord = new DateRecord(nfr, nfr.getXFIndex(), fr, nf, si);
        this.value = nfr.getValue();
    }

    public double getValue() {
        return this.value;
    }

    public String getContents() {
        return this.dateRecord.getContents();
    }

    public CellType getType() {
        return CellType.DATE_FORMULA;
    }

    public byte[] getFormulaData() throws FormulaException {
        FormulaParser fp = new FormulaParser(this.getTokens(), this, this.getExternalSheet(), this.getNameTable(), this.getSheet().getWorkbook().getSettings());
        fp.parse();
        byte[] rpnTokens = fp.getBytes();
        byte[] data = new byte[rpnTokens.length + 22];
        IntegerHelper.getTwoBytes(this.getRow(), data, 0);
        IntegerHelper.getTwoBytes(this.getColumn(), data, 2);
        IntegerHelper.getTwoBytes(this.getXFIndex(), data, 4);
        DoubleHelper.getIEEEBytes(this.value, data, 6);
        System.arraycopy(rpnTokens, 0, data, 22, rpnTokens.length);
        IntegerHelper.getTwoBytes(rpnTokens.length, data, 20);
        byte[] d2 = new byte[data.length - 6];
        System.arraycopy(data, 6, d2, 0, data.length - 6);
        return d2;
    }

    public Date getDate() {
        return this.dateRecord.getDate();
    }

    public boolean isTime() {
        return this.dateRecord.isTime();
    }

    public DateFormat getDateFormat() {
        return this.dateRecord.getDateFormat();
    }
}

