/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import jxl.CellType;
import jxl.FormulaCell;
import jxl.Sheet;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IntegerHelper;
import jxl.biff.Type;
import jxl.biff.formula.FormulaException;
import jxl.biff.formula.FormulaParser;
import jxl.write.WritableCell;
import jxl.write.biff.CellValue;
import jxl.write.biff.FormulaRecord;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.WritableSheetImpl;

class ReadFormulaRecord
extends CellValue
implements FormulaData {
    private FormulaData formula;
    private FormulaParser parser;

    protected ReadFormulaRecord(FormulaData f2) {
        super(Type.FORMULA, f2);
        this.formula = f2;
    }

    public byte[] getData() {
        try {
            byte[] celldata = super.getData();
            byte[] expressiondata = null;
            if (this.parser == null) {
                expressiondata = this.formula.getFormulaData();
            } else {
                byte[] formulaBytes = this.parser.getBytes();
                expressiondata = new byte[formulaBytes.length + 16];
                IntegerHelper.getTwoBytes(formulaBytes.length, expressiondata, 14);
                System.arraycopy(formulaBytes, 0, expressiondata, 16, formulaBytes.length);
            }
            expressiondata[8] = (byte)(expressiondata[8] | 2);
            byte[] data = new byte[celldata.length + expressiondata.length];
            System.arraycopy(celldata, 0, data, 0, celldata.length);
            System.arraycopy(expressiondata, 0, data, celldata.length, expressiondata.length);
            return data;
        }
        catch (FormulaException e2) {
            Assert.verify(false);
            return new byte[0];
        }
    }

    public CellType getType() {
        return this.formula.getType();
    }

    public String getContents() {
        return this.formula.getContents();
    }

    public byte[] getFormulaData() throws FormulaException {
        byte[] d2 = this.formula.getFormulaData();
        byte[] data = new byte[d2.length];
        System.arraycopy(d2, 0, data, 0, d2.length);
        data[8] = (byte)(data[8] | 2);
        return data;
    }

    public WritableCell copyTo(int col, int row) {
        return new FormulaRecord(col, row, this);
    }

    void setCellDetails(FormattingRecords fr, SharedStrings ss, WritableSheetImpl s2) {
        super.setCellDetails(fr, ss, s2);
        s2.getWorkbook().addRCIRCell(this);
    }

    void columnInserted(Sheet s2, int sheetIndex, int col) {
        try {
            if (this.parser == null) {
                byte[] formulaData = this.formula.getFormulaData();
                byte[] formulaBytes = new byte[formulaData.length - 16];
                System.arraycopy(formulaData, 16, formulaBytes, 0, formulaBytes.length);
                this.parser = new FormulaParser(formulaBytes, this, this.getSheet().getWorkbook(), this.getSheet().getWorkbook(), this.getSheet().getWorkbookSettings());
                this.parser.parse();
            }
            this.parser.columnInserted(sheetIndex, col, s2 == this.getSheet());
        }
        catch (FormulaException e2) {
            e2.printStackTrace();
            Assert.verify(false);
        }
    }

    void columnRemoved(Sheet s2, int sheetIndex, int col) {
        try {
            if (this.parser == null) {
                byte[] formulaData = this.formula.getFormulaData();
                byte[] formulaBytes = new byte[formulaData.length - 16];
                System.arraycopy(formulaData, 16, formulaBytes, 0, formulaBytes.length);
                this.parser = new FormulaParser(formulaBytes, this, this.getSheet().getWorkbook(), this.getSheet().getWorkbook(), this.getSheet().getWorkbookSettings());
                this.parser.parse();
            }
            this.parser.columnRemoved(sheetIndex, col, s2 == this.getSheet());
        }
        catch (FormulaException e2) {
            e2.printStackTrace();
            Assert.verify(false);
        }
    }

    void rowInserted(Sheet s2, int sheetIndex, int row) {
        try {
            if (this.parser == null) {
                byte[] formulaData = this.formula.getFormulaData();
                byte[] formulaBytes = new byte[formulaData.length - 16];
                System.arraycopy(formulaData, 16, formulaBytes, 0, formulaBytes.length);
                this.parser = new FormulaParser(formulaBytes, this, this.getSheet().getWorkbook(), this.getSheet().getWorkbook(), this.getSheet().getWorkbookSettings());
                this.parser.parse();
            }
            this.parser.rowInserted(sheetIndex, row, s2 == this.getSheet());
        }
        catch (FormulaException e2) {
            e2.printStackTrace();
            Assert.verify(false);
        }
    }

    void rowRemoved(Sheet s2, int sheetIndex, int row) {
        try {
            if (this.parser == null) {
                byte[] formulaData = this.formula.getFormulaData();
                byte[] formulaBytes = new byte[formulaData.length - 16];
                System.arraycopy(formulaData, 16, formulaBytes, 0, formulaBytes.length);
                this.parser = new FormulaParser(formulaBytes, this, this.getSheet().getWorkbook(), this.getSheet().getWorkbook(), this.getSheet().getWorkbookSettings());
                this.parser.parse();
            }
            this.parser.rowRemoved(sheetIndex, row, s2 == this.getSheet());
        }
        catch (FormulaException e2) {
            e2.printStackTrace();
            Assert.verify(false);
        }
    }

    protected FormulaData getReadFormula() {
        return this.formula;
    }

    public String getFormula() throws FormulaException {
        return ((FormulaCell)((Object)this.formula)).getFormula();
    }
}

