/*
 * Decompiled with CFR 0.152.
 */
package jxl.write.biff;

import common.Assert;
import common.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeSet;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellType;
import jxl.CellView;
import jxl.DateCell;
import jxl.HeaderFooter;
import jxl.Hyperlink;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.Range;
import jxl.Sheet;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.EmptyCell;
import jxl.biff.FormattingRecords;
import jxl.biff.FormulaData;
import jxl.biff.IndexMapping;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.SheetRangeImpl;
import jxl.biff.WorkspaceInformationRecord;
import jxl.biff.XFRecord;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.Drawing;
import jxl.format.CellFormat;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.read.biff.SheetImpl;
import jxl.write.Blank;
import jxl.write.Boolean;
import jxl.write.DateTime;
import jxl.write.Label;
import jxl.write.Number;
import jxl.write.WritableCell;
import jxl.write.WritableHyperlink;
import jxl.write.WritableImage;
import jxl.write.WritableSheet;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.CellValue;
import jxl.write.biff.ColumnInfoRecord;
import jxl.write.biff.File;
import jxl.write.biff.FooterRecord;
import jxl.write.biff.HeaderRecord;
import jxl.write.biff.HyperlinkRecord;
import jxl.write.biff.JxlWriteException;
import jxl.write.biff.MergedCells;
import jxl.write.biff.PLSRecord;
import jxl.write.biff.ReadBooleanFormulaRecord;
import jxl.write.biff.ReadErrorFormulaRecord;
import jxl.write.biff.ReadFormulaRecord;
import jxl.write.biff.ReadNumberFormulaRecord;
import jxl.write.biff.ReadStringFormulaRecord;
import jxl.write.biff.RowRecord;
import jxl.write.biff.RowsExceededException;
import jxl.write.biff.SharedStrings;
import jxl.write.biff.SheetWriter;
import jxl.write.biff.WritableWorkbookImpl;

class WritableSheetImpl
implements WritableSheet {
    private static Logger logger = Logger.getLogger(class$jxl$write$biff$WritableSheetImpl == null ? (class$jxl$write$biff$WritableSheetImpl = WritableSheetImpl.class$("jxl.write.biff.WritableSheetImpl")) : class$jxl$write$biff$WritableSheetImpl);
    private String name;
    private File outputFile;
    private RowRecord[] rows;
    private FormattingRecords formatRecords;
    private SharedStrings sharedStrings;
    private TreeSet columnFormats;
    private ArrayList hyperlinks;
    private MergedCells mergedCells;
    private int numRows;
    private int numColumns;
    private PLSRecord plsRecord;
    private boolean chartOnly;
    private ArrayList rowBreaks;
    private ArrayList drawings;
    private SheetSettings settings;
    private SheetWriter sheetWriter;
    private WorkbookSettings workbookSettings;
    private WritableWorkbookImpl workbook;
    private static final int rowGrowSize = 10;
    private static final int numRowsPerSheet = 65536;
    private static final String[] imageTypes = new String[]{"png"};
    static /* synthetic */ Class class$jxl$write$biff$WritableSheetImpl;

    public WritableSheetImpl(String n2, File of, FormattingRecords fr, SharedStrings ss, WorkbookSettings ws, WritableWorkbookImpl ww) {
        this.name = n2;
        this.outputFile = of;
        this.rows = new RowRecord[0];
        this.numRows = 0;
        this.numColumns = 0;
        this.chartOnly = false;
        this.workbook = ww;
        this.formatRecords = fr;
        this.sharedStrings = ss;
        this.workbookSettings = ws;
        this.columnFormats = new TreeSet(new ColumnInfoComparator());
        this.hyperlinks = new ArrayList();
        this.mergedCells = new MergedCells(this);
        this.rowBreaks = new ArrayList();
        this.drawings = new ArrayList();
        this.settings = new SheetSettings();
        this.sheetWriter = new SheetWriter(this.outputFile, this, this.workbookSettings);
    }

    public Cell getCell(int column, int row) {
        return this.getWritableCell(column, row);
    }

    public WritableCell getWritableCell(int column, int row) {
        WritableCell c2 = null;
        if (row < this.rows.length && this.rows[row] != null) {
            c2 = this.rows[row].getCell(column);
        }
        if (c2 == null) {
            c2 = new EmptyCell(column, row);
        }
        return c2;
    }

    public int getRows() {
        return this.numRows;
    }

    public int getColumns() {
        return this.numColumns;
    }

    public Cell findCell(String contents) {
        Cell cell = null;
        boolean found = false;
        for (int i2 = 0; i2 < this.getRows() && !found; ++i2) {
            Cell[] row = this.getRow(i2);
            for (int j2 = 0; j2 < row.length && !found; ++j2) {
                if (!row[j2].getContents().equals(contents)) continue;
                cell = row[j2];
                found = true;
            }
        }
        return cell;
    }

    public LabelCell findLabelCell(String contents) {
        LabelCell cell = null;
        boolean found = false;
        for (int i2 = 0; i2 < this.getRows() && !found; ++i2) {
            Cell[] row = this.getRow(i2);
            for (int j2 = 0; j2 < row.length && !found; ++j2) {
                if (row[j2].getType() != CellType.LABEL && row[j2].getType() != CellType.STRING_FORMULA || !row[j2].getContents().equals(contents)) continue;
                cell = (LabelCell)row[j2];
                found = true;
            }
        }
        return cell;
    }

    public Cell[] getRow(int row) {
        boolean found = false;
        int col = this.numColumns - 1;
        while (col >= 0 && !found) {
            if (this.getCell(col, row).getType() != CellType.EMPTY) {
                found = true;
                continue;
            }
            --col;
        }
        Cell[] cells = new Cell[col + 1];
        for (int i2 = 0; i2 <= col; ++i2) {
            cells[i2] = this.getCell(i2, row);
        }
        return cells;
    }

    public Cell[] getColumn(int col) {
        boolean found = false;
        int row = this.numRows - 1;
        while (row >= 0 && !found) {
            if (this.getCell(col, row).getType() != CellType.EMPTY) {
                found = true;
                continue;
            }
            --row;
        }
        Cell[] cells = new Cell[row + 1];
        for (int i2 = 0; i2 <= row; ++i2) {
            cells[i2] = this.getCell(col, i2);
        }
        return cells;
    }

    public String getName() {
        return this.name;
    }

    public void insertRow(int row) {
        if (row < 0 || row >= this.numRows) {
            return;
        }
        RowRecord[] oldRows = this.rows;
        this.rows = this.numRows == this.rows.length ? new RowRecord[oldRows.length + 10] : new RowRecord[oldRows.length];
        System.arraycopy(oldRows, 0, this.rows, 0, row);
        System.arraycopy(oldRows, row, this.rows, row + 1, this.numRows - row);
        for (int i2 = row + 1; i2 <= this.numRows; ++i2) {
            if (this.rows[i2] == null) continue;
            this.rows[i2].incrementRow();
        }
        HyperlinkRecord hr = null;
        Iterator i3 = this.hyperlinks.iterator();
        while (i3.hasNext()) {
            hr = (HyperlinkRecord)i3.next();
            hr.insertRow(row);
        }
        this.mergedCells.insertRow(row);
        ArrayList<Integer> newRowBreaks = new ArrayList<Integer>();
        Iterator ri = this.rowBreaks.iterator();
        while (ri.hasNext()) {
            int val = (Integer)ri.next();
            if (val >= row) {
                ++val;
            }
            newRowBreaks.add(new Integer(val));
        }
        this.rowBreaks = newRowBreaks;
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.rowInserted(this, row);
        }
        ++this.numRows;
    }

    public void insertColumn(int col) {
        if (col < 0 || col >= this.numColumns) {
            return;
        }
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            if (this.rows[i2] == null) continue;
            this.rows[i2].insertColumn(col);
        }
        HyperlinkRecord hr = null;
        Iterator i3 = this.hyperlinks.iterator();
        while (i3.hasNext()) {
            hr = (HyperlinkRecord)i3.next();
            hr.insertColumn(col);
        }
        i3 = this.columnFormats.iterator();
        while (i3.hasNext()) {
            ColumnInfoRecord cir = (ColumnInfoRecord)i3.next();
            if (cir.getColumn() < col) continue;
            cir.incrementColumn();
        }
        this.mergedCells.insertColumn(col);
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.columnInserted(this, col);
        }
        ++this.numColumns;
    }

    public void removeColumn(int col) {
        if (col < 0 || col >= this.numColumns) {
            return;
        }
        for (int i2 = 0; i2 < this.numRows; ++i2) {
            if (this.rows[i2] == null) continue;
            this.rows[i2].removeColumn(col);
        }
        HyperlinkRecord hr = null;
        Iterator i3 = this.hyperlinks.iterator();
        while (i3.hasNext()) {
            hr = (HyperlinkRecord)i3.next();
            if (hr.getColumn() == col && hr.getLastColumn() == col) {
                this.hyperlinks.remove(this.hyperlinks.indexOf(hr));
                continue;
            }
            hr.removeColumn(col);
        }
        this.mergedCells.removeColumn(col);
        i3 = this.columnFormats.iterator();
        ColumnInfoRecord removeColumn = null;
        while (i3.hasNext()) {
            ColumnInfoRecord cir = (ColumnInfoRecord)i3.next();
            if (cir.getColumn() == col) {
                removeColumn = cir;
                continue;
            }
            if (cir.getColumn() <= col) continue;
            cir.decrementColumn();
        }
        if (removeColumn != null) {
            this.columnFormats.remove(removeColumn);
        }
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.columnRemoved(this, col);
        }
        --this.numColumns;
    }

    public void removeRow(int row) {
        if (row < 0 || row >= this.numRows) {
            return;
        }
        RowRecord[] oldRows = this.rows;
        this.rows = new RowRecord[oldRows.length];
        System.arraycopy(oldRows, 0, this.rows, 0, row);
        System.arraycopy(oldRows, row + 1, this.rows, row, this.numRows - (row + 1));
        for (int i2 = row; i2 < this.numRows; ++i2) {
            if (this.rows[i2] == null) continue;
            this.rows[i2].decrementRow();
        }
        HyperlinkRecord hr = null;
        Iterator i3 = this.hyperlinks.iterator();
        while (i3.hasNext()) {
            hr = (HyperlinkRecord)i3.next();
            if (hr.getRow() == row && hr.getLastRow() == row) {
                i3.remove();
                continue;
            }
            hr.removeRow(row);
        }
        this.mergedCells.removeRow(row);
        ArrayList<Integer> newRowBreaks = new ArrayList<Integer>();
        Iterator ri = this.rowBreaks.iterator();
        while (ri.hasNext()) {
            int val = (Integer)ri.next();
            if (val == row) continue;
            if (val > row) {
                --val;
            }
            newRowBreaks.add(new Integer(val));
        }
        this.rowBreaks = newRowBreaks;
        if (this.workbookSettings.getFormulaAdjust()) {
            this.workbook.rowRemoved(this, row);
        }
        --this.numRows;
    }

    public void addCell(WritableCell cell) throws WriteException, RowsExceededException {
        CellValue cv2 = (CellValue)cell;
        if (cv2.isReferenced()) {
            throw new JxlWriteException(JxlWriteException.cellReferenced);
        }
        int row = cell.getRow();
        RowRecord rowrec = this.getRowRecord(row);
        rowrec.addCell(cv2);
        this.numRows = Math.max(row + 1, this.numRows);
        this.numColumns = Math.max(this.numColumns, rowrec.getMaxColumn());
        cv2.setCellDetails(this.formatRecords, this.sharedStrings, this);
    }

    private RowRecord getRowRecord(int row) throws RowsExceededException {
        RowRecord rowrec;
        if (row >= 65536) {
            throw new RowsExceededException();
        }
        if (row >= this.rows.length) {
            RowRecord[] oldRows = this.rows;
            this.rows = new RowRecord[Math.max(oldRows.length + 10, row + 1)];
            System.arraycopy(oldRows, 0, this.rows, 0, oldRows.length);
            oldRows = null;
        }
        if ((rowrec = this.rows[row]) == null) {
            this.rows[row] = rowrec = new RowRecord(row);
        }
        return rowrec;
    }

    RowRecord getRowInfo(int r2) {
        if (r2 < 0 || r2 > this.rows.length) {
            return null;
        }
        return this.rows[r2];
    }

    ColumnInfoRecord getColumnInfo(int c2) {
        Iterator i2 = this.columnFormats.iterator();
        ColumnInfoRecord cir = null;
        boolean stop = false;
        while (i2.hasNext() && !stop) {
            cir = (ColumnInfoRecord)i2.next();
            if (cir.getColumn() < c2) continue;
            stop = true;
        }
        if (!stop) {
            return null;
        }
        return cir.getColumn() == c2 ? cir : null;
    }

    public void setName(String n2) {
        this.name = n2;
    }

    public void setHidden(boolean h2) {
        this.settings.setHidden(h2);
    }

    public void setProtected(boolean prot) {
        this.settings.setProtected(prot);
    }

    public void setSelected() {
        this.settings.setSelected();
    }

    public boolean isHidden() {
        return this.settings.isHidden();
    }

    public void setColumnView(int col, int width) {
        CellView cv2 = new CellView();
        cv2.setSize(width * 256);
        this.setColumnView(col, cv2);
    }

    public void setColumnView(int col, int width, CellFormat format) {
        CellView cv2 = new CellView();
        cv2.setSize(width * 256);
        cv2.setFormat(format);
        this.setColumnView(col, cv2);
    }

    public void setColumnView(int col, CellView view) {
        block6: {
            XFRecord xfr = (XFRecord)view.getFormat();
            if (xfr == null) {
                xfr = WritableWorkbookImpl.NORMAL_STYLE;
            }
            try {
                int width;
                ColumnInfoRecord cir;
                if (!xfr.isInitialized()) {
                    this.formatRecords.addStyle(xfr);
                }
                if (!this.columnFormats.contains(cir = new ColumnInfoRecord(col, width = view.depUsed() ? view.getDimension() * 256 : view.getSize(), xfr))) {
                    this.columnFormats.add(cir);
                } else {
                    boolean removed = this.columnFormats.remove(cir);
                    this.columnFormats.add(cir);
                }
            }
            catch (NumFormatRecordsException e2) {
                logger.warn("Maximum number of format records exceeded.  Using default format.");
                ColumnInfoRecord cir = new ColumnInfoRecord(col, view.getDimension() * 256, WritableWorkbook.NORMAL_STYLE);
                if (this.columnFormats.contains(cir)) break block6;
                this.columnFormats.add(cir);
            }
        }
    }

    public void setRowView(int row, int height) throws RowsExceededException {
        this.setRowView(row, height, false);
    }

    public void setRowView(int row, boolean collapsed) throws RowsExceededException {
        RowRecord rowrec = this.getRowRecord(row);
        rowrec.setCollapsed(collapsed);
    }

    public void setRowView(int row, int height, boolean collapsed) throws RowsExceededException {
        RowRecord rowrec = this.getRowRecord(row);
        rowrec.setRowHeight(height);
        rowrec.setCollapsed(collapsed);
    }

    public void write() throws IOException {
        this.sheetWriter.setWriteData(this.rows, this.rowBreaks, this.hyperlinks, this.mergedCells, this.columnFormats);
        this.sheetWriter.setDimensions(this.getRows(), this.getColumns());
        this.sheetWriter.setSettings(this.settings);
        this.sheetWriter.setPLS(this.plsRecord);
        this.sheetWriter.setDrawings(this.drawings);
        this.sheetWriter.write();
    }

    private void copyCells(Sheet s2) {
        int cells = s2.getRows();
        Cell[] row = null;
        Cell cell = null;
        for (int i2 = 0; i2 < cells; ++i2) {
            row = s2.getRow(i2);
            for (int j2 = 0; j2 < row.length; ++j2) {
                cell = row[j2];
                CellType ct2 = cell.getType();
                try {
                    ReadFormulaRecord fr;
                    CellValue b2;
                    if (ct2 == CellType.LABEL) {
                        Label l2 = new Label((LabelCell)cell);
                        this.addCell(l2);
                        continue;
                    }
                    if (ct2 == CellType.NUMBER) {
                        Number n2 = new Number((NumberCell)cell);
                        this.addCell(n2);
                        continue;
                    }
                    if (ct2 == CellType.DATE) {
                        DateTime dt2 = new DateTime((DateCell)cell);
                        this.addCell(dt2);
                        continue;
                    }
                    if (ct2 == CellType.BOOLEAN) {
                        b2 = new Boolean((BooleanCell)cell);
                        this.addCell(b2);
                        continue;
                    }
                    if (ct2 == CellType.NUMBER_FORMULA) {
                        fr = new ReadNumberFormulaRecord((FormulaData)cell);
                        this.addCell(fr);
                        continue;
                    }
                    if (ct2 == CellType.STRING_FORMULA) {
                        fr = new ReadStringFormulaRecord((FormulaData)cell);
                        this.addCell(fr);
                        continue;
                    }
                    if (ct2 == CellType.BOOLEAN_FORMULA) {
                        fr = new ReadBooleanFormulaRecord((FormulaData)cell);
                        this.addCell(fr);
                        continue;
                    }
                    if (ct2 == CellType.FORMULA_ERROR) {
                        fr = new ReadErrorFormulaRecord((FormulaData)cell);
                        this.addCell(fr);
                        continue;
                    }
                    if (ct2 != CellType.EMPTY || cell.getCellFormat() == null) continue;
                    b2 = new Blank(cell);
                    this.addCell(b2);
                    continue;
                }
                catch (WriteException e2) {
                    Assert.verify(false);
                }
            }
        }
    }

    void copy(Sheet s2) {
        this.settings = new SheetSettings(s2.getSettings());
        this.copyCells(s2);
        SheetImpl si = (SheetImpl)s2;
        jxl.read.biff.ColumnInfoRecord[] readCirs = si.getColumnInfos();
        for (int i2 = 0; i2 < readCirs.length; ++i2) {
            jxl.read.biff.ColumnInfoRecord rcir = readCirs[i2];
            for (int j2 = rcir.getStartColumn(); j2 <= rcir.getEndColumn(); ++j2) {
                ColumnInfoRecord cir = new ColumnInfoRecord(rcir, j2, this.formatRecords);
                cir.setHidden(rcir.getHidden());
                this.columnFormats.add(cir);
            }
        }
        Hyperlink[] hls = s2.getHyperlinks();
        for (int i3 = 0; i3 < hls.length; ++i3) {
            WritableHyperlink hr = new WritableHyperlink(hls[i3], this);
            this.hyperlinks.add(hr);
        }
        Range[] merged = s2.getMergedCells();
        for (int i4 = 0; i4 < merged.length; ++i4) {
            this.mergedCells.add(new SheetRangeImpl((SheetRangeImpl)merged[i4], this));
        }
        try {
            jxl.read.biff.RowRecord[] rowprops = si.getRowProperties();
            for (int i5 = 0; i5 < rowprops.length; ++i5) {
                RowRecord rr = this.getRowRecord(rowprops[i5].getRowNumber());
                rr.setRowDetails(rowprops[i5].getRowHeight(), rowprops[i5].isCollapsed());
            }
        }
        catch (RowsExceededException e2) {
            Assert.verify(false);
        }
        int[] rowbreaks = si.getRowPageBreaks();
        if (rowbreaks != null) {
            for (int i6 = 0; i6 < rowbreaks.length; ++i6) {
                this.rowBreaks.add(new Integer(rowbreaks[i6]));
            }
        }
        this.sheetWriter.setCharts(si.getCharts());
        Drawing[] dr2 = si.getDrawings();
        for (int i7 = 0; i7 < dr2.length; ++i7) {
            WritableImage wi = new WritableImage(dr2[i7]);
            this.drawings.add(wi);
        }
        this.sheetWriter.setWorkspaceOptions(si.getWorkspaceOptions());
        if (si.getSheetBof().isChart()) {
            this.chartOnly = true;
            this.sheetWriter.setChartOnly();
        }
        if (si.getPLS() != null) {
            this.plsRecord = new PLSRecord(si.getPLS());
        }
    }

    void copy(WritableSheet s2) {
        int i2;
        this.settings = new SheetSettings(s2.getSettings());
        this.copyCells(s2);
        this.columnFormats = ((WritableSheetImpl)s2).columnFormats;
        Range[] merged = s2.getMergedCells();
        for (int i3 = 0; i3 < merged.length; ++i3) {
            this.mergedCells.add(new SheetRangeImpl((SheetRangeImpl)merged[i3], this));
        }
        try {
            RowRecord[] copyRows = ((WritableSheetImpl)s2).rows;
            RowRecord row = null;
            for (i2 = 0; i2 < copyRows.length; ++i2) {
                row = copyRows[i2];
                if (row == null || row.isDefaultHeight() && !row.isCollapsed()) continue;
                RowRecord rr = this.getRowRecord(i2);
                rr.setRowDetails(row.getRowHeight(), row.isCollapsed());
            }
        }
        catch (RowsExceededException e2) {
            Assert.verify(false);
        }
        WritableSheetImpl si = (WritableSheetImpl)s2;
        this.rowBreaks = new ArrayList(si.rowBreaks);
        this.sheetWriter.setCharts(si.getCharts());
        Drawing[] dr2 = si.getDrawings();
        for (i2 = 0; i2 < dr2.length; ++i2) {
            WritableImage wi = new WritableImage(dr2[i2]);
            this.drawings.add(wi);
        }
        this.sheetWriter.setWorkspaceOptions(si.getWorkspaceOptions());
        if (si.plsRecord != null) {
            this.plsRecord = new PLSRecord(si.plsRecord);
        }
    }

    final HeaderRecord getHeader() {
        return this.sheetWriter.getHeader();
    }

    final FooterRecord getFooter() {
        return this.sheetWriter.getFooter();
    }

    public boolean isProtected() {
        return this.settings.isProtected();
    }

    public Hyperlink[] getHyperlinks() {
        Hyperlink[] hl = new Hyperlink[this.hyperlinks.size()];
        for (int i2 = 0; i2 < this.hyperlinks.size(); ++i2) {
            hl[i2] = (Hyperlink)this.hyperlinks.get(i2);
        }
        return hl;
    }

    public Range[] getMergedCells() {
        return this.mergedCells.getMergedCells();
    }

    public WritableHyperlink[] getWritableHyperlinks() {
        WritableHyperlink[] hl = new WritableHyperlink[this.hyperlinks.size()];
        for (int i2 = 0; i2 < this.hyperlinks.size(); ++i2) {
            hl[i2] = (WritableHyperlink)this.hyperlinks.get(i2);
        }
        return hl;
    }

    public void removeHyperlink(WritableHyperlink h2) {
        this.removeHyperlink(h2, false);
    }

    public void removeHyperlink(WritableHyperlink h2, boolean preserveLabel) {
        this.hyperlinks.remove(this.hyperlinks.indexOf(h2));
        if (!preserveLabel) {
            Assert.verify(this.rows.length > h2.getRow() && this.rows[h2.getRow()] != null);
            this.rows[h2.getRow()].removeCell(h2.getColumn());
        }
    }

    public void addHyperlink(WritableHyperlink h2) throws WriteException, RowsExceededException {
        Label l2;
        Cell c2 = this.getCell(h2.getColumn(), h2.getRow());
        String contents = null;
        if (h2.isFile() || h2.isUNC()) {
            contents = h2.getFile().getPath();
        } else if (h2.isURL()) {
            String cnts = h2.getContents();
            contents = cnts == null ? h2.getURL().toString() : cnts;
        } else if (h2.isLocation()) {
            contents = h2.getContents();
        }
        if (c2.getType() == CellType.LABEL) {
            l2 = (Label)c2;
            l2.setString(contents);
            l2.setCellFormat(WritableWorkbook.HYPERLINK_STYLE);
        } else {
            l2 = new Label(h2.getColumn(), h2.getRow(), contents, (CellFormat)WritableWorkbook.HYPERLINK_STYLE);
            this.addCell(l2);
        }
        for (int i2 = h2.getRow(); i2 <= h2.getLastRow(); ++i2) {
            for (int j2 = h2.getColumn(); j2 <= h2.getLastColumn(); ++j2) {
                if (i2 == h2.getRow() || j2 == h2.getColumn() || this.rows[i2] == null) continue;
                this.rows[i2].removeCell(j2);
            }
        }
        h2.initialize(this);
        this.hyperlinks.add(h2);
    }

    public Range mergeCells(int col1, int row1, int col2, int row2) throws WriteException, RowsExceededException {
        if (col2 < col1 || row2 < row1) {
            logger.warn("Cannot merge cells - top left and bottom right incorrectly specified");
        }
        if (col2 >= this.numColumns || row2 >= this.numRows) {
            this.addCell(new Blank(col2, row2));
        }
        SheetRangeImpl range = new SheetRangeImpl(this, col1, row1, col2, row2);
        this.mergedCells.add(range);
        return range;
    }

    public void unmergeCells(Range r2) {
        this.mergedCells.unmergeCells(r2);
    }

    public void setHeader(String l2, String c2, String r2) {
        HeaderFooter header = new HeaderFooter();
        header.getLeft().append(l2);
        header.getCentre().append(c2);
        header.getRight().append(r2);
        this.settings.setHeader(header);
    }

    public void setFooter(String l2, String c2, String r2) {
        HeaderFooter footer = new HeaderFooter();
        footer.getLeft().append(l2);
        footer.getCentre().append(c2);
        footer.getRight().append(r2);
        this.settings.setFooter(footer);
    }

    public void setPageSetup(PageOrientation p2) {
        this.settings.setOrientation(p2);
    }

    public void setPageSetup(PageOrientation p2, double hm, double fm) {
        this.settings.setOrientation(p2);
        this.settings.setHeaderMargin(hm);
        this.settings.setFooterMargin(fm);
    }

    public void setPageSetup(PageOrientation p2, PaperSize ps, double hm, double fm) {
        this.settings.setPaperSize(ps);
        this.settings.setOrientation(p2);
        this.settings.setHeaderMargin(hm);
        this.settings.setFooterMargin(fm);
    }

    public SheetSettings getSettings() {
        return this.settings;
    }

    WorkbookSettings getWorkbookSettings() {
        return this.workbookSettings;
    }

    public void addRowPageBreak(int row) {
        Iterator i2 = this.rowBreaks.iterator();
        boolean found = false;
        while (i2.hasNext() && !found) {
            if ((Integer)i2.next() != row) continue;
            found = true;
        }
        if (!found) {
            this.rowBreaks.add(new Integer(row));
        }
    }

    private Chart[] getCharts() {
        return this.sheetWriter.getCharts();
    }

    private Drawing[] getDrawings() {
        Drawing[] dr2 = new Drawing[this.drawings.size()];
        System.arraycopy(this.drawings.toArray(), 0, dr2, 0, dr2.length);
        return dr2;
    }

    void checkMergedBorders() {
        this.sheetWriter.setWriteData(this.rows, this.rowBreaks, this.hyperlinks, this.mergedCells, this.columnFormats);
        this.sheetWriter.setDimensions(this.getRows(), this.getColumns());
        this.sheetWriter.checkMergedBorders();
    }

    private WorkspaceInformationRecord getWorkspaceOptions() {
        return this.sheetWriter.getWorkspaceOptions();
    }

    void rationalize(IndexMapping xfMapping, IndexMapping fontMapping, IndexMapping formatMapping) {
        Iterator i2 = this.columnFormats.iterator();
        while (i2.hasNext()) {
            ColumnInfoRecord cir = (ColumnInfoRecord)i2.next();
            cir.rationalize(xfMapping);
        }
        Chart[] charts = this.getCharts();
        for (int c2 = 0; c2 < charts.length; ++c2) {
            charts[c2].rationalize(xfMapping, fontMapping, formatMapping);
        }
    }

    WritableWorkbookImpl getWorkbook() {
        return this.workbook;
    }

    public CellFormat getColumnFormat(int col) {
        return this.getColumnView(col).getFormat();
    }

    public int getColumnWidth(int col) {
        return this.getColumnView(col).getDimension();
    }

    public int getRowHeight(int row) {
        return this.getRowView(row).getDimension();
    }

    boolean isChartOnly() {
        return this.chartOnly;
    }

    public CellView getRowView(int row) {
        CellView cv2 = new CellView();
        try {
            RowRecord rr = this.getRowRecord(row);
            if (rr == null || rr.isDefaultHeight()) {
                cv2.setDimension(this.settings.getDefaultRowHeight());
                cv2.setSize(this.settings.getDefaultRowHeight());
            } else if (rr.isCollapsed()) {
                cv2.setHidden(true);
            } else {
                cv2.setDimension(rr.getRowHeight());
                cv2.setSize(rr.getRowHeight());
            }
            return cv2;
        }
        catch (RowsExceededException e2) {
            cv2.setDimension(this.settings.getDefaultRowHeight());
            cv2.setSize(this.settings.getDefaultRowHeight());
            return cv2;
        }
    }

    public CellView getColumnView(int col) {
        ColumnInfoRecord cir = this.getColumnInfo(col);
        CellView cv2 = new CellView();
        if (cir != null) {
            cv2.setDimension(cir.getWidth() / 256);
            cv2.setSize(cir.getWidth());
            cv2.setHidden(cir.getHidden());
            cv2.setFormat(cir.getCellFormat());
        } else {
            cv2.setDimension(this.settings.getDefaultColumnWidth() / 256);
            cv2.setSize(this.settings.getDefaultColumnWidth());
        }
        return cv2;
    }

    public void addImage(WritableImage image) {
        boolean supported = false;
        java.io.File imageFile = image.getImageFile();
        String fileType = "?";
        if (imageFile != null) {
            String fileName = imageFile.getName();
            int fileTypeIndex = fileName.lastIndexOf(46);
            fileType = fileTypeIndex != -1 ? fileName.substring(fileTypeIndex + 1) : "";
            for (int i2 = 0; i2 < imageTypes.length && !supported; ++i2) {
                if (!fileType.equalsIgnoreCase(imageTypes[i2])) continue;
                supported = true;
            }
        } else {
            supported = true;
        }
        if (supported) {
            this.workbook.addDrawing(image);
            this.drawings.add(image);
        } else {
            StringBuffer message = new StringBuffer("Image type ");
            message.append(fileType);
            message.append(" not supported.  Supported types are ");
            message.append(imageTypes[0]);
            for (int i3 = 1; i3 < imageTypes.length; ++i3) {
                message.append(", ");
                message.append(imageTypes[i3]);
            }
            logger.warn(message.toString());
        }
    }

    public int getNumberOfImages() {
        return this.drawings.size();
    }

    public WritableImage getImage(int i2) {
        return (WritableImage)this.drawings.get(i2);
    }

    public void removeImage(WritableImage wi) {
        boolean removed = this.drawings.remove(wi);
        this.workbook.removeDrawing(wi);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ColumnInfoComparator
    implements Comparator {
        private ColumnInfoComparator() {
        }

        public boolean equals(Object o2) {
            return o2 == this;
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            Assert.verify(o1 instanceof ColumnInfoRecord);
            Assert.verify(o2 instanceof ColumnInfoRecord);
            ColumnInfoRecord ci1 = (ColumnInfoRecord)o1;
            ColumnInfoRecord ci2 = (ColumnInfoRecord)o2;
            return ci1.getColumn() - ci2.getColumn();
        }
    }
}

