/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AppSoundPlayer
extends JDialog {
    private Clip m_oClip = null;
    private boolean m_bPlaying = false;
    private int m_iAudioLength = 0;
    private String m_strLength = "";
    private int m_iAudioPosition = 0;
    private JButton m_jbPlay = null;
    private JSlider m_jsProgress = null;
    private JLabel m_jlTime = null;
    private Timer m_tTimer = null;
    private JPanel m_jpCenter = null;
    private static AppSoundPlayer m_oInstance = null;

    private AppSoundPlayer() {
        this.initComponent();
    }

    public static AppSoundPlayer getInstance() {
        if (m_oInstance == null) {
            m_oInstance = new AppSoundPlayer();
        }
        return m_oInstance;
    }

    @Override
    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        if (!isVisible) {
            this.reset();
        }
    }

    public static void main(String[] args) throws Exception {
        AppSoundPlayer.getInstance().setVisible(true);
        File file = new File("D:/min.wav");
        AppSoundPlayer.getInstance().setFile(file);
        Thread.sleep(5000L);
        AppSoundPlayer.getInstance().setFile(file);
    }

    private void initComponent() {
        this.m_jbPlay = new JButton("Play");
        this.m_jsProgress = new JSlider(0, this.m_iAudioLength, 0);
        this.m_jlTime = new JLabel(String.valueOf(this.m_iAudioLength / 1000) + "." + this.m_iAudioLength % 1000 / 100);
        this.m_jbPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (AppSoundPlayer.this.m_bPlaying) {
                    AppSoundPlayer.this.stop();
                } else {
                    AppSoundPlayer.this.play();
                }
            }
        });
        this.m_jbPlay.setEnabled(false);
        this.m_jsProgress.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                int value = AppSoundPlayer.this.m_jsProgress.getValue();
                AppSoundPlayer.this.m_jlTime.setText(String.valueOf(value / 1000) + "." + value % 1000 / 100 + " / " + AppSoundPlayer.this.m_strLength);
                if (value != AppSoundPlayer.this.m_iAudioPosition) {
                    AppSoundPlayer.this.skip(value);
                }
            }
        });
        this.m_tTimer = new Timer(100, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                AppSoundPlayer.this.tick();
            }
        });
        Box row = Box.createHorizontalBox();
        row.add(this.m_jbPlay);
        row.add(this.m_jsProgress);
        row.add(this.m_jlTime);
        this.m_jpCenter = new JPanel();
        this.m_jpCenter.setLayout(new BoxLayout(this.m_jpCenter, 1));
        this.m_jpCenter.add(row);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_jpCenter, "Center");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                AppSoundPlayer.this.m_iAudioLength = 0;
                AppSoundPlayer.this.m_jbPlay.setEnabled(true);
            }
        });
        this.pack();
    }

    public void setComponent() {
        this.m_jsProgress.setMaximum(this.m_iAudioLength);
        this.m_jlTime.setText(String.valueOf(this.m_iAudioLength / 1000) + "." + this.m_iAudioLength % 1000 / 100);
    }

    public void setFile(File file) {
        block14: {
            AudioInputStream ain = null;
            try {
                try {
                    ain = AudioSystem.getAudioInputStream(file);
                    DataLine.Info info = new DataLine.Info(Clip.class, ain.getFormat());
                    this.m_oClip = (Clip)AudioSystem.getLine(info);
                    this.m_oClip.open(ain);
                }
                catch (Exception e2) {
                    JOptionPane.showMessageDialog(null, AppLang.getText("Not Audio Files"), AppLang.getText("Error"), 0);
                    try {
                        if (ain != null) {
                            ain.close();
                        }
                        break block14;
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (ain != null) {
                        ain.close();
                    }
                }
                catch (IOException e4) {
                    e4.printStackTrace();
                }
                throw throwable;
            }
            try {
                if (ain != null) {
                    ain.close();
                }
            }
            catch (IOException e5) {
                e5.printStackTrace();
            }
        }
        this.m_iAudioLength = (int)(this.m_oClip.getMicrosecondLength() / 1000L);
        this.m_strLength = String.valueOf(this.m_iAudioLength / 1000) + "." + this.m_iAudioLength % 1000 / 100;
        this.setComponent();
        this.m_jbPlay.setEnabled(true);
        this.setLocation(AppGlobal.getCenterPoint(this.getWidth(), this.getHeight()));
        this.setVisible(true);
    }

    public String getSize(File file) {
        if (file == null) {
            return "";
        }
        AudioInputStream ain = null;
        Clip oClip = null;
        String strLength = "";
        int iLength = 0;
        try {
            try {
                ain = AudioSystem.getAudioInputStream(file);
                DataLine.Info info = new DataLine.Info(Clip.class, ain.getFormat());
                oClip = (Clip)AudioSystem.getLine(info);
                oClip.open(ain);
            }
            catch (Exception e2) {
                try {
                    if (ain != null) {
                        ain.close();
                    }
                }
                catch (IOException e3) {
                    e3.printStackTrace();
                }
                return "WAV FORMAT ERROR";
            }
        }
        finally {
            try {
                if (ain != null) {
                    ain.close();
                }
            }
            catch (IOException e4) {
                e4.printStackTrace();
            }
        }
        iLength = (int)(oClip.getMicrosecondLength() / 1000L);
        strLength = "" + iLength / 1000;
        return strLength;
    }

    public void play() {
        this.m_oClip.start();
        this.m_tTimer.start();
        this.m_jbPlay.setText("Stop");
        this.m_bPlaying = true;
    }

    public void stop() {
        this.m_tTimer.stop();
        this.m_oClip.stop();
        this.m_jbPlay.setText("Play");
        this.m_bPlaying = false;
    }

    public void reset() {
        this.stop();
        this.m_oClip.setMicrosecondPosition(0L);
        this.m_iAudioPosition = 0;
        this.m_jsProgress.setValue(0);
    }

    public void skip(int position) {
        if (position < 0 || position > this.m_iAudioLength) {
            return;
        }
        this.m_iAudioPosition = position;
        this.m_oClip.setMicrosecondPosition(position * 1000);
        this.m_jsProgress.setValue(position);
    }

    public int getLength() {
        return this.m_iAudioLength;
    }

    void tick() {
        if (this.m_oClip.isActive()) {
            this.m_iAudioPosition = (int)(this.m_oClip.getMicrosecondPosition() / 1000L);
            this.m_jsProgress.setValue(this.m_iAudioPosition);
        } else {
            this.reset();
        }
    }
}

