/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.update;

import com.sec.osdm.common.AppLang;
import com.sec.osdm.io.AppIOConst;
import com.sec.osdm.update.AppProgress;
import com.sec.osdm.update.SunFtpWrapper;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PackageUpdateRunner
extends JFrame
implements ActionListener {
    Container contentPane;
    JPanel panSysInfo;
    JTextArea taSystemVersion;
    JLabel lbSelectFile;
    JTextField tSelectFile;
    JButton btSelectFile;
    JPanel panFileInfo;
    JTextArea taFileInfo;
    JButton btUpload;
    String host;
    int port = 60024;
    DoUploadFile UploadFile = null;
    String sSysBaseVer = null;
    String sFileBaseVer = null;

    public PackageUpdateRunner(String title, String[] args) {
        super(title);
        this.makeGUI();
        String[] addr = args[0].split(":");
        this.host = addr[0];
        this.dispSystemVersion();
    }

    public PackageUpdateRunner(String title, String addr) {
        super(title);
        this.makeGUI();
        this.host = addr;
    }

    public static void main(String[] args) {
        new PackageUpdateRunner(AppLang.getText("Package Update"), args);
    }

    public void makeGUI() {
        this.setLocation(300, 200);
        this.setPreferredSize(new Dimension(500, 320));
        this.setResizable(false);
        this.contentPane = this.getContentPane();
        this.contentPane.setLayout(null);
        this.panSysInfo = new JPanel();
        this.panSysInfo.setBorder(BorderFactory.createTitledBorder(" " + AppLang.getText("System Information ")));
        this.panSysInfo.setSize(475, 130);
        this.panSysInfo.setLocation(10, 10);
        this.taSystemVersion = new JTextArea(AppLang.getText("System is not connected."));
        this.taSystemVersion.setEditable(false);
        this.taSystemVersion.setSize(435, 90);
        this.taSystemVersion.setLocation(20, 25);
        this.panSysInfo.setLayout(null);
        this.panSysInfo.add(this.taSystemVersion);
        this.contentPane.add(this.panSysInfo);
        this.lbSelectFile = new JLabel(AppLang.getText("Update File :"));
        this.lbSelectFile.setSize(100, 20);
        this.lbSelectFile.setLocation(15, 145);
        this.contentPane.add(this.lbSelectFile);
        this.tSelectFile = new JTextField();
        this.tSelectFile.setEditable(false);
        this.tSelectFile.setSize(290, 20);
        this.tSelectFile.setLocation(90, 145);
        this.contentPane.add(this.tSelectFile);
        this.btSelectFile = new JButton(AppLang.getText("Select File"));
        this.btSelectFile.setSize(100, 20);
        this.btSelectFile.setLocation(380, 145);
        this.contentPane.add(this.btSelectFile);
        this.btSelectFile.addActionListener(this);
        this.panFileInfo = new JPanel();
        this.panFileInfo.setBorder(BorderFactory.createTitledBorder(" " + AppLang.getText("File Information") + " "));
        this.panFileInfo.setSize(475, 80);
        this.panFileInfo.setLocation(10, 170);
        this.taFileInfo = new JTextArea(AppLang.getText("File is not selected."));
        this.taFileInfo.setEditable(false);
        this.taFileInfo.setSize(435, 40);
        this.taFileInfo.setLocation(20, 25);
        this.panFileInfo.setLayout(null);
        this.panFileInfo.add(this.taFileInfo);
        this.contentPane.add(this.panFileInfo);
        this.btUpload = new JButton(AppLang.getText("Upload"));
        this.btUpload.setSize(100, 20);
        this.btUpload.setLocation(200, 257);
        this.contentPane.add(this.btUpload);
        this.btUpload.addActionListener(this);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setVisible(true);
    }

    public void dispSystemVersion() {
        DatagramSocket socket = null;
        DatagramPacket out = null;
        DatagramPacket in = null;
        InetAddress serverInet = null;
        byte[] sendBuf = new byte[40];
        byte[] recvBuf = new byte[65508];
        String currVer = null;
        String baseVer = null;
        byte[] diskTotal = new byte[4];
        byte[] diskUsed = new byte[4];
        byte[] diskFree = new byte[4];
        try {
            try {
                socket = new DatagramSocket();
                serverInet = InetAddress.getByName(this.host);
                out = new DatagramPacket(sendBuf, 40, serverInet, this.port);
                System.arraycopy(PackageUpdateRunner.intToByteArray(0), 0, sendBuf, 0, 4);
                System.arraycopy(PackageUpdateRunner.intToByteArray(3), 0, sendBuf, 4, 4);
                System.arraycopy(PackageUpdateRunner.intToByteArray(2), 0, sendBuf, 8, 4);
                System.arraycopy(PackageUpdateRunner.intToByteArray(1), 0, sendBuf, 12, 4);
                System.arraycopy(PackageUpdateRunner.intToByteArray(40), 0, sendBuf, 16, 4);
                System.arraycopy(PackageUpdateRunner.intToByteArray(10), 0, sendBuf, 20, 4);
                System.arraycopy(PackageUpdateRunner.intToByteArray(0), 0, sendBuf, 24, 4);
                System.arraycopy(PackageUpdateRunner.intToByteArray(0), 0, sendBuf, 28, 4);
                System.arraycopy(PackageUpdateRunner.intToByteArray(0), 0, sendBuf, 32, 4);
                System.arraycopy(PackageUpdateRunner.intToByteArray(0), 0, sendBuf, 36, 4);
                socket.send(out);
                in = new DatagramPacket(recvBuf, 1024);
                socket.receive(in);
                currVer = new String(in.getData(), 40, 16);
                if (currVer != null) {
                    this.taSystemVersion.setText(String.valueOf(AppLang.getText("Current version :")) + " " + currVer);
                }
                if ((baseVer = new String(in.getData(), 56, 16)) != null) {
                    this.taSystemVersion.setText(String.valueOf(this.taSystemVersion.getText()) + "\n" + AppLang.getText("Base version :") + " " + baseVer);
                    this.sSysBaseVer = baseVer;
                }
                System.arraycopy(PackageUpdateRunner.intToByteArray(11), 0, sendBuf, 20, 4);
                socket.send(out);
                socket.receive(in);
                System.arraycopy(in.getData(), 60, diskTotal, 0, 4);
                this.taSystemVersion.setText(String.valueOf(this.taSystemVersion.getText()) + "\n" + AppLang.getText("Disk total :") + " " + PackageUpdateRunner.byteArrayToUnsignedInt(diskTotal) + " " + AppLang.getText("Kbytes"));
                System.arraycopy(in.getData(), 64, diskUsed, 0, 4);
                this.taSystemVersion.setText(String.valueOf(this.taSystemVersion.getText()) + "\n" + AppLang.getText("Disk used :") + " " + PackageUpdateRunner.byteArrayToUnsignedInt(diskUsed) + " " + AppLang.getText("Kbytes"));
                System.arraycopy(in.getData(), 68, diskFree, 0, 4);
                this.taSystemVersion.setText(String.valueOf(this.taSystemVersion.getText()) + "\n" + AppLang.getText("Disk free :") + " " + PackageUpdateRunner.byteArrayToUnsignedInt(diskFree) + " " + AppLang.getText("Kbytes"));
            }
            catch (Exception e2) {
                System.out.println(e2.getMessage());
                System.out.println(AppLang.getText("exception"));
                e2.printStackTrace();
                socket.close();
            }
        }
        finally {
            socket.close();
        }
    }

    public void SelectFile() {
        FileInputStream fis = null;
        BufferedReader br2 = null;
        try {
            try {
                FileDialog openFD = new FileDialog((Frame)this, AppLang.getText("Open"), 0);
                openFD.setVisible(true);
                String file = openFD.getFile();
                String dir = openFD.getDirectory();
                if (file != null || dir != null) {
                    fis = new FileInputStream(String.valueOf(dir) + "\\" + file);
                    br2 = new BufferedReader(new InputStreamReader(fis));
                    String str = null;
                    str = br2.readLine();
                    String[] arr = str.split("_");
                    String info = arr[0];
                    if (info.equals("uImage")) {
                        String baseVer;
                        this.tSelectFile.setText(String.valueOf(dir) + file);
                        String firmVer = arr[1];
                        this.sFileBaseVer = baseVer = arr[2];
                        String subVer = arr[4];
                        this.taFileInfo.setText(String.valueOf(AppLang.getText("The corresponding firmware's version :")) + " " + firmVer + "\n");
                        this.taFileInfo.setText(String.valueOf(this.taFileInfo.getText()) + AppLang.getText("The compatible base version :") + " " + baseVer + "\n");
                    } else {
                        JOptionPane.showMessageDialog(this, AppLang.getText("Selected file is not IVM package."));
                    }
                }
            }
            catch (FileNotFoundException fnfe) {
                JOptionPane.showMessageDialog(this, AppLang.getText("File not found."));
                try {
                    br2.close();
                    fis.close();
                }
                catch (Exception exception) {}
            }
            catch (IOException ioe) {
                JOptionPane.showMessageDialog(this, AppLang.getText("Cannot read the file."));
                try {
                    br2.close();
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                br2.close();
                fis.close();
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        String ac = e2.getActionCommand();
        if (ac.equals(AppLang.getText("Select File"))) {
            this.SelectFile();
        } else if (ac.equals(AppLang.getText("Upload"))) {
            File f2 = new File(this.tSelectFile.getText());
            if (f2.isFile()) {
                if (this.sSysBaseVer.trim().equals(this.sFileBaseVer)) {
                    int Reboot = JOptionPane.showConfirmDialog(this, AppLang.getText("Do you want to reboot?"));
                    if (Reboot != 2 && Reboot != -1) {
                        System.out.println("reboot : " + Reboot);
                        this.UploadFile = new DoUploadFile(this, Reboot);
                        this.UploadFile.start();
                    }
                } else {
                    JOptionPane.showMessageDialog(this, AppLang.getText("File's base version is not different from system's."));
                }
            } else {
                JOptionPane.showMessageDialog(this, AppLang.getText("Please select file before updating."));
            }
        }
    }

    private static byte[] intToByteArray(int integer) {
        ByteBuffer buff = ByteBuffer.allocate(4);
        buff.order(ByteOrder.BIG_ENDIAN);
        buff.putInt(integer);
        return buff.array();
    }

    private static int byteArrayToInt(byte[] bytes) {
        int size = 4;
        ByteBuffer buff = ByteBuffer.allocate(4);
        byte[] newBytes = new byte[4];
        int i2 = 0;
        while (i2 < 4) {
            newBytes[i2] = i2 + bytes.length < 4 ? (byte)0 : bytes[i2 + bytes.length - 4];
            ++i2;
        }
        buff.order(ByteOrder.BIG_ENDIAN);
        buff = ByteBuffer.wrap(newBytes);
        return buff.getInt();
    }

    private static long byteArrayToUnsignedInt(byte[] bytes) {
        long l2 = 0L;
        int pos = 0;
        l2 += (long)(PackageUpdateRunner.unsignedByteToInt(bytes[pos++]) << 24);
        l2 += (long)(PackageUpdateRunner.unsignedByteToInt(bytes[pos++]) << 16);
        l2 += (long)(PackageUpdateRunner.unsignedByteToInt(bytes[pos++]) << 8);
        return l2 += (long)(PackageUpdateRunner.unsignedByteToInt(bytes[pos++]) << 0);
    }

    private static int unsignedByteToInt(byte b2) {
        return b2 & 0xFF;
    }

    class DoUploadFile
    extends Thread {
        AppProgress m_progress = null;
        int Reboot = 0;
        Frame owner = null;

        public DoUploadFile(Frame owner, int Reboot) {
            this.m_progress = new AppProgress(owner, AppLang.getText("Upload File"));
            this.owner = owner;
            this.Reboot = Reboot;
        }

        @Override
        public void run() {
            this.m_progress.start();
            this.m_progress.setLable(AppLang.getText("Starting..."));
            boolean ret = this.UploadFile();
            this.closeThread();
        }

        private void closeThread() {
            this.m_progress.hideStatus();
            this.m_progress = null;
        }

        public boolean UploadFile() {
            boolean ret;
            block14: {
                DatagramSocket socket = null;
                DatagramPacket out = null;
                DatagramPacket in = null;
                InetAddress serverInet = null;
                byte[] sendBuf = new byte[132];
                byte[] recvBuf = new byte[65508];
                byte[] recvMsgID = new byte[4];
                byte[] recvResult = new byte[4];
                ret = false;
                boolean isUpdating = false;
                String[] userPath = PackageUpdateRunner.this.tSelectFile.getText().split("\\\\");
                String fileName = userPath[userPath.length - 1];
                String systemPath = fileName;
                int pathLen = systemPath.length();
                if (pathLen > 80) {
                    System.out.println(AppLang.getText("The length of system path is more than 80."));
                }
                try {
                    try {
                        socket = new DatagramSocket();
                        serverInet = InetAddress.getByName(PackageUpdateRunner.this.host);
                        out = new DatagramPacket(sendBuf, 132, serverInet, PackageUpdateRunner.this.port);
                        System.arraycopy(PackageUpdateRunner.intToByteArray(0), 0, sendBuf, 0, 4);
                        System.arraycopy(PackageUpdateRunner.intToByteArray(3), 0, sendBuf, 4, 4);
                        System.arraycopy(PackageUpdateRunner.intToByteArray(2), 0, sendBuf, 8, 4);
                        System.arraycopy(PackageUpdateRunner.intToByteArray(1), 0, sendBuf, 12, 4);
                        System.arraycopy(PackageUpdateRunner.intToByteArray(132), 0, sendBuf, 16, 4);
                        System.arraycopy(PackageUpdateRunner.intToByteArray(5), 0, sendBuf, 20, 4);
                        System.arraycopy(PackageUpdateRunner.intToByteArray(0), 0, sendBuf, 24, 4);
                        System.arraycopy(PackageUpdateRunner.intToByteArray(0), 0, sendBuf, 28, 4);
                        System.arraycopy(PackageUpdateRunner.intToByteArray(0), 0, sendBuf, 32, 4);
                        System.arraycopy(PackageUpdateRunner.intToByteArray(0), 0, sendBuf, 36, 4);
                        System.arraycopy(PackageUpdateRunner.intToByteArray(0), 0, sendBuf, 40, 4);
                        System.arraycopy(PackageUpdateRunner.intToByteArray(pathLen), 0, sendBuf, 44, 4);
                        System.arraycopy(systemPath.getBytes(), 0, sendBuf, 48, pathLen);
                        if (this.Reboot == 0) {
                            System.arraycopy(PackageUpdateRunner.intToByteArray(1), 0, sendBuf, 128, 4);
                        } else {
                            System.arraycopy(PackageUpdateRunner.intToByteArray(0), 0, sendBuf, 128, 4);
                        }
                        socket.send(out);
                        in = new DatagramPacket(recvBuf, 1024);
                        do {
                            socket.receive(in);
                        } while (in.getLength() == 0);
                        System.arraycopy(in.getData(), 24, recvResult, 0, 4);
                        if (PackageUpdateRunner.byteArrayToInt(recvResult) == 28) {
                            this.m_progress.setLable(AppLang.getText("Package update is now progresing. Please, for a while, try again."));
                            isUpdating = true;
                        }
                        if (isUpdating) break block14;
                        this.ftpUpload(PackageUpdateRunner.this.tSelectFile.getText(), systemPath);
                        System.arraycopy(PackageUpdateRunner.intToByteArray(6), 0, sendBuf, 20, 4);
                        socket.send(out);
                        int ii = 0;
                        String prevLabel = this.m_progress.getLable();
                        this.m_progress.showStatus();
                        while (true) {
                            socket.receive(in);
                            if (in.getLength() == 0) continue;
                            System.arraycopy(in.getData(), 20, recvMsgID, 0, 4);
                            if (PackageUpdateRunner.byteArrayToInt(recvMsgID) == 15) {
                                System.arraycopy(in.getData(), 40, recvResult, 0, 4);
                                String errMsg = this.dispError(PackageUpdateRunner.byteArrayToInt(recvResult));
                                if (PackageUpdateRunner.byteArrayToInt(recvResult) == 0) {
                                    this.m_progress.setLable(String.valueOf(prevLabel) + " - " + AppLang.getText(errMsg));
                                    System.out.println("Update complete.");
                                    ret = true;
                                } else {
                                    this.m_progress.setLable(String.valueOf(prevLabel) + " - Update fail.[" + AppLang.getText(errMsg) + "]");
                                    System.out.println("Update fail.[" + errMsg + "]");
                                }
                                this.m_progress.endStatus();
                                break;
                            }
                            if (PackageUpdateRunner.byteArrayToInt(recvMsgID) != 14) continue;
                            this.m_progress.setLable(String.valueOf(prevLabel) + " - " + AppLang.getText("Updating..."));
                            System.out.println("Updating " + ++ii);
                            this.m_progress.resetStatus();
                        }
                    }
                    catch (Exception e2) {
                        System.out.println(e2.getMessage());
                        System.out.println(AppLang.getText("exception"));
                        e2.printStackTrace();
                        socket.close();
                    }
                }
                finally {
                    socket.close();
                }
            }
            return ret;
        }

        public void ftpUpload(String localFile, String serverFile) throws IOException {
            SunFtpWrapper ftp = new SunFtpWrapper();
            ftp.openServer(PackageUpdateRunner.this.host, 60021);
            ftp.login("admin", "samsung");
            ftp.binary();
            boolean ret = ftp.uploadFile(localFile, "/mnt/nand/" + serverFile, this.m_progress);
            System.out.println("ret : " + ret);
            ftp.closeServer();
        }

        private String dispError(int error) {
            String msg = "";
            if (AppIOConst.m_uploadError.containsKey(error)) {
                msg = (String)AppIOConst.m_uploadError.get(error);
            }
            return msg;
        }
    }
}

