/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

class ConceptLocation {
    private int _concept;
    private int _begin;
    private int _end;
    private static ConceptLocationSorter _cComp;
    private static ConceptLocationSorter _pComp;

    private ConceptLocation() {
        _cComp = new ConceptSorter();
        _pComp = new PositionSorter();
    }

    public ConceptLocation(int n2, int n3, int n4) {
        this._concept = n2;
        this._begin = n3;
        this._end = n4;
    }

    public boolean equals(ConceptLocation conceptLocation) {
        return this._concept == conceptLocation._concept && this._begin == conceptLocation._begin && this._end == conceptLocation._end;
    }

    public void setConcept(int n2) {
        this._concept = n2;
    }

    public int getConcept() {
        return this._concept;
    }

    public int getBegin() {
        return this._begin;
    }

    public int getEnd() {
        return this._end;
    }

    public int getLength() {
        return this._end - this._begin;
    }

    public static void sortByConcept(ConceptLocation[] conceptLocationArray, int n2, int n3) {
        _cComp.quicksort(conceptLocationArray, n2, n3 - 1);
    }

    public static void sortByPosition(ConceptLocation[] conceptLocationArray, int n2, int n3) {
        _pComp.quicksort(conceptLocationArray, n2, n3 - 1);
    }

    public void print() {
        System.out.println(this._concept + "\t" + this._begin + "\t" + this._end);
    }

    public static void main(String[] stringArray) {
        int n2 = 30;
        ConceptLocation[] conceptLocationArray = new ConceptLocation[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = (int)(Math.random() * 1000.0);
            conceptLocationArray[n3] = new ConceptLocation((int)(Math.random() * 1000.0), n4, n4 + (int)(Math.random() * 10.0));
            ++n3;
        }
        int n5 = 0;
        while (n5 < n2) {
            conceptLocationArray[n5].print();
            ++n5;
        }
        ConceptLocation.sortByConcept(conceptLocationArray, 0, n2);
        System.out.println("----------------------------------");
        int n6 = 0;
        while (n6 < n2) {
            conceptLocationArray[n6].print();
            ++n6;
        }
        ConceptLocation.sortByPosition(conceptLocationArray, 0, n2);
        System.out.println("----------------------------------");
        int n7 = 0;
        while (n7 < n2) {
            conceptLocationArray[n7].print();
            ++n7;
        }
    }

    static {
        new ConceptLocation();
    }

    private class PositionSorter
    extends ConceptLocationSorter {
        private PositionSorter() {
        }

        public boolean smallerThan(ConceptLocation conceptLocation, ConceptLocation conceptLocation2) {
            return conceptLocation._begin < conceptLocation2._begin || conceptLocation._begin == conceptLocation2._begin && conceptLocation._end < conceptLocation2._end;
        }
    }

    private class ConceptSorter
    extends ConceptLocationSorter {
        private ConceptSorter() {
        }

        public boolean smallerThan(ConceptLocation conceptLocation, ConceptLocation conceptLocation2) {
            return conceptLocation._concept < conceptLocation2._concept;
        }
    }

    private abstract class ConceptLocationSorter {
        private ConceptLocationSorter() {
        }

        public abstract boolean smallerThan(ConceptLocation var1, ConceptLocation var2);

        private int partition(ConceptLocation[] conceptLocationArray, int n2, int n3) {
            ConceptLocation conceptLocation = conceptLocationArray[n2];
            int n4 = n2 - 1;
            int n5 = n3 + 1;
            while (true) {
                if (this.smallerThan(conceptLocation, conceptLocationArray[--n5])) {
                    continue;
                }
                while (this.smallerThan(conceptLocationArray[++n4], conceptLocation)) {
                }
                if (n4 >= n5) break;
                ConceptLocation conceptLocation2 = conceptLocationArray[n4];
                conceptLocationArray[n4] = conceptLocationArray[n5];
                conceptLocationArray[n5] = conceptLocation2;
            }
            return n5;
        }

        public void quicksort(ConceptLocation[] conceptLocationArray, int n2, int n3) {
            if (n2 < n3) {
                int n4 = this.partition(conceptLocationArray, n2, n3);
                this.quicksort(conceptLocationArray, n2, n4);
                this.quicksort(conceptLocationArray, n4 + 1, n3);
            }
        }
    }
}

