/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages;

import com.sec.osdm.common.AppFileBrowser;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppRunConference;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.io.AppFTPClient;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.AppPopupMenu;
import com.sec.osdm.pages.utils.components.AppComboBox;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class AppConference
extends JDialog
implements ActionListener,
KeyListener {
    public final int PAGE_LIST = 0;
    public final int PAGE_HISTORY = 1;
    public final int PAGE_INPROGRESS = 2;
    public AppConference m_parent = null;
    public AppPageInfo m_pageInfo = null;
    public AppFTPClient m_ftpClient = null;
    public AppLayout m_layout = null;
    public AppTable m_table = null;
    public AppTableModel m_model = null;
    public AppTextBox m_compText = null;
    public AppComboBox m_compCombo = null;
    public JPanel m_panMain = new JPanel();
    public JPanel m_contentPane = new JPanel(new BorderLayout());
    public JLabel m_compLabel = null;
    public JCheckBox m_compCheck = null;
    public JRadioButton m_compRadio = null;
    public String[][] m_corner = new String[][]{{""}};
    public String[][] m_colTitle = null;
    public String[][] m_rowTitle = null;
    public ArrayList m_components = new ArrayList();
    public ArrayList m_recvData = null;
    public ArrayList m_saveData = null;
    public ArrayList m_reqList = null;
    public String m_cnfTitle = "";
    public String m_cnfId = "";
    public String m_cnfOwner = "";
    public int m_cnfRepeat = 0;
    public byte[] m_startTime = new byte[8];
    public byte[] m_endTime = new byte[8];
    public byte[] m_endDate = new byte[8];
    public byte[] m_cardPos = new byte[2];
    public byte[] m_reqData = null;
    public byte[] m_respData = null;
    public int m_selRow = -1;
    public int m_pageSource = 0;
    public int m_startMin;
    public int m_endMin;
    public boolean m_bIsCallDlg = true;
    public boolean m_bFtpResult = false;
    public AppPopupMenu m_popup = null;

    public void initParentData() {
        try {
            this.m_cnfId = this.m_parent.m_cnfId;
            this.m_cnfTitle = this.m_parent.m_cnfTitle;
            this.m_cnfOwner = this.m_parent.m_cnfOwner;
            this.m_cnfRepeat = this.m_parent.m_cnfRepeat;
            System.arraycopy(this.m_parent.m_startTime, 0, this.m_startTime, 0, 8);
            System.arraycopy(this.m_parent.m_endTime, 0, this.m_endTime, 0, 8);
            System.arraycopy(this.m_parent.m_endDate, 0, this.m_endDate, 0, 8);
            System.arraycopy(this.m_parent.m_cardPos, 0, this.m_cardPos, 0, 2);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean readDataFromSystem() {
        this.m_recvData = new ArrayList();
        this.m_pageInfo.setReqData(this.m_reqData);
        if (AppComm.getInstance().requestDownload(this.m_pageInfo)) {
            this.m_recvData = this.m_pageInfo.getRecvData();
            return true;
        }
        return false;
    }

    public boolean saveDataToSystem() {
        this.m_respData = null;
        this.m_pageInfo.setSaveData(this.m_saveData);
        if (AppComm.getInstance().requestUpload(this.m_pageInfo)) {
            this.m_respData = this.m_pageInfo.getRespData();
            return true;
        }
        return false;
    }

    public void sendFTPFile(final String source, final String target) {
        final String ipAddress = AppRunConference.getCardAddress(this.m_cardPos[0], this.m_cardPos[1]);
        final int portNumber = AppRunConference.getCardFtpPort(this.m_cardPos[0], this.m_cardPos[1]);
        AppGlobal.showProgress(String.valueOf(source) + " --> " + target, String.valueOf(AppLang.getText("Sending file to ")) + ipAddress);
        AppGlobal.setCanceler(this);
        new Thread(){

            @Override
            public void run() {
                AppConference.this.m_bFtpResult = false;
                AppConference.this.m_ftpClient = new AppFTPClient();
                AppConference.this.m_ftpClient.setServerIP(ipAddress);
                AppConference.this.m_ftpClient.setFtpPort(portNumber);
                if (AppConference.this.m_ftpClient.connect()) {
                    if (AppConference.this.m_ftpClient.putFiles(source, target)) {
                        AppGlobal.hideProgress();
                        JOptionPane.showMessageDialog(null, "Successful Upload.");
                        AppConference.this.m_bFtpResult = true;
                    } else {
                        AppGlobal.hideProgress();
                        JOptionPane.showMessageDialog(null, "Failed to upload file. Please try again.");
                    }
                    AppConference.this.m_ftpClient.disConnect();
                } else {
                    AppGlobal.hideProgress();
                }
                AppConference.this.m_ftpClient = null;
            }
        }.start();
    }

    public void recvFTPFile(final String source, final String target) {
        final String ipAddress = AppRunConference.getCardAddress(this.m_cardPos[0], this.m_cardPos[1]);
        final int portNumber = AppRunConference.getCardFtpPort(this.m_cardPos[0], this.m_cardPos[1]);
        AppGlobal.showProgress(String.valueOf(source) + " --> " + target, String.valueOf(AppLang.getText("Receiving file from ")) + ipAddress);
        AppGlobal.setCanceler(this);
        new Thread(){

            @Override
            public void run() {
                AppConference.this.m_ftpClient = new AppFTPClient();
                AppConference.this.m_ftpClient.setServerIP(ipAddress);
                AppConference.this.m_ftpClient.setFtpPort(portNumber);
                if (AppConference.this.m_ftpClient.connect()) {
                    if (AppConference.this.m_ftpClient.getFile(source, target)) {
                        AppGlobal.hideProgress();
                        JOptionPane.showMessageDialog(null, "Successful Download.");
                    } else {
                        AppGlobal.hideProgress();
                        JOptionPane.showMessageDialog(null, "Failed to download file. Please try again.");
                    }
                    AppConference.this.m_ftpClient.disConnect();
                } else {
                    AppGlobal.hideProgress();
                }
                AppConference.this.m_ftpClient = null;
            }
        }.start();
    }

    public void deleteFTPFile(final String target) {
        final String ipAddress = AppRunConference.getCardAddress(this.m_cardPos[0], this.m_cardPos[1]);
        final int portNumber = AppRunConference.getCardFtpPort(this.m_cardPos[0], this.m_cardPos[1]);
        AppGlobal.showProgress(target, String.valueOf(AppLang.getText("Deleting file to ")) + ipAddress);
        AppGlobal.setCanceler(this);
        new Thread(){

            @Override
            public void run() {
                AppConference.this.m_ftpClient = new AppFTPClient();
                AppConference.this.m_ftpClient.setServerIP(ipAddress);
                AppConference.this.m_ftpClient.setFtpPort(portNumber);
                if (AppConference.this.m_ftpClient.connect()) {
                    if (AppConference.this.m_ftpClient.removeFile(target)) {
                        AppGlobal.hideProgress();
                        JOptionPane.showMessageDialog(null, "File Deleted.");
                    } else {
                        AppGlobal.hideProgress();
                        JOptionPane.showMessageDialog(null, "Failed to delete file. Please try again.");
                    }
                    AppConference.this.m_ftpClient.disConnect();
                } else {
                    AppGlobal.hideProgress();
                }
                AppConference.this.m_ftpClient = null;
            }
        }.start();
    }

    public void downloadRecordingFile(ArrayList recvData) {
        if (((String)recvData.get(22)).equals("0") && !((String)recvData.get(24)).equals("")) {
            AppFileBrowser browser = new AppFileBrowser();
            if (browser.saveBrowser((String)recvData.get(24))) {
                this.recvFTPFile(String.valueOf(AppGlobal.g_recordingDir) + (String)recvData.get(24), browser.getFilePath());
            }
        } else {
            JOptionPane.showMessageDialog(null, "Recording file does not exist.");
        }
    }

    public void openDialog(String title, int width, int height) {
        AppGlobal.g_dialogList.add(this);
        this.setTitle(AppLang.getText(title));
        this.setModal(true);
        this.setIconImage(AppImages.Img_Logo);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                AppConference.this.closeDialog();
            }
        });
        this.add(this.m_panMain);
        this.setSize(width, height);
        this.setResizable(false);
        this.setLocation(AppGlobal.getCenterPoint(this.getSize().width, this.getSize().height));
        this.setVisible(true);
    }

    public void closeDialog() {
        if (AppGlobal.g_dialogList.size() > 0) {
            AppGlobal.g_dialogList.remove(AppGlobal.g_dialogList.size() - 1);
        }
        this.dispose();
    }

    public void setDateMinute() {
        this.m_startTime[0] = 0;
        this.m_startTime[1] = (byte)(this.m_startMin % 4 * 15);
        this.m_startTime[2] = (byte)(this.m_startMin / 4);
        this.m_endTime[0] = 0;
        this.m_endTime[1] = (byte)(this.m_endMin % 4 * 15);
        this.m_endTime[2] = (byte)(this.m_endMin / 4);
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.runActionEvent(e2.getActionCommand());
    }

    public void runActionEvent(String command) {
    }

    @Override
    public void keyPressed(KeyEvent ke) {
    }

    @Override
    public void keyReleased(KeyEvent ke) {
        this.runKeyReleased(ke);
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    public void runKeyReleased(KeyEvent ke) {
    }

    public void cancelJob() {
        if (this.m_ftpClient != null) {
            this.m_ftpClient.abort();
        }
    }
}

