/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.components;

import com.sec.osdm.common.AppLang;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.utils.components.AppTextBox;
import java.awt.event.KeyEvent;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AppCellText
extends JTextField {
    private JTextField m_this = this;
    private int m_pattern = 0;
    private int m_minimum = 0;
    private int m_maximum = 0;
    private int m_length = 0;
    private String m_default = "";
    private String m_toolTip = "";

    public void setTextInfo(AppPageInfo page, int index) {
        this.setPattern(page.getFieldPattern(index));
        this.setRange(page.getFieldMin(index), page.getFieldMax(index));
        this.setLength(page.getFieldLength(index));
        this.setDefault(page.getFieldDefault(index));
        this.m_toolTip = AppLang.getText("Available value");
        this.m_toolTip = this.m_maximum > 0 || this.m_pattern == 36 ? String.valueOf(this.m_toolTip) + ": " + this.m_minimum + " ~ " + this.m_maximum : (this.m_pattern == 0 ? String.valueOf(this.m_toolTip) + ": " + AppLang.getText("All characters") + " - " + AppLang.getText("Max length") + ": " + this.m_length : String.valueOf(this.m_toolTip) + ": " + AppTextBox.m_htTooltip.get(this.m_pattern) + " - " + AppLang.getText("Max length") + ": " + this.m_length);
        this.setDocument(new TextPattern());
        this.setTooltipText(this.m_toolTip);
    }

    public void setPattern(int pattern) {
        this.m_pattern = pattern > 38 ? 0 : pattern;
    }

    public void setRange(int min, int max) {
        this.m_minimum = min;
        this.m_maximum = max;
        if (min > max) {
            this.m_minimum = max;
            this.m_maximum = min;
        }
    }

    public void setLength(int len) {
        this.m_length = len;
    }

    public void setDefault(String sDefault) {
        this.m_default = sDefault.trim();
    }

    public void setTooltipText(String strTooltipText) {
        this.setToolTipText(strTooltipText.trim());
    }

    public void toolTipEvent() {
        this.dispatchEvent(new KeyEvent(this, 401, 0L, 2, 112));
    }

    public class TextPattern
    extends PlainDocument {
        String m_inText = "";
        int m_inValue = 0;
        boolean m_bResult = true;

        @Override
        public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                return;
            }
            if (AppCellText.this.m_pattern != 0 && !Pattern.matches(AppTextBox.m_htPattern.get(AppCellText.this.m_pattern), str)) {
                AppCellText.this.toolTipEvent();
                return;
            }
            if (AppCellText.this.m_length <= 0) {
                super.insertString(offset, str, attr);
                return;
            }
            if (this.getLength() + str.length() > AppCellText.this.m_length) {
                AppCellText.this.toolTipEvent();
                return;
            }
            super.insertString(offset, str, attr);
            if (AppCellText.this.m_maximum > 0) {
                this.m_bResult = true;
                this.m_inText = AppCellText.this.m_this.getText().trim();
                try {
                    if (AppCellText.this.m_pattern != 36) {
                        this.m_inValue = Integer.parseInt(this.m_inText);
                        if (this.m_inText.length() >= String.format("%d", AppCellText.this.m_minimum).length() && this.m_inValue > AppCellText.this.m_maximum) {
                            this.m_bResult = false;
                        }
                    } else if (!(this.m_inText.equals("-") || this.m_inValue >= AppCellText.this.m_minimum && this.m_inValue <= AppCellText.this.m_maximum)) {
                        this.m_bResult = false;
                    }
                }
                catch (NumberFormatException ne) {
                    this.m_bResult = false;
                }
                if (!this.m_bResult) {
                    AppCellText.this.m_this.setText(AppCellText.this.m_default);
                    AppCellText.this.toolTipEvent();
                }
            }
        }
    }
}

