/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import com.sec.osdm.pages.utils.table.ICellComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.EventListenerList;
import javax.swing.table.TableCellEditor;

public class AppEditorCellComponent
extends AbstractCellEditor
implements TableCellEditor,
ItemListener,
ActionListener {
    protected EventListenerList listenerList = new EventListenerList();
    protected transient ChangeEvent changeEvent = null;
    protected ICellComponent m_curCellComponent = null;
    protected JComponent editorComponent = null;
    protected AppPanel m_panel = null;

    public Component getComponent() {
        return this.editorComponent;
    }

    @Override
    public Object getCellEditorValue() {
        return this.m_curCellComponent;
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            return ((MouseEvent)anEvent).getClickCount() >= 2;
        }
        return true;
    }

    @Override
    public boolean shouldSelectCell(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            MouseEvent e2 = (MouseEvent)anEvent;
            return e2.getID() != 506;
        }
        return true;
    }

    public boolean startCellEditing(EventObject anEvent) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.editorComponent instanceof JComboBox && ((JComboBox)this.editorComponent).isEditable()) {
            ((JComboBox)this.editorComponent).actionPerformed(new ActionEvent(this, 0, ""));
        }
        this.fireEditingStopped();
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public void addCellEditorListener(CellEditorListener l2) {
        this.listenerList.add(CellEditorListener.class, l2);
    }

    @Override
    public void removeCellEditorListener(CellEditorListener l2) {
        this.listenerList.remove(CellEditorListener.class, l2);
    }

    @Override
    protected void fireEditingStopped() {
        Object[] listeners = this.listenerList.getListenerList();
        int i2 = listeners.length - 2;
        while (i2 >= 0) {
            if (listeners[i2] == CellEditorListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i2 + 1]).editingStopped(this.changeEvent);
            }
            i2 -= 2;
        }
    }

    @Override
    protected void fireEditingCanceled() {
        Object[] listeners = this.listenerList.getListenerList();
        int i2 = listeners.length - 2;
        while (i2 >= 0) {
            if (listeners[i2] == CellEditorListener.class) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                ((CellEditorListener)listeners[i2 + 1]).editingCanceled(this.changeEvent);
            }
            i2 -= 2;
        }
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            if (value instanceof ICellComponent) {
                this.m_curCellComponent = (ICellComponent)value;
                if (this.m_curCellComponent.getOwner() != null) {
                    this.m_curCellComponent.getOwner().editingStopped(null);
                }
                this.editorComponent = this.m_curCellComponent.getComponent();
                this.m_curCellComponent.setOwner(table);
                if (this.editorComponent instanceof JTextField) {
                    if (this.m_panel == null) {
                        this.m_panel = new AppPanel();
                    }
                    this.m_panel.setComponent((JTextField)this.editorComponent);
                    this.editorComponent = this.m_panel;
                }
                this.editorComponent.setBorder(BorderFactory.createLineBorder(Color.BLACK, 1));
                this.editorComponent.requestFocus();
            } else {
                this.editorComponent = null;
            }
        } else {
            this.editorComponent = null;
        }
        return this.editorComponent;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        this.stopCellEditing();
    }

    @Override
    public void itemStateChanged(ItemEvent e2) {
        this.stopCellEditing();
    }

    public class AppPanel
    extends JPanel
    implements FocusListener {
        protected JTextField m_component = null;

        public AppPanel() {
            this.setBackground(Color.white);
            this.setLayout(new BorderLayout());
            this.addFocusListener(this);
        }

        public void setComponent(JTextField txtComp) {
            if (this.m_component != null) {
                this.remove(this.m_component);
            }
            this.m_component = txtComp;
            this.m_component.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)this.m_component, "Center");
            Dimension size = this.getPreferredSize();
            size.height = 13;
            txtComp.setPreferredSize(size);
        }

        @Override
        public void focusGained(FocusEvent e2) {
            this.m_component.requestFocus();
        }

        @Override
        public void focusLost(FocusEvent e2) {
        }

        @Override
        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e2, int condition, boolean pressed) {
            InputMap map = this.m_component.getInputMap(condition);
            ActionMap am = this.m_component.getActionMap();
            if (map != null && am != null && this.isEnabled()) {
                Action action;
                Object binding = map.get(ks);
                Action action2 = action = binding == null ? null : am.get(binding);
                if (action != null) {
                    this.m_component.selectAll();
                    return SwingUtilities.notifyAction(action, ks, e2, this.m_component, e2.getModifiers());
                }
            }
            return false;
        }
    }
}

