/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.drawing;

import common.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.WorkbookSettings;
import jxl.biff.IntegerHelper;
import jxl.biff.drawing.Chart;
import jxl.biff.drawing.Dg;
import jxl.biff.drawing.DgContainer;
import jxl.biff.drawing.Drawing;
import jxl.biff.drawing.MsoDrawingRecord;
import jxl.biff.drawing.ObjRecord;
import jxl.biff.drawing.Sp;
import jxl.biff.drawing.SpContainer;
import jxl.biff.drawing.Spgr;
import jxl.biff.drawing.SpgrContainer;
import jxl.write.biff.File;

public class SheetDrawingWriter {
    private static Logger logger = Logger.getLogger(class$jxl$biff$drawing$SheetDrawingWriter == null ? (class$jxl$biff$drawing$SheetDrawingWriter = SheetDrawingWriter.class$("jxl.biff.drawing.SheetDrawingWriter")) : class$jxl$biff$drawing$SheetDrawingWriter);
    private ArrayList drawings;
    private Chart[] charts = new Chart[0];
    private WorkbookSettings workbookSettings;
    static /* synthetic */ Class class$jxl$biff$drawing$SheetDrawingWriter;

    public SheetDrawingWriter(WorkbookSettings ws) {
    }

    public void setDrawings(ArrayList dr2) {
        this.drawings = dr2;
    }

    public void write(File outputFile) throws IOException {
        int i2;
        if (this.drawings.size() == 0 && this.charts.length == 0) {
            return;
        }
        boolean modified = false;
        Iterator i3 = this.drawings.iterator();
        while (i3.hasNext() && !modified) {
            Drawing d2 = (Drawing)i3.next();
            if (d2.getOrigin() == Drawing.READ) continue;
            modified = true;
        }
        if (!modified) {
            this.writeUnmodified(outputFile);
            return;
        }
        int numImages = this.drawings.size();
        Object[] spContainerData = new Object[numImages + this.charts.length];
        int length = 0;
        SpContainer firstSpContainer = null;
        for (i2 = 0; i2 < numImages; ++i2) {
            Drawing drawing = (Drawing)this.drawings.get(i2);
            SpContainer spc = drawing.getSpContainer();
            byte[] data = spc.getData();
            spContainerData[i2] = data;
            if (i2 == 0) {
                firstSpContainer = spc;
                continue;
            }
            length += data.length;
        }
        for (i2 = 0; i2 < this.charts.length; ++i2) {
            SpContainer spContainer = this.charts[i2].getSpContainer();
            byte[] data = spContainer.getBytes();
            data = spContainer.setHeaderData(data);
            spContainerData[i2 + numImages] = data;
            if (i2 == 0 && numImages == 0) {
                firstSpContainer = spContainer;
                continue;
            }
            length += data.length;
        }
        Drawing firstDrawing = (Drawing)this.drawings.get(0);
        DgContainer dgContainer = new DgContainer();
        Dg dg2 = new Dg(numImages + this.charts.length);
        dgContainer.add(dg2);
        SpgrContainer spgrContainer = new SpgrContainer();
        SpContainer spContainer = new SpContainer();
        Spgr spgr = new Spgr();
        spContainer.add(spgr);
        Sp sp = new Sp(Sp.MIN, 1024, 5);
        spContainer.add(sp);
        spgrContainer.add(spContainer);
        spgrContainer.add(firstSpContainer);
        dgContainer.add(spgrContainer);
        byte[] firstMsoData = dgContainer.getData();
        int len = IntegerHelper.getInt(firstMsoData[4], firstMsoData[5], firstMsoData[6], firstMsoData[7]);
        IntegerHelper.getFourBytes(len + length, firstMsoData, 4);
        len = IntegerHelper.getInt(firstMsoData[28], firstMsoData[29], firstMsoData[30], firstMsoData[31]);
        IntegerHelper.getFourBytes(len + length, firstMsoData, 28);
        MsoDrawingRecord msoDrawingRecord = new MsoDrawingRecord(firstMsoData);
        outputFile.write(msoDrawingRecord);
        ObjRecord objRecord = new ObjRecord(firstDrawing.getObjectId());
        outputFile.write(objRecord);
        for (int i4 = 1; i4 < spContainerData.length; ++i4) {
            byte[] bytes = (byte[])spContainerData[i4];
            msoDrawingRecord = new MsoDrawingRecord(bytes);
            outputFile.write(msoDrawingRecord);
            if (i4 < numImages) {
                objRecord = new ObjRecord(((Drawing)this.drawings.get(i4)).getObjectId());
                outputFile.write(objRecord);
                continue;
            }
            Chart chart = this.charts[i4 - numImages];
            objRecord = chart.getObjRecord();
            outputFile.write(objRecord);
            outputFile.write(chart);
        }
    }

    private void writeUnmodified(File outputFile) throws IOException {
        int i2;
        if (this.charts.length == 0 && this.drawings.size() == 0) {
            return;
        }
        if (this.charts.length == 0 && this.drawings.size() != 0) {
            Iterator i3 = this.drawings.iterator();
            while (i3.hasNext()) {
                Drawing d2 = (Drawing)i3.next();
                outputFile.write(d2.getMsoDrawingRecord());
                outputFile.write(d2.getObjRecord());
            }
            return;
        }
        if (this.drawings.size() == 0 && this.charts.length != 0) {
            Chart curChart = null;
            for (int i4 = 0; i4 < this.charts.length; ++i4) {
                curChart = this.charts[i4];
                if (curChart.getMsoDrawingRecord() != null) {
                    outputFile.write(curChart.getMsoDrawingRecord());
                }
                if (curChart.getObjRecord() != null) {
                    outputFile.write(curChart.getObjRecord());
                }
                outputFile.write(curChart);
            }
            return;
        }
        int numDrawings = this.drawings.size();
        int length = 0;
        SpContainer[] spContainers = new SpContainer[numDrawings + this.charts.length];
        for (i2 = 0; i2 < numDrawings; ++i2) {
            Drawing d3 = (Drawing)this.drawings.get(i2);
            spContainers[i2] = d3.getSpContainer();
            if (i2 <= 0) continue;
            length += spContainers[i2].getLength();
        }
        for (i2 = 0; i2 < this.charts.length; ++i2) {
            spContainers[i2 + numDrawings] = this.charts[i2].getSpContainer();
            length += spContainers[i2 + numDrawings].getLength();
        }
        DgContainer dgContainer = new DgContainer();
        Dg dg2 = new Dg(numDrawings + this.charts.length);
        dgContainer.add(dg2);
        SpgrContainer spgrContainer = new SpgrContainer();
        SpContainer spContainer = new SpContainer();
        Spgr spgr = new Spgr();
        spContainer.add(spgr);
        Sp sp = new Sp(Sp.MIN, 1024, 5);
        spContainer.add(sp);
        spgrContainer.add(spContainer);
        spgrContainer.add(spContainers[0]);
        dgContainer.add(spgrContainer);
        byte[] firstMsoData = dgContainer.getData();
        int len = IntegerHelper.getInt(firstMsoData[4], firstMsoData[5], firstMsoData[6], firstMsoData[7]);
        IntegerHelper.getFourBytes(len + length, firstMsoData, 4);
        len = IntegerHelper.getInt(firstMsoData[28], firstMsoData[29], firstMsoData[30], firstMsoData[31]);
        IntegerHelper.getFourBytes(len + length, firstMsoData, 28);
        MsoDrawingRecord msoDrawingRecord = new MsoDrawingRecord(firstMsoData);
        outputFile.write(msoDrawingRecord);
        ObjRecord objRecord = ((Drawing)this.drawings.get(0)).getObjRecord();
        outputFile.write(objRecord);
        for (int i5 = 1; i5 < spContainers.length; ++i5) {
            byte[] bytes = spContainers[i5].getBytes();
            byte[] bytes2 = spContainers[i5].setHeaderData(bytes);
            msoDrawingRecord = new MsoDrawingRecord(bytes2);
            outputFile.write(msoDrawingRecord);
            if (i5 < numDrawings) {
                objRecord = ((Drawing)this.drawings.get(i5)).getObjRecord();
                outputFile.write(objRecord);
                continue;
            }
            Chart chart = this.charts[i5 - numDrawings];
            objRecord = chart.getObjRecord();
            outputFile.write(objRecord);
            outputFile.write(chart);
        }
    }

    public void setCharts(Chart[] ch2) {
        this.charts = ch2;
    }

    public Chart[] getCharts() {
        return this.charts;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

