/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.common;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.common.AppRunInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Hashtable;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class AppFileBrowser {
    private JFileChooser m_browser = new JFileChooser((String)AppProperty.m_properties.get("USER_DIR"));
    private FileNameExtensionFilter m_filter = null;
    private String m_fileName = "";
    private String m_filePath = "";
    private Hashtable m_readData = null;

    public void setFileFilter(String filter, String ext) {
        this.m_filter = new FileNameExtensionFilter(filter, ext);
        this.m_browser.setFileFilter(this.m_filter);
    }

    public void setFileFilter(String filter, String ext1, String ext2) {
        this.m_filter = new FileNameExtensionFilter(filter, ext1, ext2);
        this.m_browser.setFileFilter(this.m_filter);
    }

    public void setDialogType(int type) {
        this.m_browser.setDialogType(type);
    }

    public boolean openBrowser() {
        int result = this.m_browser.showOpenDialog(null);
        if (result == 0) {
            AppProperty.m_properties.put("USER_DIR", this.m_browser.getSelectedFile().getParent());
            AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
            if (!this.m_browser.getSelectedFile().exists()) {
                AppGlobal.showErrorMessage("", AppLang.getText("Selected file is not exist"));
            } else {
                this.m_fileName = this.m_browser.getSelectedFile().getName();
                this.m_filePath = this.m_browser.getSelectedFile().getAbsolutePath();
                return true;
            }
        }
        return false;
    }

    public boolean saveBrowserWithExtender(String ext) {
        int result = this.m_browser.showSaveDialog(null);
        if (result == 0) {
            File file;
            AppProperty.m_properties.put("USER_DIR", this.m_browser.getSelectedFile().getParent());
            AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
            String fileName = this.m_browser.getSelectedFile().getName();
            String filePath = this.m_browser.getSelectedFile().getAbsolutePath();
            if (this.m_browser.getFileFilter().getDescription().toLowerCase().contains(".odm") && !fileName.toLowerCase().endsWith("." + ext)) {
                fileName = String.valueOf(fileName) + "." + ext;
                filePath = String.valueOf(filePath) + "." + ext;
            }
            if ((file = new File(filePath)).exists()) {
                if (AppGlobal.showConfirmMessage(AppLang.getText("Overwrite"), AppLang.getText("Selected file is already exist. Do you want to overwrite?")) == 1) {
                    return false;
                }
                file.delete();
            }
            try {
                file.createNewFile();
            }
            catch (IOException e1) {
                AppGlobal.showErrorMessage("", AppLang.getText("Failed to create a new file."));
                return false;
            }
            this.m_fileName = fileName;
            this.m_filePath = filePath;
            return true;
        }
        return false;
    }

    public boolean saveBrowser(String ext) {
        File recommendfile = new File(ext);
        this.m_browser.setSelectedFile(recommendfile);
        int result = this.m_browser.showSaveDialog(null);
        if (result == 0) {
            AppProperty.m_properties.put("USER_DIR", this.m_browser.getSelectedFile().getParent());
            AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
            String fileName = this.m_browser.getSelectedFile().getName();
            String filePath = this.m_browser.getSelectedFile().getAbsolutePath();
            File file = new File(filePath);
            if (file.exists()) {
                if (AppGlobal.showConfirmMessage(AppLang.getText("Overwrite"), AppLang.getText("Selected file is already exist. Do you want to overwrite?")) == 1) {
                    return false;
                }
                file.delete();
            }
            try {
                file.createNewFile();
            }
            catch (IOException e1) {
                AppGlobal.showErrorMessage("", AppLang.getText("Failed to create a new file."));
                return false;
            }
            this.m_fileName = fileName;
            this.m_filePath = filePath;
            return true;
        }
        return false;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public String getFilePath() {
        return this.m_filePath;
    }

    public Hashtable getDatabase() {
        if (this.m_readData != null) {
            return this.m_readData;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkDatabaseFile() {
        if (!this.m_filePath.equals("")) {
            try {
                FileInputStream fis = new FileInputStream(this.m_filePath);
                ObjectInputStream ois = new ObjectInputStream(fis);
                try {
                    this.m_readData = (Hashtable)ois.readObject();
                    if (this.m_readData.containsKey("0000")) {
                        AppRunInfo.setFileName(this.m_fileName);
                        AppRunInfo.setFilePath(this.m_filePath);
                        return true;
                    }
                    AppGlobal.showErrorMessage("", AppLang.getText("Invalid file format."));
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            catch (IOException ie) {
                AppGlobal.showErrorMessage("", AppLang.getText("Invalid file format."));
            }
            this.m_readData = null;
        }
        return false;
    }

    public Hashtable getDatabaseFile() {
        return this.m_readData;
    }
}

