/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.common;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppProperty;
import java.util.Hashtable;

public class AppLang {
    public static final int LANG_ENGLISH = 0;
    public static final int LANG_KOREAN = 1;
    public static final int LANG_RUSSIAN = 2;
    public static final int LANG_GERMAN = 3;
    public static final int LANG_ITALIAN = 4;
    private static final int LANG_START = 1;
    private static final int LANG_END = 4;
    private static String m_langDirectory = "/resources/files/languages/";
    private static String[] m_langFiles = new String[]{"Korean.ini", "Russian.ini", "German.ini", "Italian.ini"};
    private static Hashtable m_language = null;

    public static void setLanguage() {
        int lang = 0;
        try {
            lang = Integer.parseInt((String)AppProperty.m_properties.get("USER_LANG"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        m_language = null;
        if (lang >= 1 && lang <= 4) {
            m_language = (Hashtable)AppProperty.readDataFromFile(AppLang.class.getResourceAsStream(String.valueOf(m_langDirectory) + m_langFiles[lang - 1]));
        }
    }

    public static void changeLanguage(int lang) {
        AppProperty.m_properties.put("USER_LANG", "" + lang);
        AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
        AppGlobal.showInfoMessage("", AppLang.getText("New language setting saved. Restart the program."));
    }

    public static String getText(String str) {
        if (str == null) {
            return "";
        }
        if (m_language != null && m_language.containsKey(str)) {
            String retStr = (String)m_language.get(str);
            return retStr.equals("") ? str : retStr;
        }
        return str;
    }
}

