/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.common;

import com.sec.osdm.common.AppLang;
import com.sec.osdm.main.view.AppTreeNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Hashtable;

public class AppProperty {
    public static String m_runDirectory = String.valueOf(System.getProperty("user.dir")) + File.separator;
    public static String m_fileProperty = String.valueOf(m_runDirectory) + "Properties.ini";
    public static String m_fileSiteList = String.valueOf(m_runDirectory) + "SiteList.ini";
    public static String m_fileBook = String.valueOf(m_runDirectory) + "Bookmark.ini";
    public static String m_fileHistory = String.valueOf(m_runDirectory) + "History.ini";
    public static String m_fileTreeMenu = "/resources/files/properties/TreeMenu.ini";
    public static String m_fileIVMTree = "/resources/files/properties/TreeMenuIVM.ini";
    public static String m_fileStructure = "/resources/files/properties/Structure.ini";
    public static Hashtable m_treemenu = null;
    public static Hashtable m_allMmcList = null;
    public static Hashtable m_properties = null;
    public static Hashtable m_structure = null;
    public static ArrayList m_sitelist = null;
    public static ArrayList m_history = null;
    public static ArrayList m_bookmark = null;
    public static ArrayList m_useMmcList = new ArrayList();
    private static String[] m_propKey = new String[]{"PART_REQUEST", "USER_DIR", "USE_TOOLBAR", "USER_LANG", "USER_ID", "USER_MENU_MODE"};
    private static Object[] m_propValue = new Object[]{false, System.getProperty("user.dir"), true, "0", "admin", "Functional"};

    public static void setProperties() {
        m_structure = (Hashtable)AppProperty.readDataFromFile(AppProperty.class.getResourceAsStream(m_fileStructure));
        AppProperty.createProperties();
        AppProperty.createMenuList();
        AppProperty.createSiteList();
        AppProperty.createBookmark();
        AppProperty.createHistory();
        AppLang.setLanguage();
    }

    private static void createProperties() {
        File file = new File(m_fileProperty);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((m_properties = (Hashtable)AppProperty.readDataFromFile(m_fileProperty)) == null) {
            m_properties = new Hashtable();
        }
        int i2 = 0;
        while (i2 < m_propKey.length) {
            if (!m_properties.containsKey(m_propKey[i2])) {
                m_properties.put(m_propKey[i2], m_propValue[i2]);
            }
            ++i2;
        }
        if (!m_properties.containsKey("LINK_INFO")) {
            m_properties.put("LINK_INFO", AppProperty.createLinkInfo());
        } else {
            Hashtable linkData = (Hashtable)m_properties.get("LINK_INFO");
            if (linkData.containsKey("IP_TEL")) {
                Hashtable linkInfo = AppProperty.createLinkInfo();
                linkInfo.put("LINK_KIND", (String)linkData.get("LINK_KIND"));
                linkInfo.put("SITE_NAME", (String)linkData.get("SITE_NAME"));
                if (((String)linkData.get("LINK_KIND")).equals("LAN")) {
                    linkInfo.put("IP_ADDRESS", (String)linkData.get("IP_TEL"));
                    linkInfo.put("DATA_PORT", (String)linkData.get("DATA_COM"));
                    linkInfo.put("FILE_PORT", (String)linkData.get("FILE_BAUD"));
                    linkInfo.put("FTP_PORT", (String)linkData.get("FTP"));
                    linkInfo.put("VM_PORT", (String)linkData.get("VM"));
                } else {
                    linkInfo.put("TEL_NUMBER", (String)linkData.get("IP_TEL"));
                    linkInfo.put("COM_PORT", (String)linkData.get("DATA_COM"));
                    linkInfo.put("BAUD_RATE", (String)linkData.get("FILE_BAUD"));
                }
                m_properties.put("LINK_INFO", linkInfo);
            }
        }
        if (!m_properties.containsKey("MODEM_INFO")) {
            Hashtable<String, String> modemInfo = new Hashtable<String, String>();
            modemInfo.put("DIAL_RETRY", "1");
            modemInfo.put("DIAL_DURATION", "90");
            modemInfo.put("DIAL_TYPE", "0");
            modemInfo.put("INIT_COMMAND", "AT&F");
            m_properties.put("MODEM_INFO", modemInfo);
        }
        AppProperty.saveDataToFile(m_fileProperty, m_properties);
    }

    private static Hashtable createLinkInfo() {
        Hashtable<String, String> linkInfo = new Hashtable<String, String>();
        linkInfo.put("LINK_KIND", "LAN");
        linkInfo.put("SITE_NAME", "");
        linkInfo.put("IP_ADDRESS", "");
        linkInfo.put("DATA_PORT", "5090");
        linkInfo.put("FILE_PORT", "5003");
        linkInfo.put("FTP_PORT", "21");
        linkInfo.put("VM_PORT", "6001");
        linkInfo.put("TEL_NUMBER", "");
        linkInfo.put("COM_PORT", "1");
        linkInfo.put("BAUD_RATE", "38400");
        return linkInfo;
    }

    private static void createMenuList() {
        String file = m_fileTreeMenu;
        m_treemenu = (Hashtable)AppProperty.readDataFromFile(AppProperty.class.getResourceAsStream(file));
        m_allMmcList = new Hashtable();
        Hashtable treeMenu = (Hashtable)m_treemenu.get("MENU_LIST");
        for (String msgId : treeMenu.keySet()) {
            m_allMmcList.put(msgId, new AppTreeNode((Hashtable)treeMenu.get(msgId)));
        }
    }

    private static void createSiteList() {
        File file = new File(m_fileSiteList);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            m_sitelist = (ArrayList)AppProperty.readDataFromFile(m_fileSiteList);
        }
        catch (Exception e2) {
            file.delete();
            m_sitelist = null;
        }
        if (m_sitelist == null) {
            m_sitelist = new ArrayList();
            m_sitelist.add(new Hashtable());
            m_sitelist.add(new Hashtable());
            AppProperty.saveDataToFile(m_fileSiteList, m_sitelist);
        }
    }

    private static void createBookmark() {
        File file = new File(m_fileBook);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((m_bookmark = (ArrayList)AppProperty.readDataFromFile(m_fileBook)) == null) {
            m_bookmark = new ArrayList();
            AppProperty.saveDataToFile(m_fileBook, m_bookmark);
        }
    }

    private static void createHistory() {
        File file = new File(m_fileHistory);
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if ((m_history = (ArrayList)AppProperty.readDataFromFile(m_fileHistory)) == null) {
            m_history = new ArrayList();
            AppProperty.saveDataToFile(m_fileHistory, m_history);
        }
    }

    public static boolean createFileForWebStart(int len) {
        m_runDirectory = "c:/OfficeDM/";
        m_fileProperty = String.valueOf(m_runDirectory) + "Properties.ini";
        m_fileBook = String.valueOf(m_runDirectory) + "BookMark.ini";
        m_fileHistory = String.valueOf(m_runDirectory) + "History.ini";
        m_fileSiteList = String.valueOf(m_runDirectory) + "SiteList.ini";
        File dir = new File(m_runDirectory);
        if (!dir.exists()) {
            dir.mkdirs();
            return true;
        }
        return false;
    }

    public static Object readDataFromFile(InputStream is) {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(is);
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e2) {
            return null;
        }
        finally {
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e3) {
                return null;
            }
        }
    }

    public static Object readDataFromFile(String file) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(file));
            ObjectInputStream ois = new ObjectInputStream(fis);
            Object object = ois.readObject();
            return object;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return null;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (IOException e3) {
                e3.printStackTrace();
                return null;
            }
        }
    }

    public static boolean saveDataToFile(String file, Object obj) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(new File(file));
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(obj);
            return true;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
        finally {
            try {
                fos.close();
            }
            catch (IOException e3) {
                e3.printStackTrace();
                return false;
            }
        }
    }
}

