/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.io;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.io.AppDownRequest;
import com.sec.osdm.io.AppIOConst;
import com.sec.osdm.io.AppUpRequest;
import com.sec.osdm.main.view.AppMenuActions;
import com.sec.osdm.main.view.AppTreeNode;
import com.sec.osdm.pages.AppPageInfo;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.JOptionPane;

public class AppComm
extends AppIOConst {
    private static AppComm m_oThis = null;
    private AppComm m_comm = null;
    public AppPageInfo m_pageInfo = null;
    public byte[] m_header = new byte[18];
    public byte[] m_respHeader = new byte[18];
    public byte m_msgType = 0;

    public static AppComm getInstance() {
        if (m_oThis == null) {
            m_oThis = new AppComm();
        }
        return m_oThis;
    }

    public void setComm(AppComm comm) {
        this.m_comm = comm;
    }

    public void unsetComm() {
        this.m_comm = null;
    }

    public boolean connect() {
        if (this.m_comm != null) {
            return this.m_comm.connect();
        }
        return false;
    }

    public void disconnect() {
        if (this.m_comm != null) {
            this.m_comm.disconnect();
            this.unsetComm();
        }
    }

    public boolean sendData(byte[] data) {
        if (this.m_comm != null) {
            return this.m_comm.sendData(data);
        }
        return false;
    }

    public byte[] recvData() {
        if (this.m_comm != null) {
            return this.m_comm.recvData();
        }
        return null;
    }

    public void requestDisconnect() {
        AppGlobal.releaseThread();
        this.m_pageInfo = new AppPageInfo();
        this.m_pageInfo.setMsgId("FFFF");
        this.m_msgType = (byte)2;
        this.makeMessageHeader();
        this.sendData(this.m_header);
        this.disconnect();
    }

    public void requestAlive() {
        this.m_pageInfo = new AppPageInfo();
        this.m_pageInfo.setMsgId("FFFF");
        this.m_msgType = (byte)3;
        this.makeMessageHeader();
        this.sendData(this.m_header);
    }

    public boolean requestDownload(AppPageInfo page) {
        this.m_pageInfo = page;
        this.m_msgType = this.m_pageInfo.getDownMsgType();
        return AppDownRequest.requestDownload(m_oThis);
    }

    public boolean requestUpload(AppPageInfo page) {
        this.m_pageInfo = page;
        this.m_msgType = this.m_pageInfo.getUpMsgType();
        return AppUpRequest.requestUpload(m_oThis);
    }

    public boolean requestAllUpload(AppPageInfo page) {
        this.m_pageInfo = page;
        this.m_msgType = this.m_pageInfo.getUpMsgType();
        return AppUpRequest.requestAllUpload(m_oThis);
    }

    public boolean partialRequest(AppPageInfo page) {
        byte[] send = null;
        byte[] recv = null;
        byte[] resp = null;
        int msgLen = 0;
        this.m_pageInfo = page;
        if (this.m_pageInfo.getReqData() != null) {
            msgLen = this.m_pageInfo.getReqData().length;
        }
        this.m_pageInfo.setMsgLength(msgLen);
        this.m_pageInfo.setRecordSize(msgLen);
        this.m_msgType = this.m_pageInfo.getDownMsgType();
        this.makeMessageHeader();
        send = new byte[msgLen + 18];
        System.arraycopy(this.m_header, 0, send, 0, 18);
        if (msgLen > 0) {
            System.arraycopy(this.m_pageInfo.getReqData(), 0, send, 18, msgLen);
        }
        if (this.sendData(send) && (recv = this.recvData()) != null) {
            resp = new byte[recv.length - 18];
            System.arraycopy(recv, 18, resp, 0, resp.length);
            this.m_pageInfo.setRespData(resp);
            return true;
        }
        return false;
    }

    public void makeMessageHeader() {
        this.m_header[0] = this.getSourceTask();
        this.m_header[1] = this.getDestTask();
        this.m_header[2] = this.m_msgType;
        this.m_header[3] = -1;
        AppFunctions.short2byte(this.m_header, 4, (short)Integer.parseInt(this.m_pageInfo.getMsgId(), 16));
        AppFunctions.short2byte(this.m_header, 6, (short)this.m_pageInfo.getRecordSize());
        AppFunctions.int2byte(this.m_header, 8, this.m_pageInfo.getMsgLength());
        AppFunctions.short2byte(this.m_header, 12, (short)-1);
        this.m_header[14] = this.m_pageInfo.getMsgResponse();
        this.m_header[15] = -1;
        this.m_header[16] = -1;
        this.m_header[17] = -1;
    }

    public void dispErrorMessage(byte errMsg) {
        if (((AppTreeNode)AppProperty.m_allMmcList.get(this.m_pageInfo.getMsgId())).getMenuKind() == 1) {
            if (m_htVmError.containsKey(errMsg)) {
                String msgId = this.m_comm.m_pageInfo.getMsgId();
                if (msgId.equals("7F05")) {
                    if (JOptionPane.showConfirmDialog(null, AppLang.getText("This system is not support the function. Do you disconnect DM and execute the Webmmc?"), AppLang.getText(""), 0) == 0) {
                        try {
                            Hashtable linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
                            String m_ipServer = (String)linkInfo.get("IP_ADDRESS");
                            String osName = System.getProperty("os.name").toLowerCase();
                            String url = "https://" + m_ipServer + "/login/login.php";
                            if (osName.indexOf("win") >= 0) {
                                AppGlobal.g_dataProcess = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                            } else if (osName.indexOf("mac") >= 0) {
                                AppGlobal.g_dataProcess = Runtime.getRuntime().exec("open " + url);
                            } else if (osName.indexOf("nix") >= 0 || osName.indexOf("nux") >= 0) {
                                String[] browsers = new String[]{"epiphany", "firefox", "mozilla", "konqueror", "netscape", "opera", "links", "lynx"};
                                StringBuffer cmd = new StringBuffer();
                                int i2 = 0;
                                while (i2 < browsers.length) {
                                    cmd.append(String.valueOf(i2 == 0 ? "" : " || ") + browsers[i2] + " \"" + url + "\" ");
                                    ++i2;
                                }
                                AppGlobal.g_dataProcess = Runtime.getRuntime().exec(new String[]{"sh", "-c", cmd.toString()});
                            }
                        }
                        catch (IOException e2) {
                            e2.printStackTrace();
                        }
                        AppMenuActions.disconnectSystem(true);
                    }
                } else {
                    AppGlobal.showErrorMessage("Error", (String)m_htVmError.get(errMsg));
                }
            }
        } else if (m_htError.containsKey(errMsg)) {
            if (errMsg >= 3 && errMsg <= 7 || errMsg == 11 || errMsg == 12 || errMsg == 15) {
                AppGlobal.showInfoMessage("", (String)m_htError.get(errMsg));
            } else {
                AppGlobal.showErrorMessage("", (String)m_htError.get(errMsg));
            }
        } else {
            AppGlobal.showErrorMessage("", "(" + errMsg + ") " + AppLang.getText("Unknown problem is occurred!"));
        }
    }

    public byte getSourceTask() {
        if (((AppTreeNode)AppProperty.m_allMmcList.get(this.m_pageInfo.getMsgId())).getMenuKind() == 1) {
            return 115;
        }
        return 114;
    }

    public byte getDestTask() {
        if (((AppTreeNode)AppProperty.m_allMmcList.get(this.m_pageInfo.getMsgId())).getMenuKind() == 1) {
            return 113;
        }
        return 112;
    }
}

