/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.io;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Hashtable;

public class AppControl {
    private static int MAX_PACKET_SIZE = 16384;
    private static Socket m_socket = null;
    private static Hashtable m_linkInfo = new Hashtable();

    public AppControl() {
        m_linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
    }

    private boolean connect() {
        try {
            if (m_socket == null) {
                m_socket = new Socket((String)m_linkInfo.get("IP_ADDRESS"), Integer.parseInt((String)m_linkInfo.get("FILE_PORT")));
            }
            return true;
        }
        catch (UnknownHostException e1) {
            AppGlobal.showErrorMessage("", AppLang.getText("Server IP address is not exist."));
        }
        catch (IOException e1) {
            AppGlobal.showErrorMessage("", AppLang.getText("Failed to create socket."));
        }
        return false;
    }

    public void disconnect() {
        try {
            if (m_socket != null) {
                if (m_socket.isConnected()) {
                    m_socket.close();
                }
                m_socket = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public byte[] requestFileControl(byte[] reqData, int pacSize) {
        byte[] recv = null;
        if (this.sendData(reqData) && pacSize > 0) {
            recv = this.recvData(pacSize);
        }
        return recv;
    }

    public byte[] requestUpload(byte[] reqData, int pacSize) {
        byte[] recv = null;
        if (this.sendData(reqData) && pacSize > 0) {
            recv = this.recvUpload(pacSize);
        }
        return recv;
    }

    private boolean sendData(byte[] data) {
        byte[] send = null;
        int msgLen = 0;
        if (!this.connect()) {
            return false;
        }
        OutputStream os = null;
        try {
            os = m_socket.getOutputStream();
            int i2 = 0;
            while (i2 < data.length) {
                msgLen = MAX_PACKET_SIZE;
                if (i2 + MAX_PACKET_SIZE > data.length) {
                    msgLen = data.length - i2;
                }
                send = new byte[msgLen];
                System.arraycopy(data, i2, send, 0, msgLen);
                os.write(send);
                os.flush();
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                i2 += MAX_PACKET_SIZE;
            }
        }
        catch (IOException e2) {
            return false;
        }
        return true;
    }

    public byte[] recvData(int pacSize) {
        byte[] m_bTemp = new byte[4096];
        byte[] m_bData = null;
        int nRead = 0;
        int nOffset = 0;
        boolean isEnd = false;
        try {
            m_socket.setSoTimeout(2000);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        InputStream is = null;
        try {
            is = m_socket.getInputStream();
            block4: do {
                if ((nOffset += (nRead = is.read(m_bTemp, nOffset, m_bTemp.length - nOffset))) < pacSize) continue;
                int i2 = 8;
                while (i2 < m_bTemp.length) {
                    if (m_bTemp[i2 - 1] >= -32 && m_bTemp[i2 - 1] <= -17) {
                        isEnd = true;
                        continue block4;
                    }
                    i2 += pacSize;
                }
            } while (!isEnd);
            m_bData = new byte[nOffset];
            System.arraycopy(m_bTemp, 0, m_bData, 0, nOffset);
        }
        catch (IOException e2) {
            return null;
        }
        return m_bData;
    }

    public byte[] recvUpload(int pacSize) {
        byte[] m_bTemp = new byte[1024];
        byte[] m_bData = null;
        int nRead = 0;
        int nOffset = 0;
        try {
            m_socket.setSoTimeout(10000);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        InputStream is = null;
        try {
            is = m_socket.getInputStream();
            while ((nRead = is.read(m_bTemp, nOffset, m_bTemp.length - nOffset)) != -1) {
                if ((nOffset += nRead) >= pacSize) break;
            }
            m_bData = new byte[nOffset];
            System.arraycopy(m_bTemp, 0, m_bData, 0, nOffset);
        }
        catch (IOException e2) {
            return null;
        }
        return m_bData;
    }

    public byte[] makeMsgHeader(byte msgID, byte subID, byte mode, short seqno, byte len, byte resp) {
        byte[] header = new byte[8];
        header[0] = -6;
        header[1] = msgID;
        header[2] = subID;
        header[3] = mode;
        AppFunctions.short2byte(header, 4, seqno);
        header[6] = len;
        header[7] = resp;
        return header;
    }
}

