/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.io;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.pages.AppPageInfo;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Hashtable;

public class AppDatabase
extends AppComm {
    private static AppDatabase m_oThis = null;
    private Hashtable m_fileData = null;
    private byte[] m_respData = null;
    private byte[] m_header = new byte[18];
    private AppPageInfo m_pageInfo = null;

    private AppDatabase() {
    }

    public static AppDatabase getInstance() {
        if (m_oThis == null) {
            m_oThis = new AppDatabase();
        }
        return m_oThis;
    }

    @Override
    public boolean connect() {
        FileInputStream fis = new FileInputStream(AppRunInfo.getFilePath());
        ObjectInputStream ois = new ObjectInputStream(fis);
        try {
            this.m_fileData = (Hashtable)ois.readObject();
            this.m_pageInfo = AppComm.getInstance().m_pageInfo;
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            try {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void disconnect() {
        this.m_fileData = null;
    }

    @Override
    public boolean sendData(byte[] data) {
        String msgId = String.format("%04x", AppFunctions.byte2short(data, 4)).toUpperCase();
        if (this.m_fileData == null && !this.connect()) {
            return false;
        }
        if (data[2] == 1) {
            this.readLinkData(data);
        } else if (data[2] != 2) {
            if (data[2] >= -48 && data[2] <= -38) {
                this.readFileData(msgId);
            } else if (data[2] >= -16 && data[2] <= -12) {
                this.saveFileData(msgId, data);
            } else {
                return false;
            }
        }
        return true;
    }

    private void readLinkData(byte[] data) {
        byte[] linkData = (byte[])this.m_fileData.get("0000");
        byte[] recvData = new byte[data.length - 18];
        String filePass = AppFunctions.byte2str((byte[])this.m_fileData.get("0001"), 0, 8);
        System.arraycopy(data, 18, recvData, 0, recvData.length);
        this.makeResponseHeader(linkData.length, linkData.length, (byte)0);
        if (AppGlobal.g_bIsWithoutPWD || AppFunctions.byte2str(recvData, 2, 16).equals(filePass)) {
            this.m_respData = new byte[linkData.length + 18];
            System.arraycopy(this.m_header, 0, this.m_respData, 0, 18);
            System.arraycopy(linkData, 0, this.m_respData, 18, linkData.length);
        } else {
            this.m_header[14] = 8;
            this.m_respData = new byte[18];
            System.arraycopy(this.m_header, 0, this.m_respData, 0, 18);
        }
    }

    private void readFileData(String msgId) {
        byte[] fileData;
        if (this.m_fileData.containsKey(msgId) && (fileData = (byte[])this.m_fileData.get(msgId)) != null) {
            this.m_respData = new byte[fileData.length];
            System.arraycopy(fileData, 0, this.m_respData, 0, fileData.length);
            return;
        }
        this.makeResponseHeader(0, 0, (byte)0);
        this.m_respData = new byte[18];
        System.arraycopy(this.m_header, 0, this.m_respData, 0, 18);
    }

    private void saveFileData(String msgId, byte[] data) {
        byte[] fileData = null;
        byte[] recvData = null;
        byte[] saveData = null;
        byte[] headData = new byte[18];
        byte[] fieldData = null;
        int rcdSize = 0;
        recvData = new byte[data.length - 18];
        System.arraycopy(data, 18, recvData, 0, recvData.length);
        if (this.m_fileData.containsKey(msgId)) {
            fileData = (byte[])this.m_fileData.get(msgId);
            rcdSize = Integer.parseInt(AppFunctions.unsignedValue(AppFunctions.byte2short(fileData, 6)));
            fieldData = new byte[rcdSize];
            System.arraycopy(fileData, 0, headData, 0, 18);
            AppFunctions.int2byte(headData, 8, recvData.length + rcdSize);
            System.arraycopy(fileData, 18, fieldData, 0, rcdSize);
        } else {
            rcdSize = Integer.parseInt(AppFunctions.unsignedValue(AppFunctions.byte2short(data, 6)));
            fieldData = new byte[rcdSize];
            System.arraycopy(data, 0, headData, 0, 18);
            headData[0] = this.getDestTask();
            headData[1] = this.getSourceTask();
            headData[2] = -48;
            AppFunctions.int2byte(headData, 8, fieldData.length);
            this.m_header[14] = 0;
            Arrays.fill(fieldData, (byte)1);
        }
        saveData = new byte[fieldData.length + recvData.length + 18];
        System.arraycopy(headData, 0, saveData, 0, 18);
        System.arraycopy(fieldData, 0, saveData, 18, rcdSize);
        System.arraycopy(recvData, 0, saveData, rcdSize + 18, recvData.length);
        this.m_fileData.put(msgId, saveData);
        this.saveDataToFile();
    }

    @Override
    public byte[] recvData() {
        return this.m_respData;
    }

    private void saveDataToFile() {
        try {
            FileOutputStream m_fos = new FileOutputStream(AppRunInfo.getFilePath());
            ObjectOutputStream m_oos = new ObjectOutputStream(m_fos);
            m_oos.writeObject(this.m_fileData);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void makeResponseHeader(int rcdSize, int msgLen, byte resp) {
        Arrays.fill(this.m_header, (byte)-1);
        this.m_header[0] = 112;
        this.m_header[1] = 114;
        this.m_header[2] = AppComm.getInstance().m_msgType;
        AppFunctions.short2byte(this.m_header, 4, (short)Integer.parseInt(this.m_pageInfo.getMsgId(), 16));
        AppFunctions.short2byte(this.m_header, 6, (short)rcdSize);
        AppFunctions.int2byte(this.m_header, 8, msgLen);
        this.m_header[14] = resp;
    }

    public static /* bridge */ /* synthetic */ AppComm getInstance() {
        return AppDatabase.getInstance();
    }
}

