/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.utils.convert;

import com.sec.osdm.common.AppFunctions;
import java.util.Arrays;
import java.util.Hashtable;

public abstract class AppRefConvert {
    public static final int POS_RECORDSIZE = 6;
    public static final int POS_MSGLEN = 8;
    public static final int POS_MSGDATA = 18;
    public Hashtable m_readData = null;
    public byte[] m_dbData = null;
    public int m_rcdSize = 0;
    public int m_dataLen = 0;
    public int m_rcdCount = 0;

    public Hashtable getConvertData() {
        return this.m_readData;
    }

    public Hashtable divideReadData(byte[] readData) {
        Hashtable<String, byte[]> divide = new Hashtable<String, byte[]>();
        byte[] header = new byte[18];
        byte[] field = null;
        byte[] data = null;
        System.arraycopy(readData, 0, header, 0, 18);
        divide.put("HEADER", header);
        this.m_rcdSize = AppFunctions.byte2short(header, 6);
        field = new byte[this.m_rcdSize];
        System.arraycopy(readData, 18, field, 0, this.m_rcdSize);
        divide.put("FIELD", field);
        this.m_dataLen = AppFunctions.byte2int(header, 8) - this.m_rcdSize;
        data = new byte[this.m_dataLen];
        System.arraycopy(readData, this.m_rcdSize + 18, data, 0, this.m_dataLen);
        divide.put("DATA", data);
        this.m_rcdCount = this.m_dataLen / this.m_rcdSize;
        return divide;
    }

    public void mergeReadData(String msgId, Hashtable divide) {
        byte[] header = (byte[])divide.get("HEADER");
        byte[] field = (byte[])divide.get("FIELD");
        byte[] data = (byte[])divide.get("DATA");
        byte[] total = new byte[header.length + field.length + data.length];
        AppFunctions.short2byte(header, 6, (short)field.length);
        AppFunctions.int2byte(header, 8, field.length + data.length);
        System.arraycopy(header, 0, total, 0, header.length);
        System.arraycopy(field, 0, total, header.length, field.length);
        System.arraycopy(data, 0, total, header.length + field.length, data.length);
        this.m_readData.put(msgId, total);
    }

    public void convertData(String msgId, int addSize) {
        try {
            this.m_dbData = (byte[])this.m_readData.get(msgId);
            if (this.m_dbData != null) {
                Hashtable readData = this.divideReadData(this.m_dbData);
                byte[] field = (byte[])readData.get("FIELD");
                byte[] data = (byte[])readData.get("DATA");
                readData.put("FIELD", this.addFieldInfo(field, addSize));
                if (data != null && data.length > 0) {
                    byte[] newData = new byte[this.m_dataLen + this.m_rcdCount * addSize];
                    int newSize = this.m_rcdSize + addSize;
                    int i2 = 0;
                    int j2 = 0;
                    int k2 = 0;
                    while (i2 < this.m_rcdCount) {
                        System.arraycopy(data, k2, newData, j2, this.m_rcdSize);
                        Arrays.fill(newData, j2 + this.m_rcdSize, j2 + newSize - 1, (byte)0);
                        ++i2;
                        j2 += newSize;
                        k2 += this.m_rcdSize;
                    }
                    readData.put("DATA", newData);
                }
                this.mergeReadData(msgId, readData);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void convertData(String msgId, int addSize, int startPos) {
        try {
            this.m_dbData = (byte[])this.m_readData.get(msgId);
            if (this.m_dbData != null) {
                Hashtable readData = this.divideReadData(this.m_dbData);
                byte[] field = (byte[])readData.get("FIELD");
                byte[] data = (byte[])readData.get("DATA");
                readData.put("FIELD", this.addFieldInfo(field, addSize));
                if (data != null && data.length > 0) {
                    byte[] newData = new byte[this.m_dataLen + this.m_rcdCount * addSize];
                    int newSize = this.m_rcdSize + addSize;
                    int i2 = 0;
                    int j2 = 0;
                    int k2 = 0;
                    while (i2 < this.m_rcdCount) {
                        System.arraycopy(data, k2, newData, j2, this.m_rcdSize);
                        Arrays.fill(newData, j2 + this.m_rcdSize - startPos, j2 + newSize - 1, (byte)0);
                        ++i2;
                        j2 += newSize;
                        k2 += this.m_rcdSize;
                    }
                    readData.put("DATA", newData);
                }
                this.mergeReadData(msgId, readData);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public byte[] addFieldInfo(byte[] field, int size) {
        byte[] newField = new byte[field.length + size];
        System.arraycopy(field, 0, newField, 0, field.length);
        if (size > 0) {
            Arrays.fill(newField, field.length, newField.length - 1, (byte)1);
        }
        return newField;
    }

    public void changeFieldInfo(String msgId, int pos, int count) {
        try {
            this.m_dbData = (byte[])this.m_readData.get(msgId);
            if (this.m_dbData != null) {
                Hashtable readData = this.divideReadData(this.m_dbData);
                byte[] field = (byte[])readData.get("FIELD");
                int i2 = pos;
                while (i2 < pos + count) {
                    field[i2] = 1;
                    ++i2;
                }
                readData.put("FIELD", field);
                this.mergeReadData(msgId, readData);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public abstract void startConvert();
}

