/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.view;

import com.sec.osdm.common.AppFileBrowser;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppImages;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.io.AppDatabase;
import com.sec.osdm.io.AppModem;
import com.sec.osdm.io.AppNetwork;
import com.sec.osdm.io.AppSetup;
import com.sec.osdm.main.AppLogIn;
import com.sec.osdm.main.utils.AppAllDownLoad;
import com.sec.osdm.main.utils.AppCompare;
import com.sec.osdm.main.utils.AppExport;
import com.sec.osdm.main.utils.AppFileControl;
import com.sec.osdm.main.utils.AppImport;
import com.sec.osdm.main.utils.AppPassword;
import com.sec.osdm.main.utils.convert.AppDBConvert;
import com.sec.osdm.update_cf.PackageUpdateRunner_cf;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;

public class AppMenuActions {
    private static Action[] m_arrNormalModeActs = null;
    private static Action[] m_arrOnLineModeActs = null;
    private static Action[] m_arrOffLineModeActs = null;
    public static Action s_actSystem = new AbstractAction(AppLang.getText("System")){

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    };
    public static Action s_actConnect = new AbstractAction(AppLang.getText("Connect")){
        {
            this.putValue("ShortDescription", AppLang.getText("Connect to OfficeServ equipment"));
            this.putValue("SmallIcon", AppImages.Img_Connect);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AppMenuActions.connectSystem();
        }
    };
    public static Action s_actDisconnect = new AbstractAction(AppLang.getText("Disconnect")){
        {
            this.putValue("ShortDescription", AppLang.getText("Disconnect current connection to OfficeServ equipment"));
            this.putValue("SmallIcon", AppImages.Img_Disconnect);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AppMenuActions.disconnectSystem(true);
        }
    };
    public static Action s_actDownload = new AbstractAction(AppLang.getText("Download DB")){
        {
            this.putValue("ShortDescription", AppLang.getText("Backup OfficeServ configs to local database"));
            this.putValue("SmallIcon", AppImages.Img_Download);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new AppAllDownLoad();
        }
    };
    public static Action s_actUpload = new AbstractAction(AppLang.getText("Upload DB")){
        {
            this.putValue("ShortDescription", AppLang.getText("Restore OfficeServ configs from local database"));
            this.putValue("SmallIcon", AppImages.Img_Upload);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AppFileBrowser browser = new AppFileBrowser();
            browser.setFileFilter(String.valueOf(AppLang.getText("Database File")) + "(*.odm)", "odm");
            if (browser.openBrowser() && browser.checkDatabaseFile()) {
                new AppPassword(browser.getDatabaseFile());
            }
        }
    };
    public static Action s_actCommSetup = new AbstractAction(AppLang.getText("Link Setup")){
        {
            this.putValue("ShortDescription", AppLang.getText("Setup communication settings"));
            this.putValue("SmallIcon", AppImages.Img_CommSetup);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new AppSetup();
        }
    };
    public static Action s_actFile = new AbstractAction(AppLang.getText("File")){

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    };
    public static Action s_actOpenDB = new AbstractAction(AppLang.getText("Open DB")){
        {
            this.putValue("ShortDescription", AppLang.getText("Open local database"));
            this.putValue("SmallIcon", AppImages.Img_Open);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AppFileBrowser browser = new AppFileBrowser();
            browser.setFileFilter(String.valueOf(AppLang.getText("Database File")) + "(*.odm)", "odm");
            if (browser.openBrowser() && browser.checkDatabaseFile()) {
                AppComm.getInstance().setComm(AppDatabase.getInstance());
                new AppLogIn(1);
            }
        }
    };
    public static Action s_actCloseDB = new AbstractAction(AppLang.getText("Close DB")){
        {
            this.putValue("ShortDescription", AppLang.getText("Close local database"));
            this.putValue("SmallIcon", AppImages.Img_CloseDB);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AppGlobal.g_frmMain.m_pagePane.closeAllPages();
            AppGlobal.g_frmMain.setAppRunMode(0);
            AppComm.getInstance().requestDisconnect();
        }
    };
    public static Action s_actExit = new AbstractAction(AppLang.getText("Exit")){
        {
            this.putValue("ShortDescription", AppLang.getText("Terminate program"));
            this.putValue("SmallIcon", AppImages.Img_Exit);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AppGlobal.g_frmMain.exitProgram();
        }
    };
    public static Action s_actOptions = new AbstractAction(AppLang.getText("Options")){

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    };
    public static Action s_actLanguage = new AbstractAction(AppLang.getText("Language")){

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    };
    public static Action s_actEnglish = new AbstractAction(AppLang.getText("English")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            AppLang.changeLanguage(0);
        }
    };
    public static Action s_actKorean = new AbstractAction(AppLang.getText("Korean")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            AppLang.changeLanguage(1);
        }
    };
    public static Action s_actRussian = new AbstractAction(AppLang.getText("Russian")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            AppLang.changeLanguage(2);
        }
    };
    public static Action s_actGermany = new AbstractAction(AppLang.getText("Germany")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            AppLang.changeLanguage(3);
        }
    };
    public static Action s_actItalian = new AbstractAction(AppLang.getText("Italian")){

        @Override
        public void actionPerformed(ActionEvent evt) {
            AppLang.changeLanguage(4);
        }
    };
    public static Action s_actPartial = new AbstractAction(AppLang.getText("Partial Request")){
        {
            this.putValue("ShortDescription", AppLang.getText("Partial Request"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AppProperty.m_properties.put("PART_REQUEST", AppGlobal.g_frmMain.m_menuBar.m_request.isSelected());
            AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
        }
    };
    public static Action s_actToolbar = new AbstractAction(AppLang.getText("Use Toolbar")){
        {
            this.putValue("ShortDescription", AppLang.getText("Use Toolbar"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            AppProperty.m_properties.put("USE_TOOLBAR", AppGlobal.g_frmMain.m_menuBar.m_toolbar.isSelected());
            AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
            AppGlobal.g_frmMain.m_toolBar.setVisible(AppGlobal.g_frmMain.m_menuBar.m_toolbar.isSelected());
        }
    };
    public static Action s_actUtil = new AbstractAction(AppLang.getText("Util")){

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    };
    public static Action s_actFileControl = new AbstractAction(AppLang.getText("File Control")){
        {
            this.putValue("ShortDescription", AppLang.getText("Control files on OfficeServ equipment"));
            this.putValue("SmallIcon", AppImages.Img_FileControl);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String siteDest;
            Hashtable linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
            String siteName = (String)linkInfo.get("SITE_NAME");
            String string = siteDest = ((String)linkInfo.get("LINK_KIND")).equals("LAN") ? (String)linkInfo.get("IP_ADDRESS") : (String)linkInfo.get("TEL_NUMBER");
            if (siteName != null && !siteName.equals("") && siteDest != null && !siteDest.equals("")) {
                new AppFileControl();
            }
        }
    };
    public static Action s_actImport = new AbstractAction(AppLang.getText("DB Import")){
        {
            this.putValue("ShortDescription", AppLang.getText("Import page data from Excel sheet"));
            this.putValue("SmallIcon", AppImages.Img_Import);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new AppImport();
        }
    };
    public static Action s_actExport = new AbstractAction(AppLang.getText("DB Export")){
        {
            this.putValue("ShortDescription", AppLang.getText("Export page data to Excel sheet"));
            this.putValue("SmallIcon", AppImages.Img_Export);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new AppExport();
        }
    };
    public static Action s_actDbCompare = new AbstractAction(AppLang.getText("DB Comparison")){
        {
            this.putValue("ShortDescription", AppLang.getText("Compare local databases"));
            this.putValue("SmallIcon", AppImages.Img_Compare);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new AppCompare();
        }
    };
    public static Action s_actDbConvert = new AbstractAction(AppLang.getText("DB Conversion")){
        {
            this.putValue("ShortDescription", AppLang.getText("Conversion from Installation DB to OSDM DB"));
            this.putValue("SmallIcon", AppImages.Img_Convert);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new AppDBConvert();
        }
    };
    public static Action s_actTab = new AbstractAction(AppLang.getText("Tab")){

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    };
    public static Action s_actTabClose = new AbstractAction(AppLang.getText("Close All")){
        {
            this.putValue("ShortDescription", AppLang.getText("Close all tab panes"));
            this.putValue("SmallIcon", AppImages.Img_CloseAll);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (AppGlobal.g_frmMain != null) {
                AppGlobal.g_frmMain.m_pagePane.closeAllPages();
            }
        }
    };
    public static Action s_actHelp = new AbstractAction(AppLang.getText("Help")){

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    };
    public static Action s_actHelpTopics = new AbstractAction(AppLang.getText("Help Topics")){
        {
            this.putValue("ShortDescription", AppLang.getText("Show help topics"));
            this.putValue("SmallIcon", AppImages.Img_Help);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            String path = "java -Dfile.encoding=utf8 -jar \"" + AppProperty.m_runDirectory + "osdmhelp.jar\" " + AppProperty.m_properties.get("USER_LANG") + " P2100";
            try {
                if (AppGlobal.g_helpProcess != null) {
                    AppGlobal.g_helpProcess.destroy();
                }
                AppGlobal.g_helpProcess = Runtime.getRuntime().exec(path);
            }
            catch (IOException e2) {
                AppGlobal.showErrorMessage("", AppLang.getText("Failed to open help file."));
            }
        }
    };
    public static Action s_actAbout = new AbstractAction(AppLang.getText("About program")){
        {
            this.putValue("ShortDescription", AppLang.getText("Show program information"));
            this.putValue("SmallIcon", AppImages.Img_About);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            JOptionPane.showMessageDialog(AppGlobal.g_frmMain, "OfficeServ Device Manager \nV1.02c 2011.03.18 \nSamsung Electronics, Co., Ltd.\nCopyright(C) 2009 SEC, All rights reserved.", "About", 1);
        }
    };
    public static Action s_actBookmark = new AbstractAction(AppLang.getText("Bookmark")){
        {
            this.putValue("ShortDescription", AppLang.getText("Bookmark"));
            this.putValue("SmallIcon", AppImages.Img_Bookmark);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    };
    public static Action s_actHistory = new AbstractAction(AppLang.getText("History")){
        {
            this.putValue("ShortDescription", AppLang.getText("History"));
            this.putValue("SmallIcon", AppImages.Img_History);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    };
    public static Action s_actOSDATA = new AbstractAction("DATA"){
        {
            this.putValue("ShortDescription", AppLang.getText("DATA"));
            this.putValue("SmallIcon", AppImages.Img_Data);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            block8: {
                Hashtable linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
                String address = ((String)linkInfo.get("IP_ADDRESS")).trim();
                if (address != null && !address.equals("")) {
                    if (AppGlobal.g_dataProcess != null) {
                        AppGlobal.g_dataProcess.destroy();
                    }
                    try {
                        String osName = System.getProperty("os.name").toLowerCase();
                        String url = "https://" + address + "/login/login.php";
                        if (osName.indexOf("win") >= 0) {
                            AppGlobal.g_dataProcess = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
                            break block8;
                        }
                        if (osName.indexOf("mac") >= 0) {
                            AppGlobal.g_dataProcess = Runtime.getRuntime().exec("open " + url);
                            break block8;
                        }
                        if (osName.indexOf("nix") >= 0 || osName.indexOf("nux") >= 0) {
                            String[] browsers = new String[]{"epiphany", "firefox", "mozilla", "konqueror", "netscape", "opera", "links", "lynx"};
                            StringBuffer cmd = new StringBuffer();
                            int i2 = 0;
                            while (i2 < browsers.length) {
                                cmd.append(String.valueOf(i2 == 0 ? "" : " || ") + browsers[i2] + " \"" + url + "\" ");
                                ++i2;
                            }
                            AppGlobal.g_dataProcess = Runtime.getRuntime().exec(new String[]{"sh", "-c", cmd.toString()});
                            break block8;
                        }
                        return;
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
    };
    public static Action s_actIVM = new AbstractAction(AppLang.getText("Menu")){

        @Override
        public void actionPerformed(ActionEvent evt) {
        }
    };
    public static Action s_actUpdate = new AbstractAction(AppLang.getText("Package Update")){
        {
            this.putValue("ShortDescription", AppLang.getText("Package Update"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            new PackageUpdateRunner_cf(AppLang.getText("Conference 24 Card Package Update"));
        }
    };

    public static void enableNormalModeActs(boolean bEnable) {
        if (m_arrNormalModeActs == null) {
            m_arrNormalModeActs = new Action[]{s_actConnect, s_actCommSetup, s_actOpenDB, s_actDbCompare, s_actFileControl, s_actDbConvert};
        }
        int i2 = 0;
        while (i2 < m_arrNormalModeActs.length) {
            m_arrNormalModeActs[i2].setEnabled(bEnable);
            ++i2;
        }
        AppGlobal.g_frmMain.m_toolBar.m_btnLink.setEnabled(true);
        AppGlobal.g_frmMain.m_toolBar.m_btnFile.setEnabled(true);
        AppGlobal.g_frmMain.m_toolBar.m_btnBook.setEnabled(false);
        AppGlobal.g_frmMain.m_toolBar.m_btnHistory.setEnabled(false);
    }

    public static void enableOnLineModeActs(boolean bEnable) {
        if (m_arrOnLineModeActs == null) {
            m_arrOnLineModeActs = new Action[]{s_actDisconnect, s_actDownload, s_actUpload, s_actPartial, s_actFileControl, s_actOSDATA, s_actUpdate};
        }
        int i2 = 0;
        while (i2 < m_arrOnLineModeActs.length) {
            m_arrOnLineModeActs[i2].setEnabled(bEnable);
            ++i2;
        }
        AppGlobal.g_frmMain.m_toolBar.m_btnLink.setEnabled(false);
        AppGlobal.g_frmMain.m_toolBar.m_btnFile.setEnabled(true);
        AppGlobal.g_frmMain.m_toolBar.m_btnBook.setEnabled(true);
        AppGlobal.g_frmMain.m_toolBar.m_btnHistory.setEnabled(true);
    }

    public static void enableOffLineModeActs(boolean bEnable) {
        if (m_arrOffLineModeActs == null) {
            m_arrOffLineModeActs = new Action[]{s_actCloseDB, s_actImport, s_actExport};
        }
        int i2 = 0;
        while (i2 < m_arrOffLineModeActs.length) {
            m_arrOffLineModeActs[i2].setEnabled(bEnable);
            ++i2;
        }
        AppGlobal.g_frmMain.m_toolBar.m_btnLink.setEnabled(false);
        AppGlobal.g_frmMain.m_toolBar.m_btnFile.setEnabled(false);
        AppGlobal.g_frmMain.m_toolBar.m_btnBook.setEnabled(true);
        AppGlobal.g_frmMain.m_toolBar.m_btnHistory.setEnabled(true);
    }

    private static void connectSystem() {
        String siteDest;
        Hashtable linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
        String siteName = (String)linkInfo.get("SITE_NAME");
        String string = siteDest = ((String)linkInfo.get("LINK_KIND")).equals("LAN") ? (String)linkInfo.get("IP_ADDRESS") : (String)linkInfo.get("TEL_NUMBER");
        if (siteName == null || siteName.equals("") || siteDest == null || siteDest.equals("")) {
            return;
        }
        if (((String)linkInfo.get("LINK_KIND")).equals("LAN")) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    AppComm.getInstance().setComm(AppNetwork.getInstance());
                    new AppLogIn(2);
                }
            }).start();
        } else {
            AppComm.getInstance().setComm(AppModem.getInstance());
            new Thread(new Runnable(){

                @Override
                public void run() {
                    AppGlobal.showProgress(String.valueOf(AppLang.getText("Modem dialing")) + "(" + siteDest + ")", String.valueOf(AppLang.getText("Trying to connect to target")) + " ...");
                    if (!AppComm.getInstance().connect()) {
                        AppGlobal.hideProgress();
                        return;
                    }
                    AppGlobal.hideProgress();
                    new AppLogIn(2);
                }
            }).start();
        }
    }

    public static void disconnectSystem() {
        AppMenuActions.disconnectSystem(false);
    }

    public static void disconnectSystem(boolean request) {
        if (request) {
            AppComm.getInstance().requestDisconnect();
        }
        AppNetwork.getInstance().disconnect();
        AppGlobal.g_frmMain.m_pagePane.closeAllPages();
        AppGlobal.g_frmMain.setAppRunMode(0);
    }
}

