/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.view;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.io.AppLockOut;
import com.sec.osdm.main.utils.AppPartRequest;
import com.sec.osdm.main.view.AppTreeNode;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.vmaa.openblock.AppBlockListDetailDlg;
import com.sec.osdm.pages.vmaa.openblock.P1000OpenBlockList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.lang.reflect.Constructor;
import javax.swing.JDialog;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.tree.DefaultMutableTreeNode;

public class AppPagePane
extends JTabbedPane
implements ChangeListener {
    public AppPagePane() {
        this.addChangeListener(this);
        this.setUI(new BasicTabbedPaneUI(){

            @Override
            protected void paintTabBorder(Graphics g2, int tabPlacement, int tabIndex, int x2, int y2, int w2, int h2, boolean isSelected) {
                g2.setColor(Color.white);
                g2.drawRoundRect(x2, y2, w2, h2, 10, 10);
                if (isSelected) {
                    g2.setColor(Color.magenta);
                    g2.drawLine(x2 + 4, y2 + 20, x2 + w2 - 4, y2 + 20);
                }
            }
        });
    }

    public void openNewPage(DefaultMutableTreeNode tn) {
        AppTreeNode tnInfo = (AppTreeNode)tn.getUserObject();
        String msgId = tnInfo.getMsgId();
        String tabTitle = AppLang.getText(tnInfo.getTabTitle());
        String className = tnInfo.getClassName();
        int i2 = 0;
        while (i2 < this.getTabCount()) {
            if (this.getTitleAt(i2).equals(tabTitle)) {
                this.remove(i2);
                AppGlobal.g_frmMain.m_menuBar.removeTabMenu(tabTitle);
                break;
            }
            ++i2;
        }
        if (this.getTabCount() >= 10) {
            AppGlobal.showInfoMessage("", AppLang.getText("Too many opened windows"));
            return;
        }
        if (AppRunInfo.getRunMode() == 2 && ((Boolean)AppProperty.m_properties.get("PART_REQUEST")).booleanValue() && tnInfo.getPartialRequest()) {
            new AppPartRequest(msgId);
            return;
        }
        try {
            Class<?> klass = Class.forName(className);
            Class[] param = new Class[]{AppPageInfo.class};
            Constructor<?> cons = klass.getConstructor(param);
            Object[] args = new Object[]{new AppPageInfo(msgId)};
            AppPage objPage = (AppPage)cons.newInstance(args);
            this.add((Component)objPage, this.getTabCount());
            this.setTitleAt(this.getTabCount() - 1, tabTitle);
            this.setSelectedIndex(this.getTabCount() - 1);
            AppGlobal.g_frmMain.m_menuBar.addNewTabMenu(tabTitle);
            AppGlobal.g_frmMain.m_toolBar.addHistoryPopupItem(tnInfo);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void removePageTab(String title) {
        try {
            if (this.getTabCount() > 0) {
                this.removeTabAt(this.indexOfTab(title));
                AppGlobal.g_frmMain.m_menuBar.removeTabMenu(title);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void closeAllPages() {
        try {
            AppGlobal.hideProgress();
            int i2 = 0;
            while (i2 < AppGlobal.g_dialogList.size()) {
                JDialog dialog = (JDialog)AppGlobal.g_dialogList.get(i2);
                dialog.dispose();
                ++i2;
            }
            i2 = 0;
            while (i2 < P1000OpenBlockList.g_blkDlgList.size()) {
                ((AppBlockListDetailDlg)P1000OpenBlockList.g_blkDlgList.get(i2)).destroyWnds();
                ++i2;
            }
            AppGlobal.g_dialogList.clear();
            P1000OpenBlockList.g_blkDlgList.clear();
            P1000OpenBlockList.m_isReload = false;
            AppLockOut.m_disconn = true;
            i2 = this.getTabCount() - 1;
            while (i2 >= 0) {
                AppPage page = (AppPage)this.getComponent(i2);
                page.actionToolButton("Close");
                --i2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void stateChanged(ChangeEvent e2) {
        JTabbedPane tabSource = (JTabbedPane)e2.getSource();
        if (tabSource.getSelectedIndex() >= 0) {
            AppPage page = (AppPage)this.getComponent(tabSource.getSelectedIndex());
            AppTreeNode tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get(page.m_pageInfo.getMsgId());
            AppGlobal.g_frmMain.m_menuBar.changeTabMenu(tnInfo.getTabTitle());
            page.setToolBarStatus();
        }
    }
}

