/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.view;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.main.view.AppBookMark;
import com.sec.osdm.main.view.AppMenuActions;
import com.sec.osdm.main.view.AppTreeNode;
import com.sec.osdm.main.view.MenuButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class AppToolBar
extends JPanel {
    private JToolBar m_toolBar = new JToolBar();
    private JPopupMenu m_popLink = new JPopupMenu();
    private JPopupMenu m_popFile = new JPopupMenu();
    private JPopupMenu m_popBook = new JPopupMenu();
    private JPopupMenu m_popHistory = new JPopupMenu();
    public MenuButton m_btnLink = new MenuButton("connect", this.m_popLink);
    public MenuButton m_btnFile = new MenuButton("filecontrol", this.m_popFile);
    public MenuButton m_btnBook = new MenuButton("bookmark", this.m_popBook);
    public MenuButton m_btnHistory = new MenuButton("history", this.m_popHistory);

    public AppToolBar() {
        super(new BorderLayout());
        this.createLinkPopup();
        this.createBookPopup();
        this.createHistoryPopup();
        this.createToolBar();
        this.add((Component)this.m_toolBar, "First");
    }

    private void createToolBar() {
        this.m_toolBar.setFloatable(false);
        this.m_toolBar.add(this.m_btnLink);
        this.m_toolBar.add(AppMenuActions.s_actDisconnect);
        this.m_toolBar.addSeparator();
        this.m_toolBar.add(AppMenuActions.s_actCommSetup);
        this.m_toolBar.addSeparator();
        this.m_toolBar.add(AppMenuActions.s_actDownload);
        this.m_toolBar.add(AppMenuActions.s_actUpload);
        this.m_toolBar.addSeparator();
        this.m_toolBar.add(AppMenuActions.s_actOpenDB);
        this.m_toolBar.add(AppMenuActions.s_actCloseDB);
        this.m_toolBar.addSeparator();
        this.m_toolBar.add(this.m_btnFile);
        this.m_toolBar.addSeparator();
        this.m_toolBar.add(this.m_btnBook);
        this.m_toolBar.add(this.m_btnHistory);
        this.m_toolBar.addSeparator();
        this.m_toolBar.add(AppMenuActions.s_actExit);
        this.m_toolBar.addSeparator();
        this.m_toolBar.add(AppMenuActions.s_actHelpTopics);
        this.m_toolBar.addSeparator();
    }

    private void createLinkPopup() {
        Hashtable siteList = new Hashtable();
        ArrayList siteInfo = new ArrayList();
        String siteName2 = "";
        int i2 = 0;
        while (i2 < AppProperty.m_sitelist.size()) {
            siteList = (Hashtable)AppProperty.m_sitelist.get(i2);
            Vector vtTemp = new Vector(siteList.keySet());
            Collections.sort(vtTemp);
            for (String siteName2 : vtTemp) {
                siteInfo = (ArrayList)siteList.get(siteName2);
                this.m_popLink.add(this.addLink("connect", i2 == 0 ? "LAN" : "MODEM", siteName2, siteInfo));
                this.m_popFile.add(this.addLink("file", i2 == 0 ? "LAN" : "MODEM", siteName2, siteInfo));
            }
            ++i2;
        }
    }

    public void addLinkPopupItem(String site, String info, boolean link) {
        ArrayList<String> attr = new ArrayList<String>();
        String[] siteInfo = info.split(";");
        this.removeLinkPopupItem(site);
        attr.add(0, siteInfo[0]);
        attr.add(1, siteInfo[1]);
        attr.add(2, siteInfo[2]);
        this.m_popLink.insert(this.addLink("connect", link ? "LAN" : "MODEM", site, attr), 0);
        this.m_popFile.insert(this.addLink("file", link ? "LAN" : "MODEM", site, attr), 0);
    }

    public void removeLinkPopupItem(String site) {
        int i2 = 0;
        while (i2 < this.m_popLink.getComponentCount()) {
            if (((JMenuItem)this.m_popLink.getComponent(i2)).getActionCommand().equals(site)) {
                this.m_popLink.remove(i2);
                this.m_popFile.remove(i2);
            }
            ++i2;
        }
    }

    private void createBookPopup() {
        ArrayList bookInfo = new ArrayList();
        this.m_popBook.add(this.addPage(AppLang.getText("Edit Bookmarks"), "0"));
        this.m_popBook.addSeparator();
        int i2 = 0;
        while (i2 < AppProperty.m_bookmark.size()) {
            bookInfo = (ArrayList)AppProperty.m_bookmark.get(i2);
            this.m_popBook.add(this.addPage((String)bookInfo.get(0), (String)bookInfo.get(1)));
            ++i2;
        }
    }

    public void addBookPopupItem(AppTreeNode tnInfo) {
        ArrayList bookInfo = new ArrayList();
        String msgId = tnInfo.getMsgId();
        int i2 = 0;
        while (i2 < AppProperty.m_bookmark.size()) {
            bookInfo = (ArrayList)AppProperty.m_bookmark.get(i2);
            if (((String)bookInfo.get(1)).equals(msgId)) {
                AppProperty.m_bookmark.remove(i2);
                break;
            }
            ++i2;
        }
        bookInfo = new ArrayList();
        bookInfo.add(0, tnInfo.getTabTitle());
        bookInfo.add(1, msgId);
        AppProperty.m_bookmark.add(0, bookInfo);
        AppProperty.saveDataToFile(AppProperty.m_fileBook, AppProperty.m_bookmark);
        i2 = 2;
        while (i2 < this.m_popBook.getComponentCount()) {
            if (((JMenuItem)this.m_popBook.getComponent(i2)).getActionCommand().equals(msgId)) {
                this.m_popBook.remove(i2);
            }
            ++i2;
        }
        this.m_popBook.insert(this.addPage(tnInfo.getTabTitle(), msgId), 2);
    }

    public void removeBookPopupItem(int index) {
        ArrayList bookInfo = new ArrayList();
        JMenuItem mi = (JMenuItem)this.m_popBook.getComponent(index);
        this.m_popBook.remove(index);
        int i2 = 0;
        while (i2 < AppProperty.m_bookmark.size()) {
            bookInfo = (ArrayList)AppProperty.m_bookmark.get(i2);
            if (((String)bookInfo.get(1)).equals(mi.getActionCommand())) {
                AppProperty.m_bookmark.remove(i2);
                break;
            }
            ++i2;
        }
        AppProperty.saveDataToFile(AppProperty.m_fileBook, AppProperty.m_bookmark);
    }

    public void removeAllBookPopupItems() {
        int i2 = this.m_popBook.getComponentCount() - 1;
        while (i2 > 1) {
            this.removeBookPopupItem(i2);
            --i2;
        }
    }

    private void createHistoryPopup() {
        ArrayList hstInfo = new ArrayList();
        this.m_popHistory.add(this.addPage(AppLang.getText("Delete Histories"), "1"));
        this.m_popHistory.addSeparator();
        int i2 = 0;
        while (i2 < AppProperty.m_history.size()) {
            hstInfo = (ArrayList)AppProperty.m_history.get(i2);
            this.m_popHistory.add(this.addPage((String)hstInfo.get(0), (String)hstInfo.get(1)));
            ++i2;
        }
    }

    public void addHistoryPopupItem(AppTreeNode tnInfo) {
        ArrayList hstInfo = new ArrayList();
        String msgId = tnInfo.getMsgId();
        int i2 = 0;
        while (i2 < AppProperty.m_history.size()) {
            hstInfo = (ArrayList)AppProperty.m_history.get(i2);
            if (((String)hstInfo.get(1)).equals(msgId)) {
                AppProperty.m_history.remove(i2);
                break;
            }
            ++i2;
        }
        hstInfo = new ArrayList();
        hstInfo.add(0, tnInfo.getTabTitle());
        hstInfo.add(1, msgId);
        AppProperty.m_history.add(0, hstInfo);
        AppProperty.saveDataToFile(AppProperty.m_fileHistory, AppProperty.m_history);
        i2 = 2;
        while (i2 < this.m_popHistory.getComponentCount()) {
            if (((JMenuItem)this.m_popHistory.getComponent(i2)).getActionCommand().equals(msgId)) {
                this.m_popHistory.remove(i2);
            }
            ++i2;
        }
        this.m_popHistory.insert(this.addPage(tnInfo.getTabTitle(), msgId), 2);
    }

    public void removeAllHistoryPopupItems() {
        int i2 = this.m_popHistory.getComponentCount() - 1;
        while (i2 > 1) {
            this.m_popHistory.remove(i2);
            --i2;
        }
        AppProperty.m_history.clear();
        AppProperty.saveDataToFile(AppProperty.m_fileHistory, AppProperty.m_history);
    }

    private JMenuItem addLink(final String kind, final String link, String site, ArrayList info) {
        JMenuItem mi = null;
        String mnuName = "";
        if (link.equals("LAN")) {
            mnuName = String.valueOf(String.format("%-30s", site)) + "[LAN] " + (String)info.get(0);
        } else {
            mnuName = String.valueOf(String.format("%-30s", site)) + "[MODEM] " + (String)info.get(0) + ":";
            mnuName = String.valueOf(mnuName) + "COM" + (String)info.get(1) + ":" + (String)info.get(2) + "bps";
        }
        mi = new JMenuItem(mnuName);
        mi.setActionCommand(site);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                String siteName = e2.getActionCommand();
                Hashtable siteList = link.equals("LAN") ? (Hashtable)AppProperty.m_sitelist.get(0) : (Hashtable)AppProperty.m_sitelist.get(1);
                ArrayList siteInfo = (ArrayList)siteList.get(siteName);
                Hashtable linkInfo = (Hashtable)AppProperty.m_properties.get("LINK_INFO");
                linkInfo.put("LINK_KIND", link);
                linkInfo.put("SITE_NAME", siteName);
                linkInfo.put("IP_ADDRESS", (String)siteInfo.get(0));
                linkInfo.put("DATA_PORT", (String)siteInfo.get(1));
                linkInfo.put("FILE_PORT", (String)siteInfo.get(2));
                if (siteInfo.size() <= 3) {
                    linkInfo.put("FTP_PORT", "21");
                } else {
                    linkInfo.put("FTP_PORT", (String)siteInfo.get(3));
                }
                if (siteInfo.size() <= 4) {
                    linkInfo.put("VM_PORT", "6001");
                } else {
                    linkInfo.put("VM_PORT", (String)siteInfo.get(4));
                }
                linkInfo.put("TEL_NUMBER", (String)siteInfo.get(0));
                linkInfo.put("COM_PORT", (String)siteInfo.get(1));
                linkInfo.put("BAUD_RATE", (String)siteInfo.get(2));
                AppProperty.m_properties.put("LINK_INFO", linkInfo);
                AppProperty.saveDataToFile(AppProperty.m_fileProperty, AppProperty.m_properties);
                if (kind.equals("file")) {
                    AppMenuActions.s_actFileControl.actionPerformed(null);
                } else {
                    AppMenuActions.s_actConnect.actionPerformed(null);
                }
            }
        });
        return mi;
    }

    private JMenuItem addPage(String item, final String msgId) {
        JMenuItem mi = new JMenuItem(item);
        mi.setActionCommand(msgId);
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (msgId.equals("0")) {
                    new AppBookMark();
                } else if (msgId.equals("1")) {
                    if (AppGlobal.showConfirmMessage(AppLang.getText("Delete"), AppLang.getText("Do you really want to delete all history?")) == 0) {
                        AppToolBar.this.removeAllHistoryPopupItems();
                    }
                } else {
                    AppTreeNode tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get(msgId);
                    AppGlobal.g_frmMain.m_pagePane.openNewPage(tnInfo.getTreeNode());
                }
            }
        });
        return mi;
    }
}

