/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.main.view;

import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.pages.AppTopPanel;
import com.sec.osdm.pages.utils.AppCountry;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;

public class AppTreeNode {
    private Hashtable m_treeInfo = new Hashtable();
    private AppTopPanel m_topPanel = null;
    private DefaultMutableTreeNode m_dmtn = null;
    private String[] m_partial = null;

    public AppTreeNode(Hashtable treeInfo) {
        this.m_treeInfo = treeInfo;
    }

    public DefaultMutableTreeNode getTreeNode() {
        return this.m_dmtn;
    }

    public void setTreeNode(DefaultMutableTreeNode tn) {
        this.m_dmtn = tn;
    }

    public String getMsgId() {
        return ((String)this.m_treeInfo.get("MENU_MSGID")).trim().toUpperCase();
    }

    public void setMsgId(String msgid) {
        this.m_treeInfo.put("MENU_MSGID", msgid.trim().toUpperCase());
    }

    public String getIndex() {
        return ((String)this.m_treeInfo.get("MENU_INDEX")).trim();
    }

    public String getTitle() {
        return ((String)this.m_treeInfo.get("MENU_TITLE")).trim();
    }

    public String getTabTitle() {
        return String.valueOf(((String)this.m_treeInfo.get("MENU_INDEX")).trim()) + ((String)this.m_treeInfo.get("MENU_TITLE")).trim();
    }

    public String getClassName() {
        return "com.sec.osdm.pages." + ((String)this.m_treeInfo.get("MENU_CLASS")).trim();
    }

    public String getBlockDetailName() {
        String[] blockInfo = ((String)this.m_treeInfo.get("MENU_BLKINFO")).split(";");
        return "com.sec.osdm.pages.vmaa.openblock." + blockInfo[0].trim();
    }

    public int getMenuKind() {
        if (((String)this.m_treeInfo.get("MENU_KIND")).trim().equals("VMAA")) {
            return 1;
        }
        if (((String)this.m_treeInfo.get("MENU_KIND")).trim().equals("CONF")) {
            return 2;
        }
        return 0;
    }

    public String[] getToolbar() {
        return ((String)this.m_treeInfo.get("MENU_TOOL")).split(";");
    }

    public String getMmcList() {
        String[] mmcList = ((String)this.m_treeInfo.get("MENU_MMCLIST")).split("-");
        if (mmcList.length >= 2) {
            if (AppCountry.checkCountryGroup(2, AppRunInfo.getCountry())) {
                return mmcList[1].trim();
            }
            if (AppCountry.checkCountryGroup(1, AppRunInfo.getCountry())) {
                return mmcList[2].trim();
            }
            return mmcList[0].trim();
        }
        return "";
    }

    public ImageIcon getTreeIcon() {
        return new ImageIcon(AppTreeNode.class.getResource(((String)this.m_treeInfo.get("MENU_IMAGE")).trim()));
    }

    public boolean getPartialRequest() {
        if (this.m_treeInfo.containsKey("MENU_PARTIAL")) {
            this.m_partial = ((String)this.m_treeInfo.get("MENU_PARTIAL")).split(";");
            if (this.m_partial[0].equals("1")) {
                return true;
            }
        }
        return false;
    }

    public byte getMessageType(int type) {
        if (this.m_treeInfo.containsKey("MENU_PARTIAL")) {
            this.m_partial = ((String)this.m_treeInfo.get("MENU_PARTIAL")).split(";");
            return (byte)Integer.parseInt(this.m_partial[type + 1], 16);
        }
        return -48;
    }

    public boolean getAllDownload() {
        String down;
        return this.m_treeInfo.containsKey("MENU_UPDOWN") && ((down = (String)this.m_treeInfo.get("MENU_UPDOWN")).equals("ALL") || down.equals("DOWN"));
    }

    public boolean getAllUpload() {
        String down;
        return this.m_treeInfo.containsKey("MENU_UPDOWN") && ((down = (String)this.m_treeInfo.get("MENU_UPDOWN")).equals("ALL") || down.equals("UP"));
    }

    public AppTopPanel getTopPanel() {
        return this.m_topPanel;
    }

    public void setTopPanel(AppTopPanel top) {
        this.m_topPanel = top;
    }

    public String getToolTipText() {
        String mmcList = this.getMmcList();
        if (mmcList != null && !mmcList.equals("")) {
            return "MMC: " + mmcList;
        }
        return "";
    }

    public String toString() {
        return AppLang.getText(this.getTabTitle());
    }
}

