/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.common.AppLayout;
import com.sec.osdm.common.AppProperty;
import com.sec.osdm.common.AppRunInfo;
import com.sec.osdm.io.AppComm;
import com.sec.osdm.main.utils.AppErrorInfo;
import com.sec.osdm.main.view.AppMenuActions;
import com.sec.osdm.main.view.AppTreeNode;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.AppPageToolBar;
import com.sec.osdm.pages.AppTopPanel;
import com.sec.osdm.pages.utils.AppNumPlan;
import com.sec.osdm.pages.utils.components.AppComboBox;
import com.sec.osdm.pages.utils.components.AppNewCombo;
import com.sec.osdm.pages.utils.components.AppNewText;
import com.sec.osdm.pages.utils.components.AppPasswordTextBox;
import com.sec.osdm.pages.utils.components.AppSelect;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppHandlerCopy;
import com.sec.osdm.pages.utils.table.AppHandlerCut;
import com.sec.osdm.pages.utils.table.AppHandlerFind;
import com.sec.osdm.pages.utils.table.AppHandlerPaste;
import com.sec.osdm.pages.utils.table.AppHandlerRepeat;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import com.sec.osdm.pages.utils.table.ICellComponent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AppPage
extends JPanel
implements ActionListener,
Printable {
    public AppPageInfo m_pageInfo = null;
    public AppTreeNode m_tnInfo = null;
    public AppTable m_table = null;
    public AppTableModel m_model = null;
    public AppComboBox m_compCombo = null;
    public AppNewCombo m_newCombo = null;
    public AppTextBox m_compText = null;
    public AppNewText m_newText = null;
    public JCheckBox m_compCheck = null;
    public ArrayList m_components = new ArrayList();
    public ArrayList m_recvData = new ArrayList();
    public AppPageToolBar m_toolBar = null;
    public AppTopPanel m_topPane = new AppTopPanel();
    public JScrollPane m_jspTop = new JScrollPane();
    public JPanel m_contentPane = new JPanel(new BorderLayout());
    public AppLayout m_lmContent = null;
    public DoDownload m_downLoad = null;
    public DoUpload m_upLoad = null;
    public String[][] m_rowTitle = null;
    public String[][] m_colTitle = null;
    public String[][] m_corner = null;
    public boolean m_bIsChanged = false;
    public boolean m_bRefreshMenu = false;
    public int m_rcdSize = 0;
    public byte m_msgType = (byte)-48;
    public int m_maxEntry = 0;
    public int m_tenantNo = 0;
    public TreeMap<String, ArrayList> convData = null;
    public boolean m_curSort = false;
    public ArrayList m_arrComponent = new ArrayList();
    public boolean m_defPrintTable = true;

    public AppPage() {
    }

    public AppPage(AppPageInfo pageInfo) {
        this.setPageInfo(pageInfo);
        this.requestDownload();
    }

    public void setPageInfo(AppPageInfo pageInfo) {
        this.m_pageInfo = pageInfo;
        this.m_tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get(this.m_pageInfo.getMsgId());
        this.m_msgType = this.m_pageInfo.getDownMsgType();
        this.m_rcdSize = this.m_pageInfo.getRecordSize();
        this.m_tenantNo = AppRunInfo.getTenantNo();
        this.m_toolBar = new AppPageToolBar(AppPageToolBar.TOOLBAR_PAGE);
        this.setToolBarStatus();
        this.addTopPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_jspTop, "First");
        this.add((Component)this.m_contentPane, "Center");
        this.add((Component)this.m_toolBar, "Last");
    }

    public void setToolBarStatus() {
        this.m_toolBar.setToolBarStatus(this.m_pageInfo.getMsgId());
    }

    private void addTopPanel() {
        if (this.m_tnInfo.getTopPanel() != null) {
            this.m_topPane = this.m_tnInfo.getTopPanel();
        } else {
            this.m_jspTop.setVisible(false);
        }
        this.m_jspTop.getViewport().setView(this.m_topPane);
        this.m_jspTop.setPreferredSize(new Dimension(800, 40));
    }

    public void setTableTitle() {
        int j2;
        int i2;
        String[][] colTitle = this.m_pageInfo.getColTitle();
        String[][] rowTitle = this.m_pageInfo.getRowTitle();
        String checkField = this.m_pageInfo.getCheckTable();
        int fieldCount = this.m_pageInfo.getFieldCount();
        int startField = 0;
        if (!checkField.equals("")) {
            startField = Integer.parseInt(checkField.split(";")[1]);
            fieldCount -= startField;
        }
        this.m_corner = this.m_pageInfo.getCornerTitle();
        if (colTitle != null && checkField.indexOf("COL") >= 0) {
            this.m_colTitle = new String[colTitle.length][colTitle[0].length <= fieldCount ? colTitle[0].length : fieldCount];
            if (rowTitle != null && rowTitle.length > 0) {
                this.m_rowTitle = new String[rowTitle.length][rowTitle[0].length];
            }
        } else if (rowTitle != null && checkField.indexOf("ROW") >= 0) {
            this.m_rowTitle = new String[rowTitle.length <= fieldCount ? rowTitle.length : fieldCount][rowTitle[0].length];
            if (colTitle != null && colTitle.length > 0) {
                this.m_colTitle = new String[colTitle.length][colTitle[0].length];
            }
        } else {
            if (colTitle != null && colTitle.length > 0) {
                this.m_colTitle = new String[colTitle.length][colTitle[0].length];
            }
            if (rowTitle != null && rowTitle.length > 0) {
                this.m_rowTitle = new String[rowTitle.length][rowTitle[0].length];
            }
        }
        if (colTitle != null && colTitle.length > 0) {
            i2 = 0;
            while (i2 < this.m_colTitle.length) {
                j2 = 0;
                while (j2 < this.m_colTitle[i2].length) {
                    this.m_colTitle[i2][j2] = colTitle[i2][j2];
                    ++j2;
                }
                ++i2;
            }
        }
        if (rowTitle != null && rowTitle.length > 0) {
            i2 = 0;
            while (i2 < this.m_rowTitle.length) {
                j2 = 0;
                while (j2 < this.m_rowTitle[i2].length) {
                    this.m_rowTitle[i2][j2] = rowTitle[i2][j2];
                    ++j2;
                }
                ++i2;
            }
        }
    }

    public Object createComponent(int index, String value) {
        int pos = this.m_pageInfo.getDataPosition(index);
        if (this.m_pageInfo.getFieldType(pos) == 1) {
            this.m_compCheck = new JCheckBox();
            this.m_compCheck.setSelected(value.equals("1"));
            this.m_compCheck.setHorizontalAlignment(0);
            return this.m_compCheck;
        }
        if (this.m_pageInfo.getFieldType(pos) == 4) {
            String[] items = AppSelect.getItems(this.m_pageInfo.getFieldItem(pos));
            this.m_newCombo = new AppNewCombo(items);
            if (value != null && !value.equals("")) {
                this.m_newCombo.setSelectedValue(Integer.parseInt(value));
            } else {
                this.m_newCombo.setSelectedValue(0);
            }
            return this.m_newCombo;
        }
        if (this.m_pageInfo.getFieldType(pos) == 7) {
            value = !value.equals("") && !value.equals("255") ? "V" + String.format("%02x", Integer.parseInt(value)) : "";
        } else if (this.m_pageInfo.getFieldType(pos) == 8) {
            value = AppFunctions.formatToSV(value);
        }
        this.m_newText = new AppNewText(this.m_pageInfo, pos);
        this.m_newText.setText(value);
        return this.m_newText;
    }

    public String setComponentValue(int index, Object value, String preValue) {
        String curValue;
        block22: {
            block23: {
                int pos;
                block21: {
                    pos = this.m_pageInfo.getDataPosition(index);
                    curValue = "";
                    if (!(value instanceof JCheckBox)) break block21;
                    curValue = ((JCheckBox)value).isSelected() ? "1" : "0";
                    break block22;
                }
                if (!(value instanceof AppTextBox) && !(value instanceof AppNewText)) break block23;
                curValue = ((ICellComponent)value).toString().trim();
                switch (this.m_pageInfo.getFieldType(pos)) {
                    case 2: {
                        if (!AppFunctions.checkIPAddress(null, curValue)) {
                            if (value instanceof AppTextBox) {
                                ((AppTextBox)value).setText(preValue);
                            } else {
                                ((AppNewText)value).setText(preValue);
                            }
                            curValue = preValue;
                            break;
                        }
                        break block22;
                    }
                    case 7: {
                        try {
                            curValue = curValue.substring(1, curValue.length());
                            curValue = "" + Integer.parseInt(curValue, 16);
                        }
                        catch (Exception e2) {
                            AppGlobal.showErrorMessage("", AppLang.getText("Data format of version is wrong."));
                            ((AppNewText)value).setText(preValue);
                            curValue = preValue;
                        }
                        break;
                    }
                    case 8: {
                        try {
                            if (curValue.equals("")) break;
                            String tmpValue = curValue.substring(0, 1).toUpperCase().equals("V") ? curValue.substring(1) : curValue;
                            String[] values = tmpValue.split("\\.");
                            if (values[0].length() == 1 || values[0].length() == 2) {
                                if (values[1].length() == 1) {
                                    curValue = String.valueOf(values[0]) + values[1] + "0";
                                    curValue = "" + Integer.parseInt(curValue, 16);
                                    ((AppNewText)value).setText(AppFunctions.formatToSV(curValue));
                                    break;
                                }
                                if (values[1].length() == 2) {
                                    curValue = String.valueOf(values[0]) + values[1];
                                    curValue = "" + Integer.parseInt(curValue, 16);
                                    ((AppNewText)value).setText(AppFunctions.formatToSV(curValue));
                                    break;
                                }
                            }
                            AppGlobal.showErrorMessage("", AppLang.getText("[Version] Atom = 2 (V__.__)"));
                            ((AppNewText)value).setText(AppFunctions.formatToSV(preValue));
                            curValue = preValue;
                        }
                        catch (Exception e3) {
                            AppGlobal.showErrorMessage("", AppLang.getText("[Version] Atom = 2 (V__.__)"));
                            ((AppNewText)value).setText(AppFunctions.formatToSV(preValue));
                            curValue = preValue;
                        }
                        break;
                    }
                }
                break block22;
            }
            if (value instanceof AppPasswordTextBox) {
                curValue = ((AppPasswordTextBox)value).getText().trim();
            } else if (value instanceof AppComboBox) {
                curValue = "" + ((AppComboBox)value).getSelectedIndex();
            } else if (value instanceof AppNewCombo) {
                curValue = "" + ((AppNewCombo)value).getSelectedValue();
            }
        }
        if (!this.m_bIsChanged && !preValue.equals(curValue)) {
            this.m_bIsChanged = true;
        }
        return curValue;
    }

    public boolean getCellEnable(int pos) {
        return this.m_pageInfo.getFieldEnable(this.m_pageInfo.getDataPosition(pos)) != 0;
    }

    public void setTableModel() {
        int[] rowWidth = this.m_pageInfo.getRowWidth();
        int[] colWidth = null;
        this.m_model.setRowWidth(rowWidth);
        if (this.m_pageInfo.getColWidth().length == 1) {
            colWidth = new int[this.m_model.getColHdrColCount()];
            int i2 = 0;
            while (i2 < colWidth.length) {
                colWidth[i2] = this.m_pageInfo.getColWidth()[0];
                ++i2;
            }
        } else {
            colWidth = this.m_pageInfo.getColWidth();
        }
        this.m_model.setColWidth(colWidth);
        this.setCellSpan();
        this.m_table = new AppTable(this.m_model);
        this.m_contentPane.add((Component)this.m_table, "Center");
    }

    public void setCellSpan() {
        String[] cellSpan = this.m_pageInfo.getCellSpan();
        int i2 = 0;
        while (i2 < cellSpan.length) {
            try {
                String[] span = cellSpan[i2].split(",");
                int row = Integer.parseInt(span[1]);
                int col = Integer.parseInt(span[2]);
                int count = Integer.parseInt(span[3]);
                if (span[0].equals("0")) {
                    this.m_model.setRowHeaderRowSpan(row, col, count);
                } else if (span[0].equals("1")) {
                    this.m_model.setRowHeaderColSpan(row, col, count);
                } else if (span[0].equals("2")) {
                    this.m_model.setColHeaderRowSpan(row, col, count);
                } else if (span[0].equals("3")) {
                    this.m_model.setColHeaderColSpan(row, col, count);
                } else if (span[0].equals("4")) {
                    this.m_model.setCornerHeaderRowSpan(row, col, count);
                } else if (span[0].equals("5")) {
                    this.m_model.setCornerHeaderColSpan(row, col, count);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
    }

    public void setRowHeaderSpan(int col) {
        int cnt = 1;
        int i2 = 1;
        while (i2 < this.m_model.getRowHdrRowCount()) {
            if (((String)this.m_model.getRowHdrName(i2 - 1, col)).equals((String)this.m_model.getRowHdrName(i2, col))) {
                ++cnt;
            } else {
                this.m_model.setRowHeaderRowSpan(i2 - cnt, col, cnt);
                cnt = 1;
            }
            ++i2;
        }
        if (cnt > 1) {
            this.m_model.setRowHeaderRowSpan(this.m_model.getRowHdrRowCount() - cnt, col, cnt);
        }
    }

    public void setTableRowHidden() {
        int i2 = 0;
        while (i2 < this.m_model.getRowHdrRowCount()) {
            if (this.m_pageInfo.getFieldType(this.m_pageInfo.getDataPosition(i2)) == 255) {
                this.m_table.setRowHidden(i2);
            }
            ++i2;
        }
    }

    public void setTableColHidden() {
        int i2 = 0;
        while (i2 < this.m_model.getColHdrColCount()) {
            if (this.m_pageInfo.getFieldType(this.m_pageInfo.getDataPosition(i2)) == 255) {
                this.m_table.setColHidden(i2);
            }
            ++i2;
        }
    }

    public void requestDownload() {
        this.m_pageInfo.setRecvData(new ArrayList());
        this.m_downLoad = new DoDownload();
        this.m_downLoad.start();
        this.m_bIsChanged = false;
    }

    public void requestUpload() {
        this.m_pageInfo.setSaveData(this.m_recvData);
        this.m_upLoad = new DoUpload();
        this.m_upLoad.start();
        this.m_bIsChanged = false;
    }

    private void movePage(byte mode) {
        AppTreeNode tnInfo = null;
        int curPos = 0;
        int i2 = 0;
        while (i2 < AppProperty.m_useMmcList.size()) {
            if (this.m_pageInfo.getMsgId().equals((String)AppProperty.m_useMmcList.get(i2))) {
                curPos = i2;
                break;
            }
            ++i2;
        }
        if (mode == 0 && curPos > 0) {
            tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get((String)AppProperty.m_useMmcList.get(curPos - 1));
            AppGlobal.g_frmMain.m_pagePane.openNewPage(tnInfo.getTreeNode());
        } else if (mode == 1 && curPos < AppProperty.m_useMmcList.size() - 1) {
            tnInfo = (AppTreeNode)AppProperty.m_allMmcList.get((String)AppProperty.m_useMmcList.get(curPos + 1));
            AppGlobal.g_frmMain.m_pagePane.openNewPage(tnInfo.getTreeNode());
        }
    }

    public void closePage() {
        if (this.m_bIsChanged && !AppGlobal.g_bIsLockOut && AppGlobal.showConfirmMessage(AppLang.getText("Save data"), AppLang.getText("Data is changed. Do you want to save changed data?")) == 0) {
            this.requestUpload();
        }
        try {
            AppGlobal.g_frmMain.m_pagePane.removePageTab(AppLang.getText(this.m_tnInfo.getTabTitle()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (this.m_table != null) {
            this.m_table.getTable().editingStopped(null);
        }
        this.actionToolButton(e2.getActionCommand());
    }

    public void actionPageToolButton(String command) {
        if (command.equals("Save")) {
            this.requestUpload();
        } else if (command.equals("Reload")) {
            AppGlobal.g_frmMain.m_pagePane.openNewPage(this.m_tnInfo.getTreeNode());
        } else if (command.equals("Prev")) {
            this.movePage((byte)0);
        } else if (command.equals("Next")) {
            this.movePage((byte)1);
        } else if (command.equals("Repeat")) {
            AppHandlerRepeat repeat = new AppHandlerRepeat(this.m_table.getTable());
            repeat.bindAction();
        } else if (command.equals("Copy")) {
            AppHandlerCopy copy = new AppHandlerCopy(this.m_table.getTable());
            copy.bindAction();
        } else if (command.equals("Paste")) {
            AppHandlerPaste paste = new AppHandlerPaste(this.m_table.getTable());
            paste.bindAction();
        } else if (command.equals("Find")) {
            AppHandlerFind find = new AppHandlerFind(this.m_table.getTable());
            find.bindAction();
        } else if (command.equals("Cut")) {
            AppHandlerCut cut = new AppHandlerCut(this.m_table.getTable());
            cut.bindAction();
        } else if (command.equals("Bookmark")) {
            AppGlobal.g_frmMain.m_toolBar.addBookPopupItem(this.m_tnInfo);
        } else if (command.equals("Close")) {
            this.closePage();
        } else if (command.equals("Help")) {
            String path = "java -Dfile.encoding=utf8 -jar \"" + AppProperty.m_runDirectory + "osdmhelp.jar\" " + AppProperty.m_properties.get("USER_LANG") + " P" + this.m_pageInfo.getMsgId();
            try {
                if (AppGlobal.g_helpProcess != null) {
                    AppGlobal.g_helpProcess.destroy();
                }
                AppGlobal.g_helpProcess = Runtime.getRuntime().exec(path);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
        } else if (command.equals("Sort")) {
            if (this.m_table != null) {
                this.m_contentPane.remove(this.m_table);
                this.m_model = null;
                this.m_table = null;
            }
            if (this.m_curSort) {
                this.createPage();
                return;
            }
            this.actionSort();
        }
    }

    public void actionSort() {
        if (this.m_recvData != null && this.m_recvData.size() > 0) {
            this.m_curSort = true;
            ArrayList recvData = new ArrayList();
            ArrayList<Object> compData = null;
            String sValue = "";
            int i2 = 0;
            this.m_components.clear();
            this.m_rowTitle = new String[this.convData.size()][1];
            for (String key : this.convData.keySet()) {
                recvData = this.convData.get(key);
                this.m_rowTitle[i2][0] = key;
                compData = new ArrayList<Object>();
                int j2 = 0;
                while (j2 < this.m_colTitle[0].length) {
                    sValue = (String)recvData.get(this.m_pageInfo.getDataPosition(j2));
                    compData.add(j2, this.createComponent(j2, sValue));
                    ++j2;
                }
                this.m_components.add(i2, compData);
                ++i2;
            }
            this.createTable();
        }
    }

    public boolean isPortNumber(AppNewText aValue, String preValue) {
        String curValue = aValue.getText().trim();
        String string = curValue = curValue.toUpperCase().equals("A") || curValue.toUpperCase().equals("ALL") ? "ALL" : curValue;
        if (!curValue.equals("") && AppNumPlan.getPortNo(curValue) == 65535) {
            JOptionPane.showMessageDialog(null, AppLang.getText("[Tel Number], A(ALL)"), AppLang.getText("Data Format Error"), 1);
            aValue.setText(preValue);
            return false;
        }
        aValue.setText(curValue);
        return true;
    }

    public ArrayList getPrintableComponent() {
        return this.m_arrComponent;
    }

    public void setPrintableComponent(JComponent component) {
        this.m_arrComponent.add(component);
    }

    public boolean getDefPrintTableEnable() {
        return this.m_defPrintTable;
    }

    public void setDefPrintTableEnable(boolean enable) {
        this.m_defPrintTable = enable;
    }

    public void removePrintTable(JComponent table) {
        this.m_arrComponent.remove(table);
    }

    public void clearPrintTable() {
        this.m_arrComponent.clear();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)graphics;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        boolean wasBuffered = this.disableDoubleBuffering();
        this.paint(g2);
        this.restoreDoubleBuffering(wasBuffered);
        return 0;
    }

    private boolean disableDoubleBuffering() {
        boolean wasBuffered = this.isDoubleBuffered();
        this.setDoubleBuffered(false);
        return wasBuffered;
    }

    private void restoreDoubleBuffering(boolean wasBuffered) {
        this.setDoubleBuffered(wasBuffered);
    }

    public void createPage() {
    }

    public void createTable() {
    }

    public void actionToolButton(String command) {
    }

    public class DoDownload
    extends Thread {
        private boolean m_bIsError = false;
        private boolean m_bResult = true;

        @Override
        public void run() {
            this.m_bIsError = false;
            AppGlobal.showProgress(AppPage.this.m_tnInfo.getTabTitle(), AppLang.getText("Downloading data..."));
            this.m_bResult = AppComm.getInstance().requestDownload(AppPage.this.m_pageInfo);
            AppGlobal.hideProgress();
            if (!AppGlobal.g_bIsCancel && this.m_bResult) {
                try {
                    AppPage.this.m_recvData = AppPage.this.m_pageInfo.getRecvData();
                    AppPage.this.setTableTitle();
                    AppPage.this.createPage();
                    AppPage.this.setPrintableComponent(AppPage.this.m_table);
                    AppPage.this.m_contentPane.repaint();
                }
                catch (Exception e2) {
                    this.m_bIsError = true;
                }
                if (AppPage.this.m_maxEntry == 0 && AppPage.this.m_recvData.size() == 0) {
                    AppGlobal.showInfoMessage("", AppLang.getText("No Data."));
                    AppPage.this.closePage();
                } else if (this.m_bIsError) {
                    AppGlobal.showErrorMessage("", AppLang.getText("Failed to create page."));
                    AppPage.this.closePage();
                }
            } else {
                AppPage.this.closePage();
            }
            AppPage.this.m_downLoad = null;
        }
    }

    public class DoUpload
    extends Thread {
        @Override
        public void run() {
            AppGlobal.showProgress(AppPage.this.m_tnInfo.getTabTitle(), AppLang.getText("Uploading data..."));
            AppComm.getInstance().requestUpload(AppPage.this.m_pageInfo);
            if (AppGlobal.g_bIsRestart) {
                AppPage.this.m_upLoad = null;
                AppGlobal.hideProgress();
                AppGlobal.g_bIsRestart = false;
                AppMenuActions.disconnectSystem();
                return;
            }
            if (AppPage.this.m_tnInfo.getMsgId().equals("2105") && AppPage.this.m_bRefreshMenu) {
                AppComm.getInstance().requestDownload(new AppPageInfo("5D06"));
                AppGlobal.g_frmMain.setTreePane();
                AppPage.this.m_bRefreshMenu = false;
            }
            AppGlobal.hideProgress();
            AppPage.this.m_upLoad = null;
            if (AppGlobal.g_errorData.size() > 0 && AppGlobal.showConfirmMessage(AppLang.getText("Warning"), String.valueOf(AppLang.getText("There is(are) some warning information.")) + " \n" + "Do you want to see the details?") == 0) {
                new AppErrorInfo();
            }
            if (!AppGlobal.g_bIsCancel && AppPage.this.m_pageInfo.getMsgId().equals("2005")) {
                AppPage.this.actionPageToolButton("Reload");
            }
        }
    }
}

