/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.pages.utils.components.AppNewText;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppKeyHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;

public class AppHandlerRepeat
extends AppKeyHandler {
    public static final String KEY_COMMAND = "Repeat";
    public final int INCREACE = 1;
    public final int DECREACE = 2;
    private AppRepeatDlg m_repDlg = null;

    public AppHandlerRepeat(JTable table) {
        super(table, 82, 2, KEY_COMMAND);
    }

    @Override
    public void bindAction() {
        int[] arrSelectedRows = this.m_table.getSelectedRows();
        int[] arrSelectedCols = this.m_table.getSelectedColumns();
        if (arrSelectedRows.length == 0 || arrSelectedCols.length == 0 || arrSelectedRows.length == 1 && arrSelectedCols.length == 1) {
            return;
        }
        if (arrSelectedRows.length > 1 && arrSelectedCols.length > 1) {
            JOptionPane.showMessageDialog(null, AppLang.getText("The selected values in the range over"), AppLang.getText("Error"), 0);
            return;
        }
        this.m_repDlg = new AppRepeatDlg();
        if (this.m_repDlg.m_bFlg) {
            int nRowCount = 0;
            int nColCount = 0;
            boolean isSigleSelect = false;
            if (arrSelectedRows.length == 1 && arrSelectedCols.length == 1) {
                nRowCount = this.m_table.getRowCount() - arrSelectedRows[0];
                nColCount = this.m_table.getColumnCount() - arrSelectedCols[0];
                isSigleSelect = true;
            } else {
                nRowCount = arrSelectedRows.length;
                nColCount = arrSelectedCols.length;
                isSigleSelect = false;
            }
            try {
                int nData = this.m_repDlg.getInputData();
                int nDigit = this.m_repDlg.getDigit();
                int i2 = 0;
                while (i2 < nRowCount) {
                    int nCurRow;
                    int n2 = nCurRow = isSigleSelect ? arrSelectedRows[0] + i2 : arrSelectedRows[i2];
                    if (!this.isRowHidden(nCurRow)) {
                        int j2 = 0;
                        while (j2 < nColCount) {
                            int nCurCol;
                            int n3 = nCurCol = isSigleSelect ? arrSelectedCols[0] + j2 : arrSelectedCols[j2];
                            if (!this.isColHidden(nCurCol)) {
                                Object aCellComp = this.m_table.getValueAt(nCurRow, nCurCol);
                                boolean fEditable = this.m_table.isCellEditable(nCurRow, nCurCol);
                                if (aCellComp != null && fEditable && (aCellComp instanceof AppTextBox || aCellComp instanceof AppNewText)) {
                                    if (nData < 0) {
                                        this.m_table.updateUI();
                                        return;
                                    }
                                    String sFormatedData = String.format("%0" + nDigit + "d", nData);
                                    if (aCellComp instanceof AppNewText) {
                                        ((AppNewText)aCellComp).setText(String.valueOf(this.m_repDlg.getPre()) + sFormatedData + this.m_repDlg.getPost());
                                    } else {
                                        ((AppTextBox)aCellComp).setText(String.valueOf(this.m_repDlg.getPre()) + sFormatedData + this.m_repDlg.getPost());
                                    }
                                    nData = this.m_repDlg.getOption() == 1 ? (nData += this.m_repDlg.getIterNo()) : (nData -= this.m_repDlg.getIterNo());
                                    this.m_table.setValueAt(aCellComp, nCurRow, nCurCol);
                                }
                            }
                            ++j2;
                        }
                    }
                    ++i2;
                }
                this.m_table.updateUI();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.m_repDlg.dispose();
    }

    @Override
    public String getKeyCommand() {
        return KEY_COMMAND;
    }

    protected class AppRepeatDlg
    extends JDialog
    implements ActionListener {
        public boolean m_bFlg;
        private JPanel m_pnPre;
        private JPanel m_pnStart;
        private JPanel m_pnPost;
        private JPanel m_pnIterType;
        private JPanel m_pnIterNo;
        private JPanel m_pnBtn;
        private JPanel m_pnPage;
        private JButton m_btnOk;
        private JButton m_btnCancel;
        private JRadioButton m_rbtnIn;
        private JRadioButton m_rbtnDe;
        private JLabel m_lbStart;
        private JLabel m_lbPre;
        private JLabel m_lbPost;
        private JLabel m_lbIterNo;
        private AppTextBox m_tfStart;
        private AppTextBox m_tfPre;
        private AppTextBox m_tfPost;
        private AppTextBox m_tfIterNo;
        private ButtonGroup group;

        public AppRepeatDlg() {
            super(AppGlobal.g_frmMain, "Repeat Dialog", true);
            this.m_bFlg = false;
            this.m_pnPre = new JPanel(new FlowLayout());
            this.m_pnStart = new JPanel(new FlowLayout());
            this.m_pnPost = new JPanel(new FlowLayout());
            this.m_pnIterType = new JPanel(new FlowLayout());
            this.m_pnIterNo = new JPanel(new FlowLayout());
            this.m_pnBtn = new JPanel(new FlowLayout());
            this.m_pnPage = new JPanel(new GridLayout(6, 1));
            this.m_btnOk = new JButton("OK");
            this.m_btnCancel = new JButton("Cancel");
            this.m_rbtnIn = new JRadioButton("Increase", true);
            this.m_rbtnDe = new JRadioButton("Decrease");
            this.m_lbStart = new JLabel("Start No.   ");
            this.m_lbPre = new JLabel("Pre String  ");
            this.m_lbPost = new JLabel("Post String ");
            this.m_lbIterNo = new JLabel("Iteration   ");
            this.m_tfStart = new AppTextBox(9, 10);
            this.m_tfPre = new AppTextBox(0, 15);
            this.m_tfPost = new AppTextBox(0, 15);
            this.m_tfIterNo = new AppTextBox(9, 10);
            this.setDlg();
        }

        private void setDlg() {
            this.setSize(230, 260);
            this.setLocation(AppGlobal.getCenterPoint(this.getSize().width, this.getSize().height));
            this.setResizable(false);
            this.setLayout(new BorderLayout());
            this.group = new ButtonGroup();
            this.group.add(this.m_rbtnIn);
            this.group.add(this.m_rbtnDe);
            AppGlobal.fixSize(this.m_lbPre, new Dimension(80, 20));
            AppGlobal.fixSize(this.m_lbStart, new Dimension(80, 20));
            AppGlobal.fixSize(this.m_lbPost, new Dimension(80, 20));
            AppGlobal.fixSize(this.m_lbIterNo, new Dimension(80, 20));
            AppGlobal.fixSize(this.m_tfPre.getComponent(), new Dimension(120, 20));
            AppGlobal.fixSize(this.m_tfStart.getComponent(), new Dimension(120, 20));
            AppGlobal.fixSize(this.m_tfPost.getComponent(), new Dimension(120, 20));
            AppGlobal.fixSize(this.m_tfIterNo.getComponent(), new Dimension(120, 20));
            this.m_btnOk.setFont(AppGlobal.g_btnFont);
            this.m_btnCancel.setFont(AppGlobal.g_btnFont);
            this.m_btnOk.addActionListener(this);
            this.m_btnCancel.addActionListener(this);
            this.m_btnOk.setActionCommand("Ok");
            this.m_btnCancel.setActionCommand("Cancel");
            this.m_pnPre.add(this.m_lbPre);
            this.m_pnPre.add(this.m_tfPre.getComponent());
            this.m_pnStart.add(this.m_lbStart);
            this.m_pnStart.add(this.m_tfStart.getComponent());
            this.m_pnPost.add(this.m_lbPost);
            this.m_pnPost.add(this.m_tfPost.getComponent());
            this.m_pnIterType.add(this.m_rbtnIn);
            this.m_pnIterType.add(this.m_rbtnDe);
            this.m_pnIterNo.add(this.m_lbIterNo);
            this.m_pnIterNo.add(this.m_tfIterNo.getComponent());
            this.m_pnPage.add(this.m_pnPre);
            this.m_pnPage.add(this.m_pnStart);
            this.m_pnPage.add(this.m_pnPost);
            this.m_pnPage.add(this.m_pnIterType);
            this.m_pnPage.add(this.m_pnIterNo);
            this.m_pnBtn.add(this.m_btnOk);
            this.m_pnBtn.add(this.m_btnCancel);
            this.add((Component)this.m_pnPage, "Center");
            this.add((Component)this.m_pnBtn, "South");
            this.setVisible(true);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e2) {
                    AppRepeatDlg.this.dispose();
                }
            });
        }

        public int getOption() {
            if (this.group.isSelected(this.m_rbtnIn.getModel())) {
                return 1;
            }
            if (this.group.isSelected(this.m_rbtnDe.getModel())) {
                return 2;
            }
            return -1;
        }

        public int getInputData() {
            return Integer.parseInt(this.m_tfStart.getText());
        }

        public int getDigit() {
            return this.m_tfStart.getText().length();
        }

        public String getPre() {
            return this.m_tfPre.getText();
        }

        public String getPost() {
            return this.m_tfPost.getText();
        }

        public int getIterNo() {
            int result = 0;
            try {
                result = Integer.parseInt(this.m_tfIterNo.getText());
            }
            catch (NumberFormatException e2) {
                System.out.println(String.valueOf(this.getClass().getName().toString()) + " >Number Format Exception");
            }
            return result;
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            String strCommand = e2.getActionCommand();
            if (strCommand.equals("Ok")) {
                if (this.m_tfStart.getText().equals("")) {
                    JOptionPane.showMessageDialog(null, AppLang.getText("Please, Input Textbox"));
                    return;
                }
                if (this.getOption() == -1) {
                    JOptionPane.showMessageDialog(null, AppLang.getText("Please, Select RadioButton"));
                    return;
                }
                this.m_bFlg = true;
            }
            this.setVisible(false);
        }
    }
}

