/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.utils.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class SpanTableLabelRenderer
extends JLabel
implements TableCellRenderer {
    private Color m_bgColor = null;
    private Color m_fgColor = null;
    private Border m_border = null;
    private Font m_font = null;
    private int m_cellAlignment = -1;
    private boolean m_fHeader = false;

    public SpanTableLabelRenderer() {
        this.m_fHeader = true;
        this.m_cellAlignment = 0;
    }

    public SpanTableLabelRenderer(Color foreColor, Color bgColor, int cellAlignment, Font font, Border border) {
        this.m_fHeader = false;
        this.setRenderer(foreColor, bgColor, cellAlignment, font, border);
    }

    public SpanTableLabelRenderer(JTable table, int cellAlignment) {
        this.m_fHeader = true;
        this.setHeaderStyleRenderer(table, cellAlignment);
        this.m_cellAlignment = cellAlignment;
    }

    private void setHeaderStyleRenderer(JTable table, int cellAlignment) {
        this.m_fHeader = true;
        JTableHeader header = table.getTableHeader();
        this.setRenderer(header.getForeground(), header.getBackground(), cellAlignment, header.getFont(), UIManager.getBorder("TableHeader.cellBorder"));
    }

    private void setRenderer(Color foreColor, Color bgColor, int cellAlignment, Font font, Border border) {
        this.setOpaque(true);
        this.m_fgColor = foreColor;
        this.m_bgColor = bgColor;
        this.m_border = border;
        this.m_font = font;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.m_fHeader) {
            if (this.m_cellAlignment != -1) {
                this.setHorizontalAlignment(this.m_cellAlignment);
            }
            this.setFont(table.getTableHeader().getFont());
            super.setForeground(this.m_fgColor != null ? this.m_fgColor : table.getTableHeader().getForeground());
            super.setBackground(this.m_bgColor != null ? this.m_bgColor : table.getTableHeader().getBackground());
        } else {
            Font font = null;
            font = this.m_font != null ? this.m_font : table.getFont();
            this.setFont(font);
            if (isSelected) {
                super.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setForeground(this.m_fgColor != null ? this.m_fgColor : table.getForeground());
                super.setBackground(this.m_bgColor != null ? this.m_bgColor : table.getBackground());
            }
        }
        if (!this.m_fHeader) {
            Border border = null;
            border = isSelected ? UIManager.getBorder("Table.focusSelectedCellHighlightBorder") : BorderFactory.createEmptyBorder();
            this.setBorder(border);
        } else {
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
        }
        this.setText(value == null ? "" : " " + value.toString());
        return this;
    }
}

