/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.vmaa;

import com.sec.osdm.common.AppLang;
import com.sec.osdm.io.AppFTPClient;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.AppPageInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;

public class P2010ActivityLog
extends AppPage {
    private AppFTPClient m_ftp = new AppFTPClient();
    private JTextArea m_txtData = new JTextArea();
    private String m_source = new String("/os7100/vm/dta/ACTIVITY.LOG");
    private JButton m_btDown = new JButton(AppLang.getText("Down"));
    private JPanel m_btPanel = new JPanel(new BorderLayout());

    public P2010ActivityLog(AppPageInfo pageInfo) {
        this.setPageInfo(pageInfo);
        this.m_ftp.connect("admin", "samsung");
        if (this.isExistFile()) {
            this.m_recvData = this.m_ftp.getFileContents(this.m_source);
            this.createComponents();
        } else {
            JOptionPane.showMessageDialog(null, AppLang.getText("Can not find file"), AppLang.getText("Error"), 0);
        }
        this.m_ftp.disConnect();
    }

    public void createComponents() {
        this.m_txtData.setFont(new Font("Serif", 0, 14));
        this.m_txtData.setLineWrap(true);
        this.m_txtData.setWrapStyleWord(true);
        this.m_txtData.setEditable(false);
        this.m_txtData.setText("");
        int i2 = 0;
        while (i2 < this.m_recvData.size()) {
            this.m_txtData.append(String.valueOf((String)this.m_recvData.get(i2)) + "\n");
            ++i2;
        }
        this.createTable();
        JScrollPane jspData = new JScrollPane(this.m_txtData);
        this.m_contentPane.add((Component)this.m_btPanel, "North");
        this.m_contentPane.add((Component)jspData, "Center");
    }

    @Override
    public void createTable() {
        this.m_btDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                JFileChooser jfc = new JFileChooser();
                jfc.setSelectedFile(new File("Activity Log.TXT"));
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Text file", "TXT");
                jfc.setFileFilter(filter);
                int yn = jfc.showSaveDialog(null);
                if (yn == 0) {
                    if (jfc.getSelectedFile().getName().toUpperCase().indexOf(".TXT") > -1) {
                        P2010ActivityLog.this.m_ftp.connect("admin", "samsung");
                        boolean ret = P2010ActivityLog.this.m_ftp.getFile(P2010ActivityLog.this.m_source, jfc.getSelectedFile().getAbsolutePath());
                        if (ret) {
                            JOptionPane.showMessageDialog(null, AppLang.getText("Download file success."), AppLang.getText("Download"), 1);
                        } else {
                            JOptionPane.showMessageDialog(null, AppLang.getText("Download file failed."), AppLang.getText("Download"), 0);
                        }
                        P2010ActivityLog.this.m_ftp.disConnect();
                    } else {
                        JOptionPane.showMessageDialog(null, AppLang.getText("Invalid file format"));
                    }
                }
                jfc = null;
            }
        });
        this.m_btDown.setPreferredSize(new Dimension(80, 20));
        this.m_btPanel.add((Component)this.m_btDown, "West");
    }

    private boolean isExistFile() {
        boolean ret = false;
        ArrayList fileList = this.m_ftp.getFileList("/os7100/vm/dta");
        int i2 = 0;
        while (i2 < fileList.size()) {
            String trmStr = ((String)fileList.get(i2)).toUpperCase();
            if (trmStr.indexOf("ACTIVITY.LOG") > -1) {
                return true;
            }
            ++i2;
        }
        return ret;
    }

    @Override
    public void actionToolButton(String command) {
        this.actionPageToolButton(command);
    }

    @Override
    public void createPage() {
    }
}

