/*
 * Decompiled with CFR 0.152.
 */
package com.sec.osdm.pages.vmaa;

import com.sec.osdm.common.AppFunctions;
import com.sec.osdm.common.AppGlobal;
import com.sec.osdm.common.AppLang;
import com.sec.osdm.io.AppDownRequest;
import com.sec.osdm.io.AppNetwork;
import com.sec.osdm.pages.AppPage;
import com.sec.osdm.pages.AppPageInfo;
import com.sec.osdm.pages.utils.components.AppTextBox;
import com.sec.osdm.pages.utils.table.AppTable;
import com.sec.osdm.pages.utils.table.AppTableModel;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public class P2025StatusScreen
extends AppPage {
    private AppTable m_table1 = null;
    private AppTableModel m_model1 = null;
    private String[][] m_rowTitle1 = null;
    private String[][] m_colTitle1 = null;
    private String[][] m_corner1 = null;
    private ArrayList m_components1 = new ArrayList();
    private AliveThread m_aliveThread = null;
    private RefreshThread m_refreshThread = null;
    private Socket m_socket = null;
    private byte[] m_header = null;
    private boolean m_bSocConn = false;

    public P2025StatusScreen(AppPageInfo pageInfo) {
        this.setPageInfo(pageInfo);
        pageInfo.setDownMsgType((byte)-34);
        this.requestDownload();
    }

    @Override
    public void createPage() {
        this.createComponents();
        this.createTable();
    }

    public void createComponents() {
        this.m_corner = new String[][]{{"Port"}};
        this.m_colTitle = new String[][]{{"Mode", "Active Block", "Status"}};
        this.m_rowTitle = new String[][]{{"1"}, {"2"}, {"3"}, {"4"}};
        this.m_corner1 = new String[][]{{"Reporting"}};
        this.m_colTitle1 = new String[][]{{""}};
        this.m_rowTitle1 = new String[][]{{"Call To-Date"}, {"Average Calls per Week"}, {"Directory Accesses"}, {"Times All Ports Busy"}, {"Number of Subscribers"}, {"Total Message Count"}, {"Avg Messages/Mailbox"}, {"Disk Space Available"}};
        this.setComponents();
    }

    private void setComponents() {
        this.resetComponent();
        ArrayList recvData = (ArrayList)this.m_recvData.get(0);
        ArrayList<AppTextBox> compData = null;
        this.m_colTitle1[0][0] = String.valueOf((String)recvData.get(261)) + " ~ " + (String)recvData.get(262) + " " + (String)recvData.get(263);
        int idx = 0;
        idx = 4;
        int i2 = 0;
        while (i2 < idx) {
            compData = new ArrayList<AppTextBox>();
            this.m_compText = new AppTextBox();
            this.m_compText.setText((String)recvData.get(i2 + 66));
            compData.add(0, this.m_compText);
            this.m_compText = new AppTextBox();
            this.m_compText.setText((String)recvData.get(i2 + 131));
            compData.add(1, this.m_compText);
            this.m_compText = new AppTextBox();
            this.m_compText.setText((String)recvData.get(i2 + 196));
            compData.add(2, this.m_compText);
            this.m_components.add(i2, compData);
            ++i2;
        }
        i2 = 0;
        while (i2 < 8) {
            this.m_compText = new AppTextBox();
            if (i2 == 6) {
                int val = Integer.parseInt((String)recvData.get(i2 + 264));
                this.m_compText.setText(String.valueOf(val / 10) + "." + val % 10);
            } else {
                this.m_compText.setText((String)recvData.get(i2 + 264));
            }
            this.m_components1.add(i2, this.m_compText);
            ++i2;
        }
    }

    @Override
    public void createTable() {
        this.m_arrComponent.clear();
        this.createTable1();
        this.createTable2();
        this.m_table.setPreferredSize(new Dimension(600, (this.m_model.getRowHdrRowCount() + 1) * 22));
        this.m_contentPane.add((Component)this.m_table, "North");
        this.m_contentPane.add((Component)this.m_table1, "Center");
        if (this.m_bSocConn) {
            if (this.m_aliveThread == null) {
                this.m_aliveThread = new AliveThread();
                this.m_aliveThread.start();
            }
            if (this.m_refreshThread == null) {
                this.m_refreshThread = new RefreshThread();
                this.m_refreshThread.start();
            }
        }
    }

    private void createTable1() {
        this.m_model = new AppTableModel(this.m_rowTitle, this.m_colTitle, this.m_corner){

            @Override
            public Object getValueAt(int row, int col) {
                ArrayList compData = (ArrayList)P2025StatusScreen.this.m_components.get(row);
                return (AppTextBox)compData.get(col);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_model.setRowWidth(new int[]{100});
        this.m_model.setColWidth(new int[]{80, 150, 100});
        this.m_table = new AppTable(this.m_model);
    }

    private void createTable2() {
        this.m_model1 = new AppTableModel(this.m_rowTitle1, this.m_colTitle1, this.m_corner1){

            @Override
            public Object getValueAt(int row, int col) {
                return (AppTextBox)P2025StatusScreen.this.m_components1.get(row);
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        };
        this.m_model1.setRowWidth(new int[]{200});
        this.m_model1.setColWidth(new int[]{230});
        this.m_table1 = new AppTable(this.m_model1);
        this.setPrintableComponent(this.m_table1);
    }

    private void resetComponent() {
        this.m_components.clear();
        this.m_components1.clear();
        if (this.m_table != null) {
            this.m_contentPane.remove(this.m_table);
            this.m_model = null;
            this.m_table = null;
            this.m_contentPane.remove(this.m_table1);
            this.m_model1 = null;
            this.m_table1 = null;
        }
    }

    @Override
    public void actionToolButton(String command) {
        if (command.equals("Close")) {
            this.stopThread();
            this.disConnetSocket();
        }
        this.actionPageToolButton(command);
    }

    private boolean setSocket() {
        try {
            this.m_header = new byte[18];
            this.m_header[0] = 115;
            this.m_header[1] = 113;
            this.m_header[2] = this.m_msgType;
            this.m_header[3] = -1;
            AppFunctions.short2byte(this.m_header, 4, (short)Integer.parseInt(this.m_pageInfo.getMsgId(), 16));
            AppFunctions.short2byte(this.m_header, 6, (short)this.m_pageInfo.getRecordSize());
            AppFunctions.int2byte(this.m_header, 8, this.m_pageInfo.getMsgLength());
            AppFunctions.short2byte(this.m_header, 12, (short)-1);
            this.m_header[14] = this.m_pageInfo.getMsgResponse();
            this.m_header[15] = -1;
            this.m_header[16] = -1;
            this.m_header[17] = -1;
            this.m_socket = new Socket();
            this.m_socket.connect(new InetSocketAddress(AppNetwork.m_address, 6002), 2000);
            return true;
        }
        catch (UnknownHostException e2) {
            AppGlobal.showErrorMessage("", AppLang.getText("Server IP address is not exist."));
            return false;
        }
        catch (IOException e3) {
            AppGlobal.showErrorMessage("", AppLang.getText("Failed to create socket."));
            return false;
        }
    }

    private boolean requestSendData(byte msgType) {
        if (this.m_socket != null && this.m_socket.isConnected()) {
            AppGlobal.g_lockOut.end();
            this.m_header[2] = msgType;
            OutputStream os = null;
            try {
                os = this.m_socket.getOutputStream();
                os.write(this.m_header);
                os.flush();
            }
            catch (IOException e2) {
                AppGlobal.g_lockOut.begin();
                return false;
            }
            AppGlobal.g_lockOut.begin();
            return true;
        }
        return false;
    }

    private boolean disConnetSocket() {
        if (this.m_socket != null) {
            try {
                this.requestSendData((byte)2);
                this.m_socket.close();
                this.m_socket = null;
                return true;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return false;
            }
        }
        return false;
    }

    private boolean resetPage() {
        InputStream is = null;
        byte[] m_bTemp = new byte[0x200000];
        byte[] m_bData = null;
        int nRead = 0;
        int nOffset = 0;
        int msgLen = -1;
        try {
            is = this.m_socket.getInputStream();
            while ((nRead = is.read(m_bTemp, nOffset, m_bTemp.length - nOffset)) != -1) {
                if (nRead >= 18 && msgLen == -1) {
                    msgLen = AppFunctions.byte2int(m_bTemp, 8);
                }
                if (msgLen >= 0 && (nOffset += nRead) >= msgLen + 18) break;
            }
            if (msgLen > 0) {
                m_bData = new byte[msgLen];
                System.arraycopy(m_bTemp, 18, m_bData, 0, msgLen);
                this.m_pageInfo.setRespData(m_bData);
                AppDownRequest.makeReceiveData();
                this.m_recvData = this.m_pageInfo.getRecvData();
                return true;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
        return false;
    }

    public void stopThread() {
        if (this.m_aliveThread != null) {
            this.m_aliveThread.stop();
            this.m_aliveThread = null;
        }
        if (this.m_refreshThread != null) {
            this.m_refreshThread.stop();
            this.m_refreshThread = null;
        }
    }

    class AliveThread
    extends Thread {
        AliveThread() {
        }

        @Override
        public void run() {
            try {
                do {
                    AliveThread.sleep(90000L);
                } while (P2025StatusScreen.this.requestSendData((byte)3));
                JOptionPane.showMessageDialog(null, AppLang.getText("Disconnect Station Screen"), AppLang.getText("Information"), 1);
                P2025StatusScreen.this.actionToolButton("Close");
                return;
            }
            catch (Exception e2) {
                return;
            }
        }
    }

    class RefreshThread
    extends Thread {
        RefreshThread() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        RefreshThread.sleep(1000L);
                        if (!P2025StatusScreen.this.resetPage()) continue;
                        P2025StatusScreen.this.setComponents();
                        P2025StatusScreen.this.createTable();
                        P2025StatusScreen.this.m_table.tableChanged(null);
                        P2025StatusScreen.this.m_table1.tableChanged(null);
                    }
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

